/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.client.ObjectLoaderFactory;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.MaskValue;
import com.kingdee.bos.dao.ormapping.impl.MaskValues;
import com.kingdee.bos.dao.ormapping.impl.ObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.TypeUtils;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ObjectMatcher
extends ObjectHandler {
    private final EntityObjectInfo bo;
    private static final Logger logger = Logger.getLogger(ObjectMatcher.class);

    public ObjectMatcher(Context ctx, Connection cn, SolutionInfo solution, EntityObjectInfo bo) {
        super(ctx, cn, solution);
        this.bo = bo;
    }

    public boolean match(IObjectPK pk, ObjectPattern pattern) throws DataAccessException {
        return this.exists(pk, pattern.mainRule);
    }

    private boolean exists(IObjectPK pk, FilterInfo rule) throws DataAccessException {
        RTSelector rtSelector = RTSelectorBuilder.buildSelfPKSelector(this.ctx, this.bo);
        FilterInfo filterPK = ImplUtils.createFilter(this.bo, pk);
        String oldMastString = "";
        if (rule.getMaskString() != null) {
            oldMastString = rule.getMaskString();
        }
        int j = filterPK.getFilterItems().size();
        for (int i = 0; i < j; ++i) {
            rule.getFilterItems().add(filterPK.getFilterItems().get(i));
            if (oldMastString.lastIndexOf(35) < 0) continue;
            String temp = oldMastString.substring(oldMastString.lastIndexOf(35) + 1).trim();
            if (temp.indexOf(41) > 0) {
                temp = temp.substring(0, temp.indexOf(41)).trim();
            }
            int num = -1;
            try {
                num = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                throw new InvalidEntityViewException("cannot format " + num);
            }
            oldMastString = oldMastString + " and  #" + (num + 1);
        }
        if (!"".equals(oldMastString)) {
            rule.setMaskString(oldMastString);
        }
        try {
            IObjectCollection selectData = new ObjectReader(this.ctx, this.cn, this.solution).select(this.bo, rule, null, rtSelector);
            return selectData.size() != 0;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("select data error." + sqle.getMessage(), sqle);
        }
    }

    public boolean match(IObjectValue value, ObjectPattern pattern) throws DataAccessException {
        boolean matched = this.matchMainRule(value, pattern.mainRule);
        if (matched && pattern.entryRules != null) {
            matched = matched && this.matchEntryRules(value, pattern.entryRules);
        }
        return matched;
    }

    private boolean matchMainRule(IObjectValue value, FilterInfo rule) throws DataAccessException {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        value = ObjectLoaderFactory.getInstance(this.ctx).fillLinkProperty(value, this.getSelectorByFilter(rule));
        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance(this.ctx);
        FilterItemCollection fItems = rule.getFilterItems();
        MaskValues maskValues = new MaskValues();
        String maskString = rule.getMaskString();
        boolean flag = false;
        boolean judgeNullPointer = false;
        if (StringUtils.isEmpty((String)maskString) || fItems.size() == 1) {
            flag = true;
        }
        int size = fItems.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getEntity(value.getBOSType());
            FilterItemInfo item = fItems.get(i);
            String propertyName = item.getPropertyName();
            Object ruleData = item.getCompareValue();
            if (ruleData instanceof String) {
                ruleData = Utils.removeSpecialTAG((String)ruleData, "~9^Nz");
            }
            CompareType compType = item.getCompareType();
            String[] names = StringUtils.fastSplit((String)propertyName, (String)".");
            if (propertyName == null) {
                throw new InvalidEntityViewException(" FilterItemInfo's property name is null");
            }
            IObjectValue curDataObject = value;
            boolean linkPropMaskBooleanValue = false;
            for (int j = 0; j < names.length - 1; ++j) {
                LinkPropertyInfo property = (LinkPropertyInfo)entity.getPropertyByNameRuntime(names[j]);
                if (property instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(entity, property);
                    if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(entity))) {
                        throw new InvalidDAOMetaDataException("filterItem can not be a collection link property. property name:" + names[j] + ". full name:" + propertyName);
                    }
                    entity = relation.getChildObject(entity);
                    if (curDataObject != null) {
                        curDataObject = (IObjectValue)loader.getProperty(curDataObject, names[j]);
                    }
                    if (curDataObject == null && ruleData == null) {
                        logger.warn((Object)("curDataObject " + names[j] + " is null. when judge "));
                        if (CompareType.NOTEQUALS.equals((Object)compType)) {
                            linkPropMaskBooleanValue = false;
                            break;
                        }
                        linkPropMaskBooleanValue = true;
                        judgeNullPointer = true;
                        continue;
                    }
                    if (curDataObject == null && ruleData != null) {
                        logger.warn((Object)("curDataObject " + names[j] + " is null. when judge "));
                        if (!CompareType.NOTEQUALS.equals((Object)compType)) {
                            linkPropMaskBooleanValue = false;
                            break;
                        }
                        linkPropMaskBooleanValue = true;
                        judgeNullPointer = true;
                        continue;
                    }
                    if (curDataObject == null || ruleData != null) continue;
                    if (CompareType.NOTEQUALS.equals((Object)compType)) {
                        linkPropMaskBooleanValue = true;
                        continue;
                    }
                    linkPropMaskBooleanValue = false;
                    break;
                }
                throw new InvalidDAOMetaDataException("filterItem PropertyName invalid.not a link property. property name:" + names[j] + ". full name:" + propertyName);
            }
            if (judgeNullPointer) {
                if (flag && !linkPropMaskBooleanValue) {
                    return linkPropMaskBooleanValue;
                }
                maskValues.add(new MaskValue(linkPropMaskBooleanValue));
                judgeNullPointer = false;
                continue;
            }
            Object objectData = loader.getProperty(curDataObject, names[names.length - 1]);
            try {
                if (objectData != null && ruleData != null || objectData == null && ruleData != null && (CompareType.EXISTS.equals((Object)compType) || CompareType.NOTEXISTS.equals((Object)compType))) {
                    if (!this.regexMatcher(objectData, ruleData, compType)) {
                        logger.warn((Object)("regexMatcher false. filter is: " + item.toString() + " objectData is:" + objectData + " ruleData is:" + ruleData));
                        if (flag) {
                            return false;
                        }
                        maskValues.add(new MaskValue(false));
                        continue;
                    }
                    maskValues.add(new MaskValue(true));
                    continue;
                }
                if (objectData == null && ruleData != null || objectData != null && ruleData == null) {
                    if (CompareType.NOTEQUALS.equals((Object)compType)) {
                        maskValues.add(new MaskValue(true));
                        continue;
                    }
                    logger.warn((Object)("regexMatcher false. filter is: " + item.toString() + " objectData is:" + objectData + " ruleData is:" + ruleData));
                    if (flag) {
                        return false;
                    }
                    maskValues.add(new MaskValue(false));
                    continue;
                }
                maskValues.add(new MaskValue(true));
                continue;
            }
            catch (InterpreterException e) {
                throw new InvalidDAOMetaDataException(e.getMessage());
            }
            catch (SQLException sqle) {
                throw new InvalidDAOMetaDataException(sqle.getMessage());
            }
        }
        if (flag) {
            return true;
        }
        if (maskValues.size() != 0) {
            String expr = null;
            try {
                CollectionFormulaParser parse = new CollectionFormulaParser(maskString, (AbstractObjectCollection)maskValues);
                expr = parse.tokenList.showValue();
                Object obj = this.calculateMaskString(expr);
                return (Boolean)obj;
            }
            catch (BOSException e1) {
                throw new DataAccessException((Throwable)e1);
            }
        }
        return false;
    }

    private boolean matchEntryRules(IObjectValue value, FilterCollection entryRules) throws DataAccessException {
        int n = entryRules.size();
        for (int i = 0; i < n; ++i) {
            int j;
            FilterInfo filter = entryRules.get(i);
            IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance(this.ctx);
            IObjectCollection entries = (IObjectCollection)loader.getProperty(value, filter.getEntryName());
            if (entries == null || entries.size() <= 0) continue;
            boolean bCheck = false;
            if (EntryFilterType.ENTRYALLWHERE.equals((Object)filter.getEntryFilterType())) {
                bCheck = true;
                for (j = 0; j < entries.size(); ++j) {
                    if (this.matchMainRule(entries.getObject(j), filter)) continue;
                    bCheck = false;
                    break;
                }
            } else if (EntryFilterType.ENTRYANYWHERE.equals((Object)filter.getEntryFilterType())) {
                bCheck = false;
                for (j = 0; j < entries.size(); ++j) {
                    if (!this.matchMainRule(entries.getObject(j), filter)) continue;
                    bCheck = true;
                    break;
                }
            } else {
                throw new DataAccessException("entryFilterType error :" + filter.getEntryFilterType());
            }
            if (bCheck) continue;
            return false;
        }
        return true;
    }

    private SelectorItemCollection getSelectorByFilter(FilterInfo rule) {
        SelectorItemCollection selector = new SelectorItemCollection();
        PropertyCollection keyProps = this.bo.getLogicalKeyPropertiesRuntime();
        int keyCount = keyProps.size();
        for (int i = 0; i < keyCount; ++i) {
            selector.add(new SelectorItemInfo(keyProps.get(i).getName()));
        }
        FilterItemCollection fc = rule.getFilterItems();
        int j = fc.size();
        for (int i = 0; i < j; ++i) {
            selector.add(new SelectorItemInfo(fc.get(i).getPropertyName()));
        }
        return selector;
    }

    private Object calculateMaskString(String maskString) throws DataAccessException {
        if (maskString == null) {
            throw new IllegalArgumentException("Formula string couldn't be null.");
        }
        Interpreter interpreter = new Interpreter(this.ctx);
        String parse = maskString.toLowerCase().replaceAll("and", "&&").replaceAll("or", "||");
        try {
            return interpreter.evalExpr(parse, new HashMap());
        }
        catch (InterpreterException ie) {
            throw new DataAccessException((Throwable)ie);
        }
        catch (ParserException pe) {
            throw new DataAccessException((Throwable)pe);
        }
    }

    private static String unicode(char c) {
        String us = "0000" + Integer.toHexString(c & 0xFFFF);
        us = us.substring(us.length() - 4);
        return "\\u" + us;
    }

    public static String sql_like_to_regex(String sqlLike) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sqlLike.length(); ++i) {
            char c = sqlLike.charAt(i);
            if (c == '%') {
                sb.append(".*");
                continue;
            }
            if (c == '_') {
                sb.append(".");
                continue;
            }
            if ("\\(){}.*+".indexOf(c) >= 0) {
                sb.append(ObjectMatcher.unicode(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean regexMatcher(Object leftVal, Object rightVal, CompareType type) throws InterpreterException, SQLException {
        if (leftVal instanceof Timestamp) {
            leftVal = new Date(((Timestamp)leftVal).getTime());
        }
        if (rightVal instanceof Timestamp) {
            rightVal = new Date(((Timestamp)rightVal).getTime());
        }
        if (CompareType.EQUALS.equals((Object)type)) {
            if (leftVal instanceof Boolean && rightVal instanceof Integer) {
                return ((Boolean)leftVal).booleanValue() ? (Integer)rightVal == 1 : (Integer)rightVal == 0;
            }
            return TypeUtils.equal((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.GREATER.equals((Object)type)) {
            return TypeUtils.greaterThan((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.GREATER_EQUALS.equals((Object)type)) {
            return TypeUtils.greaterThanOrEqual((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.LESS.equals((Object)type)) {
            return TypeUtils.lessThan((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.LESS_EQUALS.equals((Object)type)) {
            return TypeUtils.lessThanOrEqual((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.NOTEQUALS.equals((Object)type)) {
            if (leftVal instanceof Boolean && rightVal instanceof Integer) {
                return !((Boolean)leftVal == false ? (Integer)rightVal == 0 : (Integer)rightVal == 1);
            }
            return !TypeUtils.equal((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.INNER.equals((Object)type)) {
            return this.computeInner(leftVal, rightVal);
        }
        if (CompareType.NOTINNER.equals((Object)type)) {
            return !this.computeInner(leftVal, rightVal);
        }
        if (CompareType.INCLUDE.equals((Object)type)) {
            return this.computeInclude(leftVal, rightVal);
        }
        if (CompareType.NOTINCLUDE.equals((Object)type)) {
            return !this.computeInclude(leftVal, rightVal);
        }
        if (CompareType.LIKE.equals((Object)type)) {
            return ObjectMatcher.computeLike(leftVal, rightVal);
        }
        if (CompareType.NOTLIKE.equals((Object)type)) {
            return !ObjectMatcher.computeLike(leftVal, rightVal);
        }
        if (CompareType.EXISTS.equals((Object)type)) {
            return this.computeExists(rightVal);
        }
        if (CompareType.NOTEXISTS.equals((Object)type)) {
            return !this.computeExists(rightVal);
        }
        throw new IllegalStateException();
    }

    private boolean computeExists(Object rightVal) throws SQLException {
        assert (this.cn != null);
        if (rightVal != null && rightVal instanceof String && !StringUtils.isEmpty((String)((String)rightVal))) {
            String sql = (String)rightVal;
            ResultSet rs = null;
            PreparedStatement preparedStmt = null;
            boolean rtn = false;
            try {
                preparedStmt = this.cn.prepareStatement(sql);
                rs = preparedStmt.executeQuery();
                if (rs.next()) {
                    rtn = true;
                }
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)preparedStmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStmt);
            return rtn;
        }
        return false;
    }

    private boolean computeInner(Object leftVal, Object rightVal) throws SQLException {
        block7: {
            assert (this.cn != null);
            if (rightVal == null || !(rightVal instanceof String) || StringUtils.isEmpty((String)((String)rightVal))) break block7;
            ArrayList<Object> value = new ArrayList<Object>();
            String sql = (String)rightVal;
            ResultSet rs = null;
            PreparedStatement preparedStmt = null;
            try {
                preparedStmt = this.cn.prepareStatement(sql);
                rs = preparedStmt.executeQuery();
                while (rs.next()) {
                    Object obj = rs.getObject(1);
                    if (obj == null) continue;
                    value.add(obj);
                }
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)preparedStmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStmt);
            if (value.contains(leftVal.toString())) {
                return true;
            }
        }
        return false;
    }

    static boolean computeLike(Object leftVal, Object rightVal) {
        Pattern filterPattern = Pattern.compile(ObjectMatcher.sql_like_to_regex(rightVal.toString()));
        Matcher filterMatcher = filterPattern.matcher(leftVal.toString());
        return filterMatcher.matches();
    }

    private boolean computeInclude(Object leftVal, Object rightVal) {
        if (rightVal != null && rightVal instanceof Set && ((Set)rightVal).size() != 0) {
            if (((Set)rightVal).contains(leftVal)) {
                return true;
            }
            if (leftVal != null && leftVal instanceof BOSUuid && ((Set)rightVal).contains(leftVal.toString())) {
                return true;
            }
        }
        return false;
    }

    public static final class ObjectPattern {
        final FilterInfo mainRule;
        final FilterCollection entryRules;

        public ObjectPattern(FilterInfo rule) {
            this(rule, null);
        }

        public ObjectPattern(FilterInfo rule, FilterCollection entryRules) {
            this.mainRule = rule;
            this.entryRules = entryRules;
        }
    }
}

