/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ORMappingManageTools;
import com.kingdee.bos.dao.ormapping.impl.ObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameters;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorItem;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorCache;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.data.KeyMapInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ObjectReader
extends ObjectHandler {
    private static final Logger logger = Logger.getLogger(ObjectReader.class);

    public ObjectReader(Context ctx, Connection cn, SolutionInfo solution) {
        super(ctx, cn, solution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectSQL(EntityObjectInfo bo, EntityViewInfo view) throws SQLException, InvalidDAOMetaDataException {
        try {
            EntityAccess ea = this.getEntityAccess(bo, view);
            String sql = new SQLGeneratorCache(ea, this.ctx).selectSQLWithTrueValue(bo, true, null, false);
            if (view.getSelector().size() == 1) {
                String string = ObjectReader.selectFirstColumn(sql);
                return string;
            }
            String string = sql;
            return string;
        }
        finally {
            this.close();
        }
    }

    private static String selectFirstColumn(String sql) {
        String rtn = sql;
        int posFrom = rtn.indexOf("FROM");
        if (rtn.indexOf("SELECT") >= 0 && posFrom > 0) {
            String columns = rtn.substring(rtn.indexOf("SELECT") + 7, posFrom);
            String afterFrom = rtn.substring(posFrom);
            if (columns.trim().length() > 0 && columns.indexOf(",") > 0) {
                String firstColumn = columns.substring(0, columns.indexOf(","));
                rtn = "SELECT " + firstColumn + " " + afterFrom;
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection selectNoChild(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector) throws SQLException, InvalidDAOMetaDataException {
        try {
            IObjectCollection iObjectCollection = this.innerSelectNoChildObject(bo, this.getEntityAccess(bo, filter, sorter, selector), null, false);
            return iObjectCollection;
        }
        finally {
            this.close();
        }
    }

    public IObjectCollection select(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector) throws SQLException, InvalidDAOMetaDataException {
        return this.select(bo, filter, sorter, selector, Integer.MIN_VALUE);
    }

    public IObjectCollection select(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector, int topCount) throws SQLException, InvalidDAOMetaDataException {
        return this.select(bo, filter, sorter, selector, topCount, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection select(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector, int topCount, int offset, boolean isoffset) throws SQLException, InvalidDAOMetaDataException {
        try {
            IObjectCollection iObjectCollection = this.innerSelect(bo, sorter, selector, this.getEntityAccess(bo, filter, sorter, selector), null, false, topCount, offset, isoffset);
            return iObjectCollection;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection select(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector, int start, int topCount) throws SQLException, InvalidDAOMetaDataException {
        try {
            if (sorter != null && sorter.size() > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < sorter.size(); ++i) {
                    sic.add(new SelectorItemInfo(sorter.get(i).getPropertyName()));
                }
                RTSelector rtSelector = RTSelectorBuilder.buildSelfPropAndAllPKSelector(sic, bo);
                for (int i = 0; i < rtSelector.size(); ++i) {
                    selector.add(rtSelector.get(i));
                }
            }
            IObjectCollection iObjectCollection = this.innerSelect(bo, sorter, selector, this.getEntityAccess(bo, filter, sorter, selector), null, false, start, topCount);
            return iObjectCollection;
        }
        finally {
            this.close();
        }
    }

    public IObjectCollection selectByEntryWhere(EntityObjectInfo bo, FilterInfo filterData, IObjectCollection entryFilters, SorterItemCollection sorter, RTSelector selector) throws SQLException, InvalidDAOMetaDataException {
        return this.selectByEntryWhere(bo, filterData, entryFilters, sorter, selector, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(EntityObjectInfo bo, FilterInfo filterData, IObjectCollection entryFilters, SorterItemCollection sorter, RTSelector selector, int topCount) throws InvalidDAOMetaDataException, SQLException {
        try {
            String string = this.innerSelectSql(bo, sorter, selector, this.getEntityAccess(bo, filterData, sorter, selector), filterData, entryFilters, null, false, null, topCount);
            return string;
        }
        finally {
            this.close();
        }
    }

    private String innerSelectSql(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, FilterInfo parentFilter, IObjectCollection entryFilterData, CrossTableInfo crossTable, boolean isCrossTableMainRef, String entryName, int topCount) throws InvalidDAOMetaDataException, SQLException {
        ORMappingManageTools.getInstance().invokeCreateObjectStart();
        if (!StringUtils.isEmpty((String)entryName)) {
            FilterInfo entryPermFilter = ((FilterCollection)entryFilterData).get(entryName);
            ea.parseEntryFilter(bo, entryPermFilter);
        }
        return ea.getSql(bo, true, crossTable, isCrossTableMainRef, topCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection selectByEntryWhere(EntityObjectInfo bo, FilterInfo filterData, IObjectCollection entryFilters, SorterItemCollection sorter, RTSelector selector, int topCount) throws SQLException, InvalidDAOMetaDataException {
        try {
            IObjectCollection iObjectCollection = this.innerSelectByEntryWhere(bo, sorter, selector, this.getEntityAccess(bo, filterData, sorter, selector), filterData, entryFilters, null, false, null, topCount);
            return iObjectCollection;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection selectByEntryWhere(EntityObjectInfo bo, FilterInfo filterData, IObjectCollection entryFilters, SorterItemCollection sorter, RTSelector selector, int topCount, int offset) throws SQLException, InvalidDAOMetaDataException {
        try {
            IObjectCollection iObjectCollection = this.innerSelectByEntryWhere(bo, sorter, selector, this.getEntityAccess(bo, filterData, sorter, selector), filterData, entryFilters, null, false, null, topCount, offset, true);
            return iObjectCollection;
        }
        finally {
            this.close();
        }
    }

    public boolean exist(EntityObjectInfo bo, FilterInfo filter) throws SQLException, InvalidDAOMetaDataException {
        EntityAccess ea = this.getEntityAccess(bo, filter, null, null);
        return ea.exists(bo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(EntityObjectInfo bo, FilterInfo filter) throws SQLException, InvalidDAOMetaDataException {
        try {
            EntityAccess ea = this.getEntityAccess(bo, filter, null, null);
            int n = ea.getCount(bo);
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK[] getPkList(EntityObjectInfo bo, FilterInfo filter, SorterItemCollection sorter, RTSelector selector) throws SQLException, InvalidDAOMetaDataException {
        try {
            IObjectPK[] iObjectPKArray = this.innerGetPkList(bo, this.getEntityAccess(bo, filter, sorter, selector), null, false);
            return iObjectPKArray;
        }
        finally {
            this.close();
        }
    }

    private IObjectPK[] innerGetPkList(EntityObjectInfo bo, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException, SQLException {
        return ea.getPkList(bo, true, crossTable, isCrossTableMainRef, Integer.MIN_VALUE);
    }

    private IObjectCollection innerSelectNoChildObject(EntityObjectInfo bo, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException, SQLException {
        return ea.select(bo, true, crossTable, isCrossTableMainRef);
    }

    IObjectCollection innerSelect(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException, SQLException {
        return this.innerSelect(bo, sorter, selector, ea, crossTable, isCrossTableMainRef, 0);
    }

    IObjectCollection innerSelect(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws InvalidDAOMetaDataException, SQLException {
        return this.innerSelect(bo, sorter, selector, ea, crossTable, isCrossTableMainRef, topCount, 0, true);
    }

    IObjectCollection innerSelect(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount, int offset, boolean isoffset) throws InvalidDAOMetaDataException, SQLException {
        IObjectCollection dpc = ea.select(bo, true, crossTable, isCrossTableMainRef, topCount, offset, isoffset);
        if (selector != null) {
            this.innerSetChildObject(HistoryUtil.dpcToList(dpc), bo, sorter, selector, ea.getFilterParameters());
        }
        return dpc;
    }

    IObjectCollection innerSelect(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, CrossTableInfo crossTable, boolean isCrossTableMainRef, int start, int topCount) throws InvalidDAOMetaDataException, SQLException {
        IObjectCollection dpc = ea.select(bo, true, crossTable, isCrossTableMainRef, start, topCount);
        if (selector != null) {
            this.innerSetChildObject(HistoryUtil.dpcToList(dpc), bo, sorter, selector, ea.getFilterParameters());
        }
        return dpc;
    }

    private IObjectCollection innerSelectByEntryWhere(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, FilterInfo parentFilter, IObjectCollection entryFilterData, CrossTableInfo crossTable, String entryName, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException, SQLException {
        return this.innerSelectByEntryWhere(bo, sorter, selector, ea, parentFilter, entryFilterData, crossTable, isCrossTableMainRef, entryName, Integer.MIN_VALUE);
    }

    private IObjectCollection innerSelectByEntryWhere(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, FilterInfo parentFilter, IObjectCollection entryFilterData, CrossTableInfo crossTable, boolean isCrossTableMainRef, String entryName, int topCount) throws InvalidDAOMetaDataException, SQLException {
        ORMappingManageTools.getInstance().invokeCreateObjectStart();
        if (!StringUtils.isEmpty((String)entryName)) {
            FilterInfo entryPermFilter = ((FilterCollection)entryFilterData).get(entryName);
            ea.parseEntryFilter(bo, entryPermFilter);
        }
        IObjectCollection dpc = ea.select(bo, true, crossTable, isCrossTableMainRef, topCount);
        if (selector != null) {
            this.innerSetChildObjectByEntryWhere(HistoryUtil.dpcToList(dpc), bo, sorter, selector, entryFilterData, parentFilter, entryName);
        }
        ORMappingManageTools.getInstance().invokeCreateObjectEnd();
        return dpc;
    }

    private IObjectCollection innerSelectByEntryWhere(EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, EntityAccess ea, FilterInfo parentFilter, IObjectCollection entryFilterData, CrossTableInfo crossTable, boolean isCrossTableMainRef, String entryName, int topCount, int offset, boolean isOffset) throws InvalidDAOMetaDataException, SQLException {
        ORMappingManageTools.getInstance().invokeCreateObjectStart();
        if (!StringUtils.isEmpty((String)entryName)) {
            FilterInfo entryPermFilter = ((FilterCollection)entryFilterData).get(entryName);
            ea.parseEntryFilter(bo, entryPermFilter);
        }
        IObjectCollection dpc = ea.select(bo, true, crossTable, isCrossTableMainRef, topCount, offset, isOffset);
        if (selector != null) {
            this.innerSetChildObjectByEntryWhere(HistoryUtil.dpcToList(dpc), bo, sorter, selector, entryFilterData, parentFilter, entryName);
        }
        ORMappingManageTools.getInstance().invokeCreateObjectEnd();
        return dpc;
    }

    private void fillChildObject(List objList, IObjectCollection childs, String linkName, EntityObjectInfo bo, EntityObjectInfo childbo) throws InvalidDAOMetaDataException {
        if (objList == null || objList.size() == 0 || childs == null || childs.size() == 0) {
            return;
        }
        PropertyInfo prop = bo.getPropertyByNameRuntime(linkName);
        if (prop instanceof OwnPropertyInfo) {
            throw new InvalidDAOMetaDataException(linkName + "should be a link property");
        }
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)prop);
        boolean isOneOrZero = CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo));
        String childLinkName = null;
        childLinkName = isOneOrZero ? bo.getFieldNameByRelationship(relation) : childbo.getFieldNameByRelationship(relation);
        if (childLinkName == null) {
            throw new InvalidDAOMetaDataException("can not find link property at child side. the parent link property name is " + linkName);
        }
        HashMap hm = new HashMap(0);
        if (!isOneOrZero) {
            hm = this.beforeFill(childs, childLinkName);
        }
        int size = objList.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue dp = (IObjectValue)objList.get(i);
            Object parentID = dp.get(dp.getPKField());
            if (isOneOrZero) {
                IObjectValue parentOldValue = (IObjectValue)dp.get(linkName);
                if (parentOldValue == null) continue;
                Object pId = parentOldValue.get(parentOldValue.getPKField());
                for (IObjectValue returnChild : childs) {
                    if (!returnChild.get(returnChild.getPKField()).equals(pId)) continue;
                    dp.put(linkName, (Object)returnChild);
                }
                continue;
            }
            IObjectCollection returnChilds = Utils.newObjectCollectionInstance(childbo);
            Object key = parentID instanceof BOSUuid ? parentID.toString() : parentID;
            int[] position = (int[])hm.get(key);
            if (position != null) {
                int n = position[1];
                for (int m = position[0]; m < n; ++m) {
                    returnChilds.addObject(childs.getObject(m));
                }
            }
            if (returnChilds.size() <= 0) continue;
            dp.put(linkName, (Object)returnChilds);
        }
    }

    private HashMap beforeFill(IObjectCollection childs, String childLinkName) {
        int beginPosition;
        HashMap<Object, int[]> hm = new HashMap<Object, int[]>(0);
        if (childs == null || childs.size() < 1) {
            return hm;
        }
        IObjectValue value = ObjectReader.getObjectValue(childs, childLinkName, 0);
        if (value == null || value.getPKField() == null) {
            return hm;
        }
        Object oldID = value.get(value.getPKField());
        int n = childs.size();
        for (int i = beginPosition = 0; i < n; ++i) {
            IObjectValue parentInfo;
            Object newID;
            value = ObjectReader.getObjectValue(childs, childLinkName, i);
            if (value == null || value.get(childLinkName) == null || (newID = (parentInfo = ObjectReader.getObjectValue(value, childLinkName)).get(parentInfo.getPKField())).equals(oldID)) continue;
            int[] position = new int[]{beginPosition, i};
            Object key = oldID instanceof BOSUuid ? oldID.toString() : oldID;
            hm.put(key, position);
            beginPosition = i;
            oldID = newID;
        }
        int[] position = new int[]{beginPosition, childs.size()};
        Object key = oldID instanceof BOSUuid ? oldID.toString() : oldID;
        hm.put(key, position);
        return hm;
    }

    private void innerSetChildObject(List objList, EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, RTFilterParameters parentFilter) throws InvalidDAOMetaDataException, SQLException {
        PropertyCollection flds = bo.getInheritedPropertiesRuntime();
        int n = flds.size();
        for (int j = 0; j < n; ++j) {
            PropertyInfo fld = flds.get(j);
            if (!(fld instanceof LinkPropertyInfo) || selector == null || !selector.startsWithKey(fld.getName())) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
            boolean isChd1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo));
            boolean isPrt1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo));
            if (!isChd1or0) {
                if (isPrt1or0) {
                    if (relation.getChildProperty(bo) == null) continue;
                    this.searchForOneToMulti(objList, bo, (LinkPropertyInfo)fld, sorter, selector, parentFilter);
                    continue;
                }
                this.searchForMultiToMulti(objList, bo, (LinkPropertyInfo)fld);
                continue;
            }
            if (!isPrt1or0) continue;
            this.searchForOneToOne(objList, bo, (LinkPropertyInfo)fld, sorter, selector);
        }
    }

    private void innerSetChildObjectByEntryWhere(List objList, EntityObjectInfo bo, SorterItemCollection sorter, RTSelector selector, IObjectCollection entryFilter, FilterInfo parentFilter, String entryName) throws InvalidDAOMetaDataException, SQLException {
        PropertyCollection flds = bo.getInheritedPropertiesRuntime();
        int n = flds.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = flds.get(i);
            if (!(fld instanceof LinkPropertyInfo) || selector == null || !selector.startsWithKey(fld.getName())) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
            boolean isChd1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo));
            boolean isPrt1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo));
            if (!isChd1or0) {
                if (isPrt1or0) {
                    this.searchForOneToMultiByEntryWhere(objList, bo, (LinkPropertyInfo)fld, sorter, selector, entryFilter, parentFilter, entryName);
                    continue;
                }
                this.searchForMultiToMulti(objList, bo, (LinkPropertyInfo)fld);
                continue;
            }
            if (!isPrt1or0) continue;
            this.searchForOneToOne(objList, bo, (LinkPropertyInfo)fld, sorter, selector);
        }
    }

    private void searchForOneToMulti(List objList, EntityObjectInfo bo, LinkPropertyInfo fld, SorterItemCollection sorter, RTSelector selector, RTFilterParameters parentFilter) throws InvalidDAOMetaDataException, SQLException {
        OwnPropertyInfo seqProp;
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo childbo = relation.getChildObject(bo);
        EntityAccess ea = this.getEntityAccess(childbo, childbo.getTable().getName());
        String fieldName = childbo.getFieldNameByRelationship(relation);
        if (fieldName == null) {
            throw new InvalidDAOMetaDataException("Get field Name by relationship error. Entity:" + childbo.getFullName() + "relation:" + relation.getFullName());
        }
        RTSelector childSelector = null;
        if (selector != null) {
            childSelector = RTSelectorBuilder.getChildInnerSelectors(selector, (PropertyInfo)fld, childbo);
            if (childSelector.size() == 0) {
                return;
            }
            childSelector.add(new RTSelectorItem(childbo, fieldName));
        }
        ea.addSortItemAtFirst(new SorterItemInfo(fieldName));
        boolean isSorter = false;
        SorterItemCollection newSorter = new SorterItemCollection();
        if (sorter != null && sorter.size() != 0) {
            int n = sorter.size();
            for (int i = 0; i < n; ++i) {
                String sortName = sorter.get(i).getPropertyName();
                if (sortName == null || !sortName.startsWith(fld.getName())) continue;
                String lastName = sortName.substring(sortName.indexOf(46) + 1);
                SorterItemInfo sort = new SorterItemInfo(lastName);
                sort.setSortType(sorter.get(i).getSortType());
                sort.setNLSSortType(sorter.get(i).getNLSSortType());
                if (lastName.indexOf(46) < 0) {
                    ea.addSortItem(sort);
                    isSorter = true;
                    continue;
                }
                newSorter.add(sort);
            }
        }
        if (!isSorter && (seqProp = childbo.getSequenceProperty()) != null) {
            ea.addSortItem(new SorterItemInfo(seqProp.getName()));
        }
        childSelector = this.recombineFilters(bo, parentFilter, relation, childbo, ea, childSelector, selector);
        ea.setSelector(childSelector);
        this.fillChildObject(objList, this.innerSelect(childbo, sorter, childSelector, ea, null, false), fld.getName(), bo, childbo);
    }

    private void searchForOneToMultiByEntryWhere(List objList, EntityObjectInfo bo, LinkPropertyInfo fld, SorterItemCollection sorter, RTSelector selector, IObjectCollection entryFilter, FilterInfo parentFilter, String entryName) throws SQLException, InvalidDAOMetaDataException {
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo childbo = relation.getChildObject(bo);
        EntityAccess ea = this.getEntityAccess(childbo, childbo.getTable().getName());
        String fieldName = childbo.getFieldNameByRelationship(relation);
        if (fieldName == null) {
            throw new InvalidDAOMetaDataException("Get field Name by relationship error. Entity:" + childbo.getFullName() + "relation:" + relation.getFullName());
        }
        RTSelector childSelector = null;
        if (selector != null) {
            childSelector = RTSelectorBuilder.getChildInnerSelectors(selector, (PropertyInfo)fld, childbo);
            if (childSelector.size() == 0) {
                return;
            }
            childSelector.add(new RTSelectorItem(childbo, fieldName));
        }
        ea.addSortItemAtFirst(new SorterItemInfo(fieldName));
        boolean isSorter = false;
        SorterItemCollection newSorter = new SorterItemCollection();
        if (sorter != null && sorter.size() != 0) {
            int n = sorter.size();
            for (int i = 0; i < n; ++i) {
                String sortName = sorter.get(i).getPropertyName();
                if (StringUtils.isEmpty((String)sortName) || !sortName.startsWith(fld.getName())) continue;
                String lastName = sortName.substring(sortName.indexOf(46) + 1);
                SorterItemInfo sort = new SorterItemInfo(lastName);
                sort.setSortType(sorter.get(i).getSortType());
                sort.setNLSSortType(sorter.get(i).getNLSSortType());
                if (lastName.indexOf(46) < 0) {
                    ea.addSortItem(sort);
                    isSorter = true;
                    continue;
                }
                newSorter.add(sort);
            }
        }
        if (!isSorter && childbo.getSequenceProperty() != null) {
            ea.addSortItem(new SorterItemInfo(childbo.getSequenceProperty().getName()));
        }
        FilterInfo parent = null;
        if (parentFilter != null) {
            try {
                parent = new FilterInfo(parentFilter.toString());
            }
            catch (ParserException pe) {
                throw new InvalidDAOMetaDataException((Throwable)pe);
            }
        }
        String strEntryName = fld.getName();
        if (!StringUtils.isEmpty((String)entryName)) {
            strEntryName = entryName + "." + strEntryName;
        }
        FilterInfo primalFilter = null;
        if (!ea.isEntryPermCol()) {
            primalFilter = ((FilterCollection)entryFilter).get(strEntryName);
            if (parent != null && parent.getFilterItems().size() != 0) {
                this.prepareParentFilter(parent, relation, bo);
                if (primalFilter != null && primalFilter.getFilterItems().size() > 0 && primalFilter.getEntryFilterType().equals((Object)EntryFilterType.NORMAL)) {
                    try {
                        primalFilter.mergeFilter(parent, "and");
                    }
                    catch (BOSException bose) {
                        throw new SQLException(bose.getMessage());
                    }
                } else {
                    primalFilter = parent;
                }
            }
        } else if (parent != null && parent.getFilterItems().size() != 0) {
            this.prepareParentFilter(parent, relation, bo);
            primalFilter = parent;
        }
        try {
            childSelector = this.recombineFiltersByEntryWhere(bo, primalFilter, childbo, ea, childSelector);
            ea.setSelector(childSelector);
        }
        catch (Throwable ignore) {
            logger.warn((Object)ignore.getMessage(), ignore);
        }
        IObjectCollection coll = this.innerSelectByEntryWhere(childbo, newSorter, childSelector, ea, primalFilter, entryFilter, null, strEntryName, false);
        this.fillChildObject(objList, coll, fld.getName(), bo, childbo);
    }

    private void prepareParentFilter(FilterInfo filter, RelationshipInfo relation, EntityObjectInfo bo) {
        FilterItemCollection items = filter.getFilterItems();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            FilterItemInfo item = items.get(i);
            item.setPropertyName(relation.getChildProperty(bo).getName() + "." + item.getPropertyName());
            if (!item.isCompareValueIsProperty()) continue;
            item.setCompareValue((Object)(relation.getChildProperty(bo).getName() + "." + item.getCompareValue()));
        }
    }

    private RTSelector recombineFilters(EntityObjectInfo bo, RTFilterParameters parentFilter, RelationshipInfo relation, EntityObjectInfo childbo, EntityAccess ea, RTSelector childSelector, RTSelector parentSelector) throws InvalidDAOMetaDataException {
        if (parentFilter != null && parentFilter.size() > 0) {
            String parentSidePropName = relation.getParentProperty(childbo).getName();
            String local = "_" + this.ctx.getLocale().toString();
            int filterCount = parentFilter.size();
            for (int i = 0; i < filterCount; ++i) {
                RTFilterParameter filterInfo = parentFilter.get(i);
                String parentFullPropName = filterInfo.getFullFieldName();
                int indexofDot = parentFullPropName.indexOf(46);
                if (indexofDot < 0) {
                    EntityObjectInfo entitytemp;
                    PropertyInfo prop = bo.getInheritedPropertyByColName(filterInfo.getFieldName(), local);
                    FilterItemInfo newItemInfo = new FilterItemInfo(parentSidePropName + '.' + filterInfo.getFieldName(), filterInfo.getCompareValue(), filterInfo.getCompareType());
                    if (filterInfo.isCompareValueIsProperty()) {
                        newItemInfo.setCompareValue(filterInfo.getCompareValue());
                        newItemInfo.setCompareValueIsProperty(filterInfo.isCompareValueIsProperty());
                    }
                    ea.addFilter(newItemInfo, prop.getMappingField(), bo.isBOSUuidCol(prop));
                    if (childSelector == null) {
                        childSelector = new RTSelector();
                    }
                    if ((entitytemp = bo.getSelfEntityObjectInfoByNameRuntime(prop.getName())) == null || entitytemp.getTable() == null) {
                        throw new InvalidDAOMetaDataException("canot find property:'" + prop.getName() + "' at InnerSelectDAO.recombineFilters");
                    }
                    childSelector.add(new RTSelectorItem(childbo, parentSidePropName, entitytemp.getTable().getName()));
                    continue;
                }
                if (parentFullPropName.substring(0, indexofDot).equalsIgnoreCase(parentSidePropName)) {
                    FilterItemInfo newItemInfo = new FilterItemInfo(parentFullPropName.substring(indexofDot + 1), filterInfo.getCompareValue(), filterInfo.getCompareType());
                    if (filterInfo.isCompareValueIsProperty()) {
                        newItemInfo.setCompareValue(filterInfo.getCompareValue());
                        newItemInfo.setCompareValueIsProperty(filterInfo.isCompareValueIsProperty());
                    }
                    PropertyInfo chdSideProp = relation.getChildProperty(childbo);
                    ea.addFilter(newItemInfo, chdSideProp.getMappingField(), childbo.isBOSUuidCol(chdSideProp));
                    continue;
                }
                int lastIndxOfDot = parentFullPropName.lastIndexOf(".");
                EntityObjectInfo boTemp = ObjectReader.getEntityInfo(parentFullPropName, bo);
                PropertyInfo prop = boTemp.getInheritedPropertyByColName(parentFullPropName.substring(lastIndxOfDot + 1), local);
                FilterItemInfo newItemInfo = new FilterItemInfo(parentSidePropName + '.' + parentFullPropName, filterInfo.getCompareValue(), filterInfo.getCompareType());
                if (filterInfo.isCompareValueIsProperty()) {
                    newItemInfo.setCompareValue(filterInfo.getCompareValue());
                    newItemInfo.setCompareValueIsProperty(filterInfo.isCompareValueIsProperty());
                }
                ea.addFilter(newItemInfo, prop.getMappingField(), boTemp.isBOSUuidCol(prop));
                if (childSelector == null) {
                    childSelector = new RTSelector();
                }
                String linkNameTemp = parentFullPropName.substring(0, lastIndxOfDot);
                String tableName = null;
                if (boTemp.isAbstract()) {
                    int n = parentSelector.size();
                    for (int j = 0; j < n; ++j) {
                        RTSelectorItem item = parentSelector.get(j);
                        if (!item.getPropertyName().equals(linkNameTemp) || item.get("tableName") == null) continue;
                        tableName = (String)item.get("tableName");
                        break;
                    }
                    childSelector.add(new RTSelectorItem(boTemp, parentSidePropName + '.' + linkNameTemp + '.' + prop.getName(), tableName));
                    continue;
                }
                childSelector.add(new RTSelectorItem(boTemp, parentSidePropName + '.' + linkNameTemp + '.' + prop.getName()));
            }
            ea.getFilterParameters().setFormat(parentFilter.getFormat());
        }
        return childSelector;
    }

    private RTSelector recombineFiltersByEntryWhere(EntityObjectInfo bo, FilterInfo filter, EntityObjectInfo childbo, EntityAccess ea, RTSelector childSelector) throws InvalidDAOMetaDataException {
        if (filter != null) {
            FilterItemCollection items = filter.getFilterItems();
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                FilterItemInfo filterInfo = items.get(i);
                String filterName = filterInfo.getPropertyName();
                if (filterName.indexOf(46) < 0) {
                    EntityObjectInfo entitytemp;
                    FilterItemInfo chdFilter;
                    PropertyInfo prop = childbo.getPropertyByNameRuntime(filterName);
                    if (prop instanceof OwnPropertyInfo || prop instanceof LinkPropertyInfo && prop.getMappingField() != null) {
                        chdFilter = new FilterItemInfo(filterName, filterInfo.getCompareValue(), filterInfo.getCompareType());
                        if (filterInfo.isCompareValueIsProperty()) {
                            chdFilter.setCompareValue(filterInfo.getCompareValue());
                            chdFilter.setCompareValueIsProperty(filterInfo.isCompareValueIsProperty());
                        }
                    } else {
                        throw new InvalidDAOMetaDataException("The property:'" + prop.getName() + "' is unknown");
                    }
                    ea.addFilter(chdFilter, prop.getMappingField(), childbo.isBOSUuidCol(prop));
                    if (childSelector == null) {
                        childSelector = new RTSelector();
                    }
                    if ((entitytemp = childbo.getSelfEntityObjectInfoByNameRuntime(prop.getName())) == null || entitytemp.getTable() == null) {
                        throw new InvalidDAOMetaDataException("canot find property:'" + prop.getName() + "' at InnerSelectDAO.recombineFilters");
                    }
                    childSelector.add(new RTSelectorItem(childbo, prop.getName(), entitytemp.getTable().getName()));
                    continue;
                }
                EntityObjectInfo boTemp = ObjectReader.getEntityInfo(filterName, childbo);
                String fieldName = filterName.substring(filterName.lastIndexOf(46) + 1);
                PropertyInfo prop = boTemp.getPropertyByNameRuntime(fieldName);
                FilterItemInfo chdFilter = new FilterItemInfo(filterName, filterInfo.getCompareValue(), filterInfo.getCompareType());
                if (filterInfo.isCompareValueIsProperty()) {
                    chdFilter.setCompareValue(filterInfo.getCompareValue());
                    chdFilter.setCompareValueIsProperty(filterInfo.isCompareValueIsProperty());
                }
                ea.addFilter(chdFilter, prop.getMappingField(), boTemp.isBOSUuidCol(prop));
                if (childSelector == null) {
                    childSelector = new RTSelector();
                }
                this.addSelectorByFilterName(filterName, prop, childSelector, boTemp);
                if (!filterInfo.isCompareValueIsProperty()) continue;
                String strCompareValue = (String)filterInfo.getCompareValue();
                chdFilter.setCompareValue((Object)strCompareValue);
                String tempName = strCompareValue.substring(strCompareValue.lastIndexOf(46) + 1);
                PropertyInfo propValue = boTemp.getPropertyByNameRuntime(tempName);
                this.addSelectorByFilterName(strCompareValue, propValue, childSelector, boTemp);
            }
            ea.getFilterParameters().setFormat(filter.getMaskString());
        }
        return childSelector;
    }

    private void addSelectorByFilterName(String filterName, PropertyInfo prop, RTSelector childSelector, EntityObjectInfo boTemp) throws InvalidDAOMetaDataException {
        String linkNameTemp = filterName.substring(0, filterName.lastIndexOf("."));
        String selectorName = linkNameTemp + '.' + prop.getName();
        String tableName = null;
        if (boTemp.isAbstract()) {
            int m = childSelector.size();
            for (int j = 0; j < m; ++j) {
                RTSelectorItem si = childSelector.get(j);
                if (!si.getPropertyName().equals(linkNameTemp) || si.get("tableName") == null) continue;
                tableName = (String)si.get("tableName");
                break;
            }
            childSelector.add(new RTSelectorItem(boTemp, selectorName, tableName));
        } else {
            childSelector.add(new RTSelectorItem(boTemp, selectorName));
        }
    }

    private static EntityObjectInfo getEntityInfo(String parentFullPropName, EntityObjectInfo bo) {
        EntityObjectInfo boTemp = bo;
        PropertyInfo prop = null;
        String[] names = StringUtils.fastSplit((String)parentFullPropName, (String)".");
        int n = names.length - 1;
        for (int i = 0; i < n; ++i) {
            prop = boTemp.getPropertyByNameRuntime(names[i]);
            if (!(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)prop);
            boTemp = relation.getChildObject(boTemp);
        }
        return boTemp;
    }

    private void searchForOneToOne(List parentList, EntityObjectInfo bo, LinkPropertyInfo fld, SorterItemCollection sorter, RTSelector selector) throws InvalidDAOMetaDataException, SQLException {
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        String fldName = fld.getName();
        EntityObjectInfo chdbo = relation.getChildObject(bo);
        ArrayList<IObjectValue> objList = null;
        HashSet<Object> idSet = null;
        int n = parentList.size();
        for (int i = 0; i < n; ++i) {
            Object o = ((IObjectValue)parentList.get(i)).get(fldName);
            if (o instanceof String || o == null) continue;
            if (objList == null) {
                objList = new ArrayList<IObjectValue>();
            }
            if (idSet == null) {
                idSet = new HashSet<Object>();
            }
            Object id = ((IObjectValue)o).get(((IObjectValue)o).getPKField());
            objList.add((IObjectValue)o);
            if (idSet.contains(id)) continue;
            idSet.add(id);
        }
        if (objList != null && objList.size() > 0) {
            RTSelector childSelector = null;
            if (selector != null) {
                childSelector = RTSelectorBuilder.getChildInnerSelectors(selector, (PropertyInfo)fld, chdbo);
                if (childSelector.size() == 0) {
                    return;
                }
                if (childSelector.size() == 1) {
                    String selectItem = childSelector.get(0).getPropertyName();
                    PropertyCollection keyProps = chdbo.getLogicalKeyPropertiesRuntime();
                    if (keyProps.size() == 1 && !StringUtils.isEmpty((String)selectItem) && selectItem.equalsIgnoreCase(keyProps.get(0).getName())) {
                        return;
                    }
                }
            }
            EntityAccess ea = this.getEntityAccess(chdbo, chdbo.getTable().getName());
            FilterItemInfo item = new FilterItemInfo(relation.getParentProperty(chdbo).getName(), idSet, CompareType.INCLUDE);
            PropertyInfo field = chdbo.getFieldByFullName(item.getPropertyName());
            if (field == null) {
                throw new InvalidDAOMetaDataException("field " + item.getPropertyName() + " can not found" + ",  chdbo=" + chdbo.getFullName());
            }
            ColumnInfo col = field.getMappingField();
            ea.addFilter(item, col, chdbo.isBOSUuidCol(field));
            this.innerSetChildObject(objList, chdbo, sorter, childSelector, ea.getFilterParameters());
            if (parentList.size() != objList.size()) {
                int dpcSize = parentList.size();
                for (int i = 0; i < dpcSize; ++i) {
                    IObjectValue value = ((IObjectValue)parentList.get(i)).getObjectValue(fldName);
                    if (value == null) continue;
                    int colSize = objList.size();
                    for (int j = 0; j < colSize; ++j) {
                        IObjectValue valueNew = (IObjectValue)objList.get(j);
                        String newPKField = valueNew.getPKField();
                        if (newPKField == null || value.getPKField() == null || valueNew.get(newPKField) == null) {
                            throw new InvalidDAOMetaDataException("cannot find pk at method innerSelect.searchForOneToOne,  valueNew.getPKField()=" + valueNew.getPKField() + ",  value.getPKField()=" + value.getPKField() + ",  valueNew.get(valueNew.getPKField())=" + valueNew.get(valueNew.getPKField()) + ",  value=" + value + ",  valueNew=" + valueNew + ",  fldName=" + fldName + ",  chdbo=" + chdbo.getFullName());
                        }
                        if (!valueNew.get(newPKField).equals(value.get(value.getPKField()))) continue;
                        ((IObjectValue)parentList.get(i)).put(fldName, (Object)valueNew);
                    }
                }
            }
        }
    }

    private void searchForMultiToMulti(List objList, EntityObjectInfo bo, LinkPropertyInfo fld) throws InvalidDAOMetaDataException, SQLException {
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        String fldName = fld.getName();
        EntityObjectInfo childbo = relation.getChildObject(bo);
        EntityObjectInfo curbo = bo;
        if (!CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) {
            while (!curbo.getPropertiesRuntime().containsKey((Object)fldName) && curbo.getBaseEntity() != null) {
                curbo = curbo.getBaseEntity();
            }
            if (curbo.getName().equals(childbo.getName())) {
                childbo = relation.getParentObject(bo);
            }
        }
        CrossTableInfo crossTable = relation.getCrossTable();
        boolean mainref = ImplUtils.isMainObjRefCrossTable(curbo, childbo, fld, crossTable);
        IObjectCollection icTemp = Utils.newObjectCollectionInstance(bo);
        IObjectCollection icReturn = Utils.newObjectCollectionInstance(bo);
        int nn = objList.size();
        for (int i = 0; i < nn; ++i) {
            EntityAccess ea = this.getEntityAccess(childbo, childbo.getTable().getName());
            icTemp.addObject((IObjectValue)objList.get(i));
            KeyMapCollection keyMaps = mainref ? crossTable.getClientTableMap().getKeyMaps() : crossTable.getSupplierTableMap().getKeyMaps();
            int keyMapsSize = keyMaps.size();
            for (int j = 0; j < keyMapsSize; ++j) {
                KeyMapInfo keyMap = keyMaps.get(j);
                ColumnInfo refCol = keyMap.getRefColumn();
                PropertyInfo refProp = curbo.getInheritedPropertyByColName(refCol.getName());
                if (icTemp.size() == 0) {
                    return;
                }
                FilterItemInfo newItemInfo = new FilterItemInfo(refProp.getName(), icTemp.getObject(0).get(icTemp.getObject(0).getPKField()), CompareType.EQUALS, true);
                ea.addFilter(newItemInfo, keyMap.getSelfColumn(), true);
            }
            this.fillChildObject(objList, this.innerSelect(childbo, null, null, ea, crossTable, mainref), fldName, bo, childbo);
            icReturn.addObject((IObjectValue)objList.get(0));
            icTemp.clear();
        }
    }

    private static IObjectValue getObjectValue(IObjectCollection childs, String childLinkName, int index) {
        IObjectValue value = null;
        Object childLink = childs.getObject(index).get(childLinkName);
        if (childLink != null) {
            if (childLink instanceof IObjectValue) {
                value = childs.getObject(index);
            } else {
                IObjectCollection ic = (IObjectCollection)childLink;
                if (ic.size() > 0) {
                    value = ic.getObject(index);
                }
            }
        }
        return value;
    }

    private static IObjectValue getObjectValue(IObjectValue objectValue, String childLinkName) {
        IObjectValue value = null;
        Object childLink = objectValue.get(childLinkName);
        if (childLink != null) {
            if (childLink instanceof IObjectValue) {
                value = (IObjectValue)childLink;
            } else {
                IObjectCollection ic = (IObjectCollection)childLink;
                if (ic.size() > 0) {
                    value = ic.getObject(0);
                }
            }
        }
        return value;
    }
}

