/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.WholeTableAffectedException;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameters;
import com.kingdee.bos.dao.ormapping.impl.SQLGenerCache;
import com.kingdee.bos.dao.ormapping.impl.SQLGenerator;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorImpl;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

class SQLGeneratorCache
implements SQLGenerator {
    private final EntityAccess ea;
    private final Context ctx;

    public SQLGeneratorCache(EntityAccess ea, Context ctx) {
        this.ea = ea;
        this.ctx = ctx;
    }

    private final SQLGenerator impl() {
        return new SQLGeneratorImpl(this.ea, this.ctx);
    }

    @Override
    public String delete() throws WholeTableAffectedException {
        String sql = null;
        if (this.needCache()) {
            String deleteIdentity = this.getDeleteDescKey();
            String key = this.transMD5(deleteIdentity);
            String desc = SQLGenerCache.getInstance().getDeleteDesc(key);
            if (desc == null) {
                sql = this.impl().delete();
                SQLGenerCache.getInstance().putDeleteDesc(key, sql);
            } else {
                sql = desc;
                RTFilterParameters fps = this.ea.getFilterParameters();
                int filtersCount = fps.size();
                for (int i = 0; i < filtersCount; ++i) {
                    RTFilterParameter fp = fps.get(i);
                    this.ea.addParameter(fp.getFieldName(), fp.getCompareValue(), fp.getSqlType());
                }
            }
        } else {
            sql = this.impl().delete();
        }
        return sql;
    }

    @Override
    public String deleteBySQL(EntityObjectInfo bo) throws WholeTableAffectedException {
        return this.impl().deleteBySQL(bo);
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix) throws InvalidDAOMetaDataException {
        return this.selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, Integer.MIN_VALUE);
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, int topCount) throws InvalidDAOMetaDataException {
        return this.selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, topCount, 0);
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, int topCount, int offset) throws InvalidDAOMetaDataException {
        String sql = null;
        if (this.needCache()) {
            String selectIdntity = this.getSelectDescKey(bo, isMultilingual, this.ctx.getLocale(), selectPrefix, topCount);
            String key = this.transMD5(selectIdntity + offset);
            SQLGenerCache.SelectDescriptor desc = SQLGenerCache.getInstance().getSelectDesc(key);
            if (desc == null) {
                sql = this.impl().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, topCount, offset);
                desc = new SQLGenerCache.SelectDescriptor(this.ea.getAliasMapping(), this.ea.getFieldList(), sql);
                SQLGenerCache.getInstance().putSelectDesc(key, desc);
            } else {
                this.ea.setAliasMapping(desc.getAliasMapping());
                this.ea.setFieldList(desc.getFieldList());
                sql = desc.getSql();
                RTFilterParameters fps = this.ea.getFilterParameters();
                int filtersCount = fps.size();
                for (int i = 0; i < filtersCount; ++i) {
                    RTFilterParameter fp = fps.get(i);
                    Object value = fp.getCompareValue();
                    this.ea.addParameter(fp.getFieldName() + "&" + i, value, fp.getSqlType());
                }
            }
        } else {
            sql = this.impl().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, topCount, offset);
        }
        return sql;
    }

    @Override
    public String selectSQLWithTrueValue(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException {
        return this.impl().selectSQLWithTrueValue(bo, isMultilingual, crossTable, isCrossTableMainRef);
    }

    @Override
    public String selectSQLWithTrueValue(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws InvalidDAOMetaDataException {
        return this.impl().selectSQLWithTrueValue(bo, isMultilingual, crossTable, isCrossTableMainRef, topCount);
    }

    @Override
    public String update() throws WholeTableAffectedException {
        return this.impl().update();
    }

    private boolean needCache() {
        boolean bNeedCache = true;
        IDeployInfoManager deploy = DeployInfoManagerFactory.getDeployInfoManager();
        if (!deploy.isUseSelectCache()) {
            bNeedCache = false;
        }
        RTFilterParameters fps = this.ea.getFilterParameters();
        int filtersCount = fps.size();
        for (int i = 0; i < filtersCount; ++i) {
            RTFilterParameter fp = fps.get(i);
            CompareType type = fp.getCompareType();
            Object value = fp.getCompareValue();
            if (value != null && !CompareType.INCLUDE.equals((Object)type) && !CompareType.NOTINCLUDE.equals((Object)type) && !CompareType.INNER.equals((Object)type) && !CompareType.NOTINNER.equals((Object)type) && !CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) continue;
            bNeedCache = false;
            break;
        }
        return bNeedCache;
    }

    private String getDeleteDescKey() {
        StringBuffer desc = new StringBuffer();
        desc.append("delete+");
        desc.append(this.ea.getTableName());
        if (this.ea.getFilterParameters() != null) {
            desc.append("+");
            desc.append(this.ea.getFilterParameters().toString());
        }
        return desc.toString();
    }

    private String getSelectDescKey(EntityObjectInfo bo, boolean isMultilingual, Locale locale, String selectPrefix, int topCount) {
        StringBuffer desc = new StringBuffer();
        desc.append("select+");
        desc.append(bo.getFullName());
        if (this.ea.getSelector() != null) {
            desc.append("+");
            desc.append(this.ea.getSelector().toString());
        }
        if (this.ea.getFilterParameters() != null) {
            desc.append("+");
            desc.append(this.ea.getFilterParameters().toString());
        }
        if (this.ea.getSorter() != null) {
            desc.append("+");
            desc.append(this.ea.getSorter().toString());
        }
        if (this.ea.getEntryFilterParameters() != null) {
            desc.append("+");
            desc.append(this.ea.getEntryFilterParameters().toString());
        }
        desc.append("+");
        desc.append(isMultilingual);
        desc.append("+");
        desc.append(locale.toString());
        desc.append("+");
        desc.append(selectPrefix);
        desc.append("+");
        desc.append(topCount);
        return desc.toString();
    }

    private String transMD5(String str) {
        StringBuffer buf = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] b = md.digest();
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return buf.toString();
    }
}

