/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.WholeTableAffectedException;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.GeneratorContext;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.KeyWord;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameters;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorItem;
import com.kingdee.bos.dao.ormapping.impl.SQLGenerator;
import com.kingdee.bos.dao.ormapping.impl.SQLStringBuffer;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.data.KeyMapInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLGeneratorImpl
implements SQLGenerator {
    private static final Logger logger = Logger.getLogger(SQLGeneratorImpl.class);
    private final EntityAccess ea;
    private final Context ctx;
    HashMap<String, String> historyTableMap = new HashMap();
    private static final String BLANK = " ";

    public SQLGeneratorImpl(EntityAccess ea, Context ctx) {
        this.ea = ea;
        this.ctx = ctx;
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix) throws InvalidDAOMetaDataException {
        return SQLGeneratorImpl.optimize(this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, false, Integer.MIN_VALUE));
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, int topCount) throws InvalidDAOMetaDataException {
        return SQLGeneratorImpl.optimize(this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, false, topCount));
    }

    @Override
    public String selectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, int topCount, int offset) throws InvalidDAOMetaDataException {
        return SQLGeneratorImpl.optimize(this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, false, topCount, offset));
    }

    @Override
    public String selectSQLWithTrueValue(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws InvalidDAOMetaDataException {
        return SQLGeneratorImpl.optimize(this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", true, Integer.MIN_VALUE));
    }

    @Override
    public String selectSQLWithTrueValue(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws InvalidDAOMetaDataException {
        return SQLGeneratorImpl.optimize(this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", true, topCount));
    }

    private static final String optimize(String sql) throws InvalidDAOMetaDataException {
        try {
            return KSqlUtil.optimize((String)sql);
        }
        catch (SqlTranslateException e1) {
            throw new InvalidDAOMetaDataException(e1.getMessage() + ",  sql:" + sql);
        }
    }

    private String innerSelectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, boolean isTrueVal, int topCount) throws InvalidDAOMetaDataException {
        return this.innerSelectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, selectPrefix, isTrueVal, topCount, 0);
    }

    private String innerSelectSQL(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, String selectPrefix, boolean isTrueVal, int topCount, int offset) throws InvalidDAOMetaDataException {
        String sql;
        String entryWhereClause;
        GeneratorContext generCtx = new GeneratorContext();
        String boName = bo.getName();
        if (topCount > 0) {
            generCtx.selectSql.append(" top " + topCount);
            if (offset > 0) {
                generCtx.selectSql.append("," + offset);
            }
            generCtx.selectSql.append(BLANK);
        }
        generCtx.fromSql.appendFrom(this.ea.getTableName(), generCtx.getTableAlias(boName));
        this.getCrossTableClause(bo, crossTable, isCrossTableMainRef, generCtx);
        this.innerGetSQL(boName, null, bo, isMultilingual, generCtx);
        int m = generCtx.selectSql.length();
        if (generCtx.selectSql.charAt(m - 1) == ',') {
            generCtx.selectSql = generCtx.selectSql.deleteCharAt(m - 1);
        }
        if (generCtx.whereSql.length() != 0) {
            generCtx.whereSql.append(")");
        }
        if (isTrueVal) {
            generCtx.whereSql.append(this.getWhereClauseWithTrueValue(bo, crossTable, generCtx.whereSql.length() == 0, generCtx));
        } else {
            generCtx.whereSql.append(this.getWhereClause(bo, crossTable, generCtx.whereSql.length() == 0, generCtx));
        }
        if (this.ea.isEntryPermCol() && !StringUtils.isEmpty((String)(entryWhereClause = this.getEntryWherePermClause(bo, crossTable, generCtx.whereSql.length() == 0, generCtx)))) {
            String entryWhereFieldSql = "Case When (" + entryWhereClause + ") Then 1 else 0 end ";
            entryWhereFieldSql = entryWhereFieldSql + "\"_V\"";
            OwnPropertyInfo newField = new OwnPropertyInfo();
            newField.setName("_V");
            newField.setDataType(DataType.BOOLEAN);
            generCtx.fieldList.add((PropertyInfo)newField);
            generCtx.selectSql.append(",").append(entryWhereFieldSql);
        }
        this.ea.setAliasMapping(generCtx.aliasMapping);
        this.ea.setFieldList(generCtx.fieldList);
        if (KeyWord.COUNT.equals(selectPrefix)) {
            String sql_temp = SQLGeneratorImpl.optimize(generCtx.selectSql.append(generCtx.fromSql).append(generCtx.whereSql).toString());
            sql = new SQLStringBuffer("SELECT COUNT(1) FROM (" + sql_temp + ") tempTable").toString();
        } else if (KeyWord.TOP_ONE.equals(selectPrefix)) {
            String temp = generCtx.selectSql.substring(generCtx.selectSql.indexOf(BLANK) + 1, generCtx.selectSql.length());
            temp = temp.substring(0, temp.indexOf(BLANK));
            sql = new SQLStringBuffer("SELECT " + KeyWord.TOP_ONE + BLANK + temp).append(generCtx.fromSql).append(generCtx.whereSql).toString();
        } else {
            SQLStringBuffer orderSql = this.getOrderByClause(bo, generCtx);
            generCtx.selectSql.append(generCtx.fromSql).append(generCtx.whereSql).append(orderSql);
            sql = generCtx.selectSql.toString();
        }
        return sql;
    }

    private void innerGetSQL(String boFullName, String prefixfldName, EntityObjectInfo bo, boolean isMultilingual, GeneratorContext generCtx) throws InvalidDAOMetaDataException {
        HistoryGeneratorParam hisParam = new HistoryGeneratorParam();
        hisParam.setRelateColumn(bo.getBusinessHistoryColumn());
        String prefixFldName = StringUtils.isEmpty((String)prefixfldName) ? "" : prefixfldName + ".";
        HashSet<String> exttbs = new HashSet<String>();
        PropertyCollection props = bo.getPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = props.get(i);
            ColumnInfo col = bo.getMappingFieldOfProperty(fld);
            if (col != null) {
                this.getColClause(boFullName, bo, isMultilingual, prefixFldName, fld, col, generCtx, hisParam);
                continue;
            }
            ExtendedFieldInfo extfld = fld.getExtendedField();
            this.getExtColClause(boFullName, bo, isMultilingual, prefixFldName, exttbs, fld, extfld, generCtx);
        }
        this.getInheritClause(boFullName, prefixfldName, bo, isMultilingual, prefixFldName, generCtx);
    }

    private void getExtColClause(String boFullName, EntityObjectInfo bo, boolean isMultilingual, String prefixFldName, Set<String> exttbs, PropertyInfo fld, ExtendedFieldInfo extfld, GeneratorContext generCtx) throws InvalidDAOMetaDataException {
        if (extfld != null && extfld.getExtendedTable() != null && extfld.getExtendedColumn() != null) {
            ColumnInfo extcol = extfld.getExtendedColumn();
            if (this.ea.getSelector() == null || this.ea.getSelector().startsWithKey(prefixFldName + fld.getName()) || bo.isLogicalKey(fld)) {
                String extTableName = extfld.getExtendedTable().getName();
                if (!exttbs.contains(extTableName)) {
                    exttbs.add(extTableName);
                    generCtx.fromSql.appendLeftJoin(extTableName, generCtx.getTableAlias(extTableName));
                    SQLStringBuffer condition = new SQLStringBuffer();
                    PKColumnCollection pkCols = bo.getTable().getPrimaryKey().getPKColumns();
                    PKColumnCollection extPkCols = extfld.getExtendedTable().getPrimaryKey().getPKColumns();
                    int colSize = pkCols.size();
                    for (int j = 0; j < colSize; ++j) {
                        ColumnInfo mainKeyCol = pkCols.get(j).getColumn();
                        ColumnInfo extKeyCol = extPkCols.get(j).getColumn();
                        if (condition.length() == 0) {
                            condition.append(" ON ");
                        } else {
                            condition.append(" AND ");
                        }
                        condition.appendQuotedName(generCtx.getTableAlias(boFullName)).append(".").appendQuotedName(mainKeyCol.getName().toUpperCase()).append("=").appendQuotedName(generCtx.getTableAlias(extTableName)).append(".").appendQuotedName(extKeyCol.getName().toUpperCase());
                    }
                    generCtx.fromSql.append(condition);
                }
                if (extcol.isMultilingual()) {
                    generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), extcol.getName() + "_" + this.ctx.getLocale(), generCtx.getTableAlias(prefixFldName) + fld.getName());
                    generCtx.fieldList.add(fld);
                    if (isMultilingual) {
                        LanguageCollection langs = this.ea.getSolution().getLanguages();
                        int langCount = langs.size();
                        for (int j = 0; j < langCount; ++j) {
                            LanguageInfo lang = langs.get(j);
                            generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), SQLGeneratorImpl.localedName(extcol.getName(), lang), generCtx.getTableAlias(prefixFldName) + SQLGeneratorImpl.localedName(fld.getName(), lang));
                            generCtx.fieldList.add(fld);
                        }
                    }
                } else if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                        HistoryGeneratorParam hisParam = new HistoryGeneratorParam();
                        hisParam.setRelateColumn(bo.getBusinessHistoryColumn());
                        this.getLinkFieldClause(extTableName, prefixFldName, bo, (LinkPropertyInfo)fld, isMultilingual, true, generCtx, hisParam);
                    }
                } else {
                    generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), extcol.getName(), generCtx.getTableAlias(prefixFldName) + fld.getName());
                    generCtx.fieldList.add(fld);
                }
            }
        }
    }

    private void getInheritClause(String boFullName, String prefixfldName, EntityObjectInfo bo, boolean isMultilingual, String prefixFldName, GeneratorContext generCtx) throws InvalidDAOMetaDataException {
        if (bo.getBaseEntity() != null) {
            EntityObjectInfo basebo;
            for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
            }
            if (basebo != null) {
                generCtx.fromSql.append(",").appendQuotedName(basebo.getTable().getName().toUpperCase()).append(BLANK).appendQuotedName(generCtx.getTableAlias(prefixFldName + basebo.getName()));
                PropertyCollection keyFields = basebo.getLogicalKeyPropertiesRuntime();
                for (int i = 0; i < keyFields.size(); ++i) {
                    if (generCtx.whereSql.length() == 0) {
                        generCtx.whereSql.append(" WHERE (");
                    } else {
                        generCtx.whereSql.append(" AND ");
                    }
                    ColumnInfo basecol = keyFields.get(i).getMappingField();
                    PropertyInfo logicKey = bo.getLogicalKeyPropertiesRuntime().get(i);
                    ColumnInfo col = null;
                    PropertyCollection entProps = bo.getPropertiesRuntime();
                    int entPropCount = entProps.size();
                    for (int k = 0; k < entPropCount; ++k) {
                        PropertyInfo entProp = entProps.get(k);
                        if (!entProp.equals((Object)logicKey)) continue;
                        col = entProp.getMappingField();
                        break;
                    }
                    if (col == null) {
                        throw new InvalidDAOMetaDataException("cannot find column ");
                    }
                    generCtx.whereSql.appendCond(generCtx.getTableAlias(boFullName), col.getName(), generCtx.getTableAlias(prefixFldName + basebo.getName()), basecol.getName());
                }
                this.innerGetSQL((prefixFldName.length() == 0 ? "" : prefixFldName + ".") + basebo.getName(), prefixfldName, basebo, isMultilingual, generCtx);
            }
        }
    }

    private void getColClause(String boFullName, EntityObjectInfo bo, boolean isMultilingual, String prefixFldName, PropertyInfo fld, ColumnInfo col, GeneratorContext generCtx, HistoryGeneratorParam hisParam) throws InvalidDAOMetaDataException {
        if (col == null) {
            throw new InvalidDAOMetaDataException("cannot find field '" + fld.getMappingField().getName() + "' at table '" + (bo.getTable() == null ? bo.getName() : bo.getTable().getName()) + "',  please check your metadata ");
        }
        if (this.ea.getSelector() == null || this.ea.getSelector().startsWithKey(prefixFldName + fld.getName()) || bo.isLogicalKey(fld)) {
            if (col.isMultilingual()) {
                generCtx.selectSql.appendField(generCtx.getTableAlias(boFullName), col.getName() + "_" + this.ctx.getLocale().toString(), generCtx.getTableAlias(prefixFldName) + fld.getName());
                generCtx.fieldList.add(fld);
                if (isMultilingual) {
                    LanguageCollection langs = this.ea.getSolution().getLanguages();
                    int count = langs.size();
                    for (int j = 0; j < count; ++j) {
                        LanguageInfo lang = langs.get(j);
                        generCtx.selectSql.appendField(generCtx.getTableAlias(boFullName), SQLGeneratorImpl.localedName(col.getName(), lang), generCtx.getTableAlias(prefixFldName) + SQLGeneratorImpl.localedName(fld.getName(), lang));
                        generCtx.fieldList.add(fld);
                    }
                }
            } else if (fld instanceof LinkPropertyInfo) {
                CardinalityType cardinalityType = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld).getChildCardinality(bo);
                if (CardinalityType.isOneORZero((CardinalityType)cardinalityType)) {
                    this.getLinkFieldClause(boFullName, prefixFldName, bo, (LinkPropertyInfo)fld, isMultilingual, true, generCtx, hisParam);
                }
            } else {
                generCtx.selectSql.appendField(generCtx.getTableAlias(boFullName), col.getName(), generCtx.getTableAlias(prefixFldName) + fld.getName());
                generCtx.fieldList.add(fld);
            }
        }
    }

    private void getLinkFieldClause(String boFullName, String prefixfldName, EntityObjectInfo parentBO, LinkPropertyInfo fld, boolean isMultilingual, boolean isLeftJoinRelation, GeneratorContext generCtx, HistoryGeneratorParam hisParam) throws InvalidDAOMetaDataException {
        ColumnInfo col;
        String prefixFldName = StringUtils.isEmpty((String)prefixfldName) ? "" : prefixfldName + ".";
        String fldFullName = prefixFldName + fld.getName();
        String prefixFldFull = fldFullName + '.';
        String boTableAlias = generCtx.getTableAlias(boFullName);
        String fldTableAlias = generCtx.getTableAlias(fldFullName);
        RelationshipInfo relationinfo = ImplUtils.getRTRelation(parentBO, fld);
        EntityObjectInfo childObject = relationinfo.getChildObject(parentBO);
        PropertyInfo childProperty = relationinfo.getChildProperty(parentBO);
        if (hisParam.isNeedHisFilter() && hisParam.relateTalbe == null) {
            hisParam.setRelateTalbe(boTableAlias);
        }
        if ((col = fld.getMappingField()) == null && fld.getExtendedField() != null) {
            col = fld.getExtendedField().getExtendedColumn();
        }
        if (col == null) {
            throw new InvalidDAOMetaDataException("Can't find property's Mapping column. Entity:" + parentBO.getFullName() + "Property:" + fld.getName());
        }
        PropertyCollection props = childObject.getLogicalKeyPropertiesRuntime();
        assert (props != null && props.size() == 1);
        String keyField = props.get(0).getName();
        String fullKeyField = prefixFldFull + keyField;
        if (this.ea.getSelector() != null && this.ea.getSelector().selectorOnlyKeyField(fullKeyField) && this.ea.getFilterParameters() != null && this.ea.getFilterParameters().hasNotKeyFilter(fullKeyField) && this.hasNotKeySorter(this.ea.getSorter(), fullKeyField)) {
            generCtx.selectSql.appendField(boTableAlias, col.getName(), fldTableAlias + '.' + keyField);
            generCtx.fieldList.add((PropertyInfo)fld);
            return;
        }
        boolean hasLinkField = false;
        generCtx.selectSql.appendField(boTableAlias, col.getName(), fldTableAlias, childProperty.getName());
        generCtx.fieldList.add(childProperty);
        if (this.ea.getSelector() != null) {
            HashSet<String> exttbs = new HashSet<String>();
            PropertyCollection entProps = childObject.getPropertiesRuntime();
            int propCount = entProps.size();
            for (int i = 0; i < propCount; ++i) {
                RelationshipInfo childRelation;
                String extTableName;
                PropertyInfo childField = entProps.get(i);
                ExtendedFieldInfo childExtFld = null;
                if (childField.getExtendedField() != null && childField.getExtendedField().getExtendedTable() != null && childField.getExtendedField().getExtendedColumn() != null) {
                    childExtFld = childField.getExtendedField();
                }
                if (!this.ea.getSelector().startsWithKey(prefixFldFull + childField.getName()) && (childField.getMappingField() == null || !childObject.isLogicalKey(childField))) continue;
                if (childExtFld != null && !exttbs.contains(extTableName = childExtFld.getExtendedTable().getName())) {
                    exttbs.add(extTableName);
                    generCtx.fromSql.appendLeftJoin(extTableName, generCtx.getTableAlias(extTableName));
                    SQLStringBuffer condition = new SQLStringBuffer();
                    PKColumnCollection mainPKCols = childObject.getTable().getPrimaryKey().getPKColumns();
                    PKColumnCollection extPKCols = childExtFld.getExtendedTable().getPrimaryKey().getPKColumns();
                    int colCount = mainPKCols.size();
                    for (int j = 0; j < colCount; ++j) {
                        ColumnInfo mainKeyCol = mainPKCols.get(j).getColumn();
                        ColumnInfo extKeyCol = extPKCols.get(j).getColumn();
                        if (condition.length() == 0) {
                            condition.append(" ON ");
                        } else {
                            condition.append(" AND ");
                        }
                        condition.appendCond(fldTableAlias, mainKeyCol.getName(), generCtx.getTableAlias(extTableName), extKeyCol.getName());
                    }
                    generCtx.fromSql.append(condition);
                }
                if (!(childField instanceof LinkPropertyInfo || childField.getMappingField() == null && childExtFld == null)) {
                    if (!hasLinkField) {
                        String childTableName = null;
                        boolean foundTableBySelf = true;
                        RTSelector selTemp = this.ea.getSelector();
                        int n = selTemp.size();
                        for (int m = 0; m < n; ++m) {
                            String tableName;
                            String propName;
                            RTSelectorItem info = selTemp.get(m);
                            if (info == null || !(propName = info.getPropertyName()).equals(fldFullName) && (propName.lastIndexOf(46) <= 0 || !propName.substring(0, propName.lastIndexOf(46)).endsWith(fld.getName())) || (tableName = (String)info.get("tableName")) == null) continue;
                            if (childObject.getTable() == null || !tableName.equalsIgnoreCase(childObject.getTable().getName())) {
                                foundTableBySelf = false;
                            }
                            childTableName = tableName;
                            break;
                        }
                        if (foundTableBySelf && childObject.getTable() != null) {
                            childTableName = childObject.getTable().getName();
                            if (this.fromNeedHistory(hisParam, childObject)) {
                                childTableName = HistoryUtil.getHistoryTableByCurrentEntity(this.ctx, childObject);
                            }
                        }
                        if (childTableName == null) continue;
                        RelationshipInfo relation = ImplUtils.getRTRelation(childObject, fld);
                        CardinalityType clientCardinalityType = relation.getClientCardinality();
                        CardinalityType supplierCardinalityType = relation.getSupplierCardinality();
                        if (isLeftJoinRelation) {
                            if (clientCardinalityType.isZeroToOneORMany() || supplierCardinalityType.isZeroToOneORMany()) {
                                if (RelationshipType.COMPOSITION.equals((Object)relation.getType()) && relation.isReverseLink(parentBO) && relation.getChildCardinality(parentBO).equals((Object)CardinalityType.ONE)) {
                                    generCtx.fromSql.appendInnerJoin(childTableName, fldTableAlias);
                                } else {
                                    generCtx.fromSql.appendLeftJoin(childTableName, fldTableAlias);
                                    isLeftJoinRelation = false;
                                }
                            } else {
                                generCtx.fromSql.appendInnerJoin(childTableName, fldTableAlias);
                            }
                        } else {
                            generCtx.fromSql.appendLeftJoin(childTableName, fldTableAlias);
                        }
                        if (RelationshipType.COMPOSITION.equals((Object)relation.getType()) && relation.isReverseLink(parentBO)) {
                            EntityObjectInfo compParentBO = relation.getChildObject(parentBO);
                            if (!hisParam.isNeedHisFilter()) {
                                hisParam.setRelateColumn(compParentBO.getBusinessHistoryColumn());
                            }
                            if (hisParam.isNeedHisFilter() && hisParam.relateTalbe == null) {
                                hisParam.setRelateTalbe(fldTableAlias);
                            }
                        }
                        if (this.fromNeedHistory(hisParam, childObject)) {
                            generCtx.fromSql.appendRelateHistoryOnCond(boTableAlias, col.getName(), fldTableAlias, HistoryUtil.getHistoryRelateColumnCurrentEntity(this.ctx, childObject), hisParam.getRelateTalbe(), hisParam.getRelateColumnFieldName());
                            this.historyTableMap.put(fldTableAlias, HistoryUtil.getHistoryRelateColumnCurrentEntity(this.ctx, childObject));
                        } else {
                            generCtx.fromSql.appendOnCond(boTableAlias, col.getName(), fldTableAlias, childProperty.getMappingField().getName());
                        }
                        hasLinkField = true;
                    }
                    if (childField.getName().equalsIgnoreCase(childProperty.getName())) continue;
                    if (childField.getMappingField() != null) {
                        ColumnInfo childcol = childObject.getMappingFieldOfProperty(childField);
                        if (childcol.isMultilingual()) {
                            generCtx.selectSql.appendField(fldTableAlias, childcol.getName() + "_" + this.ctx.getLocale().toString(), fldTableAlias, childField.getName());
                            generCtx.fieldList.add(childField);
                            if (!isMultilingual) continue;
                            LanguageCollection langs = this.ea.getSolution().getLanguages();
                            for (int j = 0; j < langs.size(); ++j) {
                                LanguageInfo lang = langs.get(j);
                                generCtx.selectSql.appendField(fldTableAlias, SQLGeneratorImpl.localedName(childcol.getName(), lang), fldTableAlias, SQLGeneratorImpl.localedName(childField.getName(), lang));
                                generCtx.fieldList.add(childField);
                            }
                            continue;
                        }
                        generCtx.selectSql.appendField(fldTableAlias, childField.getMappingField().getName(), fldTableAlias, childField.getName());
                        generCtx.fieldList.add(childField);
                        continue;
                    }
                    if (childExtFld == null) continue;
                    extTableName = childExtFld.getExtendedTable().getName();
                    ColumnInfo childcol = childExtFld.getExtendedColumn();
                    if (childcol.isMultilingual()) {
                        generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), childcol.getName() + "_" + this.ctx.getLocale().toString(), fldTableAlias, childField.getName());
                        generCtx.fieldList.add(childField);
                        if (!isMultilingual) continue;
                        LanguageCollection langs = this.ea.getSolution().getLanguages();
                        for (int j = 0; j < langs.size(); ++j) {
                            LanguageInfo lang = langs.get(j);
                            generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), SQLGeneratorImpl.localedName(childcol.getName(), lang), fldTableAlias, SQLGeneratorImpl.localedName(childField.getName(), lang));
                            generCtx.fieldList.add(childField);
                        }
                        continue;
                    }
                    generCtx.selectSql.appendField(generCtx.getTableAlias(extTableName), childcol.getName(), fldTableAlias, childField.getName());
                    generCtx.fieldList.add(childField);
                    continue;
                }
                if (!(childField instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(childRelation = ImplUtils.getRTRelation(childObject, (LinkPropertyInfo)childField)).getChildCardinality(childObject))) continue;
                HistoryGeneratorParam childHisParam = null;
                if (hisParam.isNeedHisFilter()) {
                    childHisParam = hisParam;
                } else {
                    childHisParam = new HistoryGeneratorParam();
                    childHisParam.setRelateColumn(childObject.getBusinessHistoryColumn());
                }
                if (childExtFld != null) {
                    String extTableName2 = childExtFld.getExtendedTable().getName();
                    this.getLinkFieldClause(extTableName2, fldFullName, childObject, (LinkPropertyInfo)childField, isMultilingual, isLeftJoinRelation, generCtx, childHisParam);
                    continue;
                }
                this.getLinkFieldClause(prefixFldName + (childExtFld == null ? fld.getName() : childField.getName()), fldFullName, childObject, (LinkPropertyInfo)childField, isMultilingual, isLeftJoinRelation, generCtx, childHisParam);
            }
            if (childObject.getBaseEntity() != null && !childObject.getBaseEntity().isAbstract() && this.ea.getSelector().size() > 0) {
                this.getParentFieldClause(childObject, fldTableAlias, this.ctx.getLocale().toString(), fldFullName, generCtx);
            }
        }
    }

    private boolean fromNeedHistory(HistoryGeneratorParam hisParam, EntityObjectInfo childObject) {
        return hisParam.isNeedHisFilter() && childObject.isNeedHistory();
    }

    private boolean hasNotKeySorter(SorterItemCollection sic, String name) {
        if (sic == null) {
            return true;
        }
        String nameFlag = name.substring(0, name.lastIndexOf("."));
        int size = sic.size();
        for (int i = 0; i < size; ++i) {
            String propName = sic.get(i).getPropertyName();
            if (propName.indexOf(".") < 0 || propName.length() < nameFlag.length() || !propName.startsWith(nameFlag)) continue;
            return false;
        }
        return true;
    }

    private void getParentFieldClause(EntityObjectInfo childObject, String aliasTableName, String locale, String prefixFldName, GeneratorContext generCtx) {
        EntityObjectInfo baseEntity = null;
        EntityObjectInfo entity = childObject;
        String tablePKName = null;
        String baseTablePKName = null;
        String baseTableAliasName = null;
        String string = prefixFldName = prefixFldName == null ? "" : prefixFldName;
        while (entity.getBaseEntity() != null && !entity.getBaseEntity().isAbstract()) {
            baseEntity = entity.getBaseEntity();
            tablePKName = entity.getLogicalKeyPropertiesRuntime().get(0).getMappingField().getName();
            baseTablePKName = baseEntity.getLogicalKeyPropertiesRuntime().get(0).getMappingField().getName();
            baseTableAliasName = generCtx.getTableAlias(prefixFldName + "__" + baseEntity.getName());
            generCtx.fromSql.appendLeftJoin(baseEntity.getTable().getName(), baseTableAliasName);
            generCtx.fromSql.appendOnCond(baseTableAliasName, baseTablePKName, aliasTableName, tablePKName);
            PropertyCollection props = baseEntity.getBaseEntity() != null && !baseEntity.getBaseEntity().isAbstract() ? baseEntity.getPropertiesRuntime() : baseEntity.getInheritedNoDuplicatedPropertiesRuntime();
            int propSize = props.size();
            for (int i = 0; i < propSize; ++i) {
                ColumnInfo col;
                PropertyInfo prop = props.get(i);
                if (prop == null || !this.ea.getSelector().startsWithKey(prefixFldName + '.' + prop.getName()) || prop.getMappingField() == null || (col = baseEntity.getTable().getColumnByNameRuntime(prop.getMappingField().getName())) == null) continue;
                if (col.isMultilingual()) {
                    generCtx.selectSql.appendField(baseTableAliasName, col.getName() + "_" + locale, baseTableAliasName, prop.getName());
                    generCtx.fieldList.add(prop);
                    LanguageCollection langs = this.ea.getSolution().getLanguages();
                    for (int j = 0; j < langs.size(); ++j) {
                        LanguageInfo lang = langs.get(j);
                        generCtx.selectSql.appendField(baseTableAliasName, SQLGeneratorImpl.localedName(col.getName(), lang), baseTableAliasName, SQLGeneratorImpl.localedName(prop.getName(), lang));
                        generCtx.fieldList.add(prop);
                    }
                    continue;
                }
                generCtx.selectSql.appendField(baseTableAliasName, prop.getMappingField().getName(), baseTableAliasName + "." + prop.getName());
                generCtx.fieldList.add(prop);
            }
            entity = baseEntity;
        }
    }

    private void getCrossTableClause(EntityObjectInfo bo, CrossTableInfo crossTable, boolean isCrossTableMainRef, GeneratorContext generCtx) throws InvalidDAOMetaDataException {
        block14: {
            if (crossTable == null) break block14;
            String boTableAlias = generCtx.getTableAlias(bo.getName());
            String crossTableAlias = generCtx.getTableAlias(crossTable.getName());
            generCtx.fromSql.append(",").appendQuotedName(crossTable.getName().toUpperCase()).append(BLANK).appendQuotedName(crossTableAlias);
            if (isCrossTableMainRef) {
                KeyMapCollection supKeyMaps = crossTable.getSupplierTableMap().getKeyMaps();
                int m = supKeyMaps.size();
                for (int n = 0; n < m; ++n) {
                    KeyMapInfo keyMap = supKeyMaps.get(n);
                    ColumnInfo refCol = keyMap.getRefColumn();
                    if (generCtx.whereSql.length() == 0) {
                        generCtx.whereSql.append(" WHERE (");
                    } else {
                        generCtx.whereSql.append(" AND ");
                    }
                    generCtx.whereSql.appendCond(boTableAlias, refCol.getName(), crossTableAlias, keyMap.getSelfColumn().getName());
                }
                PropertyCollection props = bo.getInheritedNoDuplicatedPropertiesRuntime();
                PropertyInfo prop = null;
                int k = props.size();
                for (int l = 0; l < k; ++l) {
                    RelationshipInfo relation;
                    PropertyInfo currprop = props.get(l);
                    if (currprop == null || !(currprop instanceof LinkPropertyInfo) || (relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)currprop)).getCrossTable() == null || !crossTable.getName().equalsIgnoreCase(relation.getCrossTable().getName())) continue;
                    prop = currprop;
                    break;
                }
                if (prop == null) {
                    throw new InvalidDAOMetaDataException("cannot find property according the crosstable '" + crossTable.getName() + "'");
                }
                KeyMapCollection cliKeyMaps = crossTable.getClientTableMap().getKeyMaps();
                int m2 = cliKeyMaps.size();
                for (int n = 0; n < m2; ++n) {
                    KeyMapInfo keyMap = cliKeyMaps.get(n);
                    generCtx.selectSql.appendField(crossTableAlias, keyMap.getSelfColumn().getName(), prop.getName() + ".roleid");
                    generCtx.fieldList.add(prop);
                }
            } else {
                KeyMapCollection cliKeyMaps = crossTable.getClientTableMap().getKeyMaps();
                int m = cliKeyMaps.size();
                for (int n = 0; n < m; ++n) {
                    KeyMapInfo keyMap = cliKeyMaps.get(n);
                    ColumnInfo refCol = keyMap.getRefColumn();
                    if (generCtx.whereSql.length() == 0) {
                        generCtx.whereSql.append(" WHERE (");
                    } else {
                        generCtx.whereSql.append(" AND ");
                    }
                    generCtx.whereSql.appendCond(boTableAlias, refCol.getName(), crossTableAlias, keyMap.getSelfColumn().getName());
                }
                KeyMapCollection supKeyMaps = crossTable.getSupplierTableMap().getKeyMaps();
                PropertyCollection props = bo.getInheritedNoDuplicatedPropertiesRuntime();
                PropertyInfo prop = null;
                int k = props.size();
                for (int l = 0; l < k; ++l) {
                    RelationshipInfo relation;
                    PropertyInfo currprop = props.get(l);
                    if (currprop == null || !(currprop instanceof LinkPropertyInfo) || (relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)currprop)).getCrossTable() == null || !crossTable.getName().equalsIgnoreCase(relation.getCrossTable().getName())) continue;
                    prop = currprop;
                    break;
                }
                if (prop == null) {
                    throw new InvalidDAOMetaDataException("cannot find property according the crosstable '" + crossTable.getName() + "'");
                }
                int m3 = supKeyMaps.size();
                for (int n = 0; n < m3; ++n) {
                    KeyMapInfo keyMap = supKeyMaps.get(n);
                    generCtx.selectSql.appendField(crossTableAlias, keyMap.getSelfColumn().getName(), prop.getName() + ".userid");
                    generCtx.fieldList.add(prop);
                }
            }
        }
    }

    private SQLStringBuffer getOrderByClause(EntityObjectInfo bo, GeneratorContext generCtx) {
        if (this.ea.getSorter().size() != 0) {
            int orderCount = 0;
            SQLStringBuffer sortSql = new SQLStringBuffer(" ORDER BY ");
            int count = this.ea.getSorter().size();
            for (int i = 0; i < count; ++i) {
                int index;
                String fullName;
                String tableName;
                SorterItemInfo sorterItem = this.ea.getSorter().get(i);
                if (sorterItem.getPropertyName().indexOf(".") < 0) {
                    PropertyInfo sortField = bo.getPropertyByNameRuntime(sorterItem.getPropertyName());
                    if (sortField == null) {
                        throw new IllegalArgumentException("cannot find sort field '" + sorterItem.getPropertyName() + "' in entity '" + bo.getName() + "'");
                    }
                    if (sortField.getMappingField() == null) continue;
                    String dataColumnName = sortField.getMappingField().getName() + (sortField.getMappingField().isMultilingual() ? "_" + this.ctx.getLocale().toString() : "");
                    EntityObjectInfo childbo = bo;
                    String boName = null;
                    while (childbo != null && childbo.getTable() != null && childbo.getTable().getColumnByNameRuntime(sortField.getMappingField().getName()) == null) {
                        childbo = bo.getBaseEntity();
                    }
                    boName = childbo == null ? bo.getName() : childbo.getName();
                    String tableAlias = generCtx.getTableAlias(boName);
                    if (this.historyTableMap.containsKey(tableAlias) && dataColumnName.equalsIgnoreCase("FID")) {
                        dataColumnName = this.historyTableMap.get(tableAlias);
                    }
                    sortSql.appendQuotedName(tableAlias).append(".").appendQuotedName(dataColumnName.toUpperCase());
                    if (sorterItem.getNLSSortType() != null) {
                        sortSql.append(BLANK + sorterItem.getNLSSortType().getName());
                    }
                    if (sorterItem.getSortType() != null && sorterItem.getSortType().equals((Object)SortType.DESCEND)) {
                        sortSql.append(" DESC");
                    }
                    ++orderCount;
                    if (i >= count - 1) continue;
                    sortSql.append(",");
                    continue;
                }
                PropertyInfo fld = null;
                try {
                    fld = bo.getFieldByFullName(sorterItem.getPropertyName());
                }
                catch (InvalidDAOMetaDataException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                if (fld == null) {
                    throw new IllegalArgumentException("field " + sorterItem.getPropertyName() + " can not found");
                }
                ColumnInfo col = fld.getMappingField();
                String colName = col.getName();
                if (col.isMultilingual()) {
                    colName = colName + "_" + this.ctx.getLocale();
                }
                if (!generCtx.aliasMapping.containsValue(tableName = SQLGeneratorImpl.getOrderParentName(bo, sorterItem, fullName = (index = (fullName = sorterItem.getPropertyName()).lastIndexOf(46)) > 0 ? fullName.substring(0, index + 1) + colName : colName))) continue;
                String tableAlias = generCtx.getTableAlias(tableName);
                if (this.historyTableMap.containsKey(tableAlias) && colName.equalsIgnoreCase("FID")) {
                    colName = this.historyTableMap.get(tableAlias);
                }
                sortSql.appendQuotedName(tableAlias).append(".").appendQuotedName(colName);
                if (sorterItem.getNLSSortType() != null) {
                    sortSql.append(BLANK + sorterItem.getNLSSortType().getName());
                }
                if (sorterItem.getSortType() != null && sorterItem.getSortType().equals((Object)SortType.DESCEND)) {
                    sortSql.append(" DESC");
                }
                ++orderCount;
                if (i >= count - 1) continue;
                sortSql.append(",");
            }
            if (orderCount == 0) {
                return new SQLStringBuffer("");
            }
            if (sortSql.length() > 0 && sortSql.lastIndexOf(",") == sortSql.length() - 1) {
                return new SQLStringBuffer(sortSql.substring(0, sortSql.length() - 1));
            }
            return sortSql;
        }
        return new SQLStringBuffer("");
    }

    private static String getOrderParentName(EntityObjectInfo bo, SorterItemInfo sorterItem, String fullName) {
        String soterName = fullName;
        int firstCharPos = soterName.indexOf(46);
        String sorterCol = soterName.substring(soterName.lastIndexOf(46) + 1);
        EntityObjectInfo boTemp = bo;
        while (firstCharPos > 0) {
            PropertyInfo prop = boTemp.getPropertyByNameRuntime(soterName.substring(0, firstCharPos));
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)prop);
            boTemp = relation.getChildObject(boTemp);
            soterName = soterName.substring(firstCharPos + 1);
            firstCharPos = soterName.indexOf(46);
        }
        if (boTemp.isSelfField(sorterCol)) {
            return fullName.equalsIgnoreCase(soterName) ? boTemp.getName() : fullName.substring(0, fullName.lastIndexOf(46));
        }
        if (boTemp.isAbstract()) {
            return soterName.substring(0, fullName.lastIndexOf(46));
        }
        return fullName.lastIndexOf(46) > -1 ? fullName.substring(0, fullName.lastIndexOf(46)) + "__" + SQLGeneratorImpl.getChildName(boTemp, sorterCol) : SQLGeneratorImpl.getChildName(boTemp, sorterCol);
    }

    private SQLStringBuffer getWhereClause(EntityObjectInfo bo, CrossTableInfo crossTable, boolean hasOtherWhereClause, GeneratorContext generCtx) {
        return this.getWhereClause(bo, crossTable, hasOtherWhereClause, false, generCtx);
    }

    private SQLStringBuffer getWhereClauseWithTrueValue(EntityObjectInfo bo, CrossTableInfo crossTable, boolean hasOtherWhereClause, GeneratorContext generCtx) {
        return this.getWhereClause(bo, crossTable, hasOtherWhereClause, true, generCtx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SQLStringBuffer getWhereClause(EntityObjectInfo bo, CrossTableInfo crossTable, boolean hasOtherWhereClause, boolean isTrueVal, GeneratorContext generCtx) {
        SQLStringBuffer whereSql = new SQLStringBuffer("");
        int filtersCount = this.ea.getFilterParameters().size();
        if (filtersCount > 0) {
            int i;
            if (hasOtherWhereClause) {
                whereSql.append(" WHERE ");
            } else {
                whereSql.append(" AND ");
            }
            String format = this.ea.getFilterParameters().getFormat();
            if (!StringUtils.isEmpty((String)format)) {
                format = "(" + format + ")";
                for (i = filtersCount - 1; i >= 0; --i) {
                    format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
                }
            }
            for (i = 0; i < filtersCount; ++i) {
                String tableName;
                SQLStringBuffer filter = new SQLStringBuffer("");
                RTFilterParameter fp = this.ea.getFilterParameters().get(i);
                Object value = fp.getCompareValue();
                CompareType type = fp.getCompareType();
                if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                    tableName = crossTable != null && fp.isRefCrossTable() ? crossTable.getName() : SQLGeneratorImpl.getFilterParentName(bo, fp.getFullFieldName());
                    String fieldName = fp.getFieldName();
                    String tableAlias = generCtx.getTableAlias(tableName);
                    if (this.historyTableMap.containsKey(tableAlias) && fieldName.equalsIgnoreCase("FID")) {
                        fieldName = this.historyTableMap.get(tableAlias);
                    }
                    filter.appendField(tableAlias, fieldName);
                    FilterItemInfo item = fp.getFilter();
                    if (item.isFuncCol()) {
                        String expr = (String)item.get("exprTemplate");
                        int idx = 0;
                        List fieldList = item.getFieldList();
                        for (int j = 0; j < fieldList.size(); ++j) {
                            expr = expr.replaceAll("#" + idx, filter.toString());
                            ++idx;
                        }
                        filter = new SQLStringBuffer(expr);
                    }
                }
                if (fp.isCompareValueIsProperty()) {
                    filter.append(fp.getCompareExpression());
                    tableName = SQLGeneratorImpl.getFilterParentName(bo, fp.getFullValueFieldName());
                    filter.appendField(generCtx.getTableAlias(tableName), fp.getValueFieldName());
                } else {
                    String tmp;
                    if (isTrueVal && value != null && value instanceof String && (tmp = (String)value).startsWith("~9^Nz")) {
                        value = tmp.substring(tmp.lastIndexOf("~9^Nz") + 5);
                    }
                    if (value == null) {
                        if (CompareType.EQUALS.equals((Object)type)) {
                            filter.append(" is null");
                        } else {
                            if (!CompareType.NOTEQUALS.equals((Object)type)) throw new IllegalArgumentException("can't compare with null,   comparetype = " + type);
                            filter.append(" is not null");
                        }
                    } else if (CompareType.LIKE.equals((Object)type)) {
                        this.ea.addParameter(fp.getFieldName() + "&" + i, value, fp.getSqlType());
                        if (isTrueVal) {
                            filter.append(" like ").appendValue(value);
                            filter.deleteCharAt(filter.length() - 1);
                        } else {
                            filter.append(" like ? ");
                        }
                    } else if (CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type)) {
                        if (value != null && value instanceof Set) {
                            Set set = (Set)value;
                            if (set.size() == 0) {
                                ((Set)value).add("");
                            }
                            if (isTrueVal || set.size() > 100) {
                                assert (set.size() < 1024) : "set size must less 1024";
                                filter.appendIn(bo, fp, type == CompareType.INCLUDE);
                            } else {
                                filter.append(BLANK + fp.getCompareExpression());
                                filter.append(" (");
                                Iterator it = set.iterator();
                                int temp = 0;
                                while (it.hasNext()) {
                                    Object obj = it.next();
                                    filter.append("?,");
                                    this.ea.addParameter(fp.getFieldName() + "&" + i + "&" + temp, obj, fp.getSqlType());
                                    ++temp;
                                }
                                if (filter.lastIndexOf(",") == filter.length() - 1) {
                                    filter.deleteCharAt(filter.length() - 1);
                                }
                                filter.append(") ");
                            }
                        } else {
                            filter.appendIn(bo, fp, type == CompareType.INCLUDE);
                        }
                    } else if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type)) {
                        if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'inner' or 'notinner' as compare type, the compare value must be string");
                        filter.append(type == CompareType.INNER ? " in " : " not in ");
                        filter.append("(");
                        filter.append(value.toString());
                        filter.append(")");
                    } else if (CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
                        if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'exists' or 'notexists' as compare type, the compare value must be string");
                        filter.append(type == CompareType.EXISTS ? " exists " : " not exists ");
                        filter.append("(");
                        filter.append(value.toString());
                        filter.append(")");
                    } else {
                        this.ea.addParameter(fp.getFieldName() + "&" + i, value, fp.getSqlType());
                        filter.append(fp.getCompareExpression());
                        if (isTrueVal) {
                            filter.append(BLANK).appendValue(value);
                            filter.deleteCharAt(filter.length() - 1);
                        } else {
                            filter.append(" ?");
                        }
                    }
                }
                if (StringUtils.isEmpty((String)format)) {
                    whereSql.append(filter);
                    if (i >= filtersCount - 1) continue;
                    whereSql.append(" AND ");
                    continue;
                }
                format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
            }
            if (format != null) {
                whereSql.append(format);
            }
        }
        if (!isTrueVal) return whereSql;
        return whereSql;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getEntryWherePermClause(EntityObjectInfo bo, CrossTableInfo crossTable, boolean hasOtherWhereClause, GeneratorContext generCtx) {
        int i;
        RTFilterParameters filters = this.ea.getEntryFilterParameters();
        SQLStringBuffer whereSql = new SQLStringBuffer("");
        int filtersCount = filters.size();
        if (filtersCount <= 0) return whereSql.toString();
        String format = filters.getFormat();
        if (!StringUtils.isEmpty((String)format)) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            String tableName;
            SQLStringBuffer filter = new SQLStringBuffer("");
            RTFilterParameter fp = filters.get(i);
            Object value = fp.getCompareValue();
            CompareType type = fp.getCompareType();
            if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                tableName = crossTable != null && fp.isRefCrossTable() ? crossTable.getName() : SQLGeneratorImpl.getFilterParentName(bo, fp.getFullFieldName());
                filter.appendField(generCtx.getTableAlias(tableName), fp.getFieldName());
            }
            if (fp.isCompareValueIsProperty()) {
                filter.append(fp.getCompareExpression());
                tableName = SQLGeneratorImpl.getFilterParentName(bo, fp.getFullValueFieldName());
                filter.appendField(generCtx.getTableAlias(tableName), fp.getValueFieldName());
            } else {
                String tmp;
                if (value != null && value instanceof String && (tmp = (String)value).startsWith("~9^Nz")) {
                    value = tmp.substring(tmp.lastIndexOf("~9^Nz") + 5);
                }
                if (value == null) {
                    if (CompareType.EQUALS.equals((Object)type)) {
                        filter.append(" is null");
                    } else {
                        if (!CompareType.NOTEQUALS.equals((Object)type)) throw new IllegalArgumentException("can't compare with null");
                        filter.append(" is not null");
                    }
                } else if (CompareType.LIKE.equals((Object)type)) {
                    filter.append(" like ").appendValue(value);
                    filter.deleteCharAt(filter.length() - 1);
                } else if (CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type)) {
                    if (value != null && value instanceof Set && ((Set)value).size() == 0) {
                        throw new IllegalArgumentException("when use 'include' or 'notinclude' as compare type,the compare value cannot be a set without elements");
                    }
                    filter.appendIn(bo, fp, type == CompareType.INCLUDE);
                } else if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type)) {
                    if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'inner' or 'notinner' as compare type, the compare value must be string");
                    filter.append(type == CompareType.INNER ? " in " : " not in ");
                    filter.append("(");
                    filter.append(value.toString());
                    filter.append(")");
                } else if (CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
                    if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'exists' or 'notexists' as compare type, the compare value must be string");
                    filter.append(type == CompareType.EXISTS ? " exists " : " not exists ");
                    filter.append("(");
                    filter.append(value.toString());
                    filter.append(")");
                } else {
                    filter.append(fp.getCompareExpression());
                    filter.append(BLANK).appendValue(value);
                    filter.deleteCharAt(filter.length() - 1);
                }
            }
            if (StringUtils.isEmpty((String)format)) {
                whereSql.append(filter);
                if (i >= filtersCount - 1) continue;
                whereSql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
        }
        if (format == null) return whereSql.toString();
        whereSql.append(format);
        return whereSql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String deleteBySQL(EntityObjectInfo bo) throws WholeTableAffectedException {
        int filtersCount = this.ea.getFilterParameters().size();
        if (filtersCount == 0) {
            throw new WholeTableAffectedException("Can't delete all of the table");
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        SQLStringBuffer subQuery = new SQLStringBuffer();
        SQLStringBuffer where = new SQLStringBuffer();
        SQLStringBuffer singleSQL = new SQLStringBuffer();
        boolean isSingle = true;
        PropertyCollection properties = bo.getInheritedNoDuplicatedPropertiesRuntime();
        int n = properties.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo propInfo = properties.get(i);
            if (!(propInfo instanceof LinkPropertyInfo)) continue;
            isSingle = false;
            break;
        }
        sql.append("DELETE");
        sql.append(" FROM ");
        sql.append(this.ea.getTableName().toUpperCase());
        singleSQL.append(sql);
        sql.append(" WHERE ");
        sql.append(bo.getLogicalKeyPropertiesRuntime().get(0).getMappingField().getName());
        sql.append(" IN(");
        HashMap<String, String> tableAliases = new HashMap<String, String>();
        subQuery.append("SELECT ");
        subQuery.append(SQLGeneratorImpl.getTableAlias(tableAliases, bo.getType().toString()));
        subQuery.append('.');
        subQuery.append(bo.getLogicalKeyPropertiesRuntime().get(0).getMappingField().getName());
        subQuery.append(" FROM ");
        subQuery.append(this.ea.getTableName().toUpperCase());
        subQuery.append(BLANK);
        subQuery.append(SQLGeneratorImpl.getTableAlias(tableAliases, bo.getType().toString()));
        where.append(" WHERE ");
        String format = this.ea.getFilterParameters().getFormat();
        if (format != null) {
            format = "(" + format + ")";
            for (int i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (int i = 0; i < filtersCount; ++i) {
            EntityObjectInfo currentBo = bo;
            SQLStringBuffer lastTableAliasKey = new SQLStringBuffer(currentBo.getType().toString());
            RTFilterParameter fp = this.ea.getFilterParameters().get(i);
            String[] names = StringUtils.split((String)fp.getFullFieldName(), (int)46);
            for (int j = 0; j < names.length; ++j) {
                PropertyInfo prop = currentBo.getPropertyByNameRuntime(names[j]);
                if (prop == null || !(prop instanceof LinkPropertyInfo)) continue;
                String currentTableAlias = SQLGeneratorImpl.getTableAlias(tableAliases, lastTableAliasKey.toString());
                RelationshipInfo relation = ImplUtils.getRTRelation(currentBo, (LinkPropertyInfo)prop);
                currentBo = relation.getChildObject(currentBo);
                lastTableAliasKey = new SQLStringBuffer(currentBo.getType().toString());
                for (int k = 0; k <= j; ++k) {
                    lastTableAliasKey.append(names[k]);
                    if (k == j) continue;
                    lastTableAliasKey.append(".");
                }
                if (tableAliases.containsKey(lastTableAliasKey.toString())) continue;
                subQuery.append(" INNER JOIN ");
                subQuery.append(currentBo.getTable().getName().toUpperCase());
                subQuery.append(BLANK);
                subQuery.append(SQLGeneratorImpl.getTableAlias(tableAliases, lastTableAliasKey.toString()));
                subQuery.append(" ON ");
                subQuery.append(currentTableAlias);
                subQuery.append('.');
                subQuery.append(prop.getMappingField().getName());
                subQuery.append(" = ");
                subQuery.append(SQLGeneratorImpl.getTableAlias(tableAliases, lastTableAliasKey.toString()));
                subQuery.append('.');
                subQuery.append(relation.getParentProperty(currentBo).getMappingField().getName());
            }
            Object value = fp.getCompareValue();
            CompareType type = fp.getCompareType();
            SQLStringBuffer filter = new SQLStringBuffer();
            String filterName = null;
            if (!CompareType.EXISTS.equals((Object)type) && !CompareType.NOTEXISTS.equals((Object)type)) {
                if (fp.getFullFieldName().indexOf(".") != -1) {
                    String filterTableKey = currentBo.getType().toString() + fp.getFullFieldName().substring(0, fp.getFullFieldName().lastIndexOf("."));
                    filterName = SQLGeneratorImpl.getTableAlias(tableAliases, filterTableKey) + '.' + fp.getFieldName().toUpperCase();
                } else {
                    filterName = SQLGeneratorImpl.getTableAlias(tableAliases, bo.getType().toString()) + '.' + fp.getFieldName().toUpperCase();
                }
                filter.append(filterName);
            }
            if (value == null) {
                if (CompareType.EQUALS.equals((Object)type)) {
                    filter.append(" is null");
                } else {
                    if (!CompareType.NOTEQUALS.equals((Object)type)) throw new IllegalArgumentException("can't compare with null");
                    filter.append(" is not null");
                }
            } else if (CompareType.LIKE.equals((Object)type)) {
                this.ea.addParameter(filterName + "&" + i, value, fp.getSqlType());
                filter.append(" like ? ");
            } else if (CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type)) {
                if (value != null && value instanceof Set && ((Set)value).size() == 0) {
                    throw new IllegalArgumentException("when use 'include' or 'notinclude' as compare type,the compare value cannot be a set without elements");
                }
                filter.appendIn(bo, fp, type == CompareType.INCLUDE);
            } else if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type)) {
                if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'inner' or 'notinner' as compare type, the compare value must be string");
                filter.append(type == CompareType.INNER ? " in " : " not in ");
                filter.append("(");
                filter.append(value.toString());
                filter.append(")");
            } else if (CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
                if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'exists' or 'notexists' as compare type, the compare value must be string");
                filter.append(type == CompareType.EXISTS ? " exists " : " not exists ");
                filter.append("(");
                filter.append(value.toString());
                filter.append(")");
            } else {
                this.ea.addParameter(filterName + "&" + i, value, fp.getSqlType());
                filter.append(fp.getCompareExpression());
                filter.append(" ?");
            }
            if (StringUtils.isEmpty((String)format)) {
                where.append(filter);
                if (i >= filtersCount - 1) continue;
                where.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter.toString());
        }
        if (format != null) {
            where.append(format);
        }
        subQuery.append(where.toString());
        sql.append(subQuery.toString());
        sql.append(")");
        if (!isSingle) return sql.toString();
        String currentTableAlias = SQLGeneratorImpl.getTableAlias(tableAliases, bo.getType().toString());
        singleSQL.append(where.toString().replaceAll(currentTableAlias + ".", ""));
        return singleSQL.toString();
    }

    private static String getTableAlias(Map<String, String> tableAliases, String key) {
        String tableAlias = tableAliases.get(key);
        if (tableAlias == null) {
            tableAlias = "\"T" + tableAliases.size() + "\"";
            tableAliases.put(key, tableAlias);
        }
        return tableAlias;
    }

    @Override
    public String delete() throws WholeTableAffectedException {
        int i;
        int filtersCount = this.ea.getFilterParameters().size();
        if (filtersCount == 0) {
            throw new WholeTableAffectedException("Can't delete all of the table");
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.ea.getTableName().toUpperCase());
        sql.append(" WHERE ");
        String format = this.ea.getFilterParameters().getFormat();
        if (format != null) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            RTFilterParameter fp = this.ea.getFilterParameters().get(i);
            this.ea.addParameter(fp.getFieldName(), fp.getCompareValue(), fp.getSqlType());
            String filter = fp.getFieldName().toUpperCase() + fp.getCompareExpression() + " ?";
            if (format == null) {
                sql.append(filter);
                if (i >= filtersCount - 1) continue;
                sql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter);
        }
        if (format != null) {
            sql.append(format);
        }
        return sql.toString();
    }

    @Override
    public String update() throws WholeTableAffectedException {
        int i;
        int filtersCount = this.ea.getFilterParameters().size();
        if (filtersCount == 0) {
            throw new WholeTableAffectedException("Can't update all of the table");
        }
        if (this.ea.getParamSize() == 0) {
            return "";
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("UPDATE ");
        sql.append(this.ea.getTableName().toUpperCase());
        sql.append(" SET ");
        List<String> paramNames = this.ea.getParamNames();
        int len = paramNames.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String field = paramNames.get(i2);
            sql.append(field.toUpperCase()).append("=?");
            if (i2 >= len - 1) continue;
            sql.append(",");
        }
        sql.append(" where ");
        String format = this.ea.getFilterParameters().getFormat();
        if (format != null) {
            format = "(" + format + ")";
            for (i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (i = 0; i < filtersCount; ++i) {
            RTFilterParameter fp = this.ea.getFilterParameters().get(i);
            this.ea.addParameter(fp.getFieldName(), fp.getCompareValue(), fp.getSqlType());
            String filter = fp.getFieldName().toUpperCase() + fp.getCompareExpression() + " ?";
            if (format == null) {
                sql.append(filter);
                if (i >= filtersCount - 1) continue;
                sql.append(" and ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter);
        }
        if (format != null) {
            sql.append(format);
        }
        return sql.toString();
    }

    private static String getFilterParentName(EntityObjectInfo bo, String fullFieldName) {
        String filterName = fullFieldName;
        int firstCharPos = filterName.indexOf(46);
        String FilterCol = filterName.substring(filterName.lastIndexOf(46) + 1);
        EntityObjectInfo boTemp = bo;
        while (firstCharPos > 0) {
            String fName = filterName.substring(0, firstCharPos);
            PropertyInfo prop = boTemp.getPropertyByNameRuntime(fName);
            if (prop == null) {
                throw new NullPointerException("bo=" + boTemp + ",  prop=null,  fieldName=" + fName);
            }
            RelationshipInfo relation = ImplUtils.getRTRelation(boTemp, (LinkPropertyInfo)prop);
            boTemp = relation.getChildObject(boTemp);
            filterName = filterName.substring(firstCharPos + 1);
            firstCharPos = filterName.indexOf(46);
        }
        if (boTemp.isSelfField(FilterCol)) {
            if (fullFieldName.equalsIgnoreCase(filterName)) {
                return boTemp.getName();
            }
            return fullFieldName.substring(0, fullFieldName.lastIndexOf(46));
        }
        if (boTemp.isAbstract()) {
            return fullFieldName.substring(0, fullFieldName.lastIndexOf(46));
        }
        if (fullFieldName.lastIndexOf(46) > -1) {
            return fullFieldName.substring(0, fullFieldName.lastIndexOf(46)) + "__" + SQLGeneratorImpl.getChildName(boTemp, FilterCol);
        }
        return SQLGeneratorImpl.getChildName(boTemp, FilterCol);
    }

    private static String getChildName(EntityObjectInfo childbo, String filterName) {
        while (!childbo.isSelfField(filterName) && childbo.getBaseEntity() != null && !childbo.getBaseEntity().isAbstract()) {
            childbo = childbo.getBaseEntity();
        }
        return childbo.getName();
    }

    private static final String localedName(String name, LanguageInfo lang) {
        return name + "_" + lang.getPostfix();
    }
}

