/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLStringBuffer {
    private static Logger logger = Logger.getLogger(SQLStringBuffer.class);
    private HashMap joinsMap = null;
    private final StringBuffer sbuf;

    public SQLStringBuffer() {
        this.sbuf = new StringBuffer();
    }

    public SQLStringBuffer(int length) {
        this.sbuf = new StringBuffer(length);
    }

    public SQLStringBuffer(String str) {
        this.sbuf = new StringBuffer(str);
    }

    public SQLStringBuffer append(SQLStringBuffer ssb) {
        this.sbuf.append(ssb.sbuf);
        return this;
    }

    public SQLStringBuffer append(boolean b) {
        this.sbuf.append(b);
        return this;
    }

    public SQLStringBuffer append(char c) {
        this.sbuf.append(c);
        return this;
    }

    public SQLStringBuffer append(char[] str, int offset, int len) {
        this.sbuf.append(str, offset, len);
        return this;
    }

    public SQLStringBuffer append(char[] str) {
        this.sbuf.append(str);
        return this;
    }

    public SQLStringBuffer append(double d) {
        this.sbuf.append(d);
        return this;
    }

    public SQLStringBuffer append(float f) {
        this.sbuf.append(f);
        return this;
    }

    public SQLStringBuffer append(int i) {
        this.sbuf.append(i);
        return this;
    }

    public SQLStringBuffer append(long l) {
        this.sbuf.append(l);
        return this;
    }

    public SQLStringBuffer append(Object obj) {
        this.sbuf.append(obj);
        return this;
    }

    public SQLStringBuffer append(String str) {
        this.sbuf.append(str);
        return this;
    }

    public SQLStringBuffer append(StringBuffer sb) {
        this.sbuf.append(sb);
        return this;
    }

    public int capacity() {
        return this.sbuf.capacity();
    }

    public char charAt(int index) {
        return this.sbuf.charAt(index);
    }

    public SQLStringBuffer delete(int start, int end) {
        this.sbuf.delete(start, end);
        return this;
    }

    public SQLStringBuffer deleteCharAt(int index) {
        this.sbuf.deleteCharAt(index);
        return this;
    }

    public void ensureCapacity(int minimumCapacity) {
        this.sbuf.ensureCapacity(minimumCapacity);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SQLStringBuffer) {
            return this.sbuf.equals(((SQLStringBuffer)obj).sbuf);
        }
        return false;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.sbuf.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public int hashCode() {
        return this.sbuf.hashCode();
    }

    public int indexOf(String str, int fromIndex) {
        return this.sbuf.indexOf(str, fromIndex);
    }

    public int indexOf(String str) {
        return this.sbuf.indexOf(str);
    }

    public SQLStringBuffer insert(int offset, boolean b) {
        this.sbuf.insert(offset, b);
        return this;
    }

    public SQLStringBuffer insert(int offset, char c) {
        this.sbuf.insert(offset, c);
        return this;
    }

    public SQLStringBuffer insert(int index, char[] str, int offset, int len) {
        this.sbuf.insert(index, str, offset, len);
        return this;
    }

    public SQLStringBuffer insert(int offset, char[] str) {
        this.sbuf.insert(offset, str);
        return this;
    }

    public SQLStringBuffer insert(int offset, double d) {
        this.sbuf.insert(offset, d);
        return this;
    }

    public SQLStringBuffer insert(int offset, float f) {
        this.sbuf.insert(offset, f);
        return this;
    }

    public SQLStringBuffer insert(int offset, int i) {
        this.sbuf.insert(offset, i);
        return this;
    }

    public SQLStringBuffer insert(int offset, long l) {
        this.sbuf.insert(offset, l);
        return this;
    }

    public SQLStringBuffer insert(int offset, Object obj) {
        this.sbuf.insert(offset, obj);
        return this;
    }

    public SQLStringBuffer insert(int offset, String str) {
        this.sbuf.insert(offset, str);
        return this;
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.sbuf.lastIndexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.sbuf.lastIndexOf(str);
    }

    public int length() {
        return this.sbuf.length();
    }

    public SQLStringBuffer replace(int start, int end, String str) {
        this.sbuf.replace(start, end, str);
        return this;
    }

    public SQLStringBuffer reverse() {
        this.sbuf.reverse();
        return this;
    }

    public void setCharAt(int index, char ch) {
        this.sbuf.setCharAt(index, ch);
    }

    public void setLength(int newLength) {
        this.sbuf.setLength(newLength);
    }

    public CharSequence subSequence(int start, int end) {
        return this.sbuf.subSequence(start, end);
    }

    public String substring(int start, int end) {
        return this.sbuf.substring(start, end);
    }

    public String substring(int start) {
        return this.sbuf.substring(start);
    }

    public String toString() {
        return this.sbuf.toString();
    }

    public SQLStringBuffer appendQuotedName(String name) {
        this.append('\"').append(name).append('\"');
        return this;
    }

    public SQLStringBuffer appendQuotedConst(String name) {
        this.append('\'').append(name).append('\'');
        return this;
    }

    public SQLStringBuffer appendIn(EntityObjectInfo bo, RTFilterParameter fp, boolean isInclude) {
        this.append(isInclude ? " in " : " not in ");
        PropertyInfo prop = bo.getPropInfoByColumnName(fp.getFieldName().toUpperCase());
        if (fp.getCompareValue() instanceof Set) {
            HashSet set = (HashSet)fp.getCompareValue();
            if (set.size() > 0) {
                assert (set.size() < 1024) : "set size must less 1024";
                this.append("(");
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (prop instanceof OwnPropertyInfo) {
                        Object obj;
                        DataType type = ((OwnPropertyInfo)prop).getDataType();
                        if (type.equals((Object)DataType.STRING) || type.equals((Object)DataType.DATE) || type.equals((Object)DataType.BOSUUID)) {
                            obj = it.next();
                            if (obj != null && obj.toString() != null) {
                                this.appendQuotedConst(obj.toString().replaceAll("'", "''")).append(",");
                                continue;
                            }
                            this.appendQuotedConst("").append(",");
                            continue;
                        }
                        if (type.equals((Object)DataType.BOOLEAN)) {
                            String val = it.next().toString();
                            if (val.equalsIgnoreCase("true")) {
                                this.append("1,");
                                continue;
                            }
                            if (!val.equalsIgnoreCase("false")) continue;
                            this.append("0,");
                            continue;
                        }
                        if (type.equals((Object)DataType.ENUM)) {
                            Object obj2;
                            String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
                            BizEnumInfo bizEnum = (BizEnumInfo)MDLoader.getInstance().loadMD(new MetaDataPK2(metadataRef, MetaDataTypeList.BIZENUM.toString()));
                            if (bizEnum != null && BizEnumValueType.STRING.getName().equals(bizEnum.get("enumDataType"))) {
                                obj2 = it.next();
                                if (obj2 != null && obj2.toString() != null) {
                                    this.appendQuotedConst(obj2.toString().replaceAll("'", "''")).append(",");
                                    continue;
                                }
                                this.appendQuotedConst("").append(",");
                                continue;
                            }
                            obj2 = it.next();
                            if (obj2 != null && obj2.toString() != null) {
                                this.append(obj2.toString()).append(",");
                                continue;
                            }
                            this.appendQuotedConst("").append(",");
                            continue;
                        }
                        obj = it.next();
                        if (obj != null && obj.toString() != null) {
                            this.append(obj.toString()).append(",");
                            continue;
                        }
                        this.appendQuotedConst("").append(",");
                        continue;
                    }
                    this.appendValue(it.next());
                }
                if (this.lastIndexOf(",") == this.length() - 1) {
                    this.deleteCharAt(this.length() - 1);
                }
                this.append(")");
            }
        } else {
            this.append(prop.toString());
        }
        return this;
    }

    public SQLStringBuffer appendValue(Object value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            return this.append(value.toString()).append(",");
        }
        if (value instanceof Boolean) {
            return this.append(value.toString().equalsIgnoreCase("true") ? "1," : "0,");
        }
        if (value instanceof Timestamp || value instanceof Date || value instanceof Time) {
            String val = null;
            if (value instanceof Timestamp) {
                val = DateTimeUtils.format((java.util.Date)((Timestamp)value), (String)"yyyy-MM-dd HH:mm:ss");
                return this.append("{ts ").appendQuotedConst(val).append("},");
            }
            if (value instanceof Date) {
                val = DateTimeUtils.format((java.util.Date)((Date)value), (String)"yyyy-MM-dd");
                return this.append("{d ").appendQuotedConst(val).append("},");
            }
            if (value instanceof Time) {
                val = DateTimeUtils.format((java.util.Date)((Time)value), (String)"HH:mm:ss");
                return this.append("{t ").appendQuotedConst(val).append("},");
            }
            return null;
        }
        return this.appendQuotedConst(value.toString().replaceAll("'", "''")).append(",");
    }

    public SQLStringBuffer appendField(String leftTable, String leftCol, String rightTable, String rightCol) {
        return this.appendQuotedName(leftTable).append(".").appendQuotedName(leftCol.toUpperCase()).append(" ").appendQuotedName(rightTable + "." + rightCol).append(",");
    }

    public SQLStringBuffer appendField(String leftTable, String leftCol, String colAlias) {
        return this.appendQuotedName(leftTable).append(".").appendQuotedName(leftCol.toUpperCase()).append(" ").appendQuotedName(colAlias.toUpperCase()).append(",");
    }

    private String getTableNameKey(String tableName, String tableAlias) {
        return tableName + "_AS_" + tableAlias;
    }

    private HashMap getJoinsMap() {
        if (this.joinsMap == null) {
            this.joinsMap = new HashMap();
        }
        return this.joinsMap;
    }

    public SQLStringBuffer appendLeftJoin(String tableName, String tableAlias) {
        if (this.getJoinsMap().containsKey(this.getTableNameKey(tableName, tableAlias))) {
            Throwable e = new Throwable();
            logger.error((Object)("Duplicate LeftJoin Info(" + tableName + " as " + tableAlias + ")"), e);
        } else {
            this.append(" left join ").appendQuotedName(tableName.toUpperCase()).append(" ").appendQuotedName(tableAlias);
            this.getJoinsMap().put(this.getTableNameKey(tableName, tableAlias), null);
        }
        return this;
    }

    public SQLStringBuffer appendInnerJoin(String tableName, String tableAlias) {
        return this.append(" inner join ").appendQuotedName(tableName.toUpperCase()).append(" ").appendQuotedName(tableAlias);
    }

    public SQLStringBuffer appendFrom(String tableName, String tableAlias) {
        return this.append(" FROM ").appendQuotedName(tableName.toUpperCase()).append(" ").appendQuotedName(tableAlias);
    }

    public SQLStringBuffer appendRelateHistoryOnCond(String leftTableName, String leftColName, String rightTableName, String rightColName, String relateTableName, String relatecolName) {
        return this.append(" ON ").appendQuotedName(leftTableName).append(".").appendQuotedName(leftColName.toUpperCase()).append("=").appendQuotedName(rightTableName).append(".").appendQuotedName(rightColName.toUpperCase()).append(" AND ").appendQuotedName(rightTableName).append(".").appendQuotedName(HistoryConstant.EFFDTCol.toUpperCase()).append("<=").appendQuotedName(relateTableName).append(".").appendQuotedName(relatecolName.toUpperCase()).append(" AND ").appendQuotedName(rightTableName).append(".").appendQuotedName(HistoryConstant.LEFFDTCol.toUpperCase()).append(">=").appendQuotedName(relateTableName).append(".").appendQuotedName(relatecolName.toUpperCase());
    }

    public SQLStringBuffer appendOnCond(String leftTableName, String leftColName, String rightTableName, String rightColName) {
        return this.append(" ON ").appendQuotedName(leftTableName).append(".").appendQuotedName(leftColName.toUpperCase()).append("=").appendQuotedName(rightTableName).append(".").appendQuotedName(rightColName.toUpperCase());
    }

    public SQLStringBuffer appendCond(String leftTableName, String leftColName, String rightTableName, String rightColName) {
        return this.appendQuotedName(leftTableName).append(".").appendQuotedName(leftColName.toUpperCase()).append("=").appendQuotedName(rightTableName).append(".").appendQuotedName(rightColName.toUpperCase());
    }

    public SQLStringBuffer appendField(String tableAliasName, String colName) {
        return this.appendQuotedName(tableAliasName).append(".").appendQuotedName(colName.toUpperCase());
    }
}

