/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccessQueueBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.ValuePreprocess;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;

abstract class AbstractBuilder
implements IBatchAccessQueueBuilder {
    private final EntityObjectInfo bo;

    AbstractBuilder(EntityObjectInfo bo) {
        this.bo = bo;
    }

    @Override
    public final IBatchAccess build() throws InvalidDAOMetaDataException {
        return this.build(this.bo);
    }

    protected abstract IBatchAccess build(EntityObjectInfo var1) throws InvalidDAOMetaDataException;

    static class ValueClone
    implements ValuePreprocess {
        private static final long serialVersionUID = 87690021384208337L;
        private final String className;
        private final String fullName;
        private final BOSObjectType boType;

        ValueClone(String className, String fullName, BOSObjectType boType) {
            this.className = className;
            this.fullName = fullName;
            this.boType = boType;
        }

        @Override
        public AccessValue process(AccessValue data) throws InvalidDAOMetaDataException {
            Class<?> clazz = null;
            if (!StringUtils.isEmpty((String)this.className)) {
                try {
                    clazz = Class.forName(this.className);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidDAOMetaDataException("create object by objectValueClass error. entity name:" + this.fullName + "\n" + e.getMessage(), (Throwable)e);
                }
            }
            IObjectValue nw = Utils.newObjectValueInstance(clazz, this.fullName, this.boType);
            Enumeration keys = data.data.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                nw.put(key, data.data.get(key));
            }
            AccessValue av = new AccessValue(nw, data.oldData);
            av.syn(data);
            data.setNext(av);
            return av;
        }

        static ValueClone getInstance(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
            return new ValueClone(bo.getObjectValueClassRuntime(), bo.getFullName(), bo.getType());
        }
    }
}

