/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessProxy;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectUpdater;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;

class BatchAccessFactory {
    private static final CustomCacheService batchAccessCache = new CustomCacheService("orm.batchAccess");
    private static final String KEY_UPDATE = "5!";
    private static final String KEY_CREATE = "1!";
    private static final String KEY_REMOVE = "3!";

    BatchAccessFactory() {
    }

    static IBatchAccess getUpdateAccess(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_UPDATE + bo.getFullName();
        return BatchAccessFactory.getFromCache(key, 5, bo);
    }

    static IBatchAccess getUpdateAccessProxy(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_UPDATE + bo.getFullName();
        return new BatchAccessProxy(new CacheProvider(key, bo));
    }

    static IBatchAccess getCreateAccess(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_CREATE + bo.getFullName();
        return BatchAccessFactory.getFromCache(key, 1, bo);
    }

    static IBatchAccess getCreateAccessProxy(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_CREATE + bo.getFullName();
        return new BatchAccessProxy(new CacheProvider(key, bo));
    }

    static IBatchAccess getRemoveAccess(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_REMOVE + bo.getFullName();
        return BatchAccessFactory.getFromCache(key, 3, bo);
    }

    static IBatchAccess getRemoveAccessProxy(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        String key = KEY_REMOVE + bo.getFullName();
        return new BatchAccessProxy(new CacheProvider(key, bo));
    }

    private static IBatchAccess getFromCache(String key, int type, EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        IBatchAccess access = (IBatchAccess)batchAccessCache.get(key);
        if (access == null) {
            access = BatchAccessFactory.getBatchAccess(type, bo);
            batchAccessCache.put(key, (Object)access);
        }
        return access;
    }

    private static IBatchAccess getBatchAccess(int type, EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        switch (type) {
            case 1: {
                return new Builder4ObjectCreator(bo).build();
            }
            case 5: {
                return new Builder4ObjectUpdater(bo).build();
            }
            case 3: {
                return new Builder4ObjectRemover(bo).build();
            }
        }
        return null;
    }

    static void clear() {
        batchAccessCache.removeAll();
    }

    static void clear(String fullName) {
        if (fullName != null) {
            batchAccessCache.remove(KEY_UPDATE + fullName);
            batchAccessCache.remove(KEY_CREATE + fullName);
            batchAccessCache.remove(KEY_REMOVE + fullName);
        }
    }

    static {
        MetadataCleaner.registerListener((MetadataClearListener)new MetadataClearListener(){

            public void clear(String key) {
                if (key != null && key.indexOf("!") > 0 && MetaDataTypeList.ENTITY.toString().equals(key.substring(key.indexOf("!") + 1))) {
                    BatchAccessFactory.clear(key.substring(0, key.indexOf("!")));
                }
            }

            public void clearAll() {
                BatchAccessFactory.clear();
            }
        });
    }

    static class CacheProvider
    implements BatchAccessProxy.BatchAccessProvider {
        private static final long serialVersionUID = -3073917929233624359L;
        private final String key;
        private final transient EntityObjectInfo bo;

        CacheProvider(String key) {
            this.key = key;
            this.bo = null;
        }

        CacheProvider(String key, EntityObjectInfo bo) {
            this.key = key;
            this.bo = bo;
        }

        @Override
        public IBatchAccess get() throws InvalidDAOMetaDataException {
            IBatchAccess access = (IBatchAccess)batchAccessCache.get(this.key);
            if (access == null) {
                int split = this.key.indexOf("!");
                int type = Integer.parseInt(this.key.substring(0, split));
                String fullName = this.key.substring(split + 1);
                access = BatchAccessFactory.getBatchAccess(type, this.getEntity(fullName));
                batchAccessCache.put(this.key, (Object)access);
            }
            return access;
        }

        private EntityObjectInfo getEntity(String fullName) {
            if (this.bo != null) {
                return this.bo;
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext());
            return loader.getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        }
    }
}

