/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.ormapping.impl.batch.IAccessType;

class BatchAccessIterator<T extends IAccessType> {
    private BatchAccessEntry<T>[] accesses = new BatchAccessEntry[4];
    private int index = -1;
    private int currCategory = -1;
    private BatchAccessEntry<T> current = null;

    BatchAccessIterator() {
    }

    void add(T access) {
        if (access == null) {
            return;
        }
        BatchAccessEntry<T> wrapper = new BatchAccessEntry<T>(access);
        for (int i = 0; i <= this.index; ++i) {
            if (wrapper.getCategory() != this.accesses[i].getCategory()) continue;
            BatchAccessEntry<T> tmp = this.accesses[i];
            while (tmp.next() != null) {
                tmp = tmp.next();
            }
            tmp.setNext(wrapper);
            return;
        }
        ++this.index;
        if (this.index == this.accesses.length) {
            BatchAccessEntry<T>[] tmp = this.accesses;
            this.accesses = new BatchAccessEntry[this.accesses.length * 2];
            System.arraycopy(tmp, 0, this.accesses, 0, tmp.length);
        }
        this.accesses[this.index] = wrapper;
        for (int tmp = this.index; tmp > 0 && this.accesses[tmp].getCategory() > this.accesses[tmp - 1].getCategory(); --tmp) {
            BatchAccessEntry<T> w = this.accesses[tmp];
            this.accesses[tmp] = this.accesses[tmp - 1];
            this.accesses[tmp - 1] = w;
        }
    }

    T next() {
        if (this.current == null || this.current.next() == null) {
            ++this.currCategory;
            if (this.currCategory > this.index) {
                return null;
            }
            if (this.accesses[this.currCategory] == null) {
                return null;
            }
            this.current = this.accesses[this.currCategory];
        } else {
            this.current = this.current.next();
        }
        return this.current.get();
    }

    void reset() {
        this.current = null;
        this.currCategory = -1;
    }

    private static class BatchAccessEntry<T extends IAccessType> {
        private final T access;
        private BatchAccessEntry<T> next;

        public BatchAccessEntry(T access) {
            this.access = access;
            this.next = null;
        }

        BatchAccessEntry<T> next() {
            return this.next;
        }

        void setNext(BatchAccessEntry<T> n) {
            this.next = n;
        }

        T get() {
            return this.access;
        }

        int getCategory() {
            return this.access.getType();
        }
    }
}

