/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.Executable;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import java.io.Serializable;
import org.apache.log4j.Logger;

class BatchAccessProxy
implements IBatchAccess,
Serializable {
    private static Logger logger = Logger.getLogger(BatchAccessProxy.class);
    private static final long serialVersionUID = -6948252102717800985L;
    private final BatchAccessProvider provider;
    private transient IBatchAccess batchAccess = null;

    BatchAccessProxy(BatchAccessProvider provider) {
        this.provider = provider;
    }

    private IBatchAccess getBatchAccess() throws InvalidDAOMetaDataException {
        if (this.batchAccess == null) {
            this.batchAccess = this.provider.get();
        }
        return this.batchAccess;
    }

    @Override
    public int getType() {
        try {
            return this.getBatchAccess().getType();
        }
        catch (InvalidDAOMetaDataException e) {
            logger.error((Object)"BatchAccessProxy get real batchAccess error.", (Throwable)e);
            return -1;
        }
    }

    @Override
    public Executable[] execute(AccessValue value) throws BOSException {
        return this.getBatchAccess().execute(value);
    }

    static interface BatchAccessProvider
    extends Serializable {
        public IBatchAccess get() throws InvalidDAOMetaDataException;
    }
}

