/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessQueue;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.batch.CommonCompositeBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.EntityBatchAccess4Creator;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Builder4ExtRecordCreator
extends AbstractBuilder {
    Builder4ExtRecordCreator(EntityObjectInfo bo) {
        super(bo);
    }

    @Override
    protected IBatchAccess build(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        BatchAccessQueue queue = null;
        PropertyCollection flds = bo.getPropertiesRuntime();
        HashMap<String, EntityBatchAccess4Creator> extCBs = new HashMap<String, EntityBatchAccess4Creator>();
        int size = flds.size();
        for (int i = 0; i < size; ++i) {
            EntityBatchAccess4Creator batchAccess;
            PropertyInfo fld = flds.get(i);
            ExtendedFieldInfo extfld = fld.getExtendedField();
            if (extfld == null) continue;
            ColumnInfo col = extfld.getExtendedColumn();
            String tableName = extfld.getExtendedTable().getName();
            if (!extCBs.containsKey(tableName)) {
                batchAccess = new EntityBatchAccess4Creator(tableName);
                extCBs.put(tableName, batchAccess);
                PropertyCollection keys = bo.getLogicalKeyPropertiesRuntime();
                int m = keys.size();
                for (int j = 0; j < m; ++j) {
                    PropertyInfo prop = keys.get(j);
                    ColumnInfo keycol = prop.getMappingField();
                    batchAccess.addProperty(new Field(keycol, new Field.ValueInfo(new Path(prop.getName()))));
                }
            } else {
                batchAccess = (EntityBatchAccess4Creator)extCBs.get(tableName);
            }
            if (fld instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) continue;
                if (RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) {
                    CommonCompositeBatchAccess.SignedBatchAccess access = new CommonCompositeBatchAccess.SignedBatchAccess(fld.getName(), new Builder4ObjectCreator(relation.getChildObject(bo)).build());
                    if (queue == null) {
                        queue = new BatchAccessQueue();
                    }
                    queue.addAccess(new CommonCompositeBatchAccess(new CommonCompositeBatchAccess.SignedBatchAccess[]{access}, new CompositeValueProvider(fld.getName())));
                }
                Path valuePath = new Path(fld.getName());
                valuePath.append(relation.getChildProperty(bo).getName());
                batchAccess.addProperty(new Field(col, new Field.ValueInfo(valuePath)));
                continue;
            }
            batchAccess.addProperty(new Field(col, new Field.ValueInfo(new Path(fld.getName()))));
        }
        Iterator iter = extCBs.values().iterator();
        while (iter.hasNext()) {
            if (queue == null) {
                queue = new BatchAccessQueue();
            }
            queue.addAccess((IBatchAccess)iter.next());
        }
        return queue;
    }

    static class CompositeValueProvider
    implements CommonCompositeBatchAccess.AccessValueProvider {
        private static final long serialVersionUID = -7601354509943239962L;
        private final String propName;

        CompositeValueProvider(String propName) {
            this.propName = propName;
        }

        @Override
        public Map<String, List<AccessValue>> getValues(AccessValue data) {
            IObjectValue value = (IObjectValue)data.data.get(this.propName);
            ArrayList<AccessValue> list = new ArrayList<AccessValue>(1);
            list.add(new AccessValue(value, null));
            HashMap<String, List<AccessValue>> m = new HashMap<String, List<AccessValue>>(1);
            m.put(this.propName, list);
            return m;
        }
    }
}

