/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessContext;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessFactory;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessQueue;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ExtRecordCreator;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4SubCrossRecordCreator;
import com.kingdee.bos.dao.ormapping.impl.batch.CommonCompositeBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.EntityBatchAccess4Creator;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.dao.ormapping.impl.batch.ValuePreprocess;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.seq.app.SequenceFacadeFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class Builder4ObjectCreator
extends AbstractBuilder {
    Builder4ObjectCreator(EntityObjectInfo bo) {
        super(bo);
    }

    @Override
    protected IBatchAccess build(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        CompositeInfo c;
        int i;
        BatchAccessQueue queue = new BatchAccessQueue();
        queue.appendProcess(new SetUuid(SetUuid.buildLogicKey(bo)));
        queue.appendProcess(AbstractBuilder.ValueClone.getInstance(bo));
        BatchAccessContext<Object> bactx = new BatchAccessContext<Object>(queue, null, bo);
        ArrayList<CompositeInfo> leftComposites = new ArrayList<CompositeInfo>(2);
        ArrayList<CompositeInfo> rightComposites = new ArrayList<CompositeInfo>(2);
        ArrayList<CompositeInfo> entries = new ArrayList<CompositeInfo>(2);
        ArrayList<CompositeInfo> subCrosses = new ArrayList<CompositeInfo>(2);
        this.processCompisiteProp(bactx, leftComposites, rightComposites, entries, subCrosses);
        ArrayList<CompositeProp> props = new ArrayList<CompositeProp>();
        int size = leftComposites.size();
        for (int i2 = 0; i2 < size; ++i2) {
            props.add(((CompositeInfo)leftComposites.get((int)i2)).prop);
        }
        ArrayList<CommonCompositeBatchAccess.SignedBatchAccess> accesses = new ArrayList<CommonCompositeBatchAccess.SignedBatchAccess>();
        int size2 = leftComposites.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            CompositeInfo c2 = (CompositeInfo)leftComposites.get(i3);
            accesses.add(new CommonCompositeBatchAccess.SignedBatchAccess(c2.prop.key, BatchAccessFactory.getCreateAccessProxy(c2.childBO)));
        }
        CompositeValueProvider provider = new CompositeValueProvider(props.toArray(new CompositeProp[0]));
        bactx.queue.addAccess(new CommonCompositeBatchAccess(accesses.toArray(new CommonCompositeBatchAccess.SignedBatchAccess[0]), provider));
        this.buildPlainAccess(bactx);
        props = new ArrayList();
        int size3 = rightComposites.size();
        for (i = 0; i < size3; ++i) {
            props.add(((CompositeInfo)rightComposites.get((int)i)).prop);
        }
        size3 = entries.size();
        for (i = 0; i < size3; ++i) {
            props.add(((CompositeInfo)entries.get((int)i)).prop);
        }
        size3 = subCrosses.size();
        for (i = 0; i < size3; ++i) {
            props.add(((CompositeInfo)subCrosses.get((int)i)).prop);
        }
        accesses = new ArrayList();
        size3 = rightComposites.size();
        for (i = 0; i < size3; ++i) {
            c = (CompositeInfo)rightComposites.get(i);
            accesses.add(new CommonCompositeBatchAccess.SignedBatchAccess(c.prop.key, BatchAccessFactory.getCreateAccessProxy(c.childBO)));
        }
        size3 = entries.size();
        for (i = 0; i < size3; ++i) {
            c = (CompositeInfo)entries.get(i);
            accesses.add(new CommonCompositeBatchAccess.SignedBatchAccess(c.prop.key, BatchAccessFactory.getCreateAccessProxy(c.childBO)));
        }
        size3 = subCrosses.size();
        for (i = 0; i < size3; ++i) {
            c = (CompositeInfo)subCrosses.get(i);
            accesses.add(new CommonCompositeBatchAccess.SignedBatchAccess(c.prop.key, new Builder4SubCrossRecordCreator(c.childBO, c.relation).build()));
        }
        provider = new CompositeValueProvider(props.toArray(new CompositeProp[0]));
        bactx.queue.addAccess(new CommonCompositeBatchAccess(accesses.toArray(new CommonCompositeBatchAccess.SignedBatchAccess[0]), provider));
        bactx.queue.addAccess(new Builder4ExtRecordCreator(bo).build());
        return queue;
    }

    private void buildPlainAccess(BatchAccessContext<EntityBatchAccess4Creator> bactx) throws InvalidDAOMetaDataException {
        EntityBatchAccess4Creator batchAccess = new EntityBatchAccess4Creator(bactx.bo.getTable().getName());
        List propNamesMapping = bactx.bo.getCompositions().allInstProp;
        int size = propNamesMapping.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo.Name2PropMapping np = (EntityObjectInfo.Name2PropMapping)propNamesMapping.get(i);
            PropertyInfo prop = np.prop;
            ColumnInfo col = bactx.bo.getMappingFieldOfProperty(prop);
            if (col == null) continue;
            boolean isLogicKey = bactx.bo.isLogicalKey(prop);
            boolean isSeq = prop.equals((Object)bactx.bo.getSequenceProperty());
            String propName = np.name;
            Path valuePath = propName.indexOf(46) > 0 ? new Path(StringUtils.fastSplit((String)propName, (int)46)) : new Path(propName);
            Field field = new Field(prop, col, isLogicKey, isSeq, new Field.ValueInfo(valuePath));
            batchAccess.addProperty(field);
        }
        bactx.queue.addAccess(batchAccess);
    }

    private void processCompisiteProp(BatchAccessContext<EntityBatchAccess4Creator> bactx, List<CompositeInfo> leftCompositions, List<CompositeInfo> rightCompositions, List<CompositeInfo> entries, List<CompositeInfo> subCrosses) {
        EntityObjectInfo.Compositions compositions = bactx.bo.getCompositions();
        List one2one = compositions.one2one;
        int size = one2one.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo.Prop2ChildBoMapping pm = (EntityObjectInfo.Prop2ChildBoMapping)one2one.get(i);
            LinkPropertyInfo prop = (LinkPropertyInfo)pm.prop;
            RelationshipInfo relation = ImplUtils.getRTRelation(bactx.bo, prop);
            boolean propAtRight = relation.getChildProperty(bactx.bo) instanceof LinkPropertyInfo;
            String propName = prop.getName();
            if (propAtRight) {
                rightCompositions.add(new CompositeInfo(new CompositeProp(propName, propName, propAtRight, false, false, pm.childPropName, null), null, pm.childBO));
                continue;
            }
            leftCompositions.add(new CompositeInfo(new CompositeProp(propName, propName, propAtRight, false, false, null, null), null, pm.childBO));
        }
        List one2Many = compositions.one2many;
        int size2 = one2Many.size();
        for (int i = 0; i < size2; ++i) {
            EntityObjectInfo.Prop2ChildBoMapping pm = (EntityObjectInfo.Prop2ChildBoMapping)one2Many.get(i);
            LinkPropertyInfo prop = (LinkPropertyInfo)pm.prop;
            String propName = prop.getName();
            OwnPropertyInfo seqProp = pm.childBO.getSequenceProperty();
            String seqPropName = seqProp != null ? seqProp.getName() : null;
            entries.add(new CompositeInfo(new CompositeProp(propName, propName, false, true, false, pm.childPropName, seqPropName), null, pm.childBO));
        }
        PropertyCollection flds = bactx.bo.getPropertiesRuntime();
        int size3 = flds.size();
        for (int i = 0; i < size3; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = flds.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ImplUtils.getRTRelation(bactx.bo, (LinkPropertyInfo)fld)).getLinkType(bactx.bo)) || relation.getCrossTable() == null || CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bactx.bo)) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bactx.bo))) continue;
            subCrosses.add(new CompositeInfo(new CompositeProp(fld.getName(), fld.getName(), false, false, true, null, null), relation, bactx.bo));
        }
    }

    static class LogicKey
    implements Serializable {
        private static final long serialVersionUID = 6473373219983870697L;
        final String[] keys;
        final boolean[] isUuid;
        LogicKey parent;

        LogicKey(String[] keys, boolean[] isUuid) {
            this.keys = keys;
            this.isUuid = isUuid;
            this.parent = null;
        }
    }

    static class SetUuid
    implements ValuePreprocess {
        private static final long serialVersionUID = 684256560760193285L;
        private static Logger logger = Logger.getLogger(SetUuid.class);
        private static boolean isUseNewUuid = true;
        final LogicKey logicKey;

        SetUuid(LogicKey logicKey) {
            this.logicKey = logicKey;
        }

        @Override
        public AccessValue process(AccessValue data) {
            BOSObjectType bosType = data.data.getBOSType();
            for (int i = 0; i < this.logicKey.keys.length; ++i) {
                if (data.data.get(this.logicKey.keys[i]) != null) continue;
                if (this.logicKey.isUuid[i]) {
                    data.data.put(this.logicKey.keys[i], (Object)SetUuid.newUuid(bosType).toString());
                }
                LogicKey parent = this.logicKey.parent;
                while (parent != null) {
                    if (parent.isUuid[i]) {
                        data.data.put(parent.keys[i], (Object)SetUuid.newUuid(bosType).toString());
                    }
                    parent = parent.parent;
                }
            }
            return data;
        }

        private static BOSUuid newUuid(BOSObjectType type) {
            BOSUuid id;
            if (isUseNewUuid) {
                try {
                    id = SequenceFacadeFactory.getLocalInstance(ConfigMDUtil.getContext()).nextValue(type.toString());
                }
                catch (Exception e) {
                    logger.error((Object)"set objet uuid in sequence way error.", (Throwable)e);
                    isUseNewUuid = false;
                    id = BOSUuid.create((BOSObjectType)type);
                }
            } else {
                id = BOSUuid.create((BOSObjectType)type);
            }
            return id;
        }

        static LogicKey buildLogicKey(EntityObjectInfo bo) {
            LogicKey key = SetUuid.convert(bo.getLogicalKeyPropertiesRuntime());
            LogicKey tmpKey = key;
            for (EntityObjectInfo basebo = bo.getBaseEntity(); basebo != null && !basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
                LogicKey l;
                tmpKey.parent = l = SetUuid.convert(basebo.getLogicalKeyPropertiesRuntime());
                tmpKey = l;
            }
            return key;
        }

        static LogicKey convert(PropertyCollection keys) {
            if (keys != null) {
                String[] logicKeys = new String[keys.size()];
                boolean[] isUuid = new boolean[keys.size()];
                for (int i = 0; i < logicKeys.length; ++i) {
                    PropertyInfo key = keys.get(i);
                    logicKeys[i] = key.getName();
                    isUuid[i] = key instanceof OwnPropertyInfo && ((OwnPropertyInfo)key).getDataType().equals((Object)DataType.BOSUUID);
                }
                return new LogicKey(logicKeys, isUuid);
            }
            return null;
        }
    }

    static class CompositeValueProvider
    implements CommonCompositeBatchAccess.AccessValueProvider {
        private static final long serialVersionUID = 7800072636300659560L;
        private final CompositeProp[] composites;

        CompositeValueProvider(CompositeProp[] composites) {
            this.composites = composites;
        }

        @Override
        public Map<String, List<AccessValue>> getValues(AccessValue data) {
            HashMap<String, List<AccessValue>> values = new HashMap<String, List<AccessValue>>(this.composites.length);
            for (int i = 0; i < this.composites.length; ++i) {
                ArrayList<Object> vs = new ArrayList<Object>();
                Object value = data.data.get(this.composites[i].propName);
                if (value != null) {
                    Object val;
                    int j;
                    int count;
                    IObjectCollection childDatas;
                    if (this.composites[i].isOne2Many) {
                        if (value instanceof IObjectCollection) {
                            childDatas = (IObjectCollection)value;
                            count = childDatas.size();
                            for (j = 0; j < count; ++j) {
                                val = childDatas.getObject(j);
                                if (this.composites[i].childSeqProp != null) {
                                    val.put(this.composites[i].childSeqProp, (Object)(j + 1));
                                }
                                val.put(this.composites[i].childPropName, (Object)data.data);
                                vs.add(new AccessValue((IObjectValue)val, null));
                            }
                        }
                    } else if (this.composites[i].isMany2Many) {
                        if (value instanceof IObjectCollection) {
                            childDatas = (IObjectCollection)value;
                            count = childDatas.size();
                            for (j = 0; j < count; ++j) {
                                val = new AccessValue(childDatas.getObject(j), null);
                                ((AccessValue)val).put("prt_V", data.data);
                                vs.add(val);
                            }
                        }
                    } else if (value instanceof IObjectValue) {
                        if (this.composites[i].propAtRight) {
                            ((IObjectValue)value).put(this.composites[i].childPropName, (Object)data.data);
                        }
                        vs.add(new AccessValue((IObjectValue)value, null));
                    }
                }
                values.put(this.composites[i].key, vs);
            }
            return values;
        }
    }

    static class CompositeProp
    implements Serializable {
        private static final long serialVersionUID = -1941261437852220832L;
        final String key;
        final String propName;
        final boolean propAtRight;
        final boolean isOne2Many;
        final boolean isMany2Many;
        final String childPropName;
        final String childSeqProp;

        CompositeProp(String key, String propName, boolean propAtRight, boolean isOne2Many, boolean isMany2Many, String childPropName, String childSeqProp) {
            this.key = key;
            this.propName = propName;
            this.propAtRight = propAtRight;
            this.isOne2Many = isOne2Many;
            this.isMany2Many = isMany2Many;
            this.childPropName = childPropName;
            this.childSeqProp = childSeqProp;
        }
    }

    static class CompositeInfo {
        final CompositeProp prop;
        final RelationshipInfo relation;
        final EntityObjectInfo childBO;

        private CompositeInfo(CompositeProp prop, RelationshipInfo relation, EntityObjectInfo childBO) {
            this.prop = prop;
            this.relation = relation;
            this.childBO = childBO;
        }
    }
}

