/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.Executable;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class CommonCompositeBatchAccess
implements IBatchAccess {
    private static final long serialVersionUID = 6806711415914328737L;
    private final SignedBatchAccess[] batchAccesses;
    private final AccessValueProvider valueProvider;

    CommonCompositeBatchAccess(SignedBatchAccess[] batchAccesses, AccessValueProvider valueProvider) {
        this.batchAccesses = batchAccesses;
        this.valueProvider = valueProvider;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Executable[] execute(AccessValue value) throws BOSException {
        if (this.batchAccesses.length <= 0) {
            return new Executable[0];
        }
        Map<String, List<AccessValue>> values = this.valueProvider.getValues(value);
        ArrayList<Executable> exes = new ArrayList<Executable>();
        for (int i = 0; i < this.batchAccesses.length; ++i) {
            List<AccessValue> vs = values.get(this.batchAccesses[i].key);
            int size = vs.size();
            for (int j = 0; j < size; ++j) {
                Executable[] es = this.batchAccesses[i].batchAccess.execute(vs.get(j));
                if (es == null) continue;
                for (int k = 0; k < es.length; ++k) {
                    exes.add(es[k]);
                }
            }
        }
        return exes.toArray(new Executable[0]);
    }

    static interface AccessValueProvider
    extends Serializable {
        public Map<String, List<AccessValue>> getValues(AccessValue var1);
    }

    static class SignedBatchAccess
    implements Serializable {
        private static final long serialVersionUID = -8850268947723457549L;
        final String key;
        final IBatchAccess batchAccess;

        SignedBatchAccess(String key, IBatchAccess batchAccess) {
            this.key = key;
            this.batchAccess = batchAccess;
        }
    }
}

