/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.PropertyConstriantValidator;
import com.kingdee.bos.dao.ormapping.PropertyValidateFailedException;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessWrapper;
import com.kingdee.bos.dao.ormapping.impl.batch.Executable;
import com.kingdee.bos.dao.ormapping.impl.batch.ExecuteContext;
import com.kingdee.bos.dao.ormapping.impl.batch.ExecuteParameter;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.ISqlGenerator;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.ConstraintInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.bos.metadata.rule.formula.FormulaExecutor;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

abstract class Executor<B extends BatchAccessWrapper<? extends IBatchAccess>>
implements Executable {
    private static Logger logger = Logger.getLogger(Executor.class);
    protected final AccessValue data;
    protected final B batchAccess;
    private static volatile PostfixInfo postfix = null;

    Executor(AccessValue data, B batchAccess) {
        this.data = data;
        this.batchAccess = batchAccess;
    }

    @Override
    public int getType() {
        return ((BatchAccessWrapper)this.batchAccess).getType();
    }

    @Override
    public final int execute(ExecuteContext ctx, ExecuteParameter param) throws BOSException, SQLException {
        int n;
        if (this.data == null) {
            return 0;
        }
        this.beforeExecute(ctx, param);
        ISqlGenerator sqlGenerator = this.getSqlGenerator(ctx, param);
        if (sqlGenerator == null) {
            return 0;
        }
        String sql = sqlGenerator.getSql();
        if (StringUtils.isEmpty((String)sql)) {
            return 0;
        }
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "execUpdateSQL", sql);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareParam(ctx, param, sql);
            n = stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("execUpdateSQL error! " + sqle.getMessage() + "\nSQL: " + sql));
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return n;
    }

    protected abstract ISqlGenerator getSqlGenerator(ExecuteContext var1, ExecuteParameter var2);

    protected abstract PreparedStatement prepareParam(ExecuteContext var1, ExecuteParameter var2, String var3) throws BOSException, SQLException;

    protected void beforeExecute(ExecuteContext ctx, ExecuteParameter param) throws BOSException, SQLException {
    }

    protected static final Object addUnicodeTag(Object oldValue, SQLType sqlType) {
        if (oldValue != null && sqlType != null && (SQLType.NCHAR.equals((Object)sqlType) || SQLType.NVARCHAR.equals((Object)sqlType)) && oldValue instanceof String && ((String)oldValue).length() > 0) {
            return "~9^Nz" + oldValue;
        }
        return oldValue;
    }

    final void calculateFormula(Context ctx, Field field, IObjectValue saveData) throws FormulaExecuteException {
        if (!field.isOwnProperty) {
            return;
        }
        if (field.formula != null && field.formula.trim().length() != 0 && !field.isSequenceProperty()) {
            Object dataValue = FormulaExecutor.executeProperty((Context)ctx, (String)field.formula, (IObjectValue)saveData, (String)field.name);
            saveData.put(field.name, dataValue);
        }
        if (saveData.containsKey(field.name)) {
            saveData.put(field.name, this.perpareParms(field, saveData.get(field.name)));
        }
    }

    private Object perpareParms(Field field, Object value) {
        assert (field != null && field.dataType != null);
        if (value == null) {
            return null;
        }
        if (field.dataType.isDateTime()) {
            return TypeConversionUtils.objToTimestamp((Object)value);
        }
        if (SQLType.NUMERIC.equals((Object)field.sqlType)) {
            BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof DoubleEnum ? new BigDecimal(((DoubleEnum)value).getValue()) : (value instanceof FloatEnum ? new BigDecimal(((FloatEnum)value).getValue()) : (value instanceof IntEnum ? new BigDecimal(((IntEnum)value).getValue()) : new BigDecimal(value.toString()))));
            return decimal.setScale(field.scale, 4);
        }
        if (SQLType.NCHAR.equals((Object)field.sqlType) || SQLType.NVARCHAR.equals((Object)field.sqlType)) {
            return "~9^Nz" + value;
        }
        return value;
    }

    protected final void checkConstriant(Context ctx, ConstraintInfo constraint, Object value) throws SQLException {
        try {
            PropertyConstriantValidator.validateConstraint((Context)ctx, (ConstraintInfo)constraint, (Object)value);
        }
        catch (PropertyValidateFailedException e) {
            throw new SQLException(e.getMessage());
        }
    }

    static String[] getLanguagePostfix(SolutionInfo solution) {
        if (postfix != null && Executor.postfix.solution == solution) {
            return Executor.postfix.postfix;
        }
        LanguageCollection langs = solution.getLanguages();
        String[] p = new String[langs.size()];
        int size = langs.size();
        for (int i = 0; i < size; ++i) {
            p[i] = "_" + langs.get(i).getPostfix();
        }
        postfix = new PostfixInfo(solution, p);
        return p;
    }

    static class PostfixInfo {
        final SolutionInfo solution;
        final String[] postfix;

        PostfixInfo(SolutionInfo solution, String[] postfix) {
            this.solution = solution;
            this.postfix = postfix;
        }
    }
}

