/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.ConstraintInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import java.io.Serializable;

class Field
implements Serializable {
    private static final long serialVersionUID = 239042279710398109L;
    final String name;
    final String fullName;
    final String columnName;
    final boolean isOwnProperty;
    final boolean isMultiLang;
    final DataType dataType;
    final SQLType sqlType;
    final int scale;
    final String formula;
    final ConstraintInfo constraint;
    final int isLogicKey;
    final int isSequenceProperty;
    final ValueInfo value;

    Field(String name, String fullName, String columnName, boolean isOwnProperty, boolean isMultiLang, DataType dataType, SQLType sqlType, int scale, String formula, ConstraintInfo constraint, int isLogicKey, int isSequenceProperty, ValueInfo value) {
        this.name = name;
        this.fullName = fullName;
        this.columnName = columnName;
        this.isOwnProperty = isOwnProperty;
        this.isMultiLang = isMultiLang;
        this.dataType = dataType;
        this.sqlType = columnName != null && ("FNUMBER".equals(columnName.toUpperCase()) || "FSIMPLENAME".equals(columnName.toUpperCase())) && SQLType.VARCHAR.equals((Object)sqlType) ? SQLType.NVARCHAR : sqlType;
        this.scale = scale;
        this.formula = formula;
        this.constraint = constraint;
        this.isLogicKey = isLogicKey;
        this.isSequenceProperty = isSequenceProperty;
        this.value = value;
    }

    Field(String name, String columnName, boolean isOwnProperty, boolean isMultiLang, DataType dataType, SQLType sqlType, int scale, String formula, ConstraintInfo constraint, int isLogicKey, int isSequenceProperty, ValueInfo value) {
        this(name, name, columnName, isOwnProperty, isMultiLang, dataType, sqlType, scale, formula, constraint, isLogicKey, isSequenceProperty, value);
    }

    Field(PropertyInfo fld, ColumnInfo col, boolean logicKey, boolean isSequence, ValueInfo value) {
        this(fld, col, logicKey ? 1 : 0, isSequence ? 1 : 0, value);
    }

    private Field(PropertyInfo fld, ColumnInfo col, int logicKey, int sequenceProperty, ValueInfo value) {
        boolean isOwn = fld instanceof OwnPropertyInfo;
        DataType dataType = null;
        String formula = null;
        ConstraintInfo constraint = null;
        if (isOwn) {
            dataType = ((OwnPropertyInfo)fld).getDataType();
            formula = ((OwnPropertyInfo)fld).getFormula();
            constraint = ((OwnPropertyInfo)fld).getConstraint();
        }
        this.fullName = this.name = fld.getName();
        this.columnName = col.getName();
        this.isOwnProperty = isOwn;
        this.isMultiLang = col.isMultilingual();
        this.dataType = dataType;
        this.sqlType = col.getName() != null && ("FNUMBER".equals(col.getName().toUpperCase()) || "FSIMPLENAME".equals(col.getName().toUpperCase())) && SQLType.VARCHAR.equals((Object)col.getTypeName()) ? SQLType.NVARCHAR : col.getTypeName();
        this.scale = col.getScale();
        this.formula = formula;
        this.constraint = constraint;
        this.isLogicKey = logicKey;
        this.isSequenceProperty = sequenceProperty;
        this.value = value;
    }

    Field(PropertyInfo fld, ColumnInfo col, ValueInfo value) {
        this(fld, col, false, false, value);
    }

    Field(ColumnInfo col, ValueInfo value) {
        this(null, null, col.getName(), false, col.isMultilingual(), null, col.getTypeName(), col.getScale(), null, null, -1, -1, value);
    }

    public String toString() {
        return this.name;
    }

    boolean isLogicKey() {
        return this.isLogicKey == 1;
    }

    boolean isSequenceProperty() {
        return this.isSequenceProperty == 1;
    }

    String getFullColumnName() {
        String fullColumnName = this.columnName;
        int index = this.fullName.lastIndexOf(46);
        if (index > 0) {
            fullColumnName = this.fullName.substring(0, index + 1) + fullColumnName;
        }
        return fullColumnName;
    }

    String getFullComparedColumnName() {
        int index;
        String fullColumnName = this.value.comparedColumn.name;
        if (fullColumnName != null && (index = this.fullName.lastIndexOf(46)) > 0) {
            fullColumnName = this.fullName.substring(0, index + 1) + fullColumnName;
        }
        return fullColumnName;
    }

    static class ComparedColumn
    implements Serializable {
        private static final long serialVersionUID = -3241258463506764784L;
        final String name;
        final boolean isMultiLang;
        final SQLType sqlType;

        ComparedColumn(String name, boolean isMultiLang, SQLType sqlType) {
            this.name = name;
            this.isMultiLang = isMultiLang;
            this.sqlType = sqlType;
        }
    }

    static class ValueInfo
    implements Serializable {
        private static final long serialVersionUID = 3856251659143046808L;
        final Path propName;
        final ComparedColumn comparedColumn;
        final int isUuid;
        final String hostName;

        public ValueInfo(Path propName, ComparedColumn comparedColumnName) {
            this(propName, comparedColumnName, -1, null);
        }

        private ValueInfo(Path propName, ComparedColumn comparedColumn, int isUuid, String hostName) {
            this.propName = propName;
            this.comparedColumn = comparedColumn;
            this.isUuid = isUuid;
            this.hostName = hostName;
        }

        public ValueInfo(Path propName, ComparedColumn comparedColumnName, boolean isUuid) {
            this(propName, comparedColumnName, isUuid ? 1 : 0, null);
        }

        public ValueInfo(Path propName, boolean isUuid) {
            this(propName, null, isUuid);
        }

        public ValueInfo(Path propName) {
            this(propName, null, -1, null);
        }

        public ValueInfo(Path propName, String hostName) {
            this.propName = propName;
            this.comparedColumn = null;
            this.isUuid = -1;
            this.hostName = hostName;
        }

        public boolean isCompareValueIsProperty() {
            return this.comparedColumn != null;
        }
    }
}

