/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.io.Serializable;

class FilterItemDesc
implements Serializable {
    private static final long serialVersionUID = -5871296560838179016L;
    private final String compareExpression;
    private final Field field;
    private final CompareType compareType;
    private final boolean isRefCrossTable;

    FilterItemDesc(Field field, CompareType compareType, boolean isRefCrossTable) {
        this.field = field;
        this.compareType = compareType;
        this.compareExpression = compareType.getName();
        this.isRefCrossTable = isRefCrossTable;
    }

    FilterItemDesc(Field field) {
        this(field, CompareType.EQUALS, false);
    }

    public Field getField() {
        return this.field;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public String getCompareExpression() {
        return this.compareExpression;
    }

    public boolean isRefCrossTable() {
        return this.isRefCrossTable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("fullFieldName:");
        buf.append(this.field.fullName);
        buf.append(",");
        buf.append("fieldName:");
        buf.append(this.field.name);
        buf.append(",");
        buf.append("sqlType:");
        buf.append(this.field.sqlType);
        buf.append(",");
        buf.append("compareType:");
        buf.append(this.getCompareType().getName());
        buf.append(",");
        buf.append("refCrossTable:");
        buf.append(this.isRefCrossTable());
        return buf.toString();
    }

    boolean isCompareValueBOSUuid() {
        boolean isBOSUuidCol;
        boolean bl = isBOSUuidCol = this.field.value.isUuid == 1;
        if (CompareType.INNER.equals((Object)this.compareType) || CompareType.NOTINNER.equals((Object)this.compareType) || CompareType.EXISTS.equals((Object)this.compareType) || CompareType.NOTEXISTS.equals((Object)this.compareType)) {
            isBOSUuidCol = false;
        }
        return isBOSUuidCol;
    }

    Object processCompareValue(Object compareValue) {
        if (!(this.field.columnName == null || this.field.value.isCompareValueIsProperty() || compareValue == null || CompareType.INCLUDE.equals((Object)this.compareType) || CompareType.NOTINCLUDE.equals((Object)this.compareType) || CompareType.INNER.equals((Object)this.compareType) || CompareType.NOTINNER.equals((Object)this.compareType) || CompareType.EXISTS.equals((Object)this.compareType) || CompareType.NOTEXISTS.equals((Object)this.compareType) || !SQLType.NCHAR.equals((Object)this.field.sqlType) && !SQLType.NVARCHAR.equals((Object)this.field.sqlType))) {
            return "~9^Nz" + compareValue;
        }
        if (this.isCompareValueBOSUuid()) {
            compareValue = ImplUtils.convToBOSUuid(compareValue);
        }
        return compareValue;
    }
}

