/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import java.io.Serializable;

class Path
implements Serializable {
    private static final long serialVersionUID = -2657053160154598420L;
    private String[] path;
    private int index;

    Path(String init) {
        this.path = new String[1];
        this.index = -1;
        if (init != null) {
            ++this.index;
            this.path[this.index] = init;
        }
    }

    Path(String[] init) {
        this.path = new String[init.length];
        this.index = init.length - 1;
        System.arraycopy(init, 0, this.path, 0, init.length);
    }

    Path() {
        this.path = new String[4];
        this.index = -1;
    }

    Path(Path p) {
        this.path = new String[p.path.length];
        this.index = p.index;
        System.arraycopy(p.path, 0, this.path, 0, this.index + 1);
    }

    Path append(String name) {
        if (name == null) {
            return this;
        }
        ++this.index;
        if (this.index == this.path.length) {
            String[] tmp = this.path;
            this.path = new String[this.path.length * 2];
            System.arraycopy(tmp, 0, this.path, 0, tmp.length);
        }
        this.path[this.index] = name;
        return this;
    }

    String get() {
        StringBuffer p = new StringBuffer();
        for (int j = 0; j <= this.index; ++j) {
            if (j != 0) {
                p.append('.');
            }
            p.append(this.path[j]);
        }
        return p.toString();
    }

    public String toString() {
        return this.get();
    }

    String[] getAsArray() {
        String[] tmp = new String[this.index + 1];
        System.arraycopy(this.path, 0, tmp, 0, this.index + 1);
        return tmp;
    }

    Object[] getValues(IObjectValue data) {
        return this.getValues(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getValues(IObjectValue data, String langPostFix) {
        if (this.index < 0) {
            return new Object[]{data};
        }
        if (data == null) {
            return new Object[]{null};
        }
        String backup = null;
        if (langPostFix != null) {
            backup = this.path[this.index];
            this.path[this.index] = langPostFix.indexOf(95) == 0 ? this.path[this.index] + langPostFix : this.path[this.index] + "_" + langPostFix;
        }
        try {
            Object v = data.get(this.path[0]);
            if (this.index > 0) {
                if (v == null) {
                    Object[] objectArray = new Object[]{null};
                    return objectArray;
                }
                Path nw = new Path();
                for (int i = 1; i <= this.index; ++i) {
                    nw.append(this.path[i]);
                }
                if (v instanceof IObjectValue) {
                    Object[] i = nw.getValues((IObjectValue)v);
                    return i;
                }
                if (v instanceof IObjectCollection) {
                    IObjectCollection col = (IObjectCollection)v;
                    Object[] objs = new Object[col.size()];
                    int idx = -1;
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        Object[] sub = nw.getValues(col.getObject(i));
                        for (int j = 0; j < sub.length; ++j) {
                            if (++idx == objs.length) {
                                Object[] tmp = objs;
                                objs = new Object[objs.length * 2];
                                System.arraycopy(tmp, 0, objs, 0, tmp.length);
                            }
                            objs[idx] = sub[j];
                        }
                    }
                    if (objs.length != idx + 1) {
                        Object[] tmp = objs;
                        objs = new Object[idx + 1];
                        System.arraycopy(tmp, 0, objs, 0, idx + 1);
                    }
                    Object[] objectArray = objs;
                    return objectArray;
                }
                Object[] objectArray = new Object[]{v};
                return objectArray;
            }
            Object[] objectArray = new Object[]{v};
            return objectArray;
        }
        finally {
            if (backup != null) {
                this.path[this.index] = backup;
            }
        }
    }
}

