/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.ormapping.impl.SQLStringBuffer;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractSqlGenerator;
import com.kingdee.bos.dao.ormapping.impl.batch.SqlGenerateException;
import com.kingdee.util.StringUtils;

class RemoveSqlGenerator
extends AbstractSqlGenerator {
    private final RemoveType removeType;
    private final ParamProvider provider;

    RemoveSqlGenerator(RemoveType removeType, String tableName, ParamProvider provider) {
        super(tableName);
        this.removeType = removeType;
        this.provider = provider;
    }

    @Override
    public String getSql() throws SqlGenerateException {
        if (RemoveType.LogicKey.equals((Object)this.removeType)) {
            return this.removeByLogicKey();
        }
        return this.removeByQuery();
    }

    String removeByLogicKey() throws SqlGenerateException {
        AbstractSqlGenerator.FilterInfo filter = this.provider.getFilter();
        if (filter == null || filter.items.size() == 0) {
            throw new SqlGenerateException("no filter, Can't delete all of the table");
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tableName.toUpperCase());
        sql.append(" WHERE ");
        sql.append(RemoveSqlGenerator.getFilter(filter));
        return sql.toString();
    }

    String removeByQuery() throws SqlGenerateException {
        QueryFilter filter = this.provider.getQueryFilter();
        if (filter == null || filter.filterItem == null) {
            throw new SqlGenerateException("no filter, Can't delete all of the table");
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tableName.toUpperCase());
        sql.append(" WHERE ");
        sql.append(filter.filterItem);
        sql.append(" in ( ");
        sql.append(filter.querySql);
        sql.append(" )");
        return sql.toString();
    }

    static String getFilter(AbstractSqlGenerator.FilterInfo filter) {
        int i;
        SQLStringBuffer sql = new SQLStringBuffer();
        int filterCount = filter.items.size();
        String format = filter.filterFormat;
        if (format != null) {
            format = "(" + format + ")";
            for (i = filterCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        int size = filterCount;
        for (i = 0; i < size; ++i) {
            AbstractSqlGenerator.FilterItemInfo item = filter.items.get(i);
            StringBuffer exp = new StringBuffer(item.columnName.toUpperCase());
            exp.append(" ").append(item.compareExpression);
            if (item.valueCount == 1) {
                exp.append(" ? ");
            } else {
                exp.append(" ( ");
                for (int j = 0; j < item.valueCount; ++j) {
                    if (j != 0) {
                        exp.append(",");
                    }
                    exp.append(" ? ");
                }
                exp.append(" ) ");
            }
            if (format == null) {
                sql.append(exp);
                if (i >= filterCount - 1) continue;
                sql.append(" AND ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)exp.toString());
        }
        if (format != null) {
            sql.append(format);
        }
        return sql.toString();
    }

    static String buildQuery(String tableName, String[] selector, AbstractSqlGenerator.FilterInfo filter) {
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("SELECT ");
        for (int i = 0; i < selector.length; ++i) {
            sql.append(selector[i]);
            if (i == selector.length - 1) continue;
            sql.append(", ");
        }
        sql.append(" FROM ");
        sql.append(tableName.toUpperCase());
        sql.append(" WHERE ");
        sql.append(RemoveSqlGenerator.getFilter(filter));
        return sql.toString();
    }

    static class QueryFilter {
        final String filterItem;
        final String querySql;

        QueryFilter(String filterItem, String querySql) {
            this.filterItem = filterItem;
            this.querySql = querySql;
        }
    }

    static interface ParamProvider {
        public AbstractSqlGenerator.FilterInfo getFilter();

        public QueryFilter getQueryFilter();
    }

    static enum RemoveType {
        LogicKey,
        Query;

    }
}

