/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.util.db.TableDesc;
import java.util.HashSet;
import java.util.Set;

class SqlParam {
    final TableDesc tableDesc;
    final MiniList<String> keys;
    final MiniList<Object> values;

    SqlParam(String tableName) {
        this.tableDesc = new TableDesc(tableName);
        this.values = new MiniList();
        this.keys = new MiniList();
    }

    void addParam(String name, int sqlType, Object value) {
        this.tableDesc.addFieldDesc(name, sqlType);
        this.keys.add(name);
        this.values.add(value);
    }

    boolean contains(String key) {
        return this.keys.contains(key);
    }

    static class MiniList<T> {
        private T[] array;
        private int pos = -1;
        private Set<T> quick_judge = null;

        MiniList(int initialCapacity) {
            this.array = new Object[initialCapacity];
        }

        MiniList() {
            this(10);
        }

        void add(T t) {
            ++this.pos;
            if (this.pos == this.array.length) {
                T[] tmp = this.array;
                this.array = new Object[this.array.length * 2];
                System.arraycopy(tmp, 0, this.array, 0, tmp.length);
            }
            this.array[this.pos] = t;
            if (this.quick_judge != null) {
                this.quick_judge.add(t);
            }
        }

        T get(int i) {
            return this.array[i];
        }

        boolean contains(T t) {
            if (t == null) {
                return false;
            }
            if (this.quick_judge != null) {
                return this.quick_judge.contains(t);
            }
            this.quick_judge = new HashSet<T>(this.pos + 1);
            boolean isExist = false;
            for (int i = 0; i <= this.pos; ++i) {
                this.quick_judge.add(this.array[i]);
                if (!t.equals(this.array[i])) continue;
                isExist = true;
            }
            return isExist;
        }

        int size() {
            return this.pos + 1;
        }
    }
}

