/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.lazyload;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.dao.ormapping.lazyload.Utils;
import com.kingdee.util.StringUtils;

public class ObjectValueLazyLoaderWrapper {
    private IObjectValue objVal;

    public ObjectValueLazyLoaderWrapper(IObjectValue objVal) {
        if (objVal == null) {
            throw new IllegalArgumentException("objVal cannot be null.");
        }
        this.objVal = objVal;
    }

    public IObjectValue getTarget() {
        return this.objVal;
    }

    public Object getProperty(String propName) throws BOSException, DataAccessException {
        assert (!StringUtils.isEmpty((String)propName));
        if (Utils.isLoaded(this.objVal, propName)) {
            return this.objVal.get(propName);
        }
        if (this.objVal.getPKField() != null && this.objVal.get(this.objVal.getPKField()) == null) {
            return this.objVal.get(propName);
        }
        this.objVal = ObjectValueLazyLoaderFactory.getRemoteInstance().fillProperty(this.objVal, propName);
        return this.objVal.get(propName);
    }
}

