/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.ast.expr;

import com.kingdee.bos.dao.ormapping_ex.ast.AstNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprType;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IntExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NCharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NullExpr;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

public abstract class ExprNode
extends AstNode
implements Serializable {
    public int type;

    protected ExprNode(int type) {
        this.type = type;
    }

    public String typename() {
        return ExprType.typename(this.type);
    }

    public static ExprNode toExpr(int value) {
        return new IntExpr(Integer.toString(value));
    }

    public static ExprNode toExpr(long value) {
        throw new UnsupportedOperationException("");
    }

    public static ExprNode toExpr(double value) {
        return new IntExpr(Double.toString(value));
    }

    public static ExprNode toExpr(Timestamp value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static ExprNode toExpr(byte[] value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static ExprNode toExpr(BigDecimal value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static ExprNode toCharExpr(String value) {
        if (value == null) {
            return NullExpr.instance;
        }
        return new CharExpr(value);
    }

    public static ExprNode toNCharExpr(String value) {
        if (value == null) {
            return NullExpr.instance;
        }
        return new NCharExpr(value);
    }
}

