/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.parser;

import com.kingdee.bos.dao.ormapping_ex.ast.AbstractDataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.AbstractTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.DataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.DistinctOption;
import com.kingdee.bos.dao.ormapping_ex.ast.JoinedTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByMode;
import com.kingdee.bos.dao.ormapping_ex.ast.SelectItem;
import com.kingdee.bos.dao.ormapping_ex.ast.SimpleTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.SubqueryTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.UnionDataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.parser.ExprParser;
import com.kingdee.bos.dao.ormapping_ex.parser.Lexer;
import com.kingdee.bos.dao.ormapping_ex.parser.OQLParserException;
import com.kingdee.bos.dao.ormapping_ex.parser.Token;
import com.kingdee.bos.dao.ormapping_ex.parser.TokenList;
import java.util.Collection;
import java.util.Map;

public class DataQueryParser {
    private TokenList _tokenList;
    private ExprParser exprParser;
    private static final String[] aliasKeyword = new String[]{"from", "where", "group", "having", "order"};

    public DataQueryParser(String oql) throws OQLParserException {
        Lexer lexer = new Lexer(oql);
        this._tokenList = new TokenList(lexer);
        this.exprParser = new ExprParser(this._tokenList);
    }

    public DataQueryParser(TokenList tokList) {
        this._tokenList = tokList;
        this.exprParser = new ExprParser(this._tokenList);
    }

    public AbstractDataQuery select() throws OQLParserException {
        return this.select(true);
    }

    public AbstractDataQuery select(boolean parseOrderBy) throws OQLParserException {
        AbstractDataQuery rtnValue;
        AbstractDataQuery select;
        if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
            this._tokenList.match(Token.SelectToken);
            select = new DataQuery();
            this.selectListOption((DataQuery)select);
            this.top((DataQuery)select);
            this.selectList(((DataQuery)select).getSelectList());
            this.from((DataQuery)select);
            if (this._tokenList.lookup(0).equals(Token.WithToken)) {
                this._tokenList.match();
                this._tokenList.match(Token.OpenBraceToken);
                String lockingHint = this._tokenList.lookup((int)0).value;
                if (!lockingHint.equalsIgnoreCase("HOLDLOCK")) {
                    throw new OQLParserException("Not support locking hints.");
                }
                ((DataQuery)select).addLockHints(lockingHint);
                this._tokenList.match();
                this._tokenList.match(Token.CloseBraceToken);
            }
            this.where((DataQuery)select);
            this.groupBy((DataQuery)select);
            rtnValue = this.selectRest(select);
        } else if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            select = this.select();
            this._tokenList.match(Token.CloseBraceToken);
            if (parseOrderBy) {
                this.orderBy(select);
            }
            rtnValue = this.selectRest(select);
        } else {
            throw new OQLParserException("not support token:" + this._tokenList.lookup(0));
        }
        if (parseOrderBy) {
            this.orderBy(rtnValue);
        }
        if (this._tokenList.lookup(0).equals(Token.OptionToken)) {
            this._tokenList.match();
            Map optionMap = ((DataQuery)rtnValue).getOptionMap();
            boolean flag = false;
            while (true) {
                int num;
                String numStr;
                String query_hint;
                if ("CONCAT".equalsIgnoreCase(query_hint = this._tokenList.lookup((int)0).value)) {
                    flag = true;
                    this._tokenList.match(3);
                    this._tokenList.match(Token.UnionToken);
                    optionMap.put("CONCAT UNION", null);
                    continue;
                }
                if ("EXPAND".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(8, "VIEWS", false);
                    optionMap.put("EXPAND VIEWS", null);
                    continue;
                }
                if ("FAST".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    numStr = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(8);
                    num = Integer.parseInt(numStr);
                    optionMap.put("FAST", num);
                    continue;
                }
                if ("FASTFIRSTROW".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("FASTFIRSTROW", null);
                    continue;
                }
                if ("FOR".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.UpdateToken);
                    optionMap.put("FORCE UPDATE", null);
                    continue;
                }
                if ("FORCE".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.OrderToken);
                    optionMap.put("FORCE ORDER", null);
                    continue;
                }
                if ("HASH".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    if (this._tokenList.lookup(0).equals(Token.GroupToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH GROUP", null);
                        continue;
                    }
                    if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH UNION", null);
                        continue;
                    }
                    if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH JOIN", null);
                        continue;
                    }
                    throw new OQLParserException("not support token:" + this._tokenList.lookup(0));
                }
                if ("KEEP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("KEEP PLAN", null);
                    continue;
                }
                if ("KEEPFIXED".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("KEEPFIXED PLAN", null);
                    continue;
                }
                if ("MAXDOP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    numStr = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(8);
                    num = Integer.parseInt(numStr);
                    optionMap.put("MAXDOP", num);
                    continue;
                }
                if ("MERGE".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
                        this._tokenList.match();
                        optionMap.put("MERGE UNION", null);
                        continue;
                    }
                    if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
                        this._tokenList.match();
                        optionMap.put("MERGE JOIN", null);
                        continue;
                    }
                    throw new OQLParserException("not support token:" + this._tokenList.lookup(0));
                }
                if ("ORDER".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match(3);
                    this._tokenList.match(Token.GroupToken);
                    optionMap.put("ORDER GROUP", null);
                    continue;
                }
                if ("LOOP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.JoinToken);
                    optionMap.put("LOOP JOIN", null);
                    continue;
                }
                if ("ROBUST".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("ROBUST PLAN", null);
                    continue;
                }
                if ("ROWLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("ROWLOCK", null);
                    continue;
                }
                if ("TABLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("TABLOCK", null);
                    continue;
                }
                if ("UPDLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("UPDLOCK", null);
                    continue;
                }
                if (!"XLOCK".equalsIgnoreCase(query_hint)) break;
                flag = true;
                this._tokenList.match();
                optionMap.put("XLOCK", null);
            }
            if (!flag) {
                throw new OQLParserException("Syntax Error. Option hints ... , current token is : " + this._tokenList.lookup(0).toString());
            }
        }
        return rtnValue;
    }

    private final AbstractDataQuery selectRest(AbstractDataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
            this._tokenList.match();
            int option = 1;
            if (this._tokenList.lookup(0).equals(Token.AllToken)) {
                this._tokenList.match();
                option = 0;
            }
            AbstractDataQuery right = this.select(false);
            select = new UnionDataQuery(select, right, option);
            select = this.selectRest(select);
        }
        return select;
    }

    private final void selectListOption(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.DistinctToken)) {
            select.setDistinctOption(DistinctOption.Distinct);
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.AllToken)) {
            select.setDistinctOption(DistinctOption.All);
            this._tokenList.match();
        }
    }

    private final void top(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.TopToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 8) {
                int top = Integer.parseInt(this._tokenList.lookup((int)0).value);
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.PercentToken)) {
                    throw new OQLParserException("not support toekn:" + this._tokenList.lookup(0));
                }
                select.setTop(top);
            } else {
                throw new OQLParserException("Error. ", this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
            }
        }
    }

    private final void from(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.FromToken)) {
            this._tokenList.match();
            AbstractTableSource tableSource = this.tableSource();
            select.setTableSource(tableSource);
        }
    }

    private final void where(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.WhereToken)) {
            this._tokenList.match();
            ExprNode expr = this.exprParser.expr();
            select.setFilterCondition(expr);
        }
    }

    private final void groupBy(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.GroupToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.ByToken);
            this.exprParser.exprList(select.getGroupByItemList());
            this.having(select);
        }
    }

    private final void having(DataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.HavingToken)) {
            this._tokenList.match();
            select.setHaving(this.exprParser.expr());
        }
    }

    private final void orderBy(AbstractDataQuery select) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.OrderToken)) {
            this._tokenList.match();
            do {
                OrderByItem orderByItem;
                this._tokenList.match();
                ExprNode expr = this.exprParser.expr();
                if (this._tokenList.lookup(0).equals(Token.AscToken)) {
                    orderByItem = new OrderByItem(expr, OrderByMode.Asc);
                    this._tokenList.match();
                } else if (this._tokenList.lookup(0).equals(Token.DescToken)) {
                    orderByItem = new OrderByItem(expr, OrderByMode.Desc);
                    this._tokenList.match();
                } else {
                    orderByItem = new OrderByItem(expr, OrderByMode.Asc);
                }
                select.getOrderByItemList().add(orderByItem);
            } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        }
    }

    private final void selectList(Collection selectItemCol) throws OQLParserException {
        BinaryOpExpr binaryOpExpr;
        ExprNode expr = this.exprParser.expr();
        String alias = null;
        if (expr instanceof BinaryOpExpr) {
            binaryOpExpr = (BinaryOpExpr)expr;
            if ((binaryOpExpr.operator == 2 || binaryOpExpr.operator == 10) && binaryOpExpr.left instanceof IdentifierExpr) {
                expr = binaryOpExpr.right;
                alias = ((IdentifierExpr)binaryOpExpr.left).value;
            }
        }
        if (alias == null) {
            alias = this.as();
        }
        selectItemCol.add(new SelectItem(expr, alias));
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            alias = null;
            expr = this.exprParser.expr();
            if (expr instanceof BinaryOpExpr) {
                binaryOpExpr = (BinaryOpExpr)expr;
                if ((binaryOpExpr.operator == 2 || binaryOpExpr.operator == 10) && binaryOpExpr.left instanceof IdentifierExpr) {
                    expr = binaryOpExpr.right;
                    alias = ((IdentifierExpr)binaryOpExpr.left).value;
                }
            }
            if (alias == null) {
                alias = this.as();
            }
            selectItemCol.add(new SelectItem(expr, alias));
        }
    }

    public AbstractTableSource tableSource() throws OQLParserException {
        AbstractTableSource tablesource = null;
        int openBraceCount = 0;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            tablesource = this.tableSource();
            SubqueryTableSource subQueryTabSrc = null;
            if (tablesource instanceof SubqueryTableSource) {
                subQueryTabSrc = (SubqueryTableSource)tablesource;
                subQueryTabSrc.subQuery = this.selectRest(subQueryTabSrc.subQuery);
            }
            this._tokenList.match(Token.CloseBraceToken);
            String alias = this.as();
            if (alias != null && alias.length() != 0) {
                subQueryTabSrc.alias = alias;
            }
            tablesource = this.tableSourceRest(tablesource);
            return tablesource;
        }
        if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
            DataQueryParser selectParser = new DataQueryParser(this._tokenList);
            AbstractDataQuery subQuery = selectParser.select();
            tablesource = new SubqueryTableSource(subQuery);
        } else if (this._tokenList.lookup((int)0).type == 1) {
            StringBuffer tableName = new StringBuffer();
            tableName.append(this._tokenList.lookup((int)0).value);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                tableName.append(".");
                this._tokenList.match();
                tableName.append(this._tokenList.lookup((int)0).value);
                this._tokenList.match(1);
            }
            tablesource = new SimpleTableSource(tableName.toString());
        }
        while (openBraceCount != 0) {
            this._tokenList.match(Token.CloseBraceToken);
            --openBraceCount;
        }
        return this.tableSourceRest(tablesource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AbstractTableSource tableSourceRest(AbstractTableSource tablesource) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.AsToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 1) {
                if (tablesource.alias != null) throw new OQLParserException("Error");
                tablesource.alias = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                tablesource = this.tableSourceRest(tablesource);
            } else {
                if (this._tokenList.lookup((int)0).type != 6) throw new OQLParserException("Error");
                if (tablesource.alias != null) throw new OQLParserException("Error");
                tablesource.alias = "'" + this._tokenList.lookup((int)0).value + "'";
                this._tokenList.match();
                tablesource = this.tableSourceRest(tablesource);
            }
        } else if (this._tokenList.lookup((int)0).type == 1 && this.canAlias(this._tokenList.lookup((int)0).value)) {
            if (tablesource.alias == null || tablesource.alias.length() == 0) {
                tablesource.alias = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                tablesource = this.tableSourceRest(tablesource);
            }
        } else if (this._tokenList.lookup((int)0).type == 6) {
            if (tablesource.alias != null) {
                if (tablesource.alias.length() != 0) throw new OQLParserException("Error", 0, 0);
            }
            tablesource.alias = "'" + this._tokenList.lookup((int)0).value + "'";
            this._tokenList.match();
            tablesource = this.tableSourceRest(tablesource);
        } else if (this._tokenList.lookup((int)0).type == 7) {
            if (tablesource.alias != null) {
                if (tablesource.alias.length() != 0) throw new OQLParserException("Error", 0, 0);
            }
            tablesource.alias = "N'" + this._tokenList.lookup((int)0).value + "'";
            this._tokenList.match();
            tablesource = this.tableSourceRest(tablesource);
        } else if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
            this._tokenList.match();
            AbstractTableSource right = this.tableSource();
            this._tokenList.match(Token.OnToken);
            ExprNode condition = this.exprParser.expr();
            tablesource = new JoinedTableSource(tablesource, right, 0, condition);
        } else if (this._tokenList.lookup(0).equals(Token.InnerToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.JoinToken);
            AbstractTableSource right = this.tableSource();
            this._tokenList.match(Token.OnToken);
            ExprNode condition = this.exprParser.expr();
            tablesource = new JoinedTableSource(tablesource, right, 0, condition);
        } else if (this._tokenList.lookup(0).equals(Token.LeftToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OuterToken)) {
                this._tokenList.match(Token.OuterToken);
            }
            this._tokenList.match(Token.JoinToken);
            AbstractTableSource right = this.tableSource();
            this._tokenList.match(Token.OnToken);
            ExprNode condition = this.exprParser.expr();
            DataQueryParser.checkOuterJoinCondition(condition);
            tablesource = new JoinedTableSource(tablesource, right, 1, condition);
        } else if (this._tokenList.lookup(0).equals(Token.RightToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OuterToken)) {
                this._tokenList.match(Token.OuterToken);
            }
            this._tokenList.match(Token.JoinToken);
            AbstractTableSource right = this.tableSource();
            this._tokenList.match(Token.OnToken);
            ExprNode condition = this.exprParser.expr();
            tablesource = new JoinedTableSource(tablesource, right, 2, condition);
        } else {
            if (this._tokenList.lookup(0).equals(Token.FullToken)) {
                throw new OQLParserException("FULL JOIN IS NOT SUPPORT.");
            }
            if (this._tokenList.lookup(0).equals(Token.CrossToken)) {
                this._tokenList.match();
                this._tokenList.match(Token.JoinToken);
                AbstractTableSource right = this.tableSource();
                tablesource = new JoinedTableSource(tablesource, right, 4, null);
            } else if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                AbstractTableSource right = this.tableSource();
                tablesource = new JoinedTableSource(tablesource, right, 4, null);
            }
        }
        if (this._tokenList.lookup(0).equals(Token.CommaToken)) return this.tableSourceRest(tablesource);
        if (this._tokenList.lookup(0).equals(Token.InnerToken)) return this.tableSourceRest(tablesource);
        if (this._tokenList.lookup(0).equals(Token.LeftToken)) return this.tableSourceRest(tablesource);
        if (this._tokenList.lookup(0).equals(Token.RightToken)) return this.tableSourceRest(tablesource);
        if (this._tokenList.lookup(0).equals(Token.FullToken)) return this.tableSourceRest(tablesource);
        if (!this._tokenList.lookup(0).equals(Token.JoinToken)) return tablesource;
        return this.tableSourceRest(tablesource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkOuterJoinCondition(ExprNode expr) throws OQLParserException {
        if (!(expr instanceof BinaryOpExpr)) throw new OQLParserException("not support join table seach condition.");
        BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
        if (binaryOpExpr.operator == 10) return;
        if (binaryOpExpr.operator != 7) throw new OQLParserException("not support join table seach condition.");
        DataQueryParser.checkOuterJoinCondition(binaryOpExpr.left);
        DataQueryParser.checkOuterJoinCondition(binaryOpExpr.right);
    }

    private final boolean canAlias(String item) {
        for (int i = 0; i < aliasKeyword.length; ++i) {
            if (!aliasKeyword[i].equalsIgnoreCase(item)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String as() throws OQLParserException {
        String rtnValue = null;
        if (this._tokenList.lookup(0).equals(Token.AsToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 6) {
                rtnValue = "'" + this._tokenList.lookup((int)0).value + "'";
                this._tokenList.match();
                return rtnValue;
            } else {
                if (this._tokenList.lookup((int)0).type != 1) throw new OQLParserException("Error", 0, 0);
                rtnValue = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
            }
            return rtnValue;
        } else if (this._tokenList.lookup((int)0).type == 6) {
            rtnValue = "'" + this._tokenList.lookup((int)0).value + "'";
            this._tokenList.match();
            return rtnValue;
        } else {
            if (this._tokenList.lookup((int)0).type != 1 || !this.canAlias(this._tokenList.lookup((int)0).value)) return rtnValue;
            rtnValue = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
        }
        return rtnValue;
    }
}

