/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.parser;

public class KeyWord {
    public static final String[] DEFAULT_KEYWORDS = new String[]{"AND", "ASC", "DELETE", "DESC", "IN", "IS", "LIKE", "NOT", "NULL", "OR", "SET", "UPDATE"};
    public static final KeyWord instance = new KeyWord();
    private final String[] _aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM", "STDDEV"};
    private final String[] _keywords;

    public final boolean isAggreateFunction(String word) {
        for (int i = 0; i < this._aggregateFunctions.length; ++i) {
            if (this._aggregateFunctions[i].compareToIgnoreCase(word) != 0) continue;
            return true;
        }
        return false;
    }

    public KeyWord() {
        this._keywords = DEFAULT_KEYWORDS;
    }

    public KeyWord(String[] keywords) {
        this._keywords = keywords;
    }

    public final boolean isKeyWord(String word) {
        int low = 0;
        int high = this._keywords.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = this._keywords[mid];
            int cmp = midVal.compareToIgnoreCase(word);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }
}

