/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping_ex.ast.CaseItem;
import com.kingdee.bos.dao.ormapping_ex.ast.ObjectQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AggregateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AllColumnExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BetweenExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CaseExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.DateTimeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InListExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IntExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.LiteralExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NotExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ObjectCreateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.VarRefExpr;
import com.kingdee.bos.dao.ormapping_ex.parser.ExprParser;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecuteStep;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ObjectQueryContext;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.SelectItemInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.util.TODOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QueryUtil {
    public static void computeOneToManyChildEntity(List identList, EntityObjectInfo parentEntity, Collection outEntityCol, Collection outEntityPrefixCol, Collection outLinkPropCol) throws BOSException {
        QueryUtil.computeOneToManyChildEntityInternal(identList, null, parentEntity, outEntityCol, outEntityPrefixCol, outLinkPropCol);
    }

    private static void computeOneToManyChildEntityInternal(List identList, String prefix, EntityObjectInfo parentEntity, Collection outEntityCol, Collection outEntityPrefixCol, Collection outLinkPropCol) throws BOSException {
        PropertyCollection propCol = parentEntity.getPropertiesRuntime();
        for (int i = 0; i < propCol.size(); ++i) {
            PropertyInfo propInfo = propCol.get(i);
            if (!(propInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)propInfo;
            RelationshipInfo relationshipInfo = linkPropInfo.getRelationship();
            CardinalityType cardinalityType = relationshipInfo.getChildCardinality(parentEntity);
            EntityObjectInfo childEntity = relationshipInfo.getChildObject(parentEntity);
            String subPrefix = prefix == null || prefix.length() == 0 ? propInfo.getName() : prefix + "." + propInfo.getName();
            boolean flag = false;
            for (int j = 0; j < identList.size(); ++j) {
                String ident = (String)identList.get(j);
                if (subPrefix != null && subPrefix.length() > 0) {
                    if (!ident.startsWith(subPrefix)) continue;
                    flag = true;
                    break;
                }
                if (ident.indexOf(".") <= 0) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            if (cardinalityType.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || cardinalityType.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                outEntityCol.add(childEntity);
                outEntityPrefixCol.add(subPrefix);
                outLinkPropCol.add(linkPropInfo);
            }
            QueryUtil.computeOneToManyChildEntityInternal(identList, subPrefix, childEntity, outEntityCol, outEntityPrefixCol, outLinkPropCol);
        }
    }

    private static SqlExpr buildJoinCondition(String leftTabName, String leftColumnName, String rightTabName, String rightColumnName) {
        SqlBinaryOpExpr leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(leftTabName), 20, (SqlExpr)new SqlIdentifierExpr(leftColumnName));
        SqlBinaryOpExpr rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(rightTabName), 20, (SqlExpr)new SqlIdentifierExpr(rightColumnName));
        SqlBinaryOpExpr joinCondition = new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr);
        return joinCondition;
    }

    public static void computeTableSource(ObjectQueryContext objQueryCtx, SqlSelect select) throws BOSException {
        String nodePrefix = objQueryCtx.getCurrentEntityPrefix();
        List entityList = objQueryCtx.getEntityList();
        List entityPrefixList = objQueryCtx.getEntityPrefixList();
        List fieldList = objQueryCtx.getFieldList();
        List propInfoList = objQueryCtx.getPropList();
        Map tabAliasMap = objQueryCtx.getTableAliasMap();
        if (!entityPrefixList.contains(nodePrefix)) {
            EntityObjectInfo entity = objQueryCtx.getCurrentEntity();
            entityList.add(0, entity);
            entityPrefixList.add(0, nodePrefix);
        }
        for (int entityIndex = 0; entityIndex < entityList.size(); ++entityIndex) {
            String childTabAlias;
            String childTabName;
            ColumnInfo childColumn;
            String parentTabAlias;
            EntityObjectInfo parentEntity;
            EntityObjectInfo entity = (EntityObjectInfo)entityList.get(entityIndex);
            String entityPrefix = (String)entityPrefixList.get(entityIndex);
            ArrayList entityFieldList = new ArrayList();
            ArrayList entityPropList = new ArrayList();
            QueryUtil.computeFieldList(nodePrefix, fieldList, propInfoList, entityIndex, entityPrefix, entityFieldList, entityPropList);
            assert (entityFieldList.size() != entityPropList.size());
            SqlTableSourceBase tableSrc = null;
            String propEntityIdent = entityPrefix;
            ArrayList tabList = new ArrayList();
            for (Map.Entry mapEntry : tabAliasMap.entrySet()) {
                String tabAliasKey = (String)mapEntry.getKey();
                int lastIndex = tabAliasKey.lastIndexOf(46);
                String tabEntityIdent = lastIndex == -1 ? null : tabAliasKey.substring(0, lastIndex);
                if ((tabEntityIdent != null || propEntityIdent != null && propEntityIdent.length() != 0) && (tabEntityIdent == null || !tabEntityIdent.equals(propEntityIdent))) continue;
                tabList.add(mapEntry);
            }
            int tabCount = tabList.size();
            for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
                Map.Entry mapEntry = (Map.Entry)tabList.get(tabIndex);
                if (tableSrc == null) {
                    tableSrc = QueryUtil.buildTableSourceItem(objQueryCtx, entityIndex, entity, entityPrefix, mapEntry);
                    continue;
                }
                SqlTableSourceBase rightSrc = QueryUtil.buildTableSourceItem(objQueryCtx, entityIndex, entity, entityPrefix, mapEntry);
                LogicalKeyInfo logicalKey = entity.getLogicalKey();
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                String leftAlias = tableSrc.alias;
                String rightAlias = rightSrc.alias;
                Object joinCondition = null;
                int keyPropColSize = keyPropCol.size();
                for (int keyPropIndex = 0; keyPropIndex < keyPropColSize; ++keyPropIndex) {
                    PropertyInfo keyProp = keyPropCol.get(keyPropIndex);
                    ColumnInfo keyColumn = keyProp.getMappingField();
                    String keyColumnName = keyColumn.getName();
                    SqlExpr expr = QueryUtil.buildJoinCondition(leftAlias, keyColumnName, rightAlias, keyColumnName);
                    joinCondition = joinCondition == null ? expr : new SqlBinaryOpExpr(joinCondition, 7, expr);
                }
                tableSrc = new SqlJoinedTableSource(tableSrc, rightSrc, 0, joinCondition);
            }
            if (tableSrc == null) {
                throw new BOSException("Fatal Error.");
            }
            if (select.tableSource == null) {
                select.tableSource = tableSrc;
                continue;
            }
            if (entityIndex == 0) {
                throw new TODOException();
            }
            if (entityPrefix == null || entityPrefix.length() == 0) {
                throw new TODOException();
            }
            EntityObjectInfo preEntity = (EntityObjectInfo)entityList.get(entityIndex - 1);
            String prefEntityPrefix = (String)entityPrefixList.get(entityIndex - 1);
            boolean isNeighbor = false;
            if (prefEntityPrefix == null || prefEntityPrefix.length() == 0) {
                if (entityPrefix.indexOf(46) == -1) {
                    isNeighbor = true;
                }
            } else if (entityPrefix.indexOf(46, prefEntityPrefix.length() + 1) == -1) {
                isNeighbor = true;
            }
            if (!isNeighbor) continue;
            String[] nameArray = entityPrefix.split("\\.");
            String propName = nameArray[nameArray.length - 1];
            if (nameArray.length > 1) {
                String[] parentNameArray;
                if (objQueryCtx.getCurrentEntityPrefix() != null && objQueryCtx.getCurrentEntityPrefix().length() != 0) {
                    parentNameArray = new String[nameArray.length - 1];
                    System.arraycopy(nameArray, 0, parentNameArray, 0, parentNameArray.length);
                    parentEntity = ORMUtils.getEntity(objQueryCtx.getRootEntity(), parentNameArray);
                } else {
                    parentNameArray = new String[nameArray.length - 1];
                    System.arraycopy(nameArray, 0, parentNameArray, 0, parentNameArray.length);
                    parentEntity = ORMUtils.getEntity(objQueryCtx.getCurrentEntity(), parentNameArray);
                }
            } else {
                if (objQueryCtx.getCurrentEntityPrefix() != null && objQueryCtx.getCurrentEntityPrefix().length() != 0) {
                    throw new TODOException();
                }
                parentEntity = objQueryCtx.getCurrentEntity();
            }
            LinkPropertyInfo linkProp = (LinkPropertyInfo)parentEntity.getPropertyByNameRuntime(propName);
            if (linkProp == null) {
                throw new BOSException("Fatal Error.");
            }
            ColumnInfo column = linkProp.getMappingField();
            ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, parentEntity, (PropertyInfo)linkProp);
            DataTableInfo parentTable = QueryUtil.getTable(parentEntity, propName);
            String parentTabName = parentTable.getName();
            int entityPrefixLastIndex = entityPrefix.lastIndexOf(46);
            String preEntityPrefix = entityPrefixLastIndex == -1 ? "" : entityPrefix.substring(0, entityPrefixLastIndex);
            String preTabAliasKey = preEntityPrefix == null || preEntityPrefix.length() == 0 ? parentTabName : preEntityPrefix + "." + parentTabName;
            if (objQueryCtx.getTableAliasMap().containsKey(preTabAliasKey)) {
                parentTabAlias = (String)objQueryCtx.getTableAliasMap().get(preTabAliasKey);
            } else {
                parentTabAlias = "T" + objQueryCtx.getTableAliasMap().size();
                objQueryCtx.getTableAliasMap().put(preTabAliasKey, parentTabAlias);
            }
            if (column == null) {
                throw new TODOException();
            }
            RelationshipInfo relationship = linkProp.getRelationship();
            EntityObjectInfo childEntity = relationship.getChildObject(preEntity);
            PropertyInfo childPropInfo = relationship.getChildProperty(preEntity);
            if (childPropInfo instanceof LinkPropertyInfo) {
                LogicalKeyInfo childLogicalKey = preEntity.getLogicalKey();
                PropertyCollection childKeyPropCol = childLogicalKey.getKeyPropertys();
                if (childKeyPropCol.size() != 1) {
                    throw new TODOException();
                }
                OwnPropertyInfo childKeyPropInfo = (OwnPropertyInfo)childKeyPropCol.get(0);
                childColumn = childKeyPropInfo.getMappingField();
                ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, preEntity, (PropertyInfo)childKeyPropInfo);
                parentEntity = ORMUtils.getEntity(childEntity, childKeyPropInfo.getName());
                childTabName = entity.getTable().getName();
                childTabAlias = QueryUtil.getTabAliasKey(tabAliasMap, entityPrefix, childTabName);
            } else {
                OwnPropertyInfo childOwnPropInfo = (OwnPropertyInfo)childPropInfo;
                childColumn = childOwnPropInfo.getMappingField();
                ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), childColumn, preEntity, (PropertyInfo)childOwnPropInfo);
                DataTableInfo childTable = QueryUtil.getTable(entity, childPropInfo.getName());
                childTabName = childTable.getName();
                childTabAlias = QueryUtil.getTabAliasKey(tabAliasMap, entityPrefix, childTabName);
            }
            if (childColumn == null) {
                throw new TODOException();
            }
            SqlExpr joinCondition = QueryUtil.buildJoinCondition(parentTabAlias, column.getName(), childTabAlias, childColumn.getName());
            select.tableSource = new SqlJoinedTableSource(select.tableSource, tableSrc, 1, joinCondition);
        }
    }

    private static SqlTableSourceBase buildTableSourceItem(ObjectQueryContext objQueryCtx, int entityIndex, EntityObjectInfo entity, String entityPrefix, Map.Entry mapEntry) throws BOSException {
        SqlTableSource tableSrc = null;
        String tabAliasKey = (String)mapEntry.getKey();
        int lastIndex = tabAliasKey.lastIndexOf(46);
        String tabName = lastIndex == -1 ? tabAliasKey : tabAliasKey.substring(lastIndex + 1);
        String tabAlias = (String)mapEntry.getValue();
        tableSrc = new SqlTableSource(tabName);
        tableSrc.alias = tabAlias;
        return tableSrc;
    }

    private static String getTabAliasKey(Map aliasMap, String propEntityIdent, String tabName) {
        String tabAlias;
        String tabAliasKey;
        if (propEntityIdent == null) {
            propEntityIdent = "";
        }
        if (aliasMap.containsKey(tabAliasKey = propEntityIdent.length() == 0 ? tabName : propEntityIdent + '.' + tabName)) {
            tabAlias = (String)aliasMap.get(tabAliasKey);
        } else {
            tabAlias = "T" + aliasMap.size();
            aliasMap.put(tabAliasKey, tabAlias);
        }
        return tabAlias;
    }

    private static void computeFieldList(String nodePrefix, List fieldList, List propInfoList, int i, String entityPrefix, List entityFieldList, List entityPropList) {
        for (int j = 0; j < fieldList.size(); ++j) {
            String field = (String)fieldList.get(j);
            PropertyInfo propInfo = (PropertyInfo)propInfoList.get(j);
            if (i == 0 && nodePrefix == null) {
                if (field.indexOf(".") != -1) continue;
                assert (!"*".endsWith(field));
                if (entityFieldList.contains(field)) continue;
                entityFieldList.add(field);
                entityPropList.add(propInfo);
                continue;
            }
            if (!field.startsWith(entityPrefix) || field.indexOf(46, entityPrefix.length() + 1) != -1 || entityFieldList.contains(field)) continue;
            assert (field.length() != entityPrefix.length());
            entityFieldList.add(field);
            entityPropList.add(propInfo);
        }
    }

    public static void computeEntityList(ObjectQuery query, String parentPrefix, ObjectQueryContext objQueryCtx) throws BOSException {
        ArrayList identList = new ArrayList();
        query.populateIdentifier(identList, true);
        QueryUtil.computeEntityListInternal(identList, objQueryCtx.getCurrentEntity(), objQueryCtx, parentPrefix);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void computeEntityListInternal(List identList, EntityObjectInfo parentEntity, ObjectQueryContext objQueryCtx, String parentPrefix) throws BOSException {
        EntityObjectInfo childEntity;
        LinkPropertyInfo linkPropInfo;
        PropertyInfo propInfo;
        List outEntityList = objQueryCtx.getEntityList();
        List outFieldList = objQueryCtx.getFieldList();
        List outEntityPrefixList = objQueryCtx.getEntityPrefixList();
        List outPropInfoList = objQueryCtx.getPropList();
        List outPropEntityList = objQueryCtx.getPropEntityList();
        for (int identIndex = 0; identIndex < identList.size(); ++identIndex) {
            OwnPropertyInfo keyProp;
            String ident = (String)identList.get(identIndex);
            if (parentPrefix != null && parentPrefix.length() > 0) {
                if (!ident.startsWith(parentPrefix) || ident.indexOf(46, parentPrefix.length() + 1) != -1 || !parentPrefix.equals(ident) && ident.indexOf(46, parentPrefix.length()) != parentPrefix.length()) continue;
                String[] nameArray = ident.split("\\.");
                String propName = nameArray[nameArray.length - 1];
                if ("*".equals(propName)) {
                    throw new TODOException();
                }
                PropertyInfo propInfo2 = parentEntity.getPropertyByNameRuntime(propName);
                if (propInfo2 == null) {
                    if (!parentPrefix.equals(ident)) throw new TODOException();
                    LogicalKeyInfo logicalKey = parentEntity.getLogicalKey();
                    PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                    int keyPropColSize = keyPropCol.size();
                    for (int k = 0; k < keyPropColSize; ++k) {
                        keyProp = keyPropCol.get(k);
                        String keyIdent = ident + "." + keyProp.getName();
                        outFieldList.add(keyIdent);
                        outPropInfoList.add(keyProp);
                        outPropEntityList.add(parentEntity);
                    }
                } else {
                    if (propInfo2 instanceof LinkPropertyInfo) {
                        if (ident.length() >= parentPrefix.length()) continue;
                        throw new TODOException();
                    }
                    outFieldList.add(ident);
                    outPropInfoList.add(propInfo2);
                    outPropEntityList.add(parentEntity);
                }
                if (outEntityPrefixList.contains(parentPrefix)) continue;
                outEntityList.add(parentEntity);
                outEntityPrefixList.add(parentPrefix);
                continue;
            }
            if (ident.indexOf(".") != -1) continue;
            if ("*".equals(ident)) {
                int propIndex = 0;
                PropertyCollection propCol = parentEntity.getPropertiesRuntime();
                int propColSize = propCol.size();
                if (propIndex >= propColSize) throw new TODOException();
                PropertyInfo propInfo3 = propCol.get(propIndex);
                if (propInfo3 instanceof OwnPropertyInfo) {
                    throw new TODOException();
                }
                if (!(propInfo3 instanceof OwnPropertyInfo)) throw new TODOException();
                throw new TODOException();
            }
            propInfo = parentEntity.getPropertyByNameRuntime(ident);
            if (propInfo == null) {
                throw new BOSException("TODO");
            }
            if (propInfo instanceof LinkPropertyInfo) {
                EntityObjectInfo entity;
                linkPropInfo = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkPropInfo.getRelationship();
                childEntity = relationship.getChildObject(entity = objQueryCtx.getCurrentEntity());
                LogicalKeyInfo logicalKey = childEntity.getLogicalKey();
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) {
                    throw new TODOException();
                }
                keyProp = (OwnPropertyInfo)keyPropCol.get(0);
                String propEntityIdent = linkPropInfo.getName() + "." + keyProp.getName();
                outFieldList.add(propEntityIdent);
                outPropInfoList.add(keyProp);
                outPropEntityList.add(childEntity);
            } else {
                if (!(propInfo instanceof OwnPropertyInfo)) throw new BOSException("TODO");
                outFieldList.add(ident);
                outPropInfoList.add(propInfo);
                outPropEntityList.add(parentEntity);
            }
            if (outEntityPrefixList.contains(parentPrefix)) continue;
            outEntityList.add(parentEntity);
            outEntityPrefixList.add(parentPrefix);
        }
        PropertyCollection propCol = parentEntity.getPropertiesRuntime();
        for (int i = 0; i < propCol.size(); ++i) {
            RelationshipInfo relationshipInfo;
            CardinalityType cardinalityType;
            propInfo = propCol.get(i);
            if (!(propInfo instanceof LinkPropertyInfo) || !(cardinalityType = (relationshipInfo = (linkPropInfo = (LinkPropertyInfo)propInfo).getRelationship()).getChildCardinality(parentEntity)).equals((Object)CardinalityType.ZERO_TO_ONE) && !cardinalityType.equals((Object)CardinalityType.ONE)) continue;
            childEntity = relationshipInfo.getChildObject(parentEntity);
            String subPrefix = parentPrefix == null || parentPrefix.length() == 0 ? propInfo.getName() : parentPrefix + "." + propInfo.getName();
            boolean flag = false;
            for (int j = 0; j < identList.size(); ++j) {
                String ident = (String)identList.get(j);
                if (subPrefix != null && subPrefix.length() > 0) {
                    if (!ident.startsWith(subPrefix)) continue;
                    flag = true;
                    break;
                }
                if (ident.indexOf(".") <= 0) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            QueryUtil.computeEntityListInternal(identList, childEntity, objQueryCtx, subPrefix);
        }
    }

    public static List getEntityList(ObjectQuery query, EntityObjectInfo rootEntity) throws BOSException {
        ArrayList identList = new ArrayList();
        query.populateIdentifier(identList, true);
        throw new TODOException();
    }

    public static PropertyInfo getProperty(EntityObjectInfo entity, String ident) {
        String[] propNameArray = ident.split("\\.");
        EntityObjectInfo curEntity = null;
        PropertyInfo propInfo = null;
        for (int j = 0; j < propNameArray.length; ++j) {
            if (j == 0) {
                curEntity = entity;
            } else {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                curEntity = linkProp.getRelationship().getChildObject(curEntity);
            }
            propInfo = curEntity.getPropertyByNameRuntime(propNameArray[j]);
        }
        return propInfo;
    }

    public static void buildSelectList(ObjectQuery query, SqlSelect select, ExecuteStep step, ObjectQueryContext objQueryCtx) throws BOSException {
        String stepPrefix;
        ExprNode filterExpr;
        int columnIndex = 0;
        List fieldList = objQueryCtx.getFieldList();
        List selectList = query.getSelectList();
        for (int i = 0; i < selectList.size(); ++i) {
            ExprNode oqlExpr = (ExprNode)selectList.get(i);
            String exprStr = oqlExpr.toString();
            if (!fieldList.contains(exprStr)) continue;
            SelectItemInfo[] selectItemArray = QueryUtil.buildSqlExpr(oqlExpr, objQueryCtx, true);
            for (int j = 0; j < selectItemArray.length; ++j) {
                String alias = "F" + columnIndex++;
                SqlExpr sqlExpr = selectItemArray[j].getSqlExpr();
                SqlSelectItem sqlSelectItem = new SqlSelectItem(sqlExpr, alias);
                select.selectList.add(sqlSelectItem);
                objQueryCtx.getColumnMap().put(QueryUtil.sqlExprToString(sqlExpr), alias);
                step.getSelectItemList().add(selectItemArray[j]);
            }
        }
        Map filterMap = query.getEntriesFilterDirect();
        if (filterMap != null && (filterExpr = (ExprNode)filterMap.get(stepPrefix = objQueryCtx.getCurrentEntityPrefix())) != null) {
            ArrayList filterIdentList = new ArrayList();
            QueryUtil.computeIdent(filterExpr, filterIdentList);
            for (int i = 0; i < filterIdentList.size(); ++i) {
                String identStr = (String)filterIdentList.get(i);
                ExprNode identExpr = new ExprParser(identStr).expr();
                SelectItemInfo[] selectItemArray = QueryUtil.buildSqlExpr(identExpr, objQueryCtx, true);
                for (int j = 0; j < selectItemArray.length; ++j) {
                    String alias = "F" + columnIndex++;
                    SqlExpr sqlExpr = selectItemArray[j].getSqlExpr();
                    objQueryCtx.getColumnMap().put(QueryUtil.sqlExprToString(sqlExpr), alias);
                    step.getEntryFilterSelectItemList().add(selectItemArray[j]);
                }
            }
        }
        List entityList = objQueryCtx.getEntityList();
        List entityPrefixList = objQueryCtx.getEntityPrefixList();
        List selectItemList = step.getSelectItemList();
        int size = entityList.size();
        for (int entityIndex = 0; entityIndex < size; ++entityIndex) {
            EntityObjectInfo entity = (EntityObjectInfo)entityList.get(entityIndex);
            String prefix = (String)entityPrefixList.get(entityIndex);
            LogicalKeyInfo logicalKey = entity.getLogicalKey();
            String[] pkIdentArray = new String[logicalKey.getKeyPropertys().size()];
            PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
            int keyPropColSize = keyPropCol.size();
            for (int pkIdentIndex = 0; pkIdentIndex < keyPropColSize; ++pkIdentIndex) {
                OwnPropertyInfo keyProp = (OwnPropertyInfo)keyPropCol.get(pkIdentIndex);
                pkIdentArray[pkIdentIndex] = prefix != null && prefix.length() != 0 ? prefix + "." + keyProp.getName() : keyProp.getName();
            }
            boolean[] pkIdentArrayMatch = new boolean[pkIdentArray.length];
            for (int pkIdentIndex = 0; pkIdentIndex < pkIdentArray.length; ++pkIdentIndex) {
                pkIdentArrayMatch[pkIdentIndex] = false;
            }
            int selectItemSize = selectItemList.size();
            for (int selectItemIndex = 0; selectItemIndex < selectItemSize; ++selectItemIndex) {
                SelectItemInfo selectItem = (SelectItemInfo)selectItemList.get(selectItemIndex);
                String itemIdent = selectItem.getIdent();
                for (int i = 0; i < pkIdentArray.length; ++i) {
                    if (!pkIdentArray[i].equalsIgnoreCase(itemIdent)) continue;
                    pkIdentArrayMatch[i] = true;
                }
            }
            for (int i = 0; i < pkIdentArray.length; ++i) {
                if (pkIdentArrayMatch[i]) continue;
                String pkIdent = pkIdentArray[i];
                ExprParser parser2 = new ExprParser(pkIdent);
                ExprNode pkExpr = parser2.expr();
                objQueryCtx.getFieldList().add(pkIdent);
                objQueryCtx.getPropList().add(logicalKey.getKeyPropertys().get(i));
                objQueryCtx.getPropEntityList().add(entity);
                SelectItemInfo[] selectItemArray = QueryUtil.buildSqlExpr(pkExpr, objQueryCtx, true);
                for (int j = 0; j < selectItemArray.length; ++j) {
                    String alias = "F" + columnIndex++;
                    SqlExpr sqlExpr = selectItemArray[j].getSqlExpr();
                    SqlSelectItem sqlSelectItem = new SqlSelectItem(sqlExpr, alias);
                    select.selectList.add(sqlSelectItem);
                    objQueryCtx.getColumnMap().put(QueryUtil.sqlExprToString(sqlExpr), alias);
                    step.getSelectItemList().add(selectItemArray[j]);
                }
            }
        }
    }

    public static SqlExpr buildCondition(ExprNode expr, ObjectQueryContext objQueryCtx) throws BOSException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr instanceof IdentifierExpr) {
            return QueryUtil.buildConditionInternal_Ident((IdentifierExpr)expr, objQueryCtx);
        }
        if (expr instanceof PropertyExpr) {
            return QueryUtil.buildConditionInternal_Prop((PropertyExpr)expr, objQueryCtx);
        }
        if (expr instanceof InListExpr) {
            return QueryUtil.buildConditionInternal_InList((InListExpr)expr, objQueryCtx);
        }
        if (expr instanceof BinaryOpExpr) {
            return QueryUtil.buildConditionInternal_Binary((BinaryOpExpr)expr, objQueryCtx);
        }
        if (expr instanceof LiteralExpr) {
            return QueryUtil.buildLiteralExpr((LiteralExpr)expr);
        }
        if (expr instanceof VarRefExpr) {
            VarRefExpr varRefExpr = (VarRefExpr)expr;
            SqlVarRefExpr sqlRefExpr = new SqlVarRefExpr(varRefExpr.text);
            return sqlRefExpr;
        }
        throw new BOSException("TODO, " + expr.getClass().getName());
    }

    public static SqlExpr buildConditionInternal_Prop(PropertyExpr expr, ObjectQueryContext objQueryCtx) throws BOSException {
        SqlBinaryOpExpr sqlExpr;
        String tabAlias;
        String ident = expr.toString();
        int lastIndex = ident.lastIndexOf(46);
        String propEntityIdent = lastIndex == -1 ? "" : ident.substring(0, lastIndex);
        String langId = objQueryCtx.getLangId();
        List fieldList = objQueryCtx.getFieldList();
        List propList = objQueryCtx.getPropList();
        List propEntityList = objQueryCtx.getPropEntityList();
        int index = fieldList.indexOf(ident);
        if (index == -1) {
            return null;
        }
        OwnPropertyInfo propInfo = (OwnPropertyInfo)propList.get(index);
        EntityObjectInfo entity = (EntityObjectInfo)propEntityList.get(index);
        String tabName = QueryUtil.getTable(entity, propInfo.getName()).getName();
        String tabAliasKey = propEntityIdent.length() == 0 ? tabName : propEntityIdent + '.' + tabName;
        if (objQueryCtx.getTableAliasMap().containsKey(tabAliasKey)) {
            tabAlias = (String)objQueryCtx.getTableAliasMap().get(tabAliasKey);
        } else {
            tabAlias = "T" + objQueryCtx.getTableAliasMap().size();
            objQueryCtx.getTableAliasMap().put(tabAliasKey, tabAlias);
        }
        ColumnInfo column = propInfo.getMappingField();
        ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, entity, (PropertyInfo)propInfo);
        if (propInfo.isMultilingual()) {
            sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName() + "_" + langId));
            return sqlExpr;
        }
        sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName()));
        return sqlExpr;
    }

    public static SqlExpr buildConditionInternal_InList(InListExpr expr, ObjectQueryContext objQueryCtx) throws BOSException {
        SqlInListExpr inListExpr = new SqlInListExpr();
        inListExpr.expr = QueryUtil.buildCondition(expr.expr, objQueryCtx);
        if (inListExpr.expr == null) {
            return null;
        }
        for (int i = 0; i < expr.targetList.size(); ++i) {
            SqlExpr targetExpr = QueryUtil.buildCondition((ExprNode)expr.targetList.get(i), objQueryCtx);
            inListExpr.targetList.add(targetExpr);
        }
        return inListExpr;
    }

    public static SqlExpr buildConditionInternal_Ident(IdentifierExpr expr, ObjectQueryContext objQueryCtx) throws BOSException {
        SqlBinaryOpExpr sqlExpr;
        String langId = objQueryCtx.getLangId();
        List fieldList = objQueryCtx.getFieldList();
        List propList = objQueryCtx.getPropList();
        List propEntityList = objQueryCtx.getPropEntityList();
        String ident = expr.value;
        int lastIndex = ident.lastIndexOf(46);
        String propEntityIdent = lastIndex == -1 ? "" : ident.substring(0, lastIndex);
        int index = fieldList.indexOf(ident);
        if (index == -1) {
            return null;
        }
        OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propList.get(index);
        EntityObjectInfo entity = (EntityObjectInfo)propEntityList.get(index);
        String tabName = QueryUtil.getTable(entity, ownPropInfo.getName()).getName();
        String tabAliasKey = propEntityIdent.length() == 0 ? tabName : propEntityIdent + '.' + tabName;
        String tabAlias = (String)objQueryCtx.getTableAliasMap().get(tabAliasKey);
        ColumnInfo column = ownPropInfo.getMappingField();
        ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, entity, (PropertyInfo)ownPropInfo);
        if (ownPropInfo.isMultilingual()) {
            sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName() + "_" + langId));
            return sqlExpr;
        }
        sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName()));
        return sqlExpr;
    }

    public static SqlExpr buildLiteralExpr(LiteralExpr expr) {
        if (expr instanceof CharExpr) {
            CharExpr charExpr = (CharExpr)expr;
            String text = charExpr.text.replaceAll("'", "''");
            return new SqlCharExpr(text);
        }
        if (expr instanceof DateTimeExpr) {
            DateTimeExpr dateExpr = (DateTimeExpr)expr;
            return new SqlDateTimeExpr(dateExpr.getYear(), dateExpr.getMonth(), dateExpr.getDate(), dateExpr.getHour(), dateExpr.getMinute(), dateExpr.getSecond());
        }
        if (expr instanceof IntExpr) {
            IntExpr literalExpr = (IntExpr)expr;
            String text = Integer.toString(literalExpr.value);
            return new SqlIntExpr(text);
        }
        throw new TODOException();
    }

    public static SqlExpr buildConditionInternal_Binary(BinaryOpExpr expr, ObjectQueryContext objQueryCtx) throws BOSException {
        int op;
        HashSet identSet = new HashSet();
        QueryUtil.computeIdent(expr, identSet);
        if (expr.operator == 7 || expr.operator == 8) {
            SqlExpr left = QueryUtil.buildCondition(expr.left, objQueryCtx);
            SqlExpr right = QueryUtil.buildCondition(expr.right, objQueryCtx);
            if (left != null) {
                if (right != null) {
                    int op2 = expr.operator == 7 ? 7 : 8;
                    return new SqlBinaryOpExpr(left, op2, right);
                }
                return right;
            }
            return null;
        }
        switch (expr.operator) {
            case 0: {
                op = 0;
                break;
            }
            case 26: {
                op = 26;
                break;
            }
            case 22: {
                op = 22;
                break;
            }
            case 9: {
                op = 9;
                break;
            }
            case 11: {
                op = 11;
                break;
            }
            case 12: {
                op = 12;
                break;
            }
            case 14: {
                op = 14;
                break;
            }
            case 15: {
                op = 15;
                break;
            }
            case 16: {
                op = 16;
                break;
            }
            case 10: {
                op = 10;
                break;
            }
            case 23: {
                op = 23;
                break;
            }
            case 18: {
                op = 18;
                break;
            }
            case 40: {
                op = 40;
                break;
            }
            default: {
                throw new TODOException();
            }
        }
        SqlExpr left = QueryUtil.buildCondition(expr.left, objQueryCtx);
        SqlExpr right = QueryUtil.buildCondition(expr.right, objQueryCtx);
        if (left == null || right == null) {
            return null;
        }
        return new SqlBinaryOpExpr(left, op, right);
    }

    private static SelectItemInfo[] buildSqlExpr(ExprNode oqlExpr, ObjectQueryContext objQueryCtx, boolean fetchMultilingualProperty) throws BOSException {
        if (oqlExpr instanceof IdentifierExpr) {
            return QueryUtil.buildSqlExpr_Ident((IdentifierExpr)oqlExpr, objQueryCtx, fetchMultilingualProperty);
        }
        if (oqlExpr instanceof PropertyExpr) {
            return QueryUtil.buildSqlExpr_Prop((PropertyExpr)oqlExpr, objQueryCtx, fetchMultilingualProperty);
        }
        throw new TODOException();
    }

    private static SelectItemInfo[] buildSqlExpr_Ident(IdentifierExpr oqlExpr, ObjectQueryContext objQueryCtx, boolean fetchMultilingualProperty) throws BOSException {
        String tabAlias;
        String ident = oqlExpr.value;
        int index = objQueryCtx.getFieldList().indexOf(ident);
        if (index == -1) {
            throw new TODOException();
        }
        OwnPropertyInfo propInfo = (OwnPropertyInfo)objQueryCtx.getPropList().get(index);
        EntityObjectInfo entity = (EntityObjectInfo)objQueryCtx.getPropEntityList().get(index);
        String entityPrefix = objQueryCtx.getCurrentEntityPrefix();
        String tabName = QueryUtil.getTable(entity, propInfo.getName()).getName();
        int lastIndex = ident.lastIndexOf(46);
        String tabAliasKey = lastIndex == -1 ? (entityPrefix != null && entityPrefix.length() != 0 ? entityPrefix + tabName : tabName) : ident.substring(0, lastIndex) + "." + tabName;
        Map aliasMap = objQueryCtx.getTableAliasMap();
        if (aliasMap.containsKey(tabAliasKey)) {
            tabAlias = (String)aliasMap.get(tabAliasKey);
        } else {
            tabAlias = "T" + aliasMap.size();
            aliasMap.put(tabAliasKey, tabAlias);
        }
        ColumnInfo column = propInfo.getMappingField();
        ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, entity, (PropertyInfo)propInfo);
        if (propInfo.isMultilingual()) {
            LanguageCollection languageCol = objQueryCtx.getSolution().getLanguages();
            SqlExpr[] exprArray = new SqlExpr[languageCol.size()];
            SelectItemInfo[] selectItemArray = new SelectItemInfo[languageCol.size()];
            for (int i = 0; i < languageCol.size(); ++i) {
                LanguageInfo lang = languageCol.get(i);
                String langPostfix = lang.getPostfix();
                exprArray[i] = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName() + "_" + langPostfix));
                SelectItemInfo selectIem = new SelectItemInfo();
                selectIem.setEntity(entity);
                selectIem.setColumnInfo(column);
                selectIem.setIdent(ident);
                selectIem.setSqlExpr(exprArray[i]);
                selectIem.setPropInfo((PropertyInfo)propInfo);
                selectIem.setLangId(langPostfix);
                selectItemArray[i] = selectIem;
            }
            return selectItemArray;
        }
        SqlBinaryOpExpr sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName()));
        SelectItemInfo selectIem = new SelectItemInfo();
        selectIem.setEntity(entity);
        selectIem.setColumnInfo(column);
        selectIem.setIdent(ident);
        selectIem.setSqlExpr((SqlExpr)sqlExpr);
        selectIem.setPropInfo((PropertyInfo)propInfo);
        return new SelectItemInfo[]{selectIem};
    }

    private static DataTableInfo getTable(EntityObjectInfo entity, String propName) {
        PropertyInfo propItemInfo;
        int i;
        EntityObjectInfo curEntity = entity;
        EntityObjectInfo baseEntity = entity.getBaseEntity();
        if (baseEntity == null || baseEntity.isAbstract()) {
            if (curEntity.getPropertyByNameRuntime(propName) != null) {
                return curEntity.getTable();
            }
            return null;
        }
        PropertyCollection properties = entity.getProperties();
        for (i = 0; i < properties.size(); ++i) {
            propItemInfo = properties.get(i);
            if (!propItemInfo.getName().equals(propName)) continue;
            return entity.getTable();
        }
        block1: while (true) {
            if ((baseEntity = (curEntity = baseEntity).getBaseEntity()) == null || baseEntity.isAbstract()) {
                if (curEntity.getPropertyByNameRuntime(propName) != null) {
                    return curEntity.getTable();
                }
                return null;
            }
            properties = curEntity.getProperties();
            i = 0;
            while (true) {
                if (i >= properties.size()) continue block1;
                propItemInfo = properties.get(i);
                if (propItemInfo.getName().equals(propName)) {
                    return curEntity.getTable();
                }
                ++i;
            }
            break;
        }
    }

    private static ColumnInfo getColumn(EntityObjectInfo entity, String propName) {
        PropertyInfo propItemInfo;
        int i;
        EntityObjectInfo curEntity = entity;
        EntityObjectInfo baseEntity = entity.getBaseEntity();
        if (baseEntity == null || baseEntity.isAbstract()) {
            PropertyInfo propInfo = curEntity.getPropertyByNameRuntime(propName);
            if (propInfo != null) {
                return propInfo.getMappingField();
            }
            return null;
        }
        PropertyCollection properties = entity.getProperties();
        for (i = 0; i < properties.size(); ++i) {
            propItemInfo = properties.get(i);
            if (!propItemInfo.getName().equals(propName)) continue;
            return propItemInfo.getMappingField();
        }
        block1: while (true) {
            if ((baseEntity = (curEntity = baseEntity).getBaseEntity()) == null || baseEntity.isAbstract()) {
                PropertyInfo propInfo = curEntity.getPropertyByNameRuntime(propName);
                if (propInfo != null) {
                    return propInfo.getMappingField();
                }
                return null;
            }
            properties = curEntity.getProperties();
            i = 0;
            while (true) {
                if (i >= properties.size()) continue block1;
                propItemInfo = properties.get(i);
                if (propItemInfo.getName().equals(propName)) {
                    return propItemInfo.getMappingField();
                }
                ++i;
            }
            break;
        }
    }

    private static SelectItemInfo[] buildSqlExpr_Prop(PropertyExpr oqlExpr, ObjectQueryContext objQueryCtx, boolean fetchMultilingualProperty) throws BOSException {
        SelectItemInfo selectIem;
        SqlBinaryOpExpr sqlExpr;
        ColumnInfo column;
        String parentLinkPropName;
        String parentEntityPrefix;
        String tabAlias;
        String ident = oqlExpr.toString();
        int index = objQueryCtx.getFieldList().indexOf(ident);
        if (index == -1) {
            throw new TODOException();
        }
        OwnPropertyInfo propInfo = (OwnPropertyInfo)objQueryCtx.getPropList().get(index);
        EntityObjectInfo entity = (EntityObjectInfo)objQueryCtx.getPropEntityList().get(index);
        String stepEntityPrefix = objQueryCtx.getCurrentEntityPrefix();
        DataTableInfo dataTable = QueryUtil.getTable(entity, propInfo.getName());
        if (dataTable == null) {
            throw new TODOException();
        }
        String tabName = dataTable.getName();
        int lastIndex = ident.lastIndexOf(46);
        String tabAliasKey = lastIndex == -1 ? (stepEntityPrefix != null && stepEntityPrefix.length() != 0 ? stepEntityPrefix + tabName : tabName) : ident.substring(0, lastIndex) + "." + tabName;
        Map aliasMap = objQueryCtx.getTableAliasMap();
        if (aliasMap.containsKey(tabAliasKey)) {
            tabAlias = (String)aliasMap.get(tabAliasKey);
        } else {
            tabAlias = "T" + aliasMap.size();
            aliasMap.put(tabAliasKey, tabAlias);
        }
        String[] propNameArray = ident.split("\\.");
        if (propNameArray.length == 1) {
            parentEntityPrefix = null;
            parentLinkPropName = null;
        } else if (propNameArray.length == 2) {
            parentEntityPrefix = null;
            parentLinkPropName = propNameArray[0];
        } else if (propNameArray.length >= 2) {
            parentEntityPrefix = ORMUtils.concat(propNameArray, 0, propNameArray.length - 2, '.');
            parentLinkPropName = propNameArray[propNameArray.length - 2];
        } else {
            throw new BOSException("Fatal Error.");
        }
        EntityObjectInfo parentEntity = parentEntityPrefix == null ? objQueryCtx.getRootEntity() : ORMUtils.getEntity(objQueryCtx.getRootEntity(), parentEntityPrefix.split("\\."));
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
        if (parentEntity != null && keyPropCol.size() == 1) {
            LinkPropertyInfo parentLinkProp = (LinkPropertyInfo)parentEntity.getPropertyByNameRuntime(parentLinkPropName);
            RelationshipInfo parentLinkRelationship = parentLinkProp.getRelationship();
            CardinalityType cardinality = parentLinkRelationship.getChildCardinality(parentEntity);
            boolean isMany = cardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || cardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED);
            OwnPropertyInfo keyProp = (OwnPropertyInfo)keyPropCol.get(0);
            if (!isMany && keyProp.getName().equals(propInfo.getName())) {
                DataTableInfo parentTable = QueryUtil.getTable(parentEntity, parentLinkPropName);
                String parentTableName = parentTable.getName();
                String parentTableAlias = QueryUtil.getTabAliasKey(objQueryCtx.getTableAliasMap(), parentEntityPrefix, parentTableName);
                ColumnInfo parentLinkMappingField = QueryUtil.getColumn(parentEntity, parentLinkPropName);
                String parentLinkMappingFieldName = parentLinkMappingField.getName();
                SqlBinaryOpExpr sqlExpr2 = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(parentTableAlias), 20, (SqlExpr)new SqlIdentifierExpr(parentLinkMappingFieldName));
                SelectItemInfo selectIem2 = new SelectItemInfo();
                selectIem2.setEntity(entity);
                selectIem2.setColumnInfo(parentLinkMappingField);
                selectIem2.setIdent(ident);
                selectIem2.setSqlExpr((SqlExpr)sqlExpr2);
                selectIem2.setPropInfo((PropertyInfo)propInfo);
                return new SelectItemInfo[]{selectIem2};
            }
        }
        if ((column = propInfo.getMappingField()) != null) {
            column = ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, entity, (PropertyInfo)propInfo);
        }
        if (column == null) {
            PropertyInfo tempPropInfo;
            column = QueryUtil.getColumn(entity, propInfo.getName());
            if (column == null && (tempPropInfo = entity.getPropertyByNameRuntime(propInfo.getName())) != null) {
                column = tempPropInfo.getMappingField();
            }
            if (column != null) {
                column = ORMUtils.ensureColumnLoaded(objQueryCtx.getBosCtx(), column, entity, (PropertyInfo)propInfo);
            }
        }
        if (column == null) {
            throw new TODOException();
        }
        if (propInfo.isMultilingual()) {
            if (fetchMultilingualProperty) {
                LanguageCollection languageCol = objQueryCtx.getSolution().getLanguages();
                SqlExpr[] exprArray = new SqlExpr[languageCol.size()];
                SelectItemInfo[] selectItemArray = new SelectItemInfo[languageCol.size()];
                for (int i = 0; i < languageCol.size(); ++i) {
                    LanguageInfo lang = languageCol.get(i);
                    String langPostfix = lang.getPostfix();
                    exprArray[i] = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName() + "_" + langPostfix));
                    SelectItemInfo selectIem3 = new SelectItemInfo();
                    selectIem3.setEntity(entity);
                    selectIem3.setColumnInfo(column);
                    selectIem3.setIdent(ident);
                    selectIem3.setSqlExpr(exprArray[i]);
                    selectIem3.setPropInfo((PropertyInfo)propInfo);
                    selectItemArray[i] = selectIem3;
                    selectIem3.setLangId(langPostfix);
                }
                return selectItemArray;
            }
            sqlExpr = new SqlIdentifierExpr(column.getName() + "_" + objQueryCtx.getLangId());
            selectIem = new SelectItemInfo();
            selectIem.setEntity(entity);
            selectIem.setColumnInfo(column);
            selectIem.setIdent(ident);
            selectIem.setSqlExpr((SqlExpr)sqlExpr);
            selectIem.setPropInfo((PropertyInfo)propInfo);
            return new SelectItemInfo[]{selectIem};
        }
        sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(column.getName()));
        selectIem = new SelectItemInfo();
        selectIem.setEntity(entity);
        selectIem.setColumnInfo(column);
        selectIem.setIdent(ident);
        selectIem.setSqlExpr((SqlExpr)sqlExpr);
        selectIem.setPropInfo((PropertyInfo)propInfo);
        return new SelectItemInfo[]{selectIem};
    }

    public static void fetchDataAndFillObjectCollection(String sql, IObjectCollection objCol) throws BOSException {
    }

    public static void computeIdent(ExprNode expr, Collection identCollection) {
        if (expr == null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof PropertyExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof AllColumnExpr) {
            identCollection.add("*");
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            QueryUtil.computeIdent(binaryOpExpr.left, identCollection);
            QueryUtil.computeIdent(binaryOpExpr.right, identCollection);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (ExprNode pramExpr : methodInvokeExpr.parameters) {
                QueryUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (ExprNode pramExpr : aggregateExpr.paramList) {
                QueryUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (ExprNode pramExpr : objCreateExpr.paramList) {
                QueryUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            QueryUtil.computeIdent(caseExpr.valueExpr, identCollection);
            for (CaseItem caseItem : caseExpr.itemList) {
                QueryUtil.computeIdent(caseItem.conditionExpr, identCollection);
                QueryUtil.computeIdent(caseItem.valueExpr, identCollection);
            }
            QueryUtil.computeIdent(caseExpr.elseExpr, identCollection);
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            QueryUtil.computeIdent(betweenExpr.testExpr, identCollection);
            QueryUtil.computeIdent(betweenExpr.beginExpr, identCollection);
            QueryUtil.computeIdent(betweenExpr.endExpr, identCollection);
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            QueryUtil.computeIdent(inListExpr.expr, identCollection);
            for (ExprNode targetExpr : inListExpr.targetList) {
                QueryUtil.computeIdent(targetExpr, identCollection);
            }
        } else if (expr instanceof NotExpr) {
            NotExpr notExpr = (NotExpr)expr;
            QueryUtil.computeIdent(notExpr.expr, identCollection);
        }
    }

    public static SqlExpr buildEntryFilterSqlExpr(ObjectQueryContext queryCtx, ExprNode filterExpr, String entryName) throws BOSException {
        SqlExpr tempExpr = QueryUtil.buildCondition(filterExpr, queryCtx);
        SqlExpr rtnVal = QueryUtil.replaceExpr(tempExpr, queryCtx.getColumnMap());
        return rtnVal;
    }

    public static SqlExpr replaceExpr(SqlExpr expr, Map columnMap) throws BOSException {
        if (expr instanceof SqlIdentifierExpr) {
            String itemStr = QueryUtil.sqlExprToString(expr);
            String replaceToStr = (String)columnMap.get(itemStr);
            if (replaceToStr != null) {
                try {
                    return new SqlExprParser(replaceToStr).expr();
                }
                catch (ParserException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            return expr;
        }
        if (expr instanceof SqlBinaryOpExpr) {
            String itemStr;
            String replaceToStr;
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if (binaryOpExpr.operator == 20 && (replaceToStr = (String)columnMap.get(itemStr = QueryUtil.sqlExprToString(expr))) != null) {
                try {
                    return new SqlExprParser(replaceToStr).expr();
                }
                catch (ParserException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            binaryOpExpr.left = QueryUtil.replaceExpr(binaryOpExpr.left, columnMap);
            binaryOpExpr.right = QueryUtil.replaceExpr(binaryOpExpr.right, columnMap);
            return expr;
        }
        if (expr instanceof SqlIntExpr || expr instanceof SqlCharExpr || expr instanceof SqlNCharExpr || expr instanceof SqlDoubleExpr) {
            return expr;
        }
        throw new TODOException();
    }

    public static String sqlExprToString(SqlExpr expr) throws BOSException {
        StringBuffer buff = new StringBuffer();
        try {
            new DrSQLFormater(buff).formatExpr(expr);
        }
        catch (FormaterException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return buff.toString();
    }
}

