/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.dataquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping_ex.ast.AbstractDataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.AbstractTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.DataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.SelectItem;
import com.kingdee.bos.dao.ormapping_ex.ast.SimpleTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.SubqueryTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.parser.DataQueryParser;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryContext;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalDataQueryResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalSqlExprBuildResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.TypeInfo;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.util.TODOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataQueryEngine {
    private final Context ctx;
    private IMetaDataLoader loader;

    public DataQueryEngine(Context ctx) {
        this.ctx = ctx;
        this.loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }

    public InternalDataQueryResult buildInternalResult(String oql) throws BOSException {
        DataQueryParser parser2 = new DataQueryParser(oql);
        AbstractDataQuery query = parser2.select();
        DataQueryContext queryCtx = new DataQueryContext(query, this.ctx);
        return this.buildInternalResult(query, queryCtx);
    }

    public InternalDataQueryResult buildInternalResult(AbstractDataQuery query, DataQueryContext queryCtx) throws BOSException {
        if (query instanceof DataQuery) {
            return this.buildInternalResult((DataQuery)query, queryCtx);
        }
        throw new TODOException();
    }

    InternalDataQueryResult buildInternalResult(DataQuery query, DataQueryContext queryCtx) throws BOSException {
        int i;
        SqlSelect select = new SqlSelect();
        this.computeTabSrcEntity(query.getTableSource(), queryCtx);
        List selectList = query.getSelectList();
        ArrayList<InternalSqlExprBuildResult> internalSqlExprBuildResultList = new ArrayList<InternalSqlExprBuildResult>();
        queryCtx.state = 0;
        int sqlSelectItemIndex = 0;
        int size = selectList.size();
        for (i = 0; i < size; ++i) {
            SelectItem selectItem = (SelectItem)selectList.get(i);
            ExprNode expr = selectItem.expr;
            InternalSqlExprBuildResult[] resultArray = DataQueryUtil.buildSqlExpr(queryCtx, expr);
            for (int j = 0; j < resultArray.length; ++j) {
                if (selectItem.alias != null) {
                    String alias = selectItem.alias;
                    resultArray[j].typeInfo.setName(alias);
                    resultArray[j].typeInfo.setAlias(alias);
                }
                internalSqlExprBuildResultList.add(resultArray[j]);
                SqlExpr sqlExpr = resultArray[j].sqlExpr;
                String alias = "F" + sqlSelectItemIndex++;
                resultArray[j].typeInfo.setSqlAlias(alias);
                SqlSelectItem sqlSelectItem = new SqlSelectItem(sqlExpr, alias);
                select.selectList.add(sqlSelectItem);
            }
        }
        queryCtx.state = 2;
        size = query.getGroupByItemList().size();
        for (i = 0; i < size; ++i) {
            ExprNode groupByItem = (ExprNode)query.getGroupByItemList().get(i);
            InternalSqlExprBuildResult[] resultArray = DataQueryUtil.buildSqlExpr(queryCtx, groupByItem);
            for (int j = 0; j < resultArray.length; ++j) {
                internalSqlExprBuildResultList.add(resultArray[j]);
                SqlExpr sqlExpr = resultArray[j].sqlExpr;
                if (select.groupBy == null) {
                    select.groupBy = new ArrayList();
                }
                select.groupBy.add(sqlExpr);
            }
        }
        queryCtx.state = 3;
        ExprNode having = query.getHaving();
        if (having != null) {
            InternalSqlExprBuildResult[] resultArray = DataQueryUtil.buildSqlExpr(queryCtx, having);
            if (resultArray.length != 1) {
                throw new BOSException("Fatal Error.");
            }
            select.having = resultArray[0].sqlExpr;
        }
        queryCtx.state = 1;
        ExprNode where = query.getFilterCondition();
        if (where != null) {
            InternalSqlExprBuildResult[] resultArray = DataQueryUtil.buildSqlExpr(queryCtx, where);
            if (resultArray.length != 1) {
                throw new BOSException("Fatal Error.");
            }
            select.condition = resultArray[0].sqlExpr;
        }
        queryCtx.state = 5;
        this.computeTableSource(select, query, queryCtx);
        TypeInfo[] typeInfoArray = new TypeInfo[internalSqlExprBuildResultList.size()];
        int size2 = internalSqlExprBuildResultList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            InternalSqlExprBuildResult buildResultItem = (InternalSqlExprBuildResult)internalSqlExprBuildResultList.get(i2);
            if (buildResultItem.typeInfo == null) {
                throw new TODOException();
            }
            typeInfoArray[i2] = buildResultItem.typeInfo;
        }
        InternalDataQueryResult rtnVal = new InternalDataQueryResult((SqlSelectBase)select, typeInfoArray);
        return rtnVal;
    }

    private void computeTableSource(SqlSelect select, DataQuery query, DataQueryContext queryCtx) throws BOSException {
        select.tableSource = this.getTableSource(query.getTableSource(), queryCtx);
    }

    private SqlTableSourceBase getTableSource(AbstractTableSource oqlTabSrc, DataQueryContext queryCtx) throws BOSException {
        if (oqlTabSrc instanceof SimpleTableSource) {
            return this.getSimpleTableSource((SimpleTableSource)oqlTabSrc, queryCtx);
        }
        if (oqlTabSrc instanceof SubqueryTableSource) {
            SubqueryTableSource subQueryTabSrc = (SubqueryTableSource)oqlTabSrc;
            String alias = subQueryTabSrc.alias;
            InternalDataQueryResult subResult = (InternalDataQueryResult)queryCtx.getIdentEntityMap().get(alias);
            String tabAlias = (String)queryCtx.getTabAliasMap().get(alias);
            SqlSubQueryTableSource sqlSubQueryTabSrc = new SqlSubQueryTableSource();
            sqlSubQueryTabSrc.subQuery = subResult.getSqlSelect();
            sqlSubQueryTabSrc.alias = tabAlias;
            return sqlSubQueryTabSrc;
        }
        throw new TODOException(oqlTabSrc.getClass().toString());
    }

    private SqlTableSourceBase getSimpleTableSource(SimpleTableSource oqlTabSrc, DataQueryContext queryCtx) throws BOSException {
        SqlTableSourceBase rtnVal = null;
        String alias = oqlTabSrc.alias;
        if (alias == null) {
            alias = oqlTabSrc.entityName;
        }
        HashMap<String, SqlTableSource> tabSrcMap = new HashMap<String, SqlTableSource>();
        for (Map.Entry entry : queryCtx.getIdentEntityMap().entrySet()) {
            String entityIdent = (String)entry.getKey();
            SqlTableSource entityTabSrc = null;
            if (entityIdent.startsWith(alias)) {
                for (Map.Entry tabEntry : queryCtx.getTabAliasMap().entrySet()) {
                    String tabAliasKey = (String)tabEntry.getKey();
                    String tabAlias = (String)tabEntry.getValue();
                    if (!tabAliasKey.startsWith(entityIdent) || tabAliasKey.indexOf(46, entityIdent.length() + 1) != -1) continue;
                    String tabName = tabAliasKey.substring(entityIdent.length() + 1);
                    assert (tabName != null && tabName.length() != 0);
                    if (entityTabSrc == null) {
                        entityTabSrc = new SqlTableSource(tabName);
                        entityTabSrc.alias = tabAlias;
                        continue;
                    }
                    throw new TODOException();
                }
            }
            assert (entityTabSrc != null);
            tabSrcMap.put(entityIdent, entityTabSrc);
        }
        ArrayList keyList = new ArrayList(tabSrcMap.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            int joinType;
            SqlBinaryOpExpr rightExpr;
            SqlBinaryOpExpr leftExpr;
            String key = (String)keyList.get(i);
            SqlTableSourceBase tabSrc = (SqlTableSourceBase)tabSrcMap.get(key);
            if (i == 0) {
                rtnVal = tabSrc;
                continue;
            }
            int lastIndex = key.lastIndexOf(46);
            String preEntityIdent = key.substring(0, lastIndex);
            String propName = key.substring(lastIndex + 1);
            EntityObjectInfo preEntity = (EntityObjectInfo)queryCtx.getIdentEntityMap().get(preEntityIdent);
            EntityObjectInfo entity = (EntityObjectInfo)queryCtx.getIdentEntityMap().get(key);
            if (preEntity == null) {
                throw new TODOException();
            }
            LinkPropertyInfo linkProp = (LinkPropertyInfo)preEntity.getPropertyByNameRuntime(propName);
            RelationshipInfo relationshp = linkProp.getRelationship();
            CardinalityType cardinality = relationshp.getChildCardinality(preEntity);
            boolean manyLink = false;
            if (cardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || cardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                manyLink = true;
            }
            EntityObjectInfo prePropEntity = ORMUtils.getEntity(preEntity, linkProp.getName());
            String preTabName = prePropEntity.getTable().getName();
            String preTabAliasKey = preEntityIdent + "." + preTabName;
            String preTabAlias = (String)queryCtx.getTabAliasMap().get(preTabAliasKey);
            if (manyLink) {
                LogicalKeyInfo preEntityLogicalKey = prePropEntity.getLogicalKey();
                assert (preEntityLogicalKey != null);
                PropertyCollection prefKeyProperties = preEntityLogicalKey.getKeyPropertys();
                if (prefKeyProperties.size() != 1) {
                    throw new TODOException();
                }
                OwnPropertyInfo keyProp = (OwnPropertyInfo)prefKeyProperties.get(0);
                ColumnInfo preColumnInfo = keyProp.getMappingField();
                String preColumnName = preColumnInfo.getName();
                leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(preColumnName));
                LinkPropertyInfo linkChildProp = (LinkPropertyInfo)relationshp.getChildProperty(preEntity);
                ColumnInfo columnInfo = linkChildProp.getMappingField();
                String columnName = columnInfo.getName();
                EntityObjectInfo propEntity = ORMUtils.getEntity(entity, linkChildProp.getName());
                String tabName = propEntity.getTable().getName();
                String tabAliasKey = key + "." + tabName;
                String tabAlias = (String)queryCtx.getTabAliasMap().get(tabAliasKey);
                assert (tabAlias != null);
                rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                joinType = 0;
            } else {
                ColumnInfo preColumnInfo = linkProp.getMappingField();
                if (preColumnInfo != null) {
                    String preColumnName = preColumnInfo.getName();
                    leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(preColumnName));
                    LogicalKeyInfo logicalKey = entity.getLogicalKey();
                    assert (logicalKey != null);
                    PropertyInfo childProp = relationshp.getChildProperty(preEntity);
                    EntityObjectInfo propEntity = ORMUtils.getEntity(entity, childProp.getName());
                    String tabName = propEntity.getTable().getName();
                    String tabAliasKey = key + "." + tabName;
                    String tabAlias = (String)queryCtx.getTabAliasMap().get(tabAliasKey);
                    PropertyCollection keyProperties = logicalKey.getKeyPropertys();
                    if (keyProperties.size() != 1) {
                        throw new TODOException();
                    }
                    OwnPropertyInfo keyProp = (OwnPropertyInfo)keyProperties.get(0);
                    ColumnInfo columnInfo = keyProp.getMappingField();
                    String columnName = columnInfo.getName();
                    rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                    joinType = 1;
                } else {
                    throw new TODOException();
                }
            }
            SqlBinaryOpExpr joinCondition = new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr);
            rtnVal = new SqlJoinedTableSource(rtnVal, tabSrc, joinType, (SqlExpr)joinCondition);
        }
        return rtnVal;
    }

    public void computeTabSrcEntity(AbstractTableSource tabSrc, DataQueryContext queryCtx) throws BOSException {
        if (tabSrc == null) {
            throw new IllegalArgumentException("tabSrc is null");
        }
        if (tabSrc instanceof SimpleTableSource) {
            this.computeSimpleTabSrcEntity((SimpleTableSource)tabSrc, queryCtx);
        } else if (tabSrc instanceof SubqueryTableSource) {
            SubqueryTableSource subQueryTabSrc = (SubqueryTableSource)tabSrc;
            AbstractDataQuery subQuery = subQueryTabSrc.subQuery;
            DataQueryContext subCtx = new DataQueryContext(queryCtx);
            InternalDataQueryResult subResult = this.buildInternalResult(subQuery, subCtx);
            String alias = subQueryTabSrc.alias;
            if (alias == null || alias.length() == 0) {
                throw new BOSException("invalid tabSrc");
            }
            queryCtx.getEntityMap().put(alias, subResult);
            queryCtx.getIdentEntityMap().put(alias, subResult);
        } else {
            throw new TODOException();
        }
    }

    public void computeSimpleTabSrcEntity(SimpleTableSource tabSrc, DataQueryContext queryCtx) throws BOSException {
        EntityObjectInfo parentDefaultEntitry;
        PropertyInfo parentPropInfo;
        Map.Entry parentMapEntry;
        Object parentVal;
        String tabName = tabSrc.entityName;
        String alias = tabSrc.alias;
        if (alias == null) {
            alias = tabName;
        }
        EntityObjectInfo entity = null;
        if (queryCtx.getParentContext() != null && queryCtx.getParentContext().getEntityMap().size() != 0 && (parentVal = (parentMapEntry = queryCtx.getParentContext().getEntityMap().entrySet().iterator().next()).getValue()) instanceof EntityObjectInfo && (parentPropInfo = (parentDefaultEntitry = (EntityObjectInfo)parentVal).getPropertyByNameRuntime(tabName)) != null && parentPropInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo parentLinkPropInfo = (LinkPropertyInfo)parentPropInfo;
            RelationshipInfo relationship = parentLinkPropInfo.getRelationship();
            entity = relationship.getChildObject(parentDefaultEntitry);
        }
        if (entity == null) {
            MetaDataPK entityPk = MetaDataPK.create((String)tabName);
            entity = this.loader.getEntity((IMetaDataPK)entityPk);
        }
        if (entity == null) {
            throw new BOSException("can not get entity.");
        }
        if (queryCtx.getEntityMap().containsValue(alias)) {
            throw new BOSException("table source ambiguously.");
        }
        queryCtx.getEntityMap().put(alias, entity);
    }
}

