/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlan;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.session.ApplicationInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheUtil {
    private static final Logger logger = Logger.getLogger(CacheUtil.class);

    public static String buildName(String prefix, String key) throws BOSException {
        String serverKey;
        String rtnVal = null;
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String string = serverKey = address != null ? address.toString() : null;
        if (serverKey != null) {
            rtnVal = prefix + '_' + Integer.toHexString(Math.abs(serverKey.hashCode())) + '_' + key;
        }
        return rtnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registeSpToDb(Context ctx, String key, String spname, String oql, EntityObjectInfo entity) throws BOSException {
        String sql = "INSERT INTO T_ORM_SP (FKey, FSpName, FServerKey, FOQL, FCreatedTime, FBOSType, FEntityName, FPackage) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String serverKey = address != null ? address.toString() : null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, key);
            stmt.setString(2, spname);
            stmt.setString(3, serverKey);
            stmt.setString(4, oql);
            stmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            stmt.setString(6, entity.getType().toString());
            stmt.setString(7, entity.getName());
            stmt.setString(8, entity.getPackage());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static void registePlanToDb(Context ctx, String key, ExecutePlan plan) throws BOSException {
        String sql = "INSERT INTO T_ORM_ExecutePlan (FKey, FPlan, FStepSize, FServerKey, FOQL, FCreatedTime, FBOSType, FEntityName, FPackage) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String serverKey = address != null ? address.toString() : null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, key);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objOut = new ObjectOutputStream(out);
                objOut.writeObject(plan);
                byte[] bytes = out.toByteArray();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                stmt.setBinaryStream(2, (InputStream)in, bytes.length);
            }
            catch (IOException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            stmt.setInt(3, plan.getSteps().size());
            stmt.setString(4, serverKey);
            stmt.setString(5, plan.getOQL());
            stmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            stmt.setString(7, plan.getEntity().getType().toString());
            stmt.setString(8, plan.getEntity().getName());
            stmt.setString(9, plan.getEntity().getPackage());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static synchronized Map getSPMap(Context ctx) throws BOSException {
        HashMap<String, String> rtnVal;
        block9: {
            if (ctx == null) {
                throw new IllegalArgumentException("ctx");
            }
            String ais = ctx.getAIS();
            ApplicationInfo appInfo = SessionManager.getInstance().getApplication(ais);
            if (appInfo == null) {
                throw new BOSException("can not get applicationInfo.");
            }
            rtnVal = (HashMap<String, String>)appInfo.get((Object)"SP_Map_Cache");
            if (rtnVal != null) break block9;
            rtnVal = new HashMap<String, String>();
            InetAddress address = null;
            try {
                address = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            String serverKey = address != null ? address.toString() : null;
            String sql = "SELECT FKey, FSpName FROM T_ORM_SP WHERE FServerKey = ?";
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = EJBFactory.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, serverKey);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1);
                    String spname = rs.getString(2);
                    rtnVal.put(key, spname);
                }
            }
            catch (SQLException e) {
                try {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            appInfo.put((Object)"SP_Map_Cache", rtnVal);
        }
        return rtnVal;
    }

    /*
     * Exception decompiling
     */
    public static synchronized Map getPlanMap(Context ctx) throws BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

