/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.util.TODOException;
import com.kingdee.util.TypeConversionUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ORMUtils {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils");

    public static IObjectCollection fillObjectValue(String langId, ResultSet rs, EntityObjectInfo rootEntity, ArrayList fieldList, Map aliasMap, Context ctx) throws BOSException {
        IObjectCollection objCol;
        try {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] selectItemArray = new String[columnCount];
            int[] dataTypeArray = new int[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String selectItem;
                String columnName = rsMetaData.getColumnName(i + 1);
                selectItemArray[i] = selectItem = (String)aliasMap.get(columnName);
                PropertyInfo propInfo = (PropertyInfo)fieldList.get(i);
                ColumnInfo columnInfo = propInfo.getMappingField();
                if (columnInfo != null) {
                    if (columnInfo.containsKey("_state_")) {
                        throw new BOSException("Fatal Error, column state, columnName : " + columnInfo.getName());
                    }
                    dataTypeArray[i] = columnInfo.getSQLType();
                    continue;
                }
                dataTypeArray[i] = 1;
            }
            ArrayList<Object[]> rowList = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    Object item;
                    int sqlType = dataTypeArray[i];
                    row[i] = item = ORMUtils.readItem(rs, i + 1, sqlType, (PropertyInfo)fieldList.get(i));
                }
                rowList.add(row);
            }
            objCol = ORMUtils.newObjectCollectionInstance(rootEntity, rowList.size());
            for (int i = 0; i < rowList.size(); ++i) {
                Object[] row = (Object[])rowList.get(i);
                IObjectValue objVal = Utils.newObjectValueInstance(rootEntity);
                for (int j = 0; j < row.length; ++j) {
                    Object itemVal = row[j];
                    String selectItem = selectItemArray[j];
                    String[] propNameArray = selectItem.split("\\.");
                    if (propNameArray.length == 1) {
                        objVal.put(selectItem, itemVal);
                        continue;
                    }
                    EntityObjectInfo propEntity = rootEntity;
                    IObjectValue propObj = objVal;
                    for (int k = 0; k < propNameArray.length; ++k) {
                        PropertyInfo propInfo = rootEntity.getPropertyByNameRuntime(propNameArray[k]);
                        Object propVal = propObj.get(propNameArray[k]);
                        if (k < propNameArray.length - 1) {
                            assert (propInfo instanceof LinkPropertyInfo);
                            if (propVal == null) {
                                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                                RelationshipInfo relationship = linkProp.getRelationship();
                                CardinalityType cardinlality = relationship.getChildCardinality(propEntity);
                                assert (cardinlality.equals((Object)CardinalityType.ZERO_TO_ONE) || cardinlality.equals((Object)CardinalityType.ONE));
                                propEntity = relationship.getChildObject(propEntity);
                                propVal = Utils.newObjectValueInstance(propEntity);
                            }
                            propObj.put(propNameArray[k], propVal);
                            propObj = (IObjectValue)propVal;
                            continue;
                        }
                        PropertyInfo columnPropInfo = (PropertyInfo)fieldList.get(j);
                        if (columnPropInfo instanceof OwnPropertyInfo) {
                            String proplangId;
                            OwnPropertyInfo ownColumnPropInfo = (OwnPropertyInfo)columnPropInfo;
                            if (ownColumnPropInfo.isMultilingual() && (proplangId = propNameArray[k].substring(propNameArray[k].lastIndexOf(95) + 1)).equalsIgnoreCase(langId)) {
                                propObj.put(columnPropInfo.getName(), itemVal);
                            }
                            propObj.put(propNameArray[k], itemVal);
                            continue;
                        }
                        throw new TODOException();
                    }
                }
                objCol.addObject(objVal);
            }
        }
        catch (SQLException e) {
            throw new BOSException("fillObject error, " + e.getMessage(), (Throwable)e);
        }
        return objCol;
    }

    private static Object readItem(ResultSet rs, int index, int sqlType, PropertyInfo propInfo) throws SQLException {
        Object item;
        switch (sqlType) {
            case 1: 
            case 12: {
                item = rs.getString(index);
                break;
            }
            case 4: {
                item = rs.getInt(index);
                break;
            }
            case 8: {
                item = new Double(rs.getDouble(index));
                break;
            }
            case 91: {
                item = rs.getDate(index);
                break;
            }
            case 93: {
                item = rs.getTimestamp(index);
                break;
            }
            case 2: {
                item = new Double(rs.getDouble(index));
                break;
            }
            default: {
                throw new TODOException();
            }
        }
        if (propInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
            DataType dataType = ownPropInfo.getDataType();
            if (dataType.equals((Object)DataType.BOOLEAN)) {
                if (!(item instanceof Boolean)) {
                    item = TypeConversionUtils.objToBoolean((Object)item) ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (dataType.equals((Object)DataType.BOSUUID)) {
                item = TypeConversionUtils.objToBOSUuid((Object)item);
            } else if (dataType.equals((Object)DataType.BYTE)) {
                if (!(item instanceof Byte)) {
                    item = TypeConversionUtils.objToByte((Object)item);
                }
            } else if (dataType.equals((Object)DataType.BYTEARRAY)) {
                item = TypeConversionUtils.objToBytes((Object)item);
            } else if (dataType.equals((Object)DataType.CHAR)) {
                item = TypeConversionUtils.objToString((Object)item);
            } else if (dataType.equals((Object)DataType.DATE)) {
                item = TypeConversionUtils.objToDate((Object)item);
            } else if (dataType.equals((Object)DataType.DECIMAL)) {
                item = TypeConversionUtils.objToBigDecimal((Object)item);
            } else if (dataType.equals((Object)DataType.DOUBLE)) {
                if (!(item instanceof Double)) {
                    item = TypeConversionUtils.objToDouble((Object)item);
                }
            } else if (dataType.equals((Object)DataType.FLOAT)) {
                if (!(item instanceof Float)) {
                    item = Float.valueOf(TypeConversionUtils.objToFloat((Object)item));
                }
            } else if (dataType.equals((Object)DataType.INTEGER)) {
                if (!(item instanceof Integer)) {
                    item = TypeConversionUtils.objToInt((Object)item);
                }
            } else if (dataType.equals((Object)DataType.LONG)) {
                if (!(item instanceof Long)) {
                    item = TypeConversionUtils.objToLong((Object)item);
                }
            } else if (dataType.equals((Object)DataType.SHORT)) {
                if (!(item instanceof Short)) {
                    item = (long)TypeConversionUtils.objToShort((Object)item);
                }
            } else if (dataType.equals((Object)DataType.STRING)) {
                item = TypeConversionUtils.objToString((Object)item);
            } else {
                throw new TODOException();
            }
        }
        return item;
    }

    public static IObjectCollection newObjectCollectionInstance(EntityObjectInfo bo, int capacity) throws InvalidDAOMetaDataException {
        return Utils.newObjectCollectionInstance(bo);
    }

    public static void fillObject(String langId, IObjectCollection objCol, EntityObjectInfo rootEntity, ResultSet rs, Map aliasMap, List fieldList, String keyPropName, int keyColumnCount) throws BOSException {
        long startTime = System.currentTimeMillis();
        long totalStartTime = System.currentTimeMillis();
        try {
            int i;
            String[] keyPropNameArray = keyPropName.split("\\.");
            EntityObjectInfo lastKeyPropEntity = rootEntity;
            LinkPropertyInfo lastKeyPropInfo = null;
            PropertyInfo lastReverKeyPropInfo = null;
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] selectItemArray = new String[columnCount];
            int[] dataTypeArray = new int[columnCount];
            String[] propKeyArray = new String[columnCount];
            CardinalityType[] cardinalityArray = new CardinalityType[columnCount];
            PropertyInfo[] columnPropArray = new PropertyInfo[columnCount];
            lastKeyPropEntity = rootEntity;
            for (int i2 = 0; i2 < keyPropNameArray.length; ++i2) {
                lastKeyPropInfo = (LinkPropertyInfo)lastKeyPropEntity.getPropertyByNameRuntime(keyPropNameArray[i2]);
                lastKeyPropEntity = lastKeyPropInfo.getRelationship().getChildObject(lastKeyPropEntity);
                cardinalityArray[i2] = lastKeyPropInfo.getRelationship().getClientCardinality();
            }
            lastReverKeyPropInfo = lastKeyPropInfo.getRelationship().getParentProperty(lastKeyPropEntity);
            String lastReversePropName = lastReverKeyPropInfo.getName();
            for (i = 0; i < columnCount; ++i) {
                String columnName = rsMetaData.getColumnName(i + 1);
                String selectItem = (String)aliasMap.get(columnName);
                propKeyArray[i] = selectItem.substring(selectItem.lastIndexOf(46) + 1);
                selectItemArray[i] = selectItem;
                PropertyInfo propInfo = (PropertyInfo)fieldList.get(i);
                ColumnInfo columnInfo = propInfo.getMappingField();
                if (columnInfo != null) {
                    if (columnInfo.containsKey("_state_")) {
                        throw new TODOException();
                    }
                    dataTypeArray[i] = columnInfo.getSQLType();
                    continue;
                }
                dataTypeArray[i] = 1;
            }
            for (i = keyColumnCount; i < columnCount; ++i) {
                String propKey = propKeyArray[i];
                columnPropArray[i] = lastKeyPropEntity.getPropertyByNameRuntime(propKey);
            }
            startTime = System.currentTimeMillis();
            ArrayList<Object[]> rowList = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] row = new Object[columnCount];
                for (int i3 = 0; i3 < columnCount; ++i3) {
                    int sqlType = dataTypeArray[i3];
                    row[i3] = ORMUtils.readItem(rs, i3 + 1, sqlType, (PropertyInfo)fieldList.get(i3));
                }
                rowList.add(row);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("read data from resultSet, timespan : " + (System.currentTimeMillis() - startTime)));
            }
            for (int i4 = 0; i4 < rowList.size(); ++i4) {
                int j;
                Object[] row = (Object[])rowList.get(i4);
                IObjectValue propObj = null;
                propObj = (IObjectValue)ORMUtils.iteratorObject(objCol, selectItemArray, row, keyPropNameArray.length);
                for (j = keyPropNameArray.length; j < keyColumnCount; ++j) {
                    Object item = row[j];
                    String selectItem = selectItemArray[j];
                    String[] propNameArray = selectItem.split("\\.");
                    IObjectValue newEntry = Utils.newObjectValueInstance(lastKeyPropEntity);
                    if (propObj != null) {
                        Object tempVal = propObj;
                        for (int k = keyPropNameArray.length - 1; k < propNameArray.length; ++k) {
                            if (tempVal instanceof IObjectCollection) {
                                IObjectCollection tempCol = (IObjectCollection)tempVal;
                                newEntry.put(propNameArray[k], item);
                                newEntry.put(lastReversePropName, (Object)propObj);
                                tempCol.addObject(newEntry);
                                propObj = newEntry;
                                continue;
                            }
                            if (tempVal instanceof IObjectValue) {
                                tempVal = tempVal.get(propNameArray[k]);
                                continue;
                            }
                            throw new TODOException();
                        }
                        continue;
                    }
                    throw new TODOException();
                }
                if (propObj == null) {
                    throw new BOSException("Error.");
                }
                for (j = keyColumnCount; j < columnCount; ++j) {
                    String propKey = propKeyArray[j];
                    Object item = row[j];
                    PropertyInfo propInfo = (PropertyInfo)fieldList.get(j);
                    PropertyInfo columnPropInfo = columnPropArray[j];
                    if (propInfo instanceof OwnPropertyInfo) {
                        OwnPropertyInfo ownProp = (OwnPropertyInfo)propInfo;
                        if (columnPropInfo == null || columnPropInfo instanceof OwnPropertyInfo) {
                            String proplangId;
                            propObj.put(propKey, item);
                            if (!ownProp.isMultilingual() || !(proplangId = propKey.substring(propKey.lastIndexOf(95) + 1)).equalsIgnoreCase(langId)) continue;
                            propObj.put(propInfo.getName(), item);
                            continue;
                        }
                        LinkPropertyInfo linkColProp = (LinkPropertyInfo)columnPropInfo;
                        RelationshipInfo relationship = linkColProp.getRelationship();
                        CardinalityType cardinality = relationship.getChildCardinality(lastKeyPropEntity);
                        if (cardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || cardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                            EntityObjectInfo linkClientEntity = relationship.getChildObject(lastKeyPropEntity);
                            IObjectCollection newObjCol = Utils.newObjectCollectionInstance(linkClientEntity);
                            IObjectValue newValue = Utils.newObjectValueInstance(linkClientEntity);
                            newValue.put(propInfo.getName(), item);
                            newObjCol.addObject(newValue);
                            propObj.put(propKey, (Object)newObjCol);
                            continue;
                        }
                        throw new TODOException();
                    }
                    throw new TODOException();
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("fillObject error, " + e.getMessage(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fillObject, timespan : " + (System.currentTimeMillis() - totalStartTime)));
        }
    }

    public static Object iteratorObject(IObjectCollection objCol, String[] strItemArray, Object[] row, int length) {
        int i;
        String[] valuePropNameArray = new String[length];
        String[] linkPropNameArray = new String[length - 1];
        for (i = 0; i < length; ++i) {
            String[] tempArray = strItemArray[i].split("\\.");
            valuePropNameArray[i] = tempArray[tempArray.length - 1];
            if (i <= 0) continue;
            linkPropNameArray[i - 1] = tempArray[tempArray.length - 2];
        }
        for (i = 0; i < objCol.size(); ++i) {
            Object tempRtnVal = ORMUtils.iterateObject(objCol.getObject(i), valuePropNameArray, linkPropNameArray, row, length, 0);
            if (tempRtnVal == null) continue;
            return tempRtnVal;
        }
        return null;
    }

    public static Object iterateObject(IObjectValue obj, String[] valuePropNameArray, String[] linkPropNameArray, Object[] row, int length, int index) {
        if (index < length) {
            Object cmpVal = row[index];
            Object tempVal = obj.get(valuePropNameArray[index]);
            if (tempVal == null) {
                return null;
            }
            if (cmpVal.equals(tempVal)) {
                if (index == length - 1) {
                    return obj;
                }
            } else {
                return null;
            }
            Object propVal = obj.get(linkPropNameArray[index]);
            if (propVal instanceof IObjectCollection) {
                IObjectCollection tempCol = (IObjectCollection)propVal;
                for (int i = 0; i < tempCol.size(); ++i) {
                    IObjectValue tempObj = tempCol.getObject(i);
                    Object tempRtnVal = ORMUtils.iterateObject(tempObj, valuePropNameArray, linkPropNameArray, row, length, index + 1);
                    if (tempRtnVal == null) continue;
                    return tempRtnVal;
                }
            } else {
                if (propVal instanceof IObjectValue) {
                    IObjectValue tempObj = (IObjectValue)propVal;
                    return ORMUtils.iterateObject(tempObj, valuePropNameArray, linkPropNameArray, row, length, index + 1);
                }
                throw new TODOException();
            }
        }
        return null;
    }

    public static IObjectValue getKeyObject(Object propVal, Object cmpVal, String[] propNameArray, int currentIndex) {
        if (cmpVal == null) {
            throw new IllegalArgumentException("cmpVal is null");
        }
        String propName = propNameArray[currentIndex];
        if (propVal instanceof IObjectCollection) {
            IObjectCollection tempCol = (IObjectCollection)propVal;
            if (currentIndex == propNameArray.length - 1) {
                for (int i = 0; i < tempCol.size(); ++i) {
                    IObjectValue tempObj = tempCol.getObject(i);
                    if (!cmpVal.equals(tempObj.get(propName))) continue;
                    return tempObj;
                }
                return null;
            }
            for (int i = 0; i < tempCol.size(); ++i) {
                IObjectValue tempObj = tempCol.getObject(i);
                IObjectValue tempRtnVal = ORMUtils.getKeyObject(tempObj, cmpVal, propNameArray, currentIndex + 1);
                if (tempRtnVal == null) continue;
                return tempRtnVal;
            }
        } else if (propVal instanceof IObjectValue) {
            IObjectValue tempObj = (IObjectValue)propVal;
            if (currentIndex == propNameArray.length) {
                if (cmpVal.equals(tempObj.get(propName))) {
                    return tempObj;
                }
            } else {
                propVal = tempObj.get(propName);
                IObjectValue tempRtnVal = ORMUtils.getKeyObject(propVal, cmpVal, propNameArray, currentIndex + 1);
                if (tempRtnVal != null) {
                    return tempRtnVal;
                }
            }
        }
        return null;
    }

    public static void computeValueList(Context ctx, List valueList, IObjectCollection objCol, String[] strItemArray, EntityObjectInfo rootEntity, SqlSelect sqlSelect, PropertyInfo[] valPropInfo) {
        SqlExpr[] sqlExprArray = new SqlExpr[1];
        for (int i = 0; i < objCol.size(); ++i) {
            ORMUtils.computeValueListInternal(ctx, valueList, strItemArray, rootEntity, objCol.getObject(i), 0, sqlSelect, sqlExprArray, valPropInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void computeValueListInternal(Context ctx, List valueList, String[] strItemArray, EntityObjectInfo propEntity, IObjectValue propObj, int itemIndex, SqlSelect sqlSelect, SqlExpr[] sqlExpr, PropertyInfo[] valPropInfo) {
        String itemPropName = strItemArray[itemIndex];
        PropertyInfo propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
        Object propVal = propObj.get(itemPropName);
        if (itemIndex < strItemArray.length - 1) {
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
            RelationshipInfo relationship = linkProp.getRelationship();
            CardinalityType cardinlality = relationship.getChildCardinality(propEntity);
            propEntity = relationship.getChildObject(propEntity);
            if (cardinlality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || cardinlality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                IObjectCollection propCol = (IObjectCollection)propVal;
                for (int i = 0; i < propCol.size(); ++i) {
                    ORMUtils.computeValueListInternal(ctx, valueList, strItemArray, propEntity, propCol.getObject(i), itemIndex + 1, sqlSelect, sqlExpr, valPropInfo);
                }
                return;
            } else {
                ORMUtils.computeValueListInternal(ctx, valueList, strItemArray, propEntity, (IObjectValue)propVal, itemIndex + 1, sqlSelect, sqlExpr, valPropInfo);
            }
            return;
        } else {
            SqlExpr old_condition = sqlSelect.condition;
            if (sqlExpr[0] == null) {
                SqlExpr leftExpr;
                valPropInfo[0] = propEntity.getPropertyByNameRuntime(itemPropName);
                if (valPropInfo[0].getMappingField() == null) {
                    if (!(valPropInfo[0] instanceof LinkPropertyInfo)) throw new TODOException();
                    LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                    RelationshipInfo relationship = linkProp.getRelationship();
                    EntityObjectInfo linkClientEnttiy = relationship.getChildObject(propEntity);
                    PropertyCollection clientKeyPropCol = linkClientEnttiy.getLogicalKey().getKeyPropertys();
                    if (clientKeyPropCol.size() != 1) {
                        throw new TODOException();
                    }
                    PropertyInfo clientClientPropInfo = clientKeyPropCol.get(0);
                    leftExpr = ORMUtils.buildTableFieldSqlExpr(ctx, linkClientEnttiy, clientClientPropInfo.getName());
                    valPropInfo[1] = valPropInfo[0];
                    valPropInfo[0] = clientClientPropInfo;
                } else {
                    leftExpr = ORMUtils.buildTableFieldSqlExpr(ctx, propEntity, itemPropName);
                }
                SqlVarRefExpr rightExpr = new SqlVarRefExpr("?");
                sqlExpr[0] = new SqlBinaryOpExpr(leftExpr, 10, (SqlExpr)rightExpr);
                sqlSelect.condition = sqlExpr[0];
            } else {
                sqlSelect.condition = new SqlBinaryOpExpr(sqlSelect.condition, 8, sqlExpr[0]);
            }
            if (propVal == null && !propObj.containsKey(itemPropName)) return;
            if (propVal instanceof IObjectCollection) {
                IObjectCollection propValCol = (IObjectCollection)propVal;
                if (propValCol.size() > 0) {
                    IObjectValue propValObj = propValCol.getObject(0);
                    Object tempPropVal = propValObj.get(valPropInfo[0].getName());
                    if (tempPropVal == null) {
                        throw new TODOException();
                    }
                    valueList.add(tempPropVal);
                    return;
                } else {
                    sqlSelect.condition = old_condition;
                }
                return;
            } else {
                if (propVal instanceof IObjectValue) {
                    throw new TODOException();
                }
                valueList.add(propVal);
            }
        }
    }

    public static SqlExpr buildTableFieldSqlExpr(Context ctx, EntityObjectInfo entity, String propName) {
        SqlBinaryOpExpr sqlExpr;
        String tableName = entity.getTable().getName();
        PropertyInfo propInfo = null;
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo propItemInfo = properties.get(i);
            if (!propItemInfo.getName().equals(propName)) continue;
            propInfo = propItemInfo;
            break;
        }
        EntityObjectInfo baseEntity = entity;
        block1: while (propInfo == null && (baseEntity = baseEntity.getBaseEntity()) != null) {
            properties = baseEntity.getPropertiesRuntime();
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo propItemInfo = properties.get(i);
                if (!propItemInfo.getName().equals(propName)) continue;
                propInfo = propItemInfo;
                continue block1;
            }
        }
        if (propInfo == null) {
            throw new TODOException("in ORMUtils.buildTableFieldSqlExpr propInfo is null");
        }
        ColumnInfo columnInfo = baseEntity.getMappingFieldOfProperty(propInfo);
        if (columnInfo == null) {
            throw new TODOException();
        }
        SqlIdentifierExpr linkTableExpr = new SqlIdentifierExpr(tableName);
        String columnName = columnInfo.getName();
        if (propInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)propInfo;
            if (ownProp.isMultilingual()) {
                String langId = ctx.getLocale().toString();
                sqlExpr = new SqlBinaryOpExpr((SqlExpr)linkTableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnName + "_" + langId));
            } else {
                sqlExpr = new SqlBinaryOpExpr((SqlExpr)linkTableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnName));
            }
        } else {
            sqlExpr = new SqlBinaryOpExpr((SqlExpr)linkTableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnName));
        }
        return sqlExpr;
    }

    public static ExprNode buildTableFieldExprNode(Context ctx, EntityObjectInfo entity, String propName, String fullPropName, Map propMap) throws BOSException {
        PropertyExpr sqlExpr;
        String tableName = entity.getTable().getName();
        PropertyInfo propInfo = null;
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo propItemInfo = properties.get(i);
            if (!propItemInfo.getName().equals(propName)) continue;
            propInfo = propItemInfo;
            break;
        }
        EntityObjectInfo baseEntity = entity;
        block1: while (propInfo == null && (baseEntity = baseEntity.getBaseEntity()) != null) {
            properties = baseEntity.getPropertiesRuntime();
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo propItemInfo = properties.get(i);
                if (!propItemInfo.getName().equals(propName)) continue;
                propInfo = propItemInfo;
                continue block1;
            }
        }
        if (propMap != null && fullPropName != null && !propMap.containsKey(propName)) {
            baseEntity.getMappingFieldOfProperty(propInfo);
            propMap.put(fullPropName, propInfo);
        }
        ColumnInfo columnInfo = null;
        if (propInfo != null) {
            columnInfo = propInfo.getMappingField();
        }
        if (columnInfo == null) {
            throw new TODOException();
        }
        IdentifierExpr linkTableExpr = new IdentifierExpr(tableName);
        String columnName = columnInfo.getName();
        OwnPropertyInfo ownProp = (OwnPropertyInfo)propInfo;
        if (ownProp.isMultilingual()) {
            String langId = ctx.getLocale().toString();
            sqlExpr = new PropertyExpr(linkTableExpr, columnName + "_" + langId);
        } else {
            sqlExpr = new PropertyExpr(linkTableExpr, columnName);
        }
        return sqlExpr;
    }

    public static EntityObjectInfo getEntity(EntityObjectInfo entity, String propName) {
        PropertyCollection properties = entity.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo propItemInfo = properties.get(i);
            if (!propItemInfo.getName().equals(propName)) continue;
            return entity;
        }
        EntityObjectInfo baseEntity = entity;
        while ((baseEntity = baseEntity.getBaseEntity()) != null) {
            properties = baseEntity.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo propItemInfo = properties.get(i);
                if (!propItemInfo.getName().equals(propName)) continue;
                return baseEntity;
            }
        }
        return null;
    }

    public static EntityObjectInfo getEntity(EntityObjectInfo rootEntity, String[] propNameArray) {
        EntityObjectInfo propEntity = rootEntity;
        for (int i = 0; i < propNameArray.length; ++i) {
            String itemPropName = propNameArray[i];
            PropertyInfo propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
            if (propInfo == null) {
                throw new TODOException("not such property '" + itemPropName + "', entity : " + propEntity.getFullName());
            }
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
            RelationshipInfo relationship = linkProp.getRelationship();
            propEntity = relationship.getChildObject(propEntity);
        }
        return propEntity;
    }

    public static Map buildPropMap(EntityObjectInfo entity) {
        HashMap<String, PropertyInfo> propMap = new HashMap<String, PropertyInfo>();
        PropertyCollection properties = entity.getPropertiesRuntime();
        int propertiesSize = properties.size();
        for (int i = 0; i < propertiesSize; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            String propName = propertyInfo.getName();
            if (propMap.containsKey(propName)) continue;
            entity.getMappingFieldOfProperty(propertyInfo);
            propMap.put(propName, propertyInfo);
        }
        return propMap;
    }

    public static String concat(String[] strArray, int offSet, int length) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buff.append(strArray[i + offSet]);
        }
        return buff.toString();
    }

    public static String concat(String[] strArray, int offSet, int length, char seperator) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buff.append(seperator);
            }
            buff.append(strArray[i + offSet]);
        }
        return buff.toString();
    }

    public static void computeReverseTableSource(Context ctx, SqlSelect sqlSelect, EntityObjectInfo[] entityArray, LinkPropertyInfo[] linkPropArray, Set entitySet) {
        if (sqlSelect.tableSource == null) {
            sqlSelect.tableSource = new SqlTableSource(entityArray[entityArray.length - 1].getTable().getName());
        }
        for (int i = entityArray.length - 1; i > 0; --i) {
            EntityObjectInfo entity = entityArray[i];
            EntityObjectInfo linkEntity = entityArray[i - 1];
            LinkPropertyInfo linkProp = linkPropArray[i - 1];
            ORMUtils.computeTableSource(ctx, sqlSelect, entity, linkEntity, linkProp, entitySet);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void computeTableSource(Context ctx, SqlSelect sqlSelect, EntityObjectInfo entity, EntityObjectInfo destEntity, LinkPropertyInfo linkPropInfo, Set entitySet) {
        int joinType;
        ColumnInfo destColumn;
        PropertyCollection keyPropCol;
        LogicalKeyInfo logicalKey;
        ColumnInfo column;
        RelationshipInfo relationShip = linkPropInfo.getRelationship();
        PropertyInfo srcPropInfo = relationShip.getParentProperty(entity);
        if (entitySet.contains(destEntity)) {
            return;
        }
        entitySet.add(destEntity);
        CardinalityType selfCardinality = relationShip.getParentCardinality(entity);
        CardinalityType destCardinality = relationShip.getChildCardinality(entity);
        EntityObjectInfo destPropOwnedEntity = destEntity;
        SqlBinaryOpExpr joinCondition = null;
        PropertyInfo destProperty = relationShip.getChildProperty(entity);
        destPropOwnedEntity = ORMUtils.getEntity(destEntity, destProperty.getName());
        if (destPropOwnedEntity == null) {
            throw new TODOException();
        }
        if (selfCardinality.equals((Object)CardinalityType.ONE) || selfCardinality.equals((Object)CardinalityType.ZERO_TO_ONE)) {
            column = srcPropInfo.getMappingField();
            if ((column = ORMUtils.ensureColumnLoaded(ctx, column, entity, srcPropInfo)) == null) {
                logicalKey = entity.getLogicalKey();
                keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) throw new TODOException();
                column = keyPropCol.get(0).getMappingField();
            }
            destColumn = destProperty.getMappingField();
            destColumn = ORMUtils.ensureColumnLoaded(ctx, destColumn, destPropOwnedEntity, destProperty);
            joinType = 1;
        } else {
            if (!selfCardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !selfCardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) throw new TODOException();
            if (!destCardinality.equals((Object)CardinalityType.ONE) && !destCardinality.equals((Object)CardinalityType.ZERO_TO_ONE)) throw new TODOException();
            column = srcPropInfo.getMappingField();
            if ((column = ORMUtils.ensureColumnLoaded(ctx, column, entity, srcPropInfo)) == null) {
                logicalKey = entity.getLogicalKey();
                keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) throw new TODOException();
                column = keyPropCol.get(0).getMappingField();
                column = ORMUtils.ensureColumnLoaded(ctx, column, entity, srcPropInfo);
            }
            destColumn = destProperty.getMappingField();
            if ((destColumn = ORMUtils.ensureColumnLoaded(ctx, destColumn, destPropOwnedEntity, destProperty)) == null) {
                throw new TODOException();
            }
            joinType = 0;
        }
        EntityObjectInfo propOwnedEntity = ORMUtils.getEntity(entity, srcPropInfo.getName());
        if (propOwnedEntity == null) {
            throw new TODOException();
        }
        DataTableInfo dataTable = destPropOwnedEntity.getTable();
        String tableName = dataTable.getName();
        SqlTableSource destTableSource = new SqlTableSource(tableName);
        SqlBinaryOpExpr leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(propOwnedEntity.getTable().getName()), 20, (SqlExpr)new SqlIdentifierExpr(column.getName()));
        SqlBinaryOpExpr rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(destEntity.getTable().getName()), 20, (SqlExpr)new SqlIdentifierExpr(destColumn.getName()));
        joinCondition = new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr);
        sqlSelect.tableSource = new SqlJoinedTableSource(sqlSelect.tableSource, (SqlTableSourceBase)destTableSource, joinType, (SqlExpr)joinCondition);
    }

    public static void computeTableNameAndPropInfo(EntityObjectInfo[] outEntity, String[] outTableName, PropertyInfo[] outPropInfo, EntityObjectInfo entity, String propName) throws BOSException {
        PropertyInfo propInfo = entity.getPropertyByNameRuntime(propName);
        EntityObjectInfo ownedEntity = entity;
        while (propInfo == null && (ownedEntity = ownedEntity.getBaseEntity()) != null) {
            propInfo = ownedEntity.getPropertyByNameRuntime(propName);
        }
        if (ownedEntity == null) {
            throw new BOSException("can not get ownedEntity, entity : " + entity.getName() + ", property : " + propName);
        }
        DataTableInfo dataTable = ownedEntity.getTable();
        outEntity[0] = ownedEntity;
        outPropInfo[0] = propInfo;
        outTableName[0] = dataTable.getName();
    }

    public static SqlSelectItem buildSelectItem(String tableName, String columnName, String alias) {
        SqlSelectItem selectItem = new SqlSelectItem();
        SqlIdentifierExpr leftTableExpr = new SqlIdentifierExpr(tableName);
        SqlIdentifierExpr leftColumnExpr = new SqlIdentifierExpr(columnName);
        selectItem.expr = new SqlBinaryOpExpr((SqlExpr)leftTableExpr, 20, (SqlExpr)leftColumnExpr);
        selectItem.alias = alias;
        return selectItem;
    }

    public static ColumnInfo ensureColumnLoaded(Context ctx, ColumnInfo column, EntityObjectInfo entity, PropertyInfo propInfo) {
        DataTableInfo table = entity.getTable();
        if (table.containsKey("_state_")) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            MetaDataPK pk = MetaDataPK.create((String)table.getPackage(), (String)table.getName());
            table = loader.getDataTable((IMetaDataPK)pk);
            entity.setTable(table);
        }
        if (column.containsKey("_state_")) {
            ColumnInfo reloadedColumn = entity.getTable().getColumnByNameRuntime(column.getName());
            if (reloadedColumn == null) {
                if (propInfo.getMappingField() != null && !propInfo.containsKey("_state_")) {
                    return propInfo.getMappingField();
                }
                throw new TODOException();
            }
            propInfo.setMappingField(reloadedColumn);
            return reloadedColumn;
        }
        return column;
    }
}

