/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping_ex.ast.ObjectQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByMode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.runtime.QueryUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.CacheUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlan;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlanAfterAction;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecuteStep;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.IPlanExecutor;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ObjectQueryContext;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ObjectQueryUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.PlanExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectLimit;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSObjectType;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectQueryEngine {
    private final Context bosContext;
    private final Connection conn;
    private static final Logger logger = Logger.getLogger(ObjectQueryEngine.class);

    public ObjectQueryEngine(Context bosContext, Connection conn) {
        this.bosContext = bosContext;
        this.conn = conn;
    }

    public Context getContext() {
        return this.bosContext;
    }

    public IObjectCollection getCollection(BOSObjectType bosType, String oql) throws BOSException {
        ObjectQuery query = new ObjectQuery(oql);
        return this.getCollection(bosType, query);
    }

    private ExecutePlan buildExecutePlan(BOSObjectType bosType, ObjectQuery query, String pramOQL) throws BOSException {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.bosContext);
        EntityObjectInfo rootEntity = metaDataLoader.getEntity(bosType);
        ObjectQueryUtil.adjust(this.bosContext, rootEntity, query);
        ArrayList identList = new ArrayList();
        query.populateIdentifier(identList, true);
        ArrayList<EntityObjectInfo> oneToManyChildEntityList = new ArrayList<EntityObjectInfo>();
        ArrayList oneToManyChildEntityPrefixList = new ArrayList();
        ArrayList oneToManyLnkPropList = new ArrayList();
        oneToManyChildEntityList.add(rootEntity);
        oneToManyChildEntityPrefixList.add(null);
        QueryUtil.computeOneToManyChildEntity(identList, rootEntity, oneToManyChildEntityList, oneToManyChildEntityPrefixList, oneToManyLnkPropList);
        assert (oneToManyChildEntityPrefixList.size() == oneToManyChildEntityList.size());
        assert (oneToManyChildEntityPrefixList.size() == oneToManyLnkPropList.size() - 1);
        ExecutePlan plan = new ExecutePlan(rootEntity, pramOQL);
        HashMap<String, ObjectQueryContext> queryCtxMap = new HashMap<String, ObjectQueryContext>();
        for (int i = 0; i < oneToManyChildEntityList.size(); ++i) {
            ObjectQueryContext objQueryCtx;
            ExecuteStep step = new ExecuteStep();
            EntityObjectInfo entity = (EntityObjectInfo)oneToManyChildEntityList.get(i);
            LinkPropertyInfo linkProp = i == 0 ? null : (LinkPropertyInfo)oneToManyLnkPropList.get(i - 1);
            String prefix = (String)oneToManyChildEntityPrefixList.get(i);
            ObjectQueryContext parentObjQueryCtx = null;
            Object parentEntity = null;
            if (prefix != null && prefix.length() > 0) {
                int index = prefix.lastIndexOf(46);
                String parentPrefix = index != -1 ? prefix.substring(0, index) : "";
                parentObjQueryCtx = (ObjectQueryContext)queryCtxMap.get(parentPrefix);
                if (parentObjQueryCtx == null) {
                    String[] propNameArray = parentPrefix.split("\\.");
                    for (int propNameIndex = 0; propNameIndex < propNameArray.length; ++propNameIndex) {
                        int prefixNameItemLength = propNameArray.length - i - 1;
                        String tempPrefix = ORMUtils.concat(propNameArray, 0, prefixNameItemLength);
                        parentObjQueryCtx = (ObjectQueryContext)queryCtxMap.get(tempPrefix);
                        if (parentObjQueryCtx == null) continue;
                        int lastIndex = prefix.lastIndexOf(46);
                        parentEntity = lastIndex == -1 ? null : ORMUtils.getEntity(rootEntity, propNameArray);
                        break;
                    }
                } else {
                    parentEntity = parentObjQueryCtx.getCurrentEntity();
                }
            }
            if (parentObjQueryCtx == null) {
                objQueryCtx = new ObjectQueryContext(this.bosContext, entity, prefix, linkProp);
                queryCtxMap.put("", objQueryCtx);
            } else {
                objQueryCtx = new ObjectQueryContext(parentObjQueryCtx, entity, prefix, linkProp);
                queryCtxMap.put(prefix, objQueryCtx);
            }
            QueryUtil.computeEntityList(query, prefix, objQueryCtx);
            assert (objQueryCtx.getEntityList().size() == objQueryCtx.getEntityPrefixList().size());
            SqlSelect select = new SqlSelect();
            if (i == 0 && query.getTop() > 0) {
                select.limit = new SqlSelectLimit(query.getTop());
            }
            QueryUtil.buildSelectList(query, select, step, objQueryCtx);
            ExprNode filter = query.getFilterCondition();
            if (filter != null) {
                select.condition = QueryUtil.buildCondition(query.getFilterCondition(), objQueryCtx);
                if (i == 0 && select.condition == null) {
                    throw new BOSException("Fatal Error. filter error.");
                }
            }
            List orderByList = query.getOrderByItemList();
            int size = orderByList.size();
            for (int j = 0; j < size; ++j) {
                OrderByItem item = (OrderByItem)orderByList.get(j);
                SqlExpr expr = QueryUtil.buildCondition(item.expr, objQueryCtx);
                if (expr == null) continue;
                SqlOrderByItem sqlOrderByItem = new SqlOrderByItem();
                sqlOrderByItem.expr = expr;
                sqlOrderByItem.mode = OrderByMode.Desc.equals(item.mode) ? 1 : 0;
                if (select.orderBy == null) {
                    select.orderBy = new ArrayList();
                }
                select.orderBy.add(sqlOrderByItem);
            }
            QueryUtil.computeTableSource(objQueryCtx, select);
            KSqlUtil.optimize((SqlSelect)select);
            step.setEntity(entity);
            step.setParentEntity((EntityObjectInfo)parentEntity);
            step.setLinkProperty(linkProp);
            step.setSqlSelect((SqlSelectBase)select);
            step.setEntityPrefix(prefix);
            step.setTabAliasMap(objQueryCtx.getTableAliasMap());
            step.setColumnMap(objQueryCtx.getColumnMap());
            plan.getSteps().add(step);
        }
        Map entryFilterMap = query.getEntriesFilterDirect();
        if (entryFilterMap != null) {
            for (Map.Entry entry : entryFilterMap.entrySet()) {
                String entryPropName = (String)entry.getKey();
                ExprNode filterExpr = (ExprNode)entry.getValue();
                ObjectQueryContext queryCtx = (ObjectQueryContext)queryCtxMap.get(entryPropName);
                SqlExpr filterSqlExpr = QueryUtil.buildEntryFilterSqlExpr(queryCtx, filterExpr, entryPropName);
                ExecutePlanAfterAction action = new ExecutePlanAfterAction(entryPropName, filterSqlExpr);
                plan.getAfterActions().put(entryPropName, action);
            }
        }
        return plan;
    }

    public IObjectCollection getCollection(BOSObjectType bosType, ObjectQuery query) throws BOSException {
        IObjectCollection objCol;
        ExecutePlan plan;
        ArrayList literalValList = new ArrayList();
        ArrayList assignToList = new ArrayList();
        query.populateLiteral(literalValList, assignToList);
        String pramOQL = query.toString().toLowerCase();
        String keyString = bosType.toString() + pramOQL;
        String keyCode = Integer.toHexString(Math.abs(keyString.hashCode()));
        IPlanExecutor executor = PlanExecutorFactory.getPlanExecutor(this.bosContext);
        Map planCacheMap = CacheUtil.getPlanMap(this.bosContext);
        Map spCacheMap = CacheUtil.getSPMap(this.bosContext);
        if (planCacheMap.containsKey(keyCode)) {
            plan = (ExecutePlan)planCacheMap.get(keyCode);
        } else {
            plan = this.buildExecutePlan(bosType, query, pramOQL);
            plan.setKeyCode(keyCode);
            planCacheMap.put(keyCode, plan);
            try {
                CacheUtil.registePlanToDb(this.bosContext, keyCode, plan);
            }
            catch (BOSException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            objCol = executor.getCollection(this.bosContext, this.conn, plan, assignToList, literalValList);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            planCacheMap.remove(keyCode);
            spCacheMap.remove(keyCode);
            throw new BOSException(ex.getMessage(), (Throwable)ex);
        }
        return objCol;
    }
}

