/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping_ex.ast.ObjectQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AllColumnExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InListExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.LiteralExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.VarRefExpr;
import com.kingdee.bos.dao.ormapping_ex.parser.ExprParser;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.util.TODOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectQueryUtil {
    public static void adjust(Context ctx, EntityObjectInfo rootEntity, ObjectQuery query) throws BOSException {
        List selectList = query.getSelectList();
        if (selectList.size() == 0) {
            selectList.add(new AllColumnExpr());
        }
        ObjectQueryUtil.replaceAllColumnExpr(ctx, rootEntity, selectList);
        ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, query);
        ObjectQueryUtil.ensureRootEntity(ctx, rootEntity, selectList);
    }

    private static void ensureRootEntity(Context ctx, EntityObjectInfo rootEntity, List selectList) throws BOSException {
        boolean hasRootPropItem = false;
        int selectListSize = selectList.size();
        for (int selectItemIndex = 0; selectItemIndex < selectListSize; ++selectItemIndex) {
            ExprNode exprNode = (ExprNode)selectList.get(selectItemIndex);
            String ident = exprNode.toString();
            if (hasRootPropItem || ident.indexOf(46) == -1) continue;
            hasRootPropItem = true;
        }
        if (hasRootPropItem) {
            return;
        }
        ArrayList<String> appendList = new ArrayList<String>();
        EntityObjectInfo entity = rootEntity;
        PropertyCollection propCol = entity.getPropertiesRuntime();
        int propColSize = propCol.size();
        for (int propIndex = 0; propIndex < propColSize; ++propIndex) {
            PropertyInfo propInfo = propCol.get(propIndex);
            if (propInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
                String propIdent = ownPropInfo.getName();
                appendList.add(propIdent);
                continue;
            }
            if (propInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkPropInfo.getRelationship();
                EntityObjectInfo childEntity = relationship.getChildObject(entity);
                RelationshipType relationType = relationship.getType();
                boolean isComposition = relationType != null && RelationshipType.COMPOSITION.equals((Object)relationType);
                isComposition = true;
                if (!isComposition) continue;
                LogicalKeyInfo childLogicalKey = childEntity.getLogicalKey();
                PropertyCollection childKeyPropCol = childLogicalKey.getKeyPropertys();
                int keyPropSize = childKeyPropCol.size();
                for (int keyPropIndex = 0; keyPropIndex < keyPropSize; ++keyPropIndex) {
                    PropertyInfo keyProp = childKeyPropCol.get(keyPropIndex);
                    String propIdent = linkPropInfo.getName() + '.' + keyProp.getName();
                    appendList.add(propIdent);
                }
                continue;
            }
            throw new TODOException();
        }
        int size = appendList.size();
        for (int i = 0; i < size; ++i) {
            String ident = (String)appendList.get(i);
            if (ident.equalsIgnoreCase("desc")) {
                selectList.add(new IdentifierExpr("desc"));
                continue;
            }
            ExprParser parser2 = new ExprParser(ident);
            ExprNode expr = parser2.expr();
            selectList.add(expr);
        }
    }

    private static void replaceLinkProp(Context ctx, EntityObjectInfo rootEntity, ObjectQuery query) throws BOSException {
        int i;
        List selectList = query.getSelectList();
        ArrayList<Integer> replaceList = new ArrayList<Integer>();
        ArrayList<String> appendList = new ArrayList<String>();
        int selectListSize = selectList.size();
        for (int selectItemIndex = 0; selectItemIndex < selectListSize; ++selectItemIndex) {
            ExprNode exprNode = (ExprNode)selectList.get(selectItemIndex);
            if (exprNode == null) {
                throw new BOSException("Illegal ObjectQuery");
            }
            String ident = exprNode.toString();
            PropertyInfo propInfo = null;
            String[] propNameArray = ident.split("\\.");
            EntityObjectInfo propEntity = rootEntity;
            for (int j = 0; j < propNameArray.length; ++j) {
                String itemPropName = propNameArray[j];
                propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
                if (propInfo == null) {
                    throw new BOSException("Fatal Error. can not found property '" + itemPropName + "', entity : " + propEntity.getFullName());
                }
                propNameArray[j] = propInfo.getName();
                if (j >= propNameArray.length - 1) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                propEntity = relationship.getChildObject(propEntity);
            }
            ident = ORMUtils.concat(propNameArray, 0, propNameArray.length, '.');
            if (propInfo == null) {
                throw new BOSException("TODO");
            }
            if (propInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                EntityObjectInfo childEntity = linkProp.getRelationship().getChildObject(propEntity);
                LogicalKeyInfo childLogicalKey = childEntity.getLogicalKey();
                PropertyCollection childKeyPropCol = childLogicalKey.getKeyPropertys();
                int childKeyPropColSize = childKeyPropCol.size();
                for (int i2 = 0; i2 < childKeyPropColSize; ++i2) {
                    PropertyInfo childKeyProp = childKeyPropCol.get(i2);
                    String propIdent = ident + '.' + childKeyProp.getName();
                    appendList.add(propIdent);
                }
                replaceList.add(selectItemIndex);
                continue;
            }
            if (ident.equalsIgnoreCase("desc")) {
                selectList.set(selectItemIndex, new IdentifierExpr("desc"));
                continue;
            }
            ExprParser parser2 = new ExprParser(ident);
            ExprNode newExpr = parser2.expr();
            selectList.set(selectItemIndex, newExpr);
        }
        for (i = replaceList.size() - 1; i >= 0; --i) {
            Integer index = (Integer)replaceList.get(i);
            selectList.remove(index);
        }
        int size = appendList.size();
        for (i = 0; i < size; ++i) {
            String ident = (String)appendList.get(i);
            ExprParser parser3 = new ExprParser(ident);
            ExprNode expr = parser3.expr();
            selectList.add(expr);
        }
        ExprNode filter = query.getFilterCondition();
        ExprNode newFilter = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, filter);
        query.setFilterCondition(newFilter);
        List orderByItemList = query.getOrderByItemList();
        int orderByItemListSize = orderByItemList.size();
        for (int i3 = 0; i3 < orderByItemListSize; ++i3) {
            OrderByItem item = (OrderByItem)orderByItemList.get(i3);
            item.expr = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, item.expr);
        }
    }

    private static ExprNode replaceLinkProp(Context ctx, EntityObjectInfo rootEntity, ExprNode expr) throws BOSException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof IdentifierExpr || expr instanceof PropertyExpr) {
            return ObjectQueryUtil.replaceLinkProp_Ident(ctx, rootEntity, expr);
        }
        if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            inListExpr.expr = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, inListExpr.expr);
            for (int i = 0; i < inListExpr.targetList.size(); ++i) {
                ExprNode item = (ExprNode)inListExpr.targetList.get(i);
                ExprNode newItem = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, item);
                inListExpr.targetList.set(i, newItem);
            }
            return inListExpr;
        }
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            binaryOpExpr.left = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, binaryOpExpr.left);
            binaryOpExpr.right = ObjectQueryUtil.replaceLinkProp(ctx, rootEntity, binaryOpExpr.right);
            return binaryOpExpr;
        }
        if (expr instanceof LiteralExpr) {
            return expr;
        }
        if (expr instanceof VarRefExpr) {
            return expr;
        }
        throw new TODOException(expr.getClass().getName());
    }

    private static ExprNode replaceLinkProp_Ident(Context ctx, EntityObjectInfo rootEntity, ExprNode expr) throws BOSException {
        String ident = expr.toString();
        PropertyInfo propInfo = null;
        String[] propNameArray = ident.split("\\.");
        EntityObjectInfo propEntity = rootEntity;
        for (int j = 0; j < propNameArray.length; ++j) {
            String itemPropName = propNameArray[j];
            propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
            if (propInfo == null) {
                throw new BOSException("Fatal Error. not such property '" + itemPropName + "', entity : " + propEntity.getFullName());
            }
            propNameArray[j] = propInfo.getName();
            if (j >= propNameArray.length - 1) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
            RelationshipInfo relationship = linkProp.getRelationship();
            propEntity = relationship.getChildObject(propEntity);
        }
        ident = ORMUtils.concat(propNameArray, 0, propNameArray.length, '.');
        if (propInfo == null) {
            throw new BOSException("TODO");
        }
        if (propInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
            EntityObjectInfo childEntity = linkProp.getRelationship().getChildObject(propEntity);
            LogicalKeyInfo childLogicalKey = childEntity.getLogicalKey();
            PropertyCollection childKeyPropCol = childLogicalKey.getKeyPropertys();
            if (childKeyPropCol.size() != 1) {
                throw new TODOException();
            }
            PropertyInfo childKeyProp = childKeyPropCol.get(0);
            ident = ident + '.' + childKeyProp.getName();
        }
        ExprParser parser2 = new ExprParser(ident);
        ExprNode newExpr = parser2.expr();
        return newExpr;
    }

    private static void replaceAllColumnExpr(Context ctx, EntityObjectInfo rootEntity, List selectList) throws BOSException {
        int i;
        ArrayList<Integer> replaceList = new ArrayList<Integer>();
        ArrayList<String> appendList = new ArrayList<String>();
        int size = selectList.size();
        for (i = 0; i < size; ++i) {
            String entityPrefix;
            EntityObjectInfo entity;
            ExprNode exprNode = (ExprNode)selectList.get(i);
            if (exprNode == null) {
                throw new BOSException("Illegal ObjectQuery");
            }
            String ident = exprNode.toString();
            if (!ident.endsWith("*")) continue;
            if (ident.equals("*")) {
                entity = rootEntity;
                entityPrefix = null;
            } else {
                int lastIndex = ident.lastIndexOf(46);
                if (lastIndex != ident.length() - 2) {
                    throw new BOSException("TODO");
                }
                entityPrefix = ident.substring(0, lastIndex);
                String[] nameArray = entityPrefix.split("\\.");
                entity = ORMUtils.getEntity(rootEntity, nameArray);
            }
            PropertyCollection propCol = entity.getPropertiesRuntime();
            int propColSize = propCol.size();
            for (int propIndex = 0; propIndex < propColSize; ++propIndex) {
                PropertyInfo propInfo = propCol.get(propIndex);
                if (propInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
                    String propIdent = ownPropInfo.getName();
                    if (entityPrefix != null) {
                        propIdent = entityPrefix + '.' + propIdent;
                    }
                    appendList.add(propIdent);
                    continue;
                }
                if (propInfo instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)propInfo;
                    RelationshipInfo relationship = linkPropInfo.getRelationship();
                    EntityObjectInfo childEntity = relationship.getChildObject(entity);
                    RelationshipType relationType = relationship.getType();
                    boolean isComposition = relationType != null && RelationshipType.COMPOSITION.equals((Object)relationType);
                    isComposition = true;
                    if (!isComposition) continue;
                    LogicalKeyInfo childLogicalKey = childEntity.getLogicalKey();
                    PropertyCollection childKeyPropCol = childLogicalKey.getKeyPropertys();
                    int keyPropSize = childKeyPropCol.size();
                    for (int keyPropIndex = 0; keyPropIndex < keyPropSize; ++keyPropIndex) {
                        PropertyInfo keyProp = childKeyPropCol.get(keyPropIndex);
                        String propIdent = linkPropInfo.getName() + '.' + keyProp.getName();
                        if (entityPrefix != null) {
                            propIdent = entityPrefix + '.' + propIdent;
                        }
                        appendList.add(propIdent);
                    }
                    continue;
                }
                throw new TODOException();
            }
            replaceList.add(i);
        }
        for (i = replaceList.size() - 1; i >= 0; --i) {
            Integer index = (Integer)replaceList.get(i);
            selectList.remove(index);
        }
        size = appendList.size();
        for (i = 0; i < size; ++i) {
            String ident = (String)appendList.get(i);
            if (ident.equalsIgnoreCase("desc")) {
                selectList.add(new IdentifierExpr("desc"));
                continue;
            }
            ExprParser parser2 = new ExprParser(ident);
            ExprNode expr = parser2.expr();
            selectList.add(expr);
        }
    }
}

