/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping_ex.ast.ObjectQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByMode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NCharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.TODOException;
import com.kingdee.util.TypeConversionUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrmEngine {
    private static int connectionCount = 0;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.OrmEngine");
    private Context ctx;
    private SolutionInfo solution;
    private String langId;

    private OrmEngine(Context ctx) {
        this.ctx = ctx;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        this.solution = loader.getSolution();
        this.langId = ctx.getLocale().toString();
    }

    public static OrmEngine getInstance(Context ctx) {
        return new OrmEngine(ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IObjectCollection getCollectionFetchByMultiPass(BOSObjectType bosType, String oql) throws BOSException {
        ArrayList<String[]> itemList;
        CharSequence key;
        IObjectCollection objCol;
        if (bosType == null) {
            throw new IllegalArgumentException("bosType");
        }
        if (oql == null) {
            throw new IllegalArgumentException("oql");
        }
        long totalStartTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        SqlSelect sqlSelect = new SqlSelect();
        ObjectQuery query = new ObjectQuery(oql);
        HashSet allIdentSet = new HashSet();
        query.populateIdentifier(allIdentSet);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        EntityObjectInfo rootEntity = metaDataLoader.getEntity(bosType);
        PropertyCollection properties = rootEntity.getInheritedNoDuplicatedPropertiesRuntime();
        String entityTableName = rootEntity.getTable().getName();
        Map propMap = ORMUtils.buildPropMap(rootEntity);
        sqlSelect.tableSource = new SqlTableSource(entityTableName);
        HashSet<EntityObjectInfo> entitySet = new HashSet<EntityObjectInfo>();
        entitySet.add(rootEntity);
        Hashtable aliasMap = new Hashtable();
        ArrayList fieldList = new ArrayList();
        this.computeBaseEntityTableSource(rootEntity, sqlSelect, entitySet, allIdentSet);
        List orderByItemList = query.getOrderByItemList();
        for (int i = 0; i < orderByItemList.size(); ++i) {
            OrderByItem orderByItem = (OrderByItem)orderByItemList.get(i);
            String orderByExprStr = orderByItem.expr.toString();
            String[] propNameArray = orderByExprStr.split("\\.");
            for (int j = 0; j < propNameArray.length; ++j) {
            }
        }
        ArrayList unFectchSelectItemList = new ArrayList();
        ArrayList fetchedList = new ArrayList();
        this.computeSelectListForMultiPass(fieldList, sqlSelect, query, rootEntity, entityTableName, propMap, aliasMap, entitySet, unFectchSelectItemList, fetchedList);
        HashSet filterAndSorterIdentSet = new HashSet();
        query.populateIdentifier(filterAndSorterIdentSet, false);
        ArrayList literalList = new ArrayList();
        ArrayList assignToList = new ArrayList();
        query.populateConditionLiteral(literalList, assignToList, false);
        HashMap identMap = new HashMap();
        this.computeIdentMap(filterAndSorterIdentSet, rootEntity, entityTableName, propMap, identMap, sqlSelect, entitySet);
        query.replaceFilterAndSorterIdent(identMap);
        this.computeFilter(sqlSelect, query, rootEntity, properties, filterAndSorterIdentSet, literalList, assignToList);
        this.computeSorter(rootEntity, query, sqlSelect);
        sqlSelect.orderBy.clear();
        String sql = OrmEngine.buildSql(sqlSelect);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(sql);
            resultSet = this.execute(stmt, sql, literalList, assignToList, propMap);
            objCol = ORMUtils.fillObjectValue(this.langId, resultSet, rootEntity, fieldList, aliasMap, this.ctx);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("SQLException. " + e.getMessage()), (Throwable)e);
                throw new BOSException("SQLException. " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    KSqlUtil.cleanUp(null, resultSet);
                    --connectionCount;
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)("fill boject value error. " + e2.getMessage()), (Throwable)e2);
                    throw new BOSException("fill boject value error. " + e2.getMessage(), (Throwable)e2);
                }
            }
        }
        try {
            KSqlUtil.cleanUp(null, (ResultSet)resultSet);
            --connectionCount;
        }
        catch (SQLException e) {
            log.error((Object)("fill boject value error. " + e.getMessage()), (Throwable)e);
            throw new BOSException("fill boject value error. " + e.getMessage(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("construct first level, timespan : " + (System.currentTimeMillis() - startTime)));
        }
        startTime = System.currentTimeMillis();
        HashMap<String, ArrayList<String[]>> itemListMap = new HashMap<String, ArrayList<String[]>>();
        for (int i = 0; i < unFectchSelectItemList.size(); ++i) {
            String[] item = (String[])unFectchSelectItemList.get(i);
            key = new StringBuffer(item[0]);
            for (int j = 1; j < item.length - 1; ++j) {
                ((StringBuffer)key).append('.').append(item[j]);
            }
            itemList = (ArrayList<String[]>)itemListMap.get(((StringBuffer)key).toString());
            if (itemList == null) {
                itemList = new ArrayList<String[]>();
                itemListMap.put(((StringBuffer)key).toString(), itemList);
            }
            itemList.add(item);
        }
        ArrayList keyList = new ArrayList(itemListMap.keySet());
        Collections.sort(keyList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("group item, timespan : " + (System.currentTimeMillis() - startTime)));
        }
        int i = 0;
        while (true) {
            if (i >= keyList.size()) {
                if (!log.isDebugEnabled()) return objCol;
                log.debug((Object)("getCollectionFetchByMultiPass, timespan : " + (System.currentTimeMillis() - totalStartTime)));
                return objCol;
            }
            startTime = System.currentTimeMillis();
            key = (String)keyList.get(i);
            itemList = (List)itemListMap.get(key);
            this.fetchAndFillOneGroup(query, rootEntity, fetchedList, objCol, (String)key, itemList, literalList, assignToList, propMap, sqlSelect.condition, filterAndSorterIdentSet);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAndFillOneGroup(ObjectQuery query, EntityObjectInfo rootEntity, List fetchedList, IObjectCollection objCol, String key, List itemList, List literalList, List assignToList, Map rootPropMap, SqlExpr whereCondition, Set conditionIdentSet) throws BOSException {
        long startTime = System.currentTimeMillis();
        SqlSelect subSqlSelect = new SqlSelect();
        HashSet subEntitySet = new HashSet();
        String[] strItemArray = key.split("\\.");
        EntityObjectInfo subEntity = ORMUtils.getEntity(rootEntity, strItemArray);
        ArrayList subFieldList = new ArrayList();
        HashMap subAliasMap = new HashMap();
        ArrayList keyItemList = new ArrayList();
        this.buildSubSqlSelectForMultiPass(rootEntity, subEntitySet, objCol, subSqlSelect, itemList, subFieldList, subAliasMap, fetchedList, strItemArray, keyItemList);
        String subEntityTableName = subEntity.getTable().getName();
        Map subPropMap = ORMUtils.buildPropMap(subEntity);
        HashSet<String> subIdentSet = new HashSet<String>();
        for (int j = 0; j < itemList.size(); ++j) {
            String[] item = (String[])itemList.get(j);
            String subIdent = item[item.length - 1];
            subIdentSet.add(subIdent);
        }
        this.computeTableSource(subSqlSelect, subIdentSet, subEntity, subEntity.getPropertiesRuntime(), subEntityTableName, subEntity.getPropertiesRuntime().size(), subEntitySet, subPropMap);
        this.computeTableSource(subSqlSelect, conditionIdentSet, rootEntity, rootEntity.getPropertiesRuntime(), null, rootEntity.getPropertiesRuntime().size(), subEntitySet, rootPropMap);
        subSqlSelect.condition = whereCondition;
        String subSql = OrmEngine.buildSql(subSqlSelect);
        Connection subConn = this.getConnection();
        PreparedStatement subStmt = null;
        ResultSet subResultSet = null;
        try {
            subStmt = subConn.prepareStatement(subSql);
            subResultSet = this.execute(subStmt, subSql, literalList, assignToList, rootPropMap);
            ORMUtils.fillObject(this.langId, objCol, rootEntity, subResultSet, subAliasMap, subFieldList, key, keyItemList.size());
        }
        catch (SQLException e) {
            try {
                log.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("SQLException. " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    KSqlUtil.cleanUp((Connection)subConn, (Statement)subStmt, subResultSet);
                    --connectionCount;
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.warn((Object)e2.getMessage(), (Throwable)e2);
                    throw new BOSException("SQLException. " + e2.getMessage(), (Throwable)e2);
                }
            }
        }
        try {
            KSqlUtil.cleanUp((Connection)subConn, (Statement)subStmt, (ResultSet)subResultSet);
            --connectionCount;
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("SQLException. " + e.getMessage(), (Throwable)e);
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)("construct group '" + key + "', timespan : " + (System.currentTimeMillis() - startTime)));
    }

    private void setParam(PreparedStatement stmt, int index, Object literalVal, int sqltype) throws SQLException {
        switch (sqltype) {
            case -1: 
            case 1: 
            case 12: {
                String tmp = TypeConversionUtils.objToString((Object)literalVal);
                if (tmp.startsWith("~9^Nz")) {
                    stmt.setString(index, tmp.substring(tmp.lastIndexOf("~9^Nz") + 5));
                    break;
                }
                stmt.setAsciiStream(index, (InputStream)new SerializableByteArrayInputStream(tmp.getBytes()), tmp.getBytes().length);
                break;
            }
            case 4: {
                stmt.setInt(index, TypeConversionUtils.objToInt((Object)literalVal));
                break;
            }
            case -7: {
                stmt.setBoolean(index, TypeConversionUtils.objToBoolean((Object)literalVal));
                break;
            }
            case -6: {
                stmt.setByte(index, TypeConversionUtils.objToByte((Object)literalVal));
                break;
            }
            case 5: {
                stmt.setShort(index, TypeConversionUtils.objToShort((Object)literalVal));
                break;
            }
            case -5: {
                stmt.setLong(index, TypeConversionUtils.objToLong((Object)literalVal));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                stmt.setDouble(index, TypeConversionUtils.objToDouble((Object)literalVal));
                break;
            }
            case 2: 
            case 3: {
                stmt.setBigDecimal(index, TypeConversionUtils.objToBigDecimal((Object)literalVal));
                break;
            }
            case 91: {
                stmt.setDate(index, TypeConversionUtils.objToDate((Object)literalVal));
                break;
            }
            case 92: {
                stmt.setTime(index, TypeConversionUtils.objToTime((Object)literalVal));
                break;
            }
            case 93: {
                stmt.setTimestamp(index, TypeConversionUtils.objToTimestamp((Object)literalVal));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                stmt.setBytes(index, TypeConversionUtils.objToBytes((Object)literalVal));
                break;
            }
            case 2005: {
                stmt.setString(index, new String(TypeConversionUtils.objToBytes((Object)literalVal)));
            }
        }
    }

    private static String buildSql(SqlSelect sqlSelect) throws BOSException {
        StringBuffer buff = new StringBuffer();
        try {
            new DrSQLFormater(buff).formatSelect(sqlSelect);
        }
        catch (FormaterException e) {
            log.error((Object)("sqlDom to sql error, " + e.getMessage()), (Throwable)e);
            throw new BOSException("sqlDom to sql error, " + e.getMessage(), (Throwable)e);
        }
        String sql = buff.toString();
        return sql;
    }

    private void buildSubSqlSelectForMultiPass(EntityObjectInfo rootEntity, Set entitySet, IObjectCollection objCol, SqlSelect sqlSelect, List itemList, List fieldList, Map aliasMap, List fetchedList, String[] keyPropNameArray, List keyItemList) throws BOSException {
        int i;
        HashSet<String> identSet = new HashSet<String>();
        String keyFullPropName = ORMUtils.concat(keyPropNameArray, 0, keyPropNameArray.length, '.');
        EntityObjectInfo[] entityArray = new EntityObjectInfo[keyPropNameArray.length + 1];
        LinkPropertyInfo[] reverseLinkPropArray = new LinkPropertyInfo[keyPropNameArray.length];
        PropertyInfo[] reverseClientPropArray = new PropertyInfo[keyPropNameArray.length];
        String[] keyItemArray = new String[keyPropNameArray.length];
        entityArray[0] = rootEntity;
        for (i = 0; i < keyPropNameArray.length; ++i) {
            EntityObjectInfo linkPropEntity;
            EntityObjectInfo propEntity = entityArray[i];
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propEntity.getPropertyByNameRuntime(keyPropNameArray[i]);
            RelationshipInfo relationship = linkProp.getRelationship();
            entityArray[i + 1] = linkPropEntity = relationship.getChildObject(propEntity);
            PropertyInfo reverseChildRelationProp = relationship.getChildProperty(linkPropEntity);
            reverseLinkPropArray[i] = (LinkPropertyInfo)relationship.getParentProperty(linkPropEntity);
            reverseClientPropArray[i] = reverseChildRelationProp;
            String propName = reverseChildRelationProp.getName();
            String[] item = new String[i + 1];
            if (i != 0) {
                for (int j = 0; j < i; ++j) {
                    item[j] = keyPropNameArray[j];
                }
                item[i] = propName;
            } else {
                item[0] = propName;
            }
            keyItemArray[i] = ORMUtils.concat(item, 0, item.length, '.');
            keyItemList.add(keyItemArray[i]);
        }
        ORMUtils.computeReverseTableSource(this.ctx, sqlSelect, entityArray, reverseLinkPropArray, entitySet);
        for (i = 0; i < keyItemArray.length; ++i) {
            PropertyInfo[] outPropArray = new PropertyInfo[1];
            EntityObjectInfo[] outEntityArray = new EntityObjectInfo[1];
            String[] outTabNameArray = new String[1];
            ORMUtils.computeTableNameAndPropInfo(outEntityArray, outTabNameArray, outPropArray, entityArray[i], reverseClientPropArray[i].getName());
            PropertyInfo propInfo = outPropArray[0];
            String tableName = outTabNameArray[0];
            String columnName = propInfo.getMappingField().getName();
            String alias = "F" + aliasMap.size();
            aliasMap.put(alias, keyItemArray[i]);
            SqlSelectItem selectItem = ORMUtils.buildSelectItem(tableName, columnName, alias);
            sqlSelect.selectList.add(selectItem);
            fieldList.add(propInfo);
        }
        EntityObjectInfo propEntity = entityArray[entityArray.length - 1];
        PropertyCollection keyProperties = propEntity.getLogicalKey().getKeyPropertys();
        for (int i2 = 0; i2 < keyProperties.size(); ++i2) {
            PropertyInfo keyPropInfo = keyProperties.get(i2);
            String fullPropName = keyFullPropName + "." + keyPropInfo.getName();
            PropertyInfo[] outPropArray = new PropertyInfo[1];
            EntityObjectInfo[] outEntityArray = new EntityObjectInfo[1];
            String[] outTabNameArray = new String[1];
            ORMUtils.computeTableNameAndPropInfo(outEntityArray, outTabNameArray, outPropArray, propEntity, keyPropInfo.getName());
            PropertyInfo propInfo = outPropArray[0];
            String tableName = outTabNameArray[0];
            String columnName = propInfo.getMappingField().getName();
            String alias = "F" + aliasMap.size();
            aliasMap.put(alias, fullPropName);
            SqlSelectItem selectItem = ORMUtils.buildSelectItem(tableName, columnName, alias);
            sqlSelect.selectList.add(selectItem);
            fieldList.add(propInfo);
            keyItemList.add(fullPropName);
        }
        for (int i3 = 0; i3 < itemList.size(); ++i3) {
            String[] item = (String[])itemList.get(i3);
            String lastPropName = item[item.length - 1];
            String fullPropName = null;
            for (int j = 0; j < item.length; ++j) {
                if (fullPropName == null) {
                    fullPropName = item[j];
                    continue;
                }
                fullPropName = fullPropName + '.';
                fullPropName = fullPropName + item[j];
            }
            identSet.add(lastPropName);
            EntityObjectInfo entity = rootEntity;
            LinkPropertyInfo linkProp = null;
            block6: for (int j = 0; j < item.length - 1; ++j) {
                String subPropName = item[j];
                PropertyCollection properties = entity.getPropertiesRuntime();
                for (int k = 0; k < properties.size(); ++k) {
                    PropertyInfo subPropInfo = properties.get(k);
                    if (!subPropInfo.getName().equals(subPropName)) continue;
                    if (subPropInfo instanceof LinkPropertyInfo) {
                        linkProp = (LinkPropertyInfo)subPropInfo;
                        RelationshipInfo relationShip = linkProp.getRelationship();
                        entity = relationShip.getChildObject(entity);
                        continue block6;
                    }
                    throw new BOSException("Fatal Error.");
                }
            }
            if (!entitySet.contains(entity)) {
                if (sqlSelect.tableSource == null) {
                    sqlSelect.tableSource = new SqlTableSource(entity.getTable().getName());
                }
                this.computeBaseEntityTableSource(entity, sqlSelect, entitySet, identSet);
            }
            if (linkProp == null) {
                throw new BOSException("Fatal Error. " + item);
            }
            this.buildSelectItem(entity, lastPropName, fullPropName, sqlSelect, aliasMap, fieldList, entitySet);
            fetchedList.add(fullPropName);
        }
    }

    private void computeSelectListForMultiPass(List fieldList, SqlSelect sqlSelect, ObjectQuery query, EntityObjectInfo entity, String entityTableName, Map propMap, Map aliasMap, Set entitySet, List unFectchSelectItemList, List fetchedList) throws BOSException {
        int querySelectListSize = query.getSelectList().size();
        new SqlIdentifierExpr(entityTableName);
        for (int i = 0; i < querySelectListSize; ++i) {
            String usedPropName;
            ExprNode itemExpr = (ExprNode)query.getSelectList().get(i);
            if (itemExpr instanceof IdentifierExpr) {
                usedPropName = itemExpr.toString();
                if (usedPropName.equals("*")) {
                    throw new BOSException("TODO");
                }
                PropertyInfo propInfo = null;
                PropertyCollection properties = entity.getPropertiesRuntime();
                for (int j = 0; j < properties.size(); ++j) {
                    PropertyInfo propItemInfo = properties.get(j);
                    if (!propItemInfo.getName().equals(usedPropName)) continue;
                    propInfo = propItemInfo;
                    break;
                }
                if (propInfo instanceof LinkPropertyInfo) {
                    throw new BOSException("TODO");
                }
                this.buildSelectItem(entity, usedPropName, usedPropName, sqlSelect, aliasMap, fieldList, entitySet);
                fetchedList.add(usedPropName);
                continue;
            }
            if (itemExpr instanceof PropertyExpr) {
                PropertyExpr propExpr = (PropertyExpr)itemExpr;
                ExprNode tempExpr = propExpr.owner;
                while (tempExpr instanceof PropertyExpr) {
                    tempExpr = ((PropertyExpr)tempExpr).owner;
                }
                usedPropName = tempExpr.toString();
                PropertyInfo usedPropInfo = (PropertyInfo)propMap.get(usedPropName);
                if (usedPropInfo == null || !(usedPropInfo instanceof LinkPropertyInfo)) {
                    throw new BOSException("TODO");
                }
                String[] itemNameArray = itemExpr.toString().split("\\.");
                LinkPropertyInfo linkProp = (LinkPropertyInfo)usedPropInfo;
                RelationshipInfo relationShip = linkProp.getRelationship();
                CardinalityType cardinalityType = relationShip.getChildCardinality(entity);
                EntityObjectInfo linkPropEntity = linkProp.getRelationship().getChildObject(entity);
                if (cardinalityType.equals((Object)CardinalityType.ZERO_TO_ONE) || cardinalityType.equals((Object)CardinalityType.ONE)) {
                    this.computeTableSource(this.ctx, linkProp, sqlSelect, entity, entitySet);
                    for (int j = 2; j < itemNameArray.length; ++j) {
                        String subPropName = itemNameArray[j - 1];
                        int k = 0;
                        PropertyCollection subLinkPropCol = linkPropEntity.getInheritedNoDuplicatedPropertiesRuntime();
                        if (k >= subLinkPropCol.size()) continue;
                        LinkPropertyInfo subLinkProp = (LinkPropertyInfo)subLinkPropCol.get(k);
                        if (subLinkProp.getName().equals(subPropName)) {
                            linkPropEntity = subLinkProp.getRelationship().getChildObject(linkPropEntity);
                            continue;
                        }
                        throw new BOSException("TODO");
                    }
                    PropertyInfo reverseParentPropInfo = relationShip.getParentProperty(linkPropEntity);
                    if (reverseParentPropInfo instanceof LinkPropertyInfo) {
                        throw new BOSException("TODO");
                    }
                    String reverseFullPropName = linkProp.getName() + "." + reverseParentPropInfo.getName();
                    this.buildSelectItem(linkPropEntity, reverseParentPropInfo.getName(), reverseFullPropName, sqlSelect, aliasMap, fieldList, entitySet);
                    String linkLastPropName = itemNameArray[itemNameArray.length - 1];
                    if (linkLastPropName.equals("*")) {
                        throw new BOSException("TODO");
                    }
                    this.buildSelectItem(linkPropEntity, linkLastPropName, itemExpr.toString(), sqlSelect, aliasMap, fieldList, entitySet);
                    fetchedList.add(usedPropName);
                    continue;
                }
                PropertyInfo reverseChildPropInfo = relationShip.getChildProperty(linkPropEntity);
                usedPropName = reverseChildPropInfo.getName();
                if (!fetchedList.contains(usedPropName)) {
                    if (reverseChildPropInfo instanceof LinkPropertyInfo) {
                        throw new BOSException("TODO");
                    }
                    this.buildSelectItem(entity, usedPropName, usedPropName, sqlSelect, aliasMap, fieldList, entitySet);
                    fetchedList.add(usedPropName);
                }
                unFectchSelectItemList.add(itemNameArray);
                continue;
            }
            throw new BOSException("TODO");
        }
    }

    private void computeBaseEntityTableSource(EntityObjectInfo entity, SqlSelect sqlSelect, Set entitySet, Collection identCol) throws BOSException {
        block0: for (String ident : identCol) {
            if (ident.indexOf(46) >= 0) continue;
            EntityObjectInfo baseEntity = entity;
            while (true) {
                EntityObjectInfo subEntity = baseEntity;
                if (!ident.equals("*")) {
                    PropertyInfo subPropInfo;
                    PropertyCollection subRuntimeProperties = subEntity.getPropertiesRuntime();
                    for (int i = 0; i < subRuntimeProperties.size() && !(subPropInfo = subRuntimeProperties.get(i)).getName().equals(ident); ++i) {
                    }
                }
                if ((baseEntity = baseEntity.getBaseEntity()) == null || baseEntity.isAbstract()) continue block0;
                if (entitySet.contains(baseEntity)) continue;
                LogicalKeyInfo subLogicalKey = subEntity.getLogicalKey();
                PropertyCollection subKeyPropCol = subLogicalKey.getKeyPropertys();
                DataTableInfo subTable = subEntity.getTable();
                LogicalKeyInfo baseLogicalKey = baseEntity.getLogicalKey();
                PropertyCollection baseKeyPropCol = baseLogicalKey.getKeyPropertys();
                DataTableInfo baseTable = baseEntity.getTable();
                if (subKeyPropCol.size() != baseKeyPropCol.size()) {
                    throw new BOSException("Fatal Error, subEntity's keyProperties is not same to baseEntity.");
                }
                SqlTableSource baseTableSource = new SqlTableSource(baseTable.getName());
                SqlBinaryOpExpr joinCondition = null;
                for (int j = 0; j < subKeyPropCol.size(); ++j) {
                    PropertyInfo subProperty = subKeyPropCol.get(j);
                    ColumnInfo subColumn = subProperty.getMappingField();
                    ColumnInfo baseColumn = subProperty.getMappingField();
                    if (subColumn == null || baseColumn == null) {
                        throw new BOSException("TODO");
                    }
                    SqlBinaryOpExpr leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(subTable.getName()), 20, (SqlExpr)new SqlIdentifierExpr(subColumn.getName()));
                    SqlBinaryOpExpr rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(baseTable.getName()), 20, (SqlExpr)new SqlIdentifierExpr(baseColumn.getName()));
                    joinCondition = joinCondition == null ? new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr) : new SqlBinaryOpExpr((SqlExpr)joinCondition, 7, (SqlExpr)new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr));
                }
                if (joinCondition == null) {
                    throw new BOSException("can not build baseTable's joinCondition.");
                }
                sqlSelect.tableSource = new SqlJoinedTableSource(sqlSelect.tableSource, (SqlTableSourceBase)baseTableSource, 0, joinCondition);
                entitySet.add(baseEntity);
            }
        }
    }

    public IObjectCollection getCollection(BOSObjectType bosType, String oql) throws BOSException {
        return this.getCollectionFetchByMultiPass(bosType, oql);
    }

    private ResultSet execute(PreparedStatement stmt, String sql, List literalList, List assignToList, Map propMap) throws BOSException {
        ResultSet resultSet = null;
        try {
            for (int i = 0; i < literalList.size(); ++i) {
                byte[] bytes;
                String val;
                Object literalVal = literalList.get(i);
                String assignToIdent = (String)assignToList.get(i);
                if (assignToIdent != null) {
                    PropertyInfo propInfo = (PropertyInfo)propMap.get(assignToIdent);
                    if (propInfo == null) {
                        throw new BOSException("TODO");
                    }
                    ColumnInfo column = propInfo.getMappingField();
                    if (column == null) {
                        throw new BOSException("TODO");
                    }
                    if (column.containsKey("_state_")) {
                        throw new BOSException("Fatal Error. columnName : " + column.getName());
                    }
                    int sqltype = column.getSQLType();
                    if (literalVal == null || literalVal instanceof String && ((String)literalVal).length() == 0) {
                        if (sqltype == 2005) {
                            stmt.setString(i + 1, null);
                            continue;
                        }
                        if (sqltype == 2004) {
                            stmt.setBytes(i + 1, null);
                            continue;
                        }
                        stmt.setNull(i + 1, sqltype);
                        continue;
                    }
                    this.setParam(stmt, i + 1, literalVal, sqltype);
                    continue;
                }
                if (literalVal == null || literalVal instanceof String && ((String)literalVal).length() == 0) {
                    throw new BOSException("TODO");
                }
                if (literalVal instanceof NCharExpr) {
                    stmt.setString(i + 1, (String)((NCharExpr)literalVal).getValue());
                    continue;
                }
                if (literalVal instanceof CharExpr) {
                    val = (String)((CharExpr)literalVal).getValue();
                    bytes = val.getBytes();
                    SerializableByteArrayInputStream inputStream = new SerializableByteArrayInputStream(bytes);
                    stmt.setAsciiStream(i + 1, (InputStream)inputStream, bytes.length);
                    continue;
                }
                if (literalVal instanceof String) {
                    val = (String)literalVal;
                    if (val.startsWith("~9^Nz")) {
                        stmt.setString(i + 1, val.substring(val.lastIndexOf("~9^Nz") + 5));
                        continue;
                    }
                    bytes = val.getBytes();
                    stmt.setAsciiStream(i + 1, (InputStream)new SerializableByteArrayInputStream(bytes), bytes.length);
                    continue;
                }
                if (literalVal instanceof Date) {
                    Timestamp timeStamp = TypeConversionUtils.objToTimestamp(literalVal);
                    stmt.setTimestamp(i + 1, timeStamp);
                    continue;
                }
                stmt.setObject(i + 1, literalVal);
            }
            resultSet = stmt.executeQuery();
        }
        catch (SQLException e) {
            log.error((Object)("execute sql error." + e.getMessage() + "\n" + sql), (Throwable)e);
            throw new BOSException("execute sql error." + e.getMessage() + "\n" + sql, (Throwable)e);
        }
        return resultSet;
    }

    private void computeSorter(EntityObjectInfo entity, ObjectQuery query, SqlSelect sqlSelect) throws BOSException {
        List orderByItemList = query.getOrderByItemList();
        for (int i = 0; i < orderByItemList.size(); ++i) {
            OrderByItem orderByItem = (OrderByItem)orderByItemList.get(i);
            try {
                SqlExprParser exprParser = new SqlExprParser(orderByItem.expr.toString());
                SqlExpr sqlExpr = exprParser.expr();
                int orderByMode = orderByItem.mode == OrderByMode.Asc ? 0 : 1;
                SqlOrderByItem sqlOrderByItem = new SqlOrderByItem(sqlExpr, orderByMode);
                sqlSelect.orderBy.add(sqlOrderByItem);
                continue;
            }
            catch (ParserException e) {
                log.error((Object)("compute sorter error. " + e.getMessage()), (Throwable)e);
                throw new BOSException("compute sorter error. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSelectItem(EntityObjectInfo entity, String propName, String fullPropName, SqlSelect sqlSelect, Map aliasMap, List fieldList, Set entitySet) throws BOSException {
        if (!entitySet.contains(entity)) {
            // empty if block
        }
        PropertyInfo[] outPropArray = new PropertyInfo[1];
        EntityObjectInfo[] outEntityArray = new EntityObjectInfo[1];
        String[] outTabNameArray = new String[1];
        ORMUtils.computeTableNameAndPropInfo(outEntityArray, outTabNameArray, outPropArray, entity, propName);
        EntityObjectInfo ownedEntity = outEntityArray[0];
        PropertyInfo propInfo = outPropArray[0];
        String tableName = outTabNameArray[0];
        if (propInfo == null) {
            throw new BOSException("TODO");
        }
        ColumnInfo columnInfo = propInfo.getMappingField();
        if ((columnInfo = ORMUtils.ensureColumnLoaded(this.ctx, columnInfo, ownedEntity, propInfo)) == null) {
            if (propInfo instanceof LinkPropertyInfo) {
                EntityObjectInfo linkEntity = ((LinkPropertyInfo)propInfo).getRelationship().getChildObject(ownedEntity);
                PropertyCollection linkEntityProperties = linkEntity.getLogicalKey().getKeyPropertys();
                SqlIdentifierExpr tableExpr = new SqlIdentifierExpr(linkEntity.getTable().getName());
                for (int i = 0; i < linkEntityProperties.size(); ++i) {
                    PropertyInfo linkEntityProp = linkEntityProperties.get(i);
                    if (linkEntityProp instanceof LinkPropertyInfo) continue;
                    columnInfo = linkEntityProp.getMappingField();
                    if ((columnInfo = ORMUtils.ensureColumnLoaded(this.ctx, columnInfo, linkEntity, linkEntityProp)) == null) {
                        throw new BOSException("TODO");
                    }
                    assert (linkEntityProp instanceof OwnPropertyInfo);
                    OwnPropertyInfo ownedPropInfo = (OwnPropertyInfo)linkEntityProp;
                    if (ownedPropInfo.isMultilingual()) {
                        LanguageCollection langs = this.solution.getLanguages();
                        for (int j = 0; j < langs.size(); ++j) {
                            LanguageInfo lang = langs.get(j);
                            SqlBinaryOpExpr selectItemExpr = new SqlBinaryOpExpr((SqlExpr)tableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnInfo.getName() + "_" + lang.getPostfix()));
                            String alias = "F" + aliasMap.size();
                            aliasMap.put(alias, fullPropName + "_" + lang.getPostfix());
                            SqlSelectItem selectItem = new SqlSelectItem((SqlExpr)selectItemExpr, alias);
                            sqlSelect.selectList.add(selectItem);
                            fieldList.add(propInfo);
                        }
                        continue;
                    }
                    SqlBinaryOpExpr selectItemExpr = new SqlBinaryOpExpr((SqlExpr)tableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnInfo.getName()));
                    String alias = "F" + aliasMap.size();
                    aliasMap.put(alias, fullPropName);
                    SqlSelectItem selectItem = new SqlSelectItem((SqlExpr)selectItemExpr, alias);
                    sqlSelect.selectList.add(selectItem);
                    fieldList.add(linkEntityProp);
                }
                return;
            }
            if (!(propInfo instanceof OwnPropertyInfo)) throw new BOSException("TODO");
            ExtendedFieldInfo extFieldInfo = propInfo.getExtendedField();
            if (extFieldInfo != null) throw new BOSException("TODO");
            throw new BOSException("TODO");
        }
        String columnName = columnInfo.getName();
        SqlIdentifierExpr tableExpr = new SqlIdentifierExpr(tableName);
        if (!(propInfo instanceof OwnPropertyInfo)) {
            throw new BOSException("TODO");
        }
        OwnPropertyInfo ownedPropInfo = (OwnPropertyInfo)propInfo;
        if (ownedPropInfo.isMultilingual()) {
            LanguageCollection langs = this.solution.getLanguages();
            for (int i = 0; i < langs.size(); ++i) {
                LanguageInfo lang = langs.get(i);
                SqlBinaryOpExpr selectItemExpr = new SqlBinaryOpExpr((SqlExpr)tableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnName + "_" + lang.getPostfix()));
                String alias = "F" + aliasMap.size();
                aliasMap.put(alias, fullPropName + "_" + lang.getPostfix());
                SqlSelectItem selectItem = new SqlSelectItem((SqlExpr)selectItemExpr, alias);
                sqlSelect.selectList.add(selectItem);
                fieldList.add(propInfo);
            }
            return;
        } else {
            SqlBinaryOpExpr selectItemExpr = new SqlBinaryOpExpr((SqlExpr)tableExpr, 20, (SqlExpr)new SqlIdentifierExpr(columnName));
            String alias = "F" + aliasMap.size();
            aliasMap.put(alias, fullPropName);
            SqlSelectItem selectItem = new SqlSelectItem((SqlExpr)selectItemExpr, alias);
            sqlSelect.selectList.add(selectItem);
            fieldList.add(propInfo);
        }
    }

    private void computeIdentMap(Set identSet, EntityObjectInfo entity, String entityTableName, Map propMap, Map identMap, SqlSelect sqlSelect, Set entitySet) throws BOSException {
        for (String ident : identSet) {
            PropertyInfo propInfo;
            String[] itemNameArray = ident.toString().split("\\.");
            if (itemNameArray.length == 1) {
                ExprNode sqlExpr = ORMUtils.buildTableFieldExprNode(this.ctx, entity, ident, ident, propMap);
                identMap.put(ident, sqlExpr);
                continue;
            }
            EntityObjectInfo curEntity = null;
            for (int i = 0; i < itemNameArray.length - 1; ++i) {
                String item = itemNameArray[i];
                if (i == 0) {
                    curEntity = entity;
                    propInfo = (PropertyInfo)propMap.get(item);
                } else {
                    propInfo = null;
                    PropertyCollection properties = curEntity.getInheritedNoDuplicatedPropertiesRuntime();
                    for (int j = 0; j < properties.size(); ++j) {
                        PropertyInfo propItemInfo = properties.get(j);
                        if (!propItemInfo.getName().equals(item)) continue;
                        propInfo = propItemInfo;
                        break;
                    }
                }
                if (!(propInfo instanceof LinkPropertyInfo)) {
                    throw new BOSException("TODO");
                }
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                this.computeTableSource(this.ctx, linkProp, sqlSelect, curEntity, entitySet);
                curEntity = linkProp.getRelationship().getChildObject(curEntity);
            }
            if (curEntity == null) {
                throw new BOSException("TODO");
            }
            String propName = itemNameArray[itemNameArray.length - 1];
            PropertyCollection properties = curEntity.getInheritedNoDuplicatedPropertiesRuntime();
            propInfo = null;
            for (int j = 0; j < properties.size(); ++j) {
                PropertyInfo propItemInfo = properties.get(j);
                if (!propItemInfo.getName().equals(propName)) continue;
                propInfo = propItemInfo;
                break;
            }
            if (propInfo == null) {
                throw new BOSException("TODO");
            }
            ExprNode sqlExpr = ORMUtils.buildTableFieldExprNode(this.ctx, curEntity, propName, ident, propMap);
            identMap.put(ident, sqlExpr);
        }
    }

    private void computeFilter(SqlSelect sqlSelect, ObjectQuery query, EntityObjectInfo entity, PropertyCollection properties, Set identSet, List literalList, List assignToList) throws BOSException {
        query.populateConditionLiteral(literalList, assignToList, true);
        String sql = query.getFilterCondition().toString();
        try {
            SqlExprParser sqlExprParser = new SqlExprParser(sql);
            sqlSelect.condition = sqlExprParser.expr();
        }
        catch (ParserException e) {
            log.error((Object)("compute filter error, " + e.getMessage()), (Throwable)e);
            throw new BOSException("compute filter error, " + e.getMessage(), (Throwable)e);
        }
    }

    private void computeTableSource(SqlSelect sqlSelect, Set identList, EntityObjectInfo entity, PropertyCollection properties, String entityTableName, int propertiesSize, Set entitySet, Map propMap) throws BOSException {
        if (properties == null) {
            properties = entity.getPropertiesRuntime();
            propertiesSize = properties.size();
        }
        if (sqlSelect.tableSource == null) {
            throw new BOSException("Error.");
        }
        for (int i = 0; i < propertiesSize; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            String propName = propertyInfo.getName();
            if (propMap.containsKey(propName)) continue;
            entity.getMappingFieldOfProperty(propertyInfo);
            propMap.put(propName, propertyInfo);
        }
        for (String item : identList) {
            String[] itemNameArray = item.split("\\.");
            PropertyInfo propertyInfo = (PropertyInfo)propMap.get(itemNameArray[0]);
            if (propertyInfo == null) {
                throw new TODOException();
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                this.computeTableSource(this.ctx, (LinkPropertyInfo)propertyInfo, sqlSelect, entity, entitySet);
            } else {
                sqlSelect.tableSource = this.computeTableSource(entitySet, entity, sqlSelect.tableSource, (PropertyContainer)propertyInfo);
            }
            if (itemNameArray.length <= 2) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo linkPropEntity = linkProp.getRelationship().getChildObject(entity);
            block2: for (int i = 2; i < itemNameArray.length; ++i) {
                String subPropName = itemNameArray[i - 1];
                PropertyCollection subLinkPropCol = linkPropEntity.getInheritedNoDuplicatedPropertiesRuntime();
                for (int j = 0; j < subLinkPropCol.size(); ++j) {
                    PropertyInfo subLinkProp = subLinkPropCol.get(j);
                    if (!subLinkProp.getName().equals(subPropName)) continue;
                    if (!(subLinkProp instanceof LinkPropertyInfo)) {
                        throw new BOSException("TODO");
                    }
                    this.computeTableSource(this.ctx, (LinkPropertyInfo)subLinkProp, sqlSelect, linkPropEntity, entitySet);
                    linkPropEntity = ((LinkPropertyInfo)subLinkProp).getRelationship().getChildObject(linkPropEntity);
                    continue block2;
                }
            }
        }
    }

    private void computeTableSource(Context ctx, LinkPropertyInfo linkPropInfo, SqlSelect sqlSelect, EntityObjectInfo entity, Set entitySet) throws BOSException {
        RelationshipInfo relationShip = linkPropInfo.getRelationship();
        EntityObjectInfo destEntity = relationShip.getChildObject(entity);
        ORMUtils.computeTableSource(ctx, sqlSelect, entity, destEntity, linkPropInfo, entitySet);
    }

    private SqlTableSourceBase computeTableSource(Set entitySet, EntityObjectInfo entity, SqlTableSourceBase tableSource, PropertyContainer propInfo) {
        return tableSource;
    }

    private Connection getConnection() throws BOSException {
        Connection rtnVal = null;
        try {
            rtnVal = EJBFactory.getConnection(this.ctx);
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new BOSException("can not get connection, " + e.getMessage(), (Throwable)e);
        }
        ++connectionCount;
        return rtnVal;
    }
}

