/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.CacheUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlan;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecuteStep;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.IPlanExecutor;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.SelectItemInfo;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.impl.AbstractPlanExecutor;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.MSTransactSQLFormater;
import com.kingdee.util.TODOException;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DM_PlanExecutor
extends AbstractPlanExecutor
implements IPlanExecutor {
    private static final Logger logger = Logger.getLogger(DM_PlanExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(Context ctx, Connection conn, ExecutePlan plan, List assignToList, List literalValList) throws BOSException {
        if (assignToList.size() != literalValList.size()) {
            throw new BOSException("Fatal Error.");
        }
        StringBuffer buff = new StringBuffer();
        this.buildSql(ctx, plan, buff, assignToList, literalValList);
        String sql = buff.toString();
        IObjectCollection objCol = null;
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            int pramIndex;
            int i;
            stmt = conn.prepareCall(sql);
            this.setPreparedStmt(plan, assignToList, literalValList, stmt);
            int ORACLE_TYPE_CURSOR = -10;
            int outPramCount = plan.getSteps().size();
            for (i = 0; i < outPramCount; ++i) {
                pramIndex = assignToList.size() + i + 1;
                stmt.registerOutParameter(pramIndex, -10);
            }
            stmt.execute();
            for (i = 0; i < outPramCount; ++i) {
                block12: {
                    try {
                        pramIndex = assignToList.size() + i + 1;
                        rs = (ResultSet)stmt.getObject(pramIndex);
                        if (i == 0) {
                            objCol = this.buildObjectCollection(ctx, plan, rs);
                            break block12;
                        }
                        this.fillObjectCollection(ctx, plan, i, rs, objCol);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
        if (objCol == null) {
            throw new BOSException("Fatal Error.");
        }
        return objCol;
    }

    @Override
    protected void buildSql(Context ctx, ExecutePlan plan, StringBuffer rtnBuff, List assignToList, List literalValList) throws BOSException {
        String spName;
        block11: {
            Map spCacheMap;
            String key;
            block10: {
                key = plan.getKeyCode();
                spCacheMap = CacheUtil.getSPMap(ctx);
                if (!spCacheMap.containsKey(key)) break block10;
                spName = (String)spCacheMap.get(key);
                break block11;
            }
            String tabNamePrefix = CacheUtil.buildName("T_ORM", key);
            spName = CacheUtil.buildName("ORM_SP", key);
            String spSql = this.buildSpSql(ctx, spName, tabNamePrefix, plan, assignToList, literalValList);
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = EJBFactory.getConnection(ctx);
                stmt = conn.createStatement();
                this.createTempTable(ctx, plan, tabNamePrefix, stmt);
                this.executeImmediate(stmt, spSql);
            }
            catch (SQLException e) {
                try {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            spCacheMap.put(key, spName);
            CacheUtil.registeSpToDb(ctx, key, spName, plan.getOQL(), plan.getEntity());
        }
        rtnBuff.append("{call ");
        rtnBuff.append(spName);
        rtnBuff.append(" (");
        int size = assignToList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                rtnBuff.append(", ");
            }
            rtnBuff.append('?');
        }
        int assignToListSize = assignToList.size();
        int size2 = plan.getSteps().size();
        for (int i = 0; i < size2; ++i) {
            if (i == 0) {
                if (assignToListSize > 0) {
                    rtnBuff.append(", ");
                }
            } else {
                rtnBuff.append(", ");
            }
            rtnBuff.append('?');
        }
        rtnBuff.append(")}");
    }

    private void createTempTable(Context ctx, ExecutePlan plan, String tabNamePrefix, Statement stmt) throws SQLException {
        List stepList = plan.getSteps();
        int size = stepList.size() - 1;
        for (int i = 0; i < size; ++i) {
            this.createTempTable(ctx, plan, i, tabNamePrefix, stmt);
        }
    }

    private void executeImmediate(Statement stmt, String sql) throws SQLException {
        String dialectSql = "/*dialect*/BEGIN EXECUTE IMMEDIATE '" + sql + "'; END;";
        stmt.execute(dialectSql);
    }

    private void createTempTable(Context ctx, ExecutePlan plan, int stepIndex, String tabNamePrefix, Statement stmt) throws SQLException {
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(stepIndex);
        String tabName = tabNamePrefix + "_" + stepIndex;
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE GLOBAL TEMPORARY TABLE ");
        buff.append(tabName);
        buff.append(" (");
        List selectItemList = step.getSelectItemList();
        int itemSize = selectItemList.size();
        for (int i = 0; i < itemSize; ++i) {
            if (i != 0) {
                buff.append(" , ");
            }
            SelectItemInfo selectItem = (SelectItemInfo)selectItemList.get(i);
            String comment = " /* " + selectItem.getIdent() + "*/";
            ColumnInfo column = selectItem.getColumnInfo();
            column = ORMUtils.ensureColumnLoaded(ctx, column, selectItem.getEntity(), selectItem.getPropInfo());
            selectItem.setColumnInfo(column);
            this.appendSelectItem(buff, i, column, comment);
        }
        int columnIndex = selectItemList.size();
        ArrayList parentKeyColumnList = new ArrayList();
        ArrayList parentKeyColumnIndexList = new ArrayList();
        this.getParentKeyColumnList(parentKeyColumnList, parentKeyColumnIndexList, plan, stepIndex);
        int size = parentKeyColumnList.size();
        for (int i = 0; i < size; ++i) {
            buff.append(" , \n");
            ColumnInfo parentColumn = (ColumnInfo)parentKeyColumnList.get(i);
            String comment = " /* parentKeyColumn : " + parentColumn.getName() + " */ ";
            this.appendSelectItem(buff, columnIndex, parentColumn, comment);
            ++columnIndex;
        }
        buff.append(") ON COMMIT PRESERVE ROWS");
        String ddl = buff.toString();
        try {
            this.executeImmediate(stmt, ddl);
        }
        catch (SQLException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void appendSelectItem(StringBuffer buff, int columnIndex, ColumnInfo column, String comment) {
        buff.append("\tF" + columnIndex);
        buff.append(" ");
        SQLType sqlType = column.getTypeName();
        if (sqlType.equals((Object)SQLType.INT)) {
            buff.append("NUMBER(10)");
        } else if (sqlType.equals((Object)SQLType.VARCHAR)) {
            buff.append("VARCHAR2");
        } else if (sqlType.equals((Object)SQLType.NVARCHAR)) {
            buff.append("NVARCHAR2");
        } else if (sqlType.equals((Object)SQLType.DATETIME)) {
            buff.append("TIMESTAMP");
        } else if (sqlType.equals((Object)SQLType.NUMERIC)) {
            buff.append("NUMBER");
        } else {
            buff.append(sqlType.getName());
        }
        if (sqlType.equals((Object)SQLType.CHAR) || sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.NVARCHAR)) {
            buff.append("(");
            buff.append(column.getLength());
            buff.append(")");
        }
    }

    private String buildSpSql(Context ctx, String spName, String tabPrefix, ExecutePlan plan, List assignToList, List literalValList) throws BOSException {
        int i;
        int i2;
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE OR REPLACE PROCEDURE ");
        buff.append(spName);
        buff.append(" (");
        int assignToListSize = assignToList.size();
        for (i2 = 0; i2 < assignToListSize; ++i2) {
            OwnPropertyInfo ownPropInfo;
            if (i2 != 0) {
                buff.append(", ");
            }
            String pramName = "P" + i2;
            buff.append(pramName);
            buff.append(' ');
            String assignTo = (String)assignToList.get(i2);
            if (assignTo == null) {
                throw new TODOException();
            }
            PropertyInfo propInfo = null;
            String[] propNameArray = assignTo.split("\\.");
            EntityObjectInfo propEntity = plan.getEntity();
            for (int j = 0; j < propNameArray.length; ++j) {
                String itemPropName = propNameArray[j];
                propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
                if (j >= propNameArray.length - 1) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                propEntity = relationship.getChildObject(propEntity);
            }
            if (propInfo instanceof OwnPropertyInfo) {
                ownPropInfo = (OwnPropertyInfo)propInfo;
            } else if (propInfo instanceof LinkPropertyInfo) {
                OwnPropertyInfo keyProp;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                EntityObjectInfo childEntity = relationship.getChildObject(propEntity);
                LogicalKeyInfo logicalKey = childEntity.getLogicalKey();
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) {
                    throw new TODOException();
                }
                ownPropInfo = keyProp = (OwnPropertyInfo)keyPropCol.get(0);
            } else {
                throw new TODOException();
            }
            ColumnInfo column = ownPropInfo.getMappingField();
            SQLType sqlType = column.getTypeName();
            if (sqlType.equals((Object)SQLType.VARCHAR)) {
                buff.append("VARCHAR2");
                continue;
            }
            if (sqlType.equals((Object)SQLType.NVARCHAR)) {
                buff.append("NVARCHAR2");
                continue;
            }
            if (sqlType.equals((Object)SQLType.NUMERIC) || sqlType.equals((Object)SQLType.INT)) {
                buff.append("NUMBER");
                continue;
            }
            if (sqlType.equals((Object)SQLType.DATETIME)) {
                buff.append("TIMESTAMP");
                continue;
            }
            buff.append(sqlType.getName());
        }
        int size = plan.getSteps().size();
        for (i2 = 0; i2 < size; ++i2) {
            if (i2 == 0) {
                if (assignToListSize > 0) {
                    buff.append(", ");
                }
            } else {
                buff.append(", ");
            }
            String outCurName = "out_cur_" + i2;
            buff.append(outCurName);
            buff.append(" OUT SYS_REFCURSOR");
        }
        buff.append("\n)");
        buff.append("\nAS\nBEGIN\n");
        buff.append("\n");
        List stepList = plan.getSteps();
        int size2 = stepList.size();
        for (i = 1; i < size2; ++i) {
            int prefStepIndex = i - 1;
            String preVar = tabPrefix + "_" + prefStepIndex;
            buff.append("TRUNCATE TABLE ");
            buff.append(preVar);
            buff.append(";\n");
        }
        size2 = stepList.size();
        for (i = 0; i < size2; ++i) {
            ExecuteStep step = (ExecuteStep)stepList.get(i);
            if (i != 0) {
                buff.append("\n\n");
            }
            String stepPrefix = step.getEntityPrefix();
            String tabVar = tabPrefix + "_" + i;
            buff.append("\n");
            if (i != 0) {
                EntityObjectInfo parentEntity;
                String parentEntityPrefix;
                ExecuteStep preStep = null;
                int prefStepIndex = 0;
                for (int j = i - 1; j >= 0; --j) {
                    ExecuteStep item = (ExecuteStep)stepList.get(j);
                    String itemPrefix = item.getEntityPrefix();
                    if (itemPrefix == null) {
                        preStep = item;
                        prefStepIndex = j;
                        break;
                    }
                    if (!stepPrefix.startsWith(itemPrefix) || stepPrefix.length() <= itemPrefix.length() || stepPrefix.charAt(itemPrefix.length()) != '.') continue;
                    preStep = item;
                    prefStepIndex = j;
                    break;
                }
                if (preStep == null) {
                    throw new BOSException("Fatal Error.");
                }
                int parentColumnIndex = -1;
                int lastIndex = stepPrefix.lastIndexOf(46);
                if (lastIndex == -1) {
                    parentEntityPrefix = null;
                    parentEntity = preStep.getEntity();
                } else {
                    parentEntityPrefix = stepPrefix.substring(0, lastIndex);
                    String[] parentEntityNameArray = parentEntityPrefix.split("\\.");
                    parentEntity = ORMUtils.getEntity(plan.getEntity(), parentEntityNameArray);
                }
                LogicalKeyInfo parentLogicalKey = parentEntity.getLogicalKey();
                if (parentLogicalKey.getKeyPropertys().size() != 1) {
                    throw new TODOException();
                }
                OwnPropertyInfo parentKeyProp = (OwnPropertyInfo)parentLogicalKey.getKeyPropertys().get(0);
                String ident = parentEntityPrefix == null ? parentKeyProp.getName() : parentEntityPrefix + "." + parentKeyProp.getName();
                List selectItemList = preStep.getSelectItemList();
                int itemSize = selectItemList.size();
                for (int j = 0; j < itemSize; ++j) {
                    SelectItemInfo selectItem = (SelectItemInfo)selectItemList.get(j);
                    if (!selectItem.getIdent().equalsIgnoreCase(ident)) continue;
                    parentColumnIndex = j;
                    break;
                }
                if (parentColumnIndex == -1) {
                    throw new TODOException();
                }
                String preVar = tabPrefix + "_" + prefStepIndex;
                String fieldName = "F" + parentColumnIndex;
                String preTabAlias = "V_0";
                SqlTableSource tabSrc = new SqlTableSource(preVar);
                tabSrc.alias = preTabAlias;
                SqlBinaryOpExpr leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(fieldName));
                LinkPropertyInfo linkPropInfo = step.getLinkProperty();
                EntityObjectInfo propEntity = ORMUtils.getEntity(step.getParentEntity(), linkPropInfo.getName());
                RelationshipInfo relationship = linkPropInfo.getRelationship();
                PropertyInfo reversePropInfo = relationship.getChildProperty(propEntity);
                EntityObjectInfo childEntity = relationship.getChildObject(propEntity);
                EntityObjectInfo reversePropEntity = ORMUtils.getEntity(childEntity, reversePropInfo.getName());
                String tabName = reversePropEntity.getTable().getName();
                String entityPrefix = step.getEntityPrefix();
                String tabAliasKey = entityPrefix == null || entityPrefix.length() == 0 ? tabName : entityPrefix + '.' + tabName;
                String tabAlias = (String)step.getTabAliasMap().get(tabAliasKey);
                ColumnInfo column = reversePropInfo.getMappingField();
                column = ORMUtils.ensureColumnLoaded(ctx, column, reversePropEntity, reversePropInfo);
                String joinColumnName = column.getName();
                SqlBinaryOpExpr rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(joinColumnName));
                SqlBinaryOpExpr joinCondition = new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr);
                SqlSelect select = (SqlSelect)step.getSqlSelect();
                select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tabSrc, 0, (SqlExpr)joinCondition);
                ArrayList parentColumnList = new ArrayList();
                ArrayList parentColumnIndexList = new ArrayList();
                this.getParentKeyColumnList(parentColumnList, parentColumnIndexList, plan, i);
                int parentColumnListSize = parentColumnList.size();
                for (int j = 0; j < parentColumnListSize; ++j) {
                    Integer columnIndex = (Integer)parentColumnIndexList.get(j);
                    String columnName = "F" + columnIndex;
                    SqlSelectItem sqlSelectItem = new SqlSelectItem();
                    sqlSelectItem.expr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                    select.selectList.add(sqlSelectItem);
                }
            }
            if (i == size2 - 1) {
                for (int j = 0; j < size2 - 1; ++j) {
                    buff.append("OPEN ");
                    String outCurName = "out_cur_" + j;
                    buff.append(outCurName);
                    buff.append(" FOR ");
                    buff.append("SELECT * FROM ");
                    buff.append(tabPrefix + "_" + j);
                    buff.append(";\n");
                }
                buff.append("OPEN ");
                String outCurName = "out_cur_" + i;
                buff.append(outCurName);
                buff.append(" FOR ");
                try {
                    new MSTransactSQLFormater(buff).formatSelectBase(step.getSqlSelect());
                }
                catch (FormaterException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                buff.append(";");
                continue;
            }
            SqlInsert insert = new SqlInsert(tabVar);
            insert.subQuery = step.getSqlSelect();
            try {
                new MSTransactSQLFormater(buff).formatInsertStmt(new SqlInsertStmt(insert));
            }
            catch (FormaterException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            buff.append(";");
        }
        buff.append("\nEND ");
        buff.append(spName);
        buff.append("; ");
        boolean STATE_LINE_COMMENT = false;
        boolean STATE_MULTILINE_COMMENT = true;
        int STATE_BODY = 2;
        int state = 2;
        StringBuffer spBuff = new StringBuffer();
        int pramIndex = 0;
        int length = buff.length();
        block18: for (int i3 = 0; i3 < length; ++i3) {
            char ch = buff.charAt(i3);
            switch (state) {
                case 2: {
                    if (ch == '-' && i3 != length - 1 && buff.charAt(i3 + 1) == '-') {
                        state = 0;
                        spBuff.append(ch);
                        continue block18;
                    }
                    if (ch == '/' && i3 != length - 1 && buff.charAt(i3 + 1) == '*') {
                        state = 1;
                        spBuff.append(ch);
                        continue block18;
                    }
                    if (ch == '?') {
                        spBuff.append("P");
                        spBuff.append(pramIndex);
                        ++pramIndex;
                        continue block18;
                    }
                    spBuff.append(ch);
                    continue block18;
                }
                case 0: {
                    if (ch == '\n' || ch == '\r') {
                        state = 2;
                    }
                    spBuff.append(ch);
                    continue block18;
                }
                case 1: {
                    if (ch == '*' && i3 != length - 1 && buff.charAt(i3 + 1) == '/') {
                        state = 2;
                    }
                    spBuff.append(ch);
                    continue block18;
                }
                default: {
                    spBuff.append(ch);
                }
            }
        }
        if (assignToList.size() != pramIndex) {
            throw new BOSException("Fatal Error.");
        }
        String sp_sql = spBuff.toString();
        return sp_sql;
    }

    private void getParentKeyColumnList(List parentKeyColumnList, List parentColumnIndexList, ExecutePlan plan, int stepIndex) {
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(stepIndex);
        String stepPrefix = step.getEntityPrefix();
        for (int i = stepIndex - 1; i >= 0; --i) {
            ExecuteStep preStep = (ExecuteStep)plan.getSteps().get(i);
            EntityObjectInfo parentEntity = preStep.getEntity();
            LogicalKeyInfo parentLogicalKey = parentEntity.getLogicalKey();
            if (parentLogicalKey.getKeyPropertys().size() != 1) {
                throw new TODOException();
            }
            OwnPropertyInfo parentKeyProp = (OwnPropertyInfo)parentLogicalKey.getKeyPropertys().get(0);
            String preStepPrefix = preStep.getEntityPrefix();
            if (preStepPrefix != null && !stepPrefix.startsWith(preStepPrefix)) continue;
            String ident = preStepPrefix == null ? parentKeyProp.getName() : preStepPrefix + "." + parentKeyProp.getName();
            SelectItemInfo selectItem = null;
            int columnIndex = -1;
            List prefSelectItemList = preStep.getSelectItemList();
            int itemSize = prefSelectItemList.size();
            for (int j = 0; j < itemSize; ++j) {
                SelectItemInfo item = (SelectItemInfo)prefSelectItemList.get(j);
                if (!item.getIdent().equalsIgnoreCase(ident)) continue;
                selectItem = item;
                columnIndex = j;
                break;
            }
            if (selectItem == null) {
                throw new TODOException();
            }
            ColumnInfo column = selectItem.getColumnInfo();
            parentKeyColumnList.add(column);
            parentColumnIndexList.add(columnIndex);
        }
    }
}

