/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping_ex.runtime.QueryUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.CacheUtil;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlan;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlanAfterAction;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecuteStep;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.IPlanExecutor;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.SelectItemInfo;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.impl.AbstractPlanExecutor;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.MSTransactSQLFormater;
import com.kingdee.util.TODOException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MS_SQL_Server_PlanExecutor
extends AbstractPlanExecutor
implements IPlanExecutor {
    private static final Logger logger = Logger.getLogger(MS_SQL_Server_PlanExecutor.class);

    @Override
    protected void buildSql(Context ctx, ExecutePlan plan, StringBuffer rtnBuff, List assignToList, List literalValList) throws BOSException {
        String spName;
        block7: {
            Map spCacheMap;
            String key;
            block6: {
                key = plan.getKeyCode();
                spCacheMap = CacheUtil.getSPMap(ctx);
                if (!spCacheMap.containsKey(key)) break block6;
                spName = (String)spCacheMap.get(key);
                break block7;
            }
            spName = CacheUtil.buildName("ORM_SP", key);
            StringBuffer dropSpSqlBuff = new StringBuffer();
            dropSpSqlBuff.append("/*dialect*/");
            dropSpSqlBuff.append("\n");
            dropSpSqlBuff.append("if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[");
            dropSpSqlBuff.append(spName);
            dropSpSqlBuff.append("]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)");
            dropSpSqlBuff.append("\ndrop procedure [dbo].[");
            dropSpSqlBuff.append(spName);
            dropSpSqlBuff.append("]");
            String dropSpSql = dropSpSqlBuff.toString();
            String spSql = this.buildSpSql(ctx, spName, plan, assignToList, literalValList);
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = EJBFactory.getConnection(ctx);
                stmt = conn.createStatement();
                stmt.execute(dropSpSql);
                stmt.execute(spSql);
            }
            catch (SQLException e) {
                try {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            spCacheMap.put(key, spName);
            CacheUtil.registeSpToDb(ctx, key, spName, plan.getOQL(), plan.getEntity());
        }
        rtnBuff.append("EXEC ");
        rtnBuff.append(spName);
        rtnBuff.append(" ");
        int size = assignToList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                rtnBuff.append(", ");
            }
            rtnBuff.append('?');
        }
    }

    private String buildSpSql(Context ctx, String spName, ExecutePlan plan, List assignToList, List literalValList) throws BOSException {
        StringBuffer buff = new StringBuffer();
        buff.append("/*dialect*/");
        buff.append("\n");
        buff.append("CREATE PROCEDURE ");
        buff.append(spName);
        buff.append(" ");
        this.buildSpParam(plan, assignToList, literalValList, buff);
        buff.append("\nAS\nBEGIN\n");
        buff.append("/* \n");
        buff.append(plan.getOQL());
        buff.append("\n */\n");
        buff.append("\n");
        this.buildSpBodyMain(ctx, plan, buff);
        buff.append("\nEND");
        String sp_sql = this.buildCallSqSql(assignToList, buff);
        return sp_sql;
    }

    private String buildCallSqSql(List assignToList, StringBuffer buff) throws BOSException {
        boolean STATE_LINE_COMMENT = false;
        boolean STATE_MULTILINE_COMMENT = true;
        int STATE_BODY = 2;
        int state = 2;
        StringBuffer spBuff = new StringBuffer();
        int pramIndex = 0;
        int length = buff.length();
        block5: for (int i = 0; i < length; ++i) {
            char ch = buff.charAt(i);
            switch (state) {
                case 2: {
                    if (ch == '-' && i != length - 1 && buff.charAt(i + 1) == '-') {
                        state = 0;
                        spBuff.append(ch);
                        continue block5;
                    }
                    if (ch == '/' && i != length - 1 && buff.charAt(i + 1) == '*') {
                        state = 1;
                        spBuff.append(ch);
                        continue block5;
                    }
                    if (ch == '?') {
                        spBuff.append("@P");
                        spBuff.append(pramIndex);
                        ++pramIndex;
                        continue block5;
                    }
                    spBuff.append(ch);
                    continue block5;
                }
                case 0: {
                    if (ch == '\n' || ch == '\r') {
                        state = 2;
                    }
                    spBuff.append(ch);
                    continue block5;
                }
                case 1: {
                    if (ch == '*' && i != length - 1 && buff.charAt(i + 1) == '/') {
                        state = 2;
                    }
                    spBuff.append(ch);
                    continue block5;
                }
                default: {
                    spBuff.append(ch);
                }
            }
        }
        if (assignToList.size() != pramIndex) {
            throw new BOSException("Fatal Error.");
        }
        String sp_sql = spBuff.toString();
        return sp_sql;
    }

    private void buildSpBodyMain(Context ctx, ExecutePlan plan, StringBuffer buff) throws BOSException {
        List stepList = plan.getSteps();
        ArrayList stepColumnList = new ArrayList();
        int size = stepList.size();
        for (int i = 0; i < size; ++i) {
            ExecuteStep step = (ExecuteStep)stepList.get(i);
            if (i != 0) {
                buff.append("\n\n");
            }
            buff.append("/* \n");
            buff.append(step.getTabAliasMap().toString());
            buff.append("\n */\n");
            String stepPrefix = step.getEntityPrefix();
            String tabVar = "@TAB_" + i;
            ArrayList columnList = new ArrayList();
            if (i != size - 1) {
                this.buildDeclareTabSQL(ctx, buff, plan, i, columnList);
            }
            stepColumnList.add(columnList);
            buff.append("\n");
            if (i != 0) {
                EntityObjectInfo parentEntity;
                String parentEntityPrefix;
                ExecuteStep preStep = null;
                int prefStepIndex = 0;
                for (int j = i - 1; j >= 0; --j) {
                    ExecuteStep item = (ExecuteStep)stepList.get(j);
                    String itemPrefix = item.getEntityPrefix();
                    if (itemPrefix == null) {
                        preStep = item;
                        prefStepIndex = j;
                        break;
                    }
                    if (!stepPrefix.startsWith(itemPrefix) || stepPrefix.length() <= itemPrefix.length() || stepPrefix.charAt(itemPrefix.length()) != '.') continue;
                    preStep = item;
                    prefStepIndex = j;
                    break;
                }
                if (preStep == null) {
                    throw new BOSException("Fatal Error.");
                }
                int parentColumnIndex = -1;
                int lastIndex = stepPrefix.lastIndexOf(46);
                if (lastIndex == -1) {
                    parentEntityPrefix = null;
                    parentEntity = preStep.getEntity();
                } else {
                    parentEntityPrefix = stepPrefix.substring(0, lastIndex);
                    String[] parentEntityNameArray = parentEntityPrefix.split("\\.");
                    parentEntity = ORMUtils.getEntity(plan.getEntity(), parentEntityNameArray);
                }
                LogicalKeyInfo parentLogicalKey = parentEntity.getLogicalKey();
                if (parentLogicalKey.getKeyPropertys().size() != 1) {
                    throw new TODOException();
                }
                OwnPropertyInfo parentKeyProp = (OwnPropertyInfo)parentLogicalKey.getKeyPropertys().get(0);
                String ident = parentEntityPrefix == null ? parentKeyProp.getName() : parentEntityPrefix + "." + parentKeyProp.getName();
                List selectItemList = preStep.getSelectItemList();
                int itemSize = selectItemList.size();
                for (int j = 0; j < itemSize; ++j) {
                    SelectItemInfo selectItem = (SelectItemInfo)selectItemList.get(j);
                    if (!selectItem.getIdent().equalsIgnoreCase(ident)) continue;
                    parentColumnIndex = j;
                    break;
                }
                if (parentColumnIndex == -1) {
                    throw new TODOException();
                }
                String preVar = "@TAB_" + prefStepIndex;
                if (i != size - 1) {
                    buff.append("IF EXISTS (SELECT TOP 1 1 FROM ");
                    buff.append(preVar);
                    buff.append(") \n\t");
                }
                List parentNameColumnList = (List)stepColumnList.get(prefStepIndex);
                String fieldName = (String)parentNameColumnList.get(parentColumnIndex);
                String preTabAlias = "V_0";
                SqlTableSource tabSrc = new SqlTableSource(preVar);
                tabSrc.alias = preTabAlias;
                SqlBinaryOpExpr leftExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(fieldName));
                LinkPropertyInfo linkPropInfo = step.getLinkProperty();
                EntityObjectInfo propEntity = ORMUtils.getEntity(step.getParentEntity(), linkPropInfo.getName());
                RelationshipInfo relationship = linkPropInfo.getRelationship();
                PropertyInfo reversePropInfo = relationship.getChildProperty(propEntity);
                EntityObjectInfo childEntity = relationship.getChildObject(propEntity);
                EntityObjectInfo reversePropEntity = ORMUtils.getEntity(childEntity, reversePropInfo.getName());
                String tabName = reversePropEntity.getTable().getName();
                String entityPrefix = step.getEntityPrefix();
                String tabAliasKey = entityPrefix == null || entityPrefix.length() == 0 ? tabName : entityPrefix + '.' + tabName;
                String tabAlias = (String)step.getTabAliasMap().get(tabAliasKey);
                ColumnInfo column = reversePropInfo.getMappingField();
                column = ORMUtils.ensureColumnLoaded(ctx, column, reversePropEntity, reversePropInfo);
                String joinColumnName = column.getName();
                SqlBinaryOpExpr rightExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(joinColumnName));
                SqlBinaryOpExpr joinCondition = new SqlBinaryOpExpr((SqlExpr)leftExpr, 10, (SqlExpr)rightExpr);
                SqlSelect select = (SqlSelect)step.getSqlSelect();
                select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tabSrc, 0, (SqlExpr)joinCondition);
                int itemSize2 = step.getEntryFilterSelectItemList().size();
                for (int itemIndex = 0; itemIndex < itemSize2; ++itemIndex) {
                    SelectItemInfo selectItem = (SelectItemInfo)step.getEntryFilterSelectItemList().get(itemIndex);
                    String alias = "F" + select.selectList.size();
                    SqlSelectItem sqlSelectItem = new SqlSelectItem(selectItem.getSqlExpr(), alias);
                    select.selectList.add(sqlSelectItem);
                }
                ArrayList parentColumnList = new ArrayList();
                ArrayList parentColumnIndexList = new ArrayList();
                this.getParentKeyColumnList(parentColumnList, parentColumnIndexList, plan, i);
                int parentColumnListSize = parentColumnList.size();
                for (int j = 0; j < parentColumnListSize; ++j) {
                    Integer columnIndex = (Integer)parentColumnIndexList.get(j);
                    String columnName = "F" + columnIndex;
                    columnName = (String)parentNameColumnList.get(columnIndex);
                    SqlSelectItem sqlSelectItem = new SqlSelectItem();
                    sqlSelectItem.expr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(preTabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                    select.selectList.add(sqlSelectItem);
                }
            }
            if (i == size - 1) {
                ExecutePlanAfterAction action;
                for (int stepIndex = 0; stepIndex < size - 1; ++stepIndex) {
                    String tempStepPrefix;
                    ExecutePlanAfterAction action2;
                    ExecuteStep tempStep = (ExecuteStep)plan.getSteps().get(stepIndex);
                    buff.append("SELECT ");
                    boolean commaFlag = false;
                    int tempSize = tempStep.getSelectItemList().size();
                    for (int selectItemIndex = 0; selectItemIndex < tempSize; ++selectItemIndex) {
                        SelectItemInfo selectItem = (SelectItemInfo)tempStep.getSelectItemList().get(selectItemIndex);
                        if (commaFlag) {
                            buff.append(", ");
                        }
                        try {
                            SqlExpr sqlExpr = QueryUtil.replaceExpr(selectItem.getSqlExpr(), tempStep.getColumnMap());
                            String columnName = QueryUtil.sqlExprToString(sqlExpr);
                            buff.append(columnName);
                        }
                        catch (BOSException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                            throw new TODOException();
                        }
                        commaFlag = true;
                    }
                    List currentStepColumnNameList = (List)stepColumnList.get(stepIndex);
                    ArrayList parentKeyColumnList = new ArrayList();
                    ArrayList parentKeyColumnIndexList = new ArrayList();
                    this.getParentKeyColumnList(parentKeyColumnList, parentKeyColumnIndexList, plan, stepIndex);
                    int columnListSize = currentStepColumnNameList.size();
                    for (int j = currentStepColumnNameList.size() - parentKeyColumnList.size(); j < columnListSize; ++j) {
                        if (commaFlag) {
                            buff.append(", ");
                        }
                        String keyColumnName = (String)currentStepColumnNameList.get(j);
                        buff.append(keyColumnName);
                        commaFlag = true;
                    }
                    buff.append(" FROM ");
                    buff.append("@TAB_" + stepIndex);
                    Map actionMap = plan.getAfterActionsByDirect();
                    if (actionMap != null && (action2 = (ExecutePlanAfterAction)actionMap.get(tempStepPrefix = tempStep.getEntityPrefix())) != null) {
                        buff.append(" WHERE ");
                        try {
                            new MSTransactSQLFormater(buff).formatExpr(action2.getFilter());
                        }
                        catch (FormaterException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                            throw new BOSException(e.getMessage(), (Throwable)e);
                        }
                    }
                    buff.append("\n");
                }
                try {
                    new MSTransactSQLFormater(buff).formatSelectBase(step.getSqlSelect());
                }
                catch (FormaterException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                Map actionMap = plan.getAfterActionsByDirect();
                if (actionMap == null || (action = (ExecutePlanAfterAction)actionMap.get(stepPrefix)) == null) continue;
                throw new TODOException();
            }
            SqlInsert insert = new SqlInsert(tabVar);
            insert.subQuery = step.getSqlSelect();
            try {
                new MSTransactSQLFormater(buff).formatInsertStmt(new SqlInsertStmt(insert));
                continue;
            }
            catch (FormaterException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void buildSpParam(ExecutePlan plan, List assignToList, List literalValList, StringBuffer buff) {
        int size = assignToList.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropInfo;
            if (i != 0) {
                buff.append(", ");
            }
            String pramName = "@P" + i;
            buff.append(pramName);
            buff.append(' ');
            String assignTo = (String)assignToList.get(i);
            if (assignTo == null) {
                throw new TODOException();
            }
            PropertyInfo propInfo = null;
            String[] propNameArray = assignTo.split("\\.");
            EntityObjectInfo propEntity = plan.getEntity();
            for (int j = 0; j < propNameArray.length; ++j) {
                String itemPropName = propNameArray[j];
                propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
                if (j >= propNameArray.length - 1) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                propEntity = relationship.getChildObject(propEntity);
            }
            if (propInfo instanceof OwnPropertyInfo) {
                ownPropInfo = (OwnPropertyInfo)propInfo;
            } else if (propInfo instanceof LinkPropertyInfo) {
                OwnPropertyInfo keyProp;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                EntityObjectInfo childEntity = relationship.getChildObject(propEntity);
                LogicalKeyInfo logicalKey = childEntity.getLogicalKey();
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) {
                    throw new TODOException();
                }
                ownPropInfo = keyProp = (OwnPropertyInfo)keyPropCol.get(0);
            } else {
                throw new TODOException();
            }
            ColumnInfo column = ownPropInfo.getMappingField();
            SQLType sqlType = column.getTypeName();
            if (sqlType.equals((Object)SQLType.CHAR) || sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.NVARCHAR) || sqlType.equals((Object)SQLType.BINARY) || sqlType.equals((Object)SQLType.VARBINARY)) {
                buff.append(sqlType.getName());
                buff.append(" (");
                buff.append(column.getLength());
                buff.append(")");
                continue;
            }
            if (sqlType.equals((Object)SQLType.NUMERIC)) {
                buff.append("DECIMAL (");
                buff.append(column.getPrecision());
                buff.append(", ");
                buff.append(column.getScale());
                buff.append(")");
                continue;
            }
            if (sqlType.equals((Object)SQLType.DATETIME)) {
                buff.append("DATETIME");
                continue;
            }
            if (sqlType.equals((Object)SQLType.INT)) {
                buff.append("INT");
                continue;
            }
            throw new TODOException();
        }
    }

    private void appendSelectItem(StringBuffer buff, String columnName, ColumnInfo column, String comment) {
        buff.append("\t");
        buff.append(columnName);
        buff.append(" ");
        SQLType sqlType = column.getTypeName();
        if (sqlType.equals((Object)SQLType.NCLOB)) {
            buff.append("NTEXT");
        } else if (sqlType.equals((Object)SQLType.CLOB)) {
            buff.append("TEXT");
        } else if (sqlType.equals((Object)SQLType.BLOB)) {
            buff.append("IMAGE");
        } else {
            buff.append(sqlType.getName());
        }
        if (sqlType.equals((Object)SQLType.CHAR) || sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.NVARCHAR)) {
            buff.append("(");
            buff.append(column.getLength());
            buff.append(")");
        } else if (sqlType.equals((Object)SQLType.NUMERIC) && column.getPrecision() > 0) {
            buff.append("(");
            buff.append(column.getPrecision());
            if (column.getScale() > 0) {
                buff.append(", ");
                buff.append(column.getScale());
            }
            buff.append(")");
        }
        buff.append(comment);
    }

    private void buildDeclareTabSQL(Context ctx, StringBuffer buff, ExecutePlan plan, int stepIndex, List columnNameList) throws BOSException {
        String comment;
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(stepIndex);
        String tabVar = "@TAB_" + stepIndex;
        buff.append("DECLARE " + tabVar);
        buff.append(" TABLE (\n");
        List selectItemList = step.getSelectItemList();
        int itemSize = selectItemList.size();
        for (int i = 0; i < itemSize; ++i) {
            if (i != 0) {
                buff.append(" , \n");
            }
            SelectItemInfo selectItem = (SelectItemInfo)selectItemList.get(i);
            String comment2 = " /* " + selectItem.getIdent() + "*/";
            ColumnInfo column = selectItem.getColumnInfo();
            column = ORMUtils.ensureColumnLoaded(ctx, column, selectItem.getEntity(), selectItem.getPropInfo());
            selectItem.setColumnInfo(column);
            StringBuffer columnName = new StringBuffer();
            String sqlExprStr = QueryUtil.sqlExprToString(selectItem.getSqlExpr());
            String tempColumnName = (String)step.getColumnMap().get(sqlExprStr);
            if (tempColumnName == null) {
                columnName.append("F").append(i).append("_");
                while (columnNameList.contains(columnName)) {
                    columnName.append("_");
                }
            } else {
                columnName.append(tempColumnName);
            }
            columnNameList.add(columnName.toString());
            this.appendSelectItem(buff, columnName.toString(), column, comment2);
        }
        int columnIndex = selectItemList.size();
        int itemSize2 = step.getEntryFilterSelectItemList().size();
        for (int i = 0; i < itemSize2; ++i) {
            String columnName;
            buff.append(" , \n");
            SelectItemInfo selectItem = (SelectItemInfo)step.getEntryFilterSelectItemList().get(i);
            String sqlExprStr = QueryUtil.sqlExprToString(selectItem.getSqlExpr());
            String tempColumnName = (String)step.getColumnMap().get(sqlExprStr);
            comment = " /* " + selectItem.getIdent() + "*/";
            ColumnInfo column = selectItem.getColumnInfo();
            column = ORMUtils.ensureColumnLoaded(ctx, column, selectItem.getEntity(), selectItem.getPropInfo());
            selectItem.setColumnInfo(column);
            if (tempColumnName == null) {
                columnName = "F" + i + "_";
                while (columnNameList.contains(columnName)) {
                    columnName = columnName + "_";
                }
            } else {
                columnName = tempColumnName;
            }
            columnNameList.add(columnName);
            this.appendSelectItem(buff, columnName, column, comment);
        }
        ArrayList parentKeyColumnList = new ArrayList();
        ArrayList parentKeyColumnIndexList = new ArrayList();
        this.getParentKeyColumnList(parentKeyColumnList, parentKeyColumnIndexList, plan, stepIndex);
        int size = parentKeyColumnList.size();
        for (int parentKeyColumnIndex = 0; parentKeyColumnIndex < size; ++parentKeyColumnIndex) {
            buff.append(" , \n");
            ColumnInfo parentColumn = (ColumnInfo)parentKeyColumnList.get(parentKeyColumnIndex);
            comment = " /* parentKeyColumn : " + parentColumn.getName() + " */ ";
            String columnName = "F" + columnIndex;
            while (columnNameList.contains(columnName)) {
                columnName = columnName + "_";
            }
            columnNameList.add(columnName);
            this.appendSelectItem(buff, columnName, parentColumn, comment);
            ++columnIndex;
        }
        buff.append("\n)");
    }

    private void getParentKeyColumnList(List parentKeyColumnList, List parentColumnIndexList, ExecutePlan plan, int stepIndex) {
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(stepIndex);
        String stepPrefix = step.getEntityPrefix();
        ExecuteStep parentStep = null;
        if (stepIndex > 0) {
            for (int i = stepIndex - 1; i >= 0; --i) {
                ExecuteStep preStep = (ExecuteStep)plan.getSteps().get(i);
                String entityPrefix = preStep.getEntityPrefix();
                if (entityPrefix != null && entityPrefix.length() != 0 && (!stepPrefix.startsWith(entityPrefix) || stepPrefix.charAt(entityPrefix.length()) != '.')) continue;
                parentStep = preStep;
                break;
            }
        }
        int parentSelectItemOffSet = 0;
        for (int i = stepIndex - 1; i >= 0; --i) {
            ColumnInfo column;
            ExecuteStep preStep = (ExecuteStep)plan.getSteps().get(i);
            EntityObjectInfo parentEntity = preStep.getEntity();
            LogicalKeyInfo parentLogicalKey = parentEntity.getLogicalKey();
            if (parentLogicalKey.getKeyPropertys().size() != 1) {
                throw new TODOException();
            }
            OwnPropertyInfo parentKeyProp = (OwnPropertyInfo)parentLogicalKey.getKeyPropertys().get(0);
            String preStepPrefix = preStep.getEntityPrefix();
            if (preStepPrefix != null && !stepPrefix.startsWith(preStepPrefix)) continue;
            String ident = preStepPrefix == null ? parentKeyProp.getName() : preStepPrefix + "." + parentKeyProp.getName();
            SelectItemInfo selectItem = null;
            int columnIndex = -1;
            List prefSelectItemList = parentStep.getSelectItemList();
            int itemSize = prefSelectItemList.size();
            for (int j = 0; j < itemSize; ++j) {
                SelectItemInfo item = (SelectItemInfo)prefSelectItemList.get(j);
                if (!item.getIdent().equalsIgnoreCase(ident)) continue;
                selectItem = item;
                columnIndex = j;
                break;
            }
            if (selectItem == null) {
                columnIndex = prefSelectItemList.size() + parentSelectItemOffSet++;
                column = parentKeyProp.getMappingField();
                parentKeyColumnList.add(column);
                parentColumnIndexList.add(columnIndex);
                continue;
            }
            column = selectItem.getColumnInfo();
            parentKeyColumnList.add(column);
            parentColumnIndexList.add(columnIndex);
        }
    }
}

