/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryEngine;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalDataQueryResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.TypeInfo;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ObjectQueryEngine;
import com.kingdee.bos.dao.ormapping_ex.service.IOrmService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OrmService
extends AbstractBOSObject
implements IOrmService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.dao.ormapping_ex.service.OrmService");

    public OrmService() {
        super.registerInterface(IOrmService.class, (Object)this);
    }

    public OrmService(Context ctx) {
        super(ctx);
        super.registerInterface(IOrmService.class, (Object)this);
    }

    public BOSObjectType getType() {
        return IOrmService.BOSTYPE;
    }

    @Override
    public IObjectCollection getCollection(BOSObjectType bosType, String oql) throws BOSException {
        IObjectCollection objCol;
        Connection conn = null;
        try {
            long begin = System.currentTimeMillis();
            conn = EJBFactory.getConnection(this.getContext());
            ObjectQueryEngine engine = new ObjectQueryEngine(this.getContext(), conn);
            objCol = engine.getCollection(bosType, oql);
            long end = System.currentTimeMillis();
            long timespan = end - begin;
            log.info((Object)("new timespan : " + timespan));
        }
        catch (SQLException e) {
            try {
                log.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return objCol;
    }

    @Override
    public IObjectCollection getCollection_old(BOSObjectType bosType, String oql) throws BOSException {
        IObjectCollection objCol;
        Context ctx = this.getContext();
        Connection conn = null;
        long begin = System.currentTimeMillis();
        try {
            conn = EJBFactory.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, conn);
            objCol = dao.getCollection(oql);
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        long end = System.currentTimeMillis();
        long timespan = end - begin;
        log.info((Object)("old timespan : " + timespan));
        return objCol;
    }

    @Override
    public void getCollectionNotReturn(BOSObjectType bosType, String oql) throws BOSException {
        Context ctx = this.getContext();
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection(ctx);
            ObjectQueryEngine engine = new ObjectQueryEngine(this.getContext(), conn);
            long begin = System.currentTimeMillis();
            IObjectCollection objCol = engine.getCollection(bosType, oql);
            long end = System.currentTimeMillis();
            long timespan = end - begin;
            log.info((Object)("new timespan : " + timespan + ", objCol.size : " + objCol.size()));
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    public void getCollectionNotReturn_old(BOSObjectType bosType, String oql) throws BOSException {
        IObjectCollection objCol;
        Context ctx = this.getContext();
        Connection conn = null;
        long begin = System.currentTimeMillis();
        try {
            conn = EJBFactory.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance(bosType, ctx, conn);
            objCol = dao.getCollection(oql);
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        long end = System.currentTimeMillis();
        long timespan = end - begin;
        log.info((Object)("old timespan : " + timespan + ", objCol.size : " + objCol.size()));
    }

    @Override
    public void testDataQuery(String oql) throws BOSException {
        DataQueryEngine engine = new DataQueryEngine(this.getContext());
        InternalDataQueryResult result = engine.buildInternalResult(oql);
        TypeInfo[] typeInfoArray = result.getTypeInfoArray();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("----------- " + i + " -----------"));
            log.debug((Object)("name : " + typeInfoArray[i].getName()));
            log.debug((Object)("alias : " + typeInfoArray[i].getAlias()));
            log.debug((Object)("dataType : " + typeInfoArray[i].getDataType().getName()));
            log.debug((Object)("sqlType : " + typeInfoArray[i].getSqlType()));
        }
        log.info((Object)result.getSql());
    }
}

