/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query;

import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.util.Locale;

public class BizEnumValueDTO
extends BizEnumValueInfo {
    public static BizEnumValueDTO createDTO(BizEnumValueInfo bizEnum) {
        if (bizEnum == null) {
            return null;
        }
        BizEnumValueDTO dto = new BizEnumValueDTO();
        dto.setName(bizEnum.getName());
        dto.setValue(bizEnum.getValue());
        Locale[] locs = bizEnum.getCurrentLocales();
        int n = locs.length;
        for (int i = 0; i < n; ++i) {
            dto.put("alias", bizEnum.getAlias(locs[i]), locs[i]);
        }
        return dto;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.getName());
        marshaller.writeObject(this.getValue());
        Locale[] locs = this.getCurrentLocales();
        marshaller.writeInt(locs.length);
        int n = locs.length;
        for (int i = 0; i < n; ++i) {
            marshaller.writeObject((Object)locs[i]);
            marshaller.writeObject((Object)this.getAlias(locs[i]));
        }
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.setName((String)unmarshaller.readObject());
        this.setValue(unmarshaller.readObject());
        int locLen = unmarshaller.readInt();
        for (int i = 0; i < locLen; ++i) {
            Locale loc = (Locale)unmarshaller.readObject();
            String alias = (String)unmarshaller.readObject();
            this.put("alias", alias, loc);
        }
    }
}

