/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IOQLDataAccess;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.IVirtualModeDataAccess;
import com.kingdee.bos.dao.query.server.OQLDataAccessFactory;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.dao.query.server.VirtualModeDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class QueryExecutor
implements IQueryExecutor {
    private static final int ZERO = 0;
    private final Context ctx;
    private final Context objectCtx;
    private final IMetaDataPK pk;
    private final String oql;
    private EntityViewInfo view;
    private Map views;
    protected final Map parameters;
    protected final QueryExecuteOption option;
    private boolean isUsedSql = false;
    private String sql;
    private List pkField;
    private static final Logger logger = Logger.getLogger(QueryExecutor.class);

    QueryExecutor(IMetaDataPK pk) {
        this(null, pk, null);
    }

    QueryExecutor(IMetaDataPK pk, Context objectCtx) {
        this(pk, null, objectCtx);
    }

    QueryExecutor(String oql) {
        this(null, null, oql);
    }

    QueryExecutor(String oql, Context objectCtx) {
        this(null, oql, objectCtx);
    }

    QueryExecutor(Context ctx, String oql) {
        this(ctx, null, oql);
    }

    QueryExecutor(Context ctx, IMetaDataPK pk) {
        this(ctx, pk, null);
    }

    QueryExecutor(Context ctx, IMetaDataPK pk, String oql) {
        this.ctx = ctx;
        this.objectCtx = null;
        this.pk = pk;
        this.parameters = new HashMap();
        this.option = new QueryExecuteOption();
        this.oql = oql;
        this.views = new HashMap();
        this.isUsedSql = false;
    }

    QueryExecutor(IMetaDataPK pk, String oql, Context objectCtx) {
        this.ctx = null;
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        this.objectCtx = objectCtx;
        this.pk = pk;
        this.parameters = new HashMap();
        this.option = new QueryExecuteOption();
        this.oql = oql;
        this.views = new HashMap();
        this.isUsedSql = false;
    }

    QueryExecutor(String sql, List pkField) {
        this(null, sql, pkField, null);
    }

    QueryExecutor(Context ctx, String sql, List pkField) {
        this(ctx, sql, pkField, null);
    }

    QueryExecutor(String sql, List pkField, Context objectCtx) {
        this(null, sql, pkField, objectCtx);
    }

    QueryExecutor(Context ctx, String sql, List pkField, Context objectCtx) {
        this.ctx = ctx;
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        this.objectCtx = objectCtx;
        this.option = new QueryExecuteOption();
        this.parameters = new HashMap();
        this.pk = null;
        this.oql = null;
        this.sql = sql;
        this.pkField = pkField;
        this.isUsedSql = true;
    }

    @Override
    public void setParameter(int index, Object value) throws BOSException {
        this.parameters.put(index, value);
    }

    @Override
    public IRowSet executeQuery(List keyList) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return null;
        }
        return qda.getRowSet(this.pk, MetaDataTypeList.BASEQUERY, (List<String>)keyList, this.view, this.views, this.option);
    }

    @Override
    public IRowSet executeQuery(int start, int length) throws BOSException {
        if (this.pk != null) {
            return this.executeQueryByPK(start, length);
        }
        if (!StringUtils.isEmpty((String)this.oql)) {
            return this.executeQueryByOQL(start, length);
        }
        throw new BOSException("Can't found MetaDataPK or OQL,Query Engine don't work!");
    }

    private IRowSet executeQueryByOQL(int start, int length) throws BOSException {
        IOQLDataAccess oql = OQLDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        IRowSet set = oql.getRowSet(this.oql, this.option, start, length);
        return set;
    }

    private IRowSet executeQueryByPK(int start, int length) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        IRowSet set = null;
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            set = qda.getRowSet(this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option, start, length);
        } else {
            if (this.view == null) {
                this.view = new EntityViewInfo();
            }
            set = qda.getRowSet(this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option, start, length);
        }
        return set;
    }

    @Override
    public Uuid openQuery() throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        Uuid uuid = null;
        if (this.isUsedSql) {
            uuid = qda.openQuery(this.sql, this.pkField, this.option);
        } else {
            if (this.view != null && this.views.size() != 0) {
                throw new BOSException("Can't set views and view at one time!");
            }
            if (this.views.size() != 0) {
                uuid = qda.openQuery(this.pk, MetaDataTypeList.BASEQUERY, null, this.views, this.parameters, this.option);
            } else {
                if (this.view == null) {
                    this.view = new EntityViewInfo();
                }
                uuid = qda.openQuery(this.pk, MetaDataTypeList.BASEQUERY, this.view, null, this.parameters, this.option);
            }
        }
        return uuid;
    }

    @Override
    public QueryExecuteOption option() {
        return this.option;
    }

    @Override
    public EntityViewInfo getObjectView() {
        return this.view;
    }

    @Override
    public void setObjectView(EntityViewInfo view) {
        this.view = view;
    }

    @Override
    public void setObjectView(String oql) throws BOSException {
        try {
            this.view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            logger.error((Object)"parser oql error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void setEntityView(String objName, EntityViewInfo view) throws BOSException {
        this.views.put(objName, view);
    }

    @Override
    public EntityViewInfo getEntityView(String objName) {
        return (EntityViewInfo)this.views.get(objName);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID) throws BOSException {
        return this.getQueryKeys(querySessionID, 0);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID, int length) throws BOSException {
        return this.getQueryKeys(querySessionID, 0, length);
    }

    @Override
    public IRowSet executeQuery() throws BOSException {
        return this.executeQuery(0, Integer.MAX_VALUE);
    }

    @Override
    public String getSQL() throws BOSException {
        String sql = "";
        if (this.isUsedSql) {
            sql = this.sql;
        } else if (this.pk != null) {
            IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
            if (this.views.size() != 0) {
                sql = qda.getQuerySql(this.pk, this.views, this.option);
            } else {
                if (this.view == null) {
                    this.view = new EntityViewInfo();
                }
                sql = qda.getQuerySql(this.pk, this.view, this.option);
            }
        } else if (!StringUtils.isEmpty((String)this.oql)) {
            IOQLDataAccess oql = OQLDataAccessFactory.getInstance(this.ctx, this.objectCtx);
            sql = oql.getSQL(this.oql);
        } else {
            throw new BOSException("Can't found MetaDataPK or OQL,Query Engine don't work!");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseQueryCache(Uuid querySessionID) {
        IVirtualModeDataAccess qda = null;
        try {
            qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        }
        catch (BOSException e) {
            logger.error((Object)"VirtualModeDataAccessFactory.getInstance(ctx) occur error: ", (Throwable)e);
        }
        finally {
            if (qda != null) {
                qda.closeQuery(querySessionID);
            }
        }
    }

    @Override
    public boolean isDefineLogicalKey() throws BOSException {
        QueryInfo query = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getQuery(this.pk);
        return query.getQueryPK() != null;
    }

    @Override
    public boolean hasResult() throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        boolean result = false;
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            result = qda.hasResult(this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option);
        } else {
            if (this.view == null) {
                this.view = new EntityViewInfo();
            }
            result = qda.hasResult(this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option);
        }
        return result;
    }

    @Override
    public IRowSet executeQuery(Uuid querySessionID, int start, int length) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.getRowSet(querySessionID, this.sql, (List<String>)this.pkField, this.option, start, length);
        }
        return qda.getRowSet(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, start, length);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID, int start, int length) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.getQueryPKList(querySessionID, this.sql, this.pkField, this.option, start, length);
        }
        return qda.getQueryPKList(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, start, length);
    }

    @Override
    public int getRowCount() throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.getRowCount(this.sql, this.parameters, this.option);
        }
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            return qda.getRowCount(this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option);
        }
        if (this.view == null) {
            this.view = new EntityViewInfo();
        }
        return qda.getRowCount(this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option);
    }

    @Override
    public int getRowCount(Uuid querySessionID) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.getRowCount(querySessionID, this.sql, this.pkField, this.option);
        }
        return qda.getRowCount(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option);
    }

    @Override
    public int getRowCountByFields(Uuid querySessionID, String[] fields) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCountByFields(querySessionID, fields);
    }

    @Override
    public int getRowCountByFields(String[] fields) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            return qda.getRowCount(this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option, fields);
        }
        if (this.view == null) {
            this.view = new EntityViewInfo();
        }
        return qda.getRowCount(this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option, fields);
    }

    @Override
    public IRowSet sum(String queryCacheid, QueryFieldInfo[] fields) throws BOSException {
        if (fields == null || fields.length == 0) {
            throw new BOSException("no specify fileds be found.");
        }
        String[] fs = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fs[i] = fields[i].getName();
        }
        return this.sum(queryCacheid, fs);
    }

    @Override
    public IRowSet sum(QueryFieldInfo[] fields) throws BOSException {
        return this.sum(null, fields);
    }

    @Override
    public IRowSet sum(String queryCacheid, String[] fields) throws BOSException {
        if (fields == null || fields.length == 0) {
            throw new BOSException("no specify fileds be found.");
        }
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            return qda.sum(queryCacheid, this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option, fields);
        }
        if (this.view == null) {
            this.view = new EntityViewInfo();
        }
        return qda.sum(queryCacheid, this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option, fields);
    }

    @Override
    public IRowSet sum(String[] fields) throws BOSException {
        return this.sum(null, fields);
    }

    @Override
    public Map doAllQueryTask(Uuid uuid, int start, int length, String[] fields, boolean isFirstTime, String keyFieldName) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.doAllQueryTask(uuid, start, length, this.sql, this.pkField, this.option, fields, isFirstTime);
        }
        return qda.doAllQueryTask(uuid, start, length, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, fields, isFirstTime, keyFieldName);
    }

    @Override
    public Map doAllQueryTask(Uuid uuid, int start, int length, String[] fields, boolean isFirstTime) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.isUsedSql) {
            return qda.doAllQueryTask(uuid, start, length, this.sql, this.pkField, this.option, fields, isFirstTime);
        }
        return qda.doAllQueryTask(uuid, start, length, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, fields, isFirstTime, null);
    }

    @Override
    public List getBillIDList(Uuid querySessionID, String idFieldName, int start, int length) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getBillIDList(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, idFieldName, start, length);
    }

    @Override
    public int indexOfBillID(Uuid querySessionID, String idFieldName, BOSUuid billid) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.indexOfBillID(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, idFieldName, billid);
    }

    @Override
    public void removeBillID(Uuid querySessionID, String idFieldName, BOSUuid billid) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        qda.removeBillID(querySessionID, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, idFieldName, billid);
    }

    private void checkEmptyFilter() {
        boolean b3;
        boolean b1 = this.view == null || this.view.getFilter() == null || this.view.getFilter().getFilterItems() == null || this.view.getFilter().getFilterItems().isEmpty();
        boolean b2 = this.views.isEmpty();
        boolean bl = b3 = this.option.topCount == 0;
        if (b1 && b2 && b3) {
            logger.warn((Object)"query filter is empty", new Throwable());
        }
    }

    @Override
    public IRowSet executeQueryForRealPage(int start, int length) throws BOSException {
        if (this.isUsedSql) {
            return this.executeQueryBySql(start, length);
        }
        if (this.pk != null) {
            return this.executeQueryByPKForRealPage(start, length);
        }
        if (!StringUtils.isEmpty((String)this.oql)) {
            return this.executeQueryByOQLForRealPage(start, length);
        }
        throw new BOSException("Can't found MetaDataPK or OQL,Query Engine don't work!");
    }

    private IRowSet executeQueryByOQLForRealPage(int start, int length) throws BOSException {
        return this.executeQueryByOQL(start, length);
    }

    private IRowSet executeQueryByPKForRealPage(int start, int length) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        IRowSet set = null;
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (this.views.size() != 0) {
            set = qda.getRowSetForRealPage(this.pk, this.views, (Map<Integer, Object>)this.parameters, this.option, start, length);
        } else {
            if (this.view == null) {
                this.view = new EntityViewInfo();
            }
            set = qda.getRowSetForRealPage(this.pk, this.view, (Map<Integer, Object>)this.parameters, this.option, start, length);
        }
        return set;
    }

    private IRowSet executeQueryBySql(int start, int length) throws BOSException {
        if (StringUtils.isEmpty((String)this.sql)) {
            return null;
        }
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowSetForRealPage(this.sql, this.parameters, this.option, start, length);
    }

    @Override
    public Map getRowCountAsyn(Uuid uuid, int rowCount, boolean isIgnoreRowCount) throws BOSException {
        this.checkEmptyFilter();
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCountAsyn(uuid, this.pk, MetaDataTypeList.BASEQUERY, this.view, this.views, this.parameters, this.option, rowCount, isIgnoreRowCount);
    }

    public IRowSet groupbyAndCount(QueryFieldInfo countField, QueryFieldInfo groupbyField) throws BOSException {
        return null;
    }

    @Override
    public IRowSet groupbyAndAgg(QueryFieldInfo[] selectorFields, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo[] groupbyFields) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        return qda.groupbyAndAgg(this.pk, this.view, this.views, this.parameters, this.option, selectorFields, aggFields, aggFuns, groupbyFields);
    }

    @Override
    public IRowSet groupbyTime(QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo timeField, int[] timeSegments, int rowCount) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        if (this.view != null && this.views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        return qda.groupbyTime(this.pk, this.view, this.views, this.parameters, this.option, aggFields, aggFuns, timeField, timeSegments, rowCount);
    }
}

