/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query;

import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.ICustomEnumInfoProvider;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class QueryHelper {
    private static final String CONFIGFILE_NAME = "customEnumInfoForQuery.properties";
    private static final String EAS_DEPLOY = "eas.deploy";
    private static Properties properties;
    private static final Logger logger;

    private QueryHelper() {
    }

    private static ICustomEnumInfoProvider getCustomEnumInfoProvider(String clazzName) {
        String value;
        if (properties != null && (value = properties.getProperty(clazzName)) != null) {
            Object rtn = null;
            try {
                Class<?> clazz = Class.forName(value);
                rtn = clazz.newInstance();
            }
            catch (Exception e) {
                rtn = null;
            }
            if (rtn instanceof ICustomEnumInfoProvider) {
                return rtn;
            }
        }
        return null;
    }

    public static String addMark(String item) {
        return "\"" + item + "\"";
    }

    private static String getEnumClass(BizEnumInfo bizEnum) {
        String clazz = bizEnum.getClassName();
        if (clazz == null) {
            String msg = "Enum's class is null. Check enum:" + bizEnum.getFullName();
            logger.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        return clazz;
    }

    public static BizEnumValueInfo getAliasFromEnumValue(BizEnumInfo bizEnum, String value) {
        BizEnumValueInfo v;
        ICustomEnumInfoProvider provider = QueryHelper.getCustomEnumInfoProvider(QueryHelper.getEnumClass(bizEnum));
        if (provider != null && (v = provider.getEnumValue(value)) != null) {
            return QueryHelper.toDTO(v);
        }
        BizEnumValueInfo enumValue = bizEnum.getInnerEnumValue(value);
        return QueryHelper.toDTO(enumValue);
    }

    public static BizEnumValueInfo getAliasFromEnumValue(BizEnumInfo bizEnum, int value) {
        BizEnumValueInfo v;
        ICustomEnumInfoProvider provider = QueryHelper.getCustomEnumInfoProvider(QueryHelper.getEnumClass(bizEnum));
        if (provider != null && (v = provider.getEnumValue(value)) != null) {
            return QueryHelper.toDTO(v);
        }
        BizEnumValueInfo enumValue = bizEnum.getInnerEnumValue(value);
        return QueryHelper.toDTO(enumValue);
    }

    public static BizEnumValueInfo getAliasFromEnumValue(BizEnumInfo bizEnum, long value) {
        BizEnumValueInfo v;
        ICustomEnumInfoProvider provider = QueryHelper.getCustomEnumInfoProvider(QueryHelper.getEnumClass(bizEnum));
        if (provider != null && (v = provider.getEnumValue(value)) != null) {
            return QueryHelper.toDTO(v);
        }
        BizEnumValueInfo enumValue = bizEnum.getInnerEnumValue(value);
        return QueryHelper.toDTO(enumValue);
    }

    public static BizEnumValueInfo getAliasFromEnumValue(BizEnumInfo bizEnum, double value) {
        BizEnumValueInfo v;
        ICustomEnumInfoProvider provider = QueryHelper.getCustomEnumInfoProvider(QueryHelper.getEnumClass(bizEnum));
        if (provider != null && (v = provider.getEnumValue(value)) != null) {
            return QueryHelper.toDTO(v);
        }
        BizEnumValueInfo enumValue = bizEnum.getInnerEnumValue(value);
        return QueryHelper.toDTO(enumValue);
    }

    public static BizEnumValueInfo getAliasFromEnumValue(BizEnumInfo bizEnum, float value) {
        BizEnumValueInfo v;
        ICustomEnumInfoProvider provider = QueryHelper.getCustomEnumInfoProvider(QueryHelper.getEnumClass(bizEnum));
        if (provider != null && (v = provider.getEnumValue(value)) != null) {
            return QueryHelper.toDTO(v);
        }
        BizEnumValueInfo enumValue = bizEnum.getInnerEnumValue(value);
        return QueryHelper.toDTO(enumValue);
    }

    private static final BizEnumValueInfo toDTO(BizEnumValueInfo enumValue) {
        return BizEnumValueDTO.createDTO(enumValue);
    }

    public static boolean isIdentifierExpr(Object expr) {
        if (expr instanceof SqlIdentifierExpr) {
            return true;
        }
        return expr instanceof SqlBinaryOpExpr && ((SqlBinaryOpExpr)expr).operator == 20 && QueryHelper.isIdentifierExpr(((SqlBinaryOpExpr)expr).left) && QueryHelper.isIdentifierExpr(((SqlBinaryOpExpr)expr).right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block10: {
            logger = Logger.getLogger(QueryHelper.class);
            try {
                if (System.getProperty(EAS_DEPLOY) != null || !"".equalsIgnoreCase(System.getProperty(EAS_DEPLOY).trim())) {
                    String configFilePath = System.getProperty(EAS_DEPLOY) + "/" + CONFIGFILE_NAME;
                    InputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(new File(configFilePath));
                        properties = new Properties();
                        properties.load(inputStream);
                        break block10;
                    }
                    catch (FileNotFoundException e) {
                        logger.warn((Object)("load customEnumInfoForQuery.properties error: " + e.getMessage()));
                        break block10;
                    }
                    catch (IOException e) {
                        logger.warn((Object)("load customEnumInfoForQuery.properties error: " + e.getMessage()));
                        break block10;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                logger.warn((Object)"can't find the value of 'eas.deploy(system property)',please check the enviroment");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

