/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.PropertyRefDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.shell.KSQLSettingFactory;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BaseDataAccess
extends AbstractBOSObject {
    public static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.query.server.BaseDataAccess");

    public BaseDataAccess(Context ctx) {
        super(ctx);
    }

    public BaseDataAccess() {
    }

    protected String getRuntimeSql(QueryContext ctx) throws BOSException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(((Object)((Object)this)).getClass().getName(), "getRuntimeSql", null);
        }
        RTQuerySqlAccess qsa = ctx.getQuerySqlAccess();
        try {
            qsa.select.setTop(ctx.getTop());
            qsa.order.setIgnoreOrder(ctx.getOption().isIgnoreOrder);
            qsa.select.setDistinct(ctx.getOption().isAutoIgnoreDuplicatedRow);
            qsa.select.setAddOrder2Selector(ctx.isAddOrder2Selector());
            if (ctx.getViews() != null && ctx.getViews().size() > 0) {
                if (!ctx.isAddedPermissionFilter()) {
                    this.addPermissionFilter(ctx, ctx.getViews());
                }
            } else {
                EntityViewInfo view = ctx.getView();
                if (view == null) {
                    view = new EntityViewInfo();
                }
                if (!ctx.isAddedPermissionFilter()) {
                    this.addPermissionFilter(ctx, view);
                }
            }
            qsa.state.set(ctx.getView(), ctx.getViews());
            EntityViewInfo viewInfo = qsa.state.getView();
            Map<String, String> countFieldPkMap = ctx.getCountFieldPks();
            if (viewInfo != null && viewInfo.getSelector().size() != 0 && countFieldPkMap != null && countFieldPkMap.size() != 0) {
                SelectorItemCollection sic = viewInfo.getSelector();
                for (String s : countFieldPkMap.keySet()) {
                    boolean f = false;
                    int len = sic.size();
                    for (int i = 0; i < len; ++i) {
                        SelectorItemInfo sii = sic.get(i);
                        String pn = sii.getPropertyName();
                        String an = sii.getAliasName();
                        if (pn != null && pn.equals(s)) {
                            f = true;
                            break;
                        }
                        if (an == null || !an.equals(s)) continue;
                        f = true;
                        break;
                    }
                    if (f) continue;
                    viewInfo.getSelector().add(s);
                }
            }
            qsa.select.queryFieldMapSeletorAlias(ctx.getCountFields());
            qsa.select.queryFieldMapSeletorAlias(countFieldPkMap);
            String string = qsa.getSql(ctx.isBParaType(), ctx.getParameters());
            return string;
        }
        catch (BOSException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            BOSException e2 = new BOSException(e.getMessage() + ",  query : " + qsa.getQueryInfoName() + ",  view : " + ctx.getView(), (Throwable)e);
            throw e2;
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private void addPermissionFilter(QueryContext ctx, Map<String, EntityViewInfo> map) throws BOSException {
        Iterator<EntityViewInfo> itr = map.values().iterator();
        while (itr.hasNext()) {
            this.addPermissionFilter(ctx, itr.next());
        }
    }

    private void addPermissionFilter(QueryContext ctx, EntityViewInfo view) throws BOSException {
        EntityViewInfo permissionView = ctx.getPermissionEntityView();
        if (permissionView != null) {
            FilterInfo filter = permissionView.getFilter();
            if (filter != null && filter.getFilterItems().size() != 0) {
                FilterInfo viewFilter = view.getFilter();
                if (viewFilter != null && viewFilter.getFilterItems().size() != 0) {
                    viewFilter.mergeFilter(filter, "and");
                } else {
                    view.setFilter(filter);
                }
            }
            int n = permissionView.getEntryFilters().size();
            for (int i = 0; i < n; ++i) {
                FilterInfo entryFilter = permissionView.getEntryFilters().get(i);
                FilterInfo viewEntryFilter = view.getEntryFilters().get(entryFilter.getEntryName());
                if (viewEntryFilter != null && viewEntryFilter.getFilterItems().size() != 0) {
                    viewEntryFilter.mergeFilter(entryFilter, "and");
                    continue;
                }
                view.getEntryFilters().add(entryFilter);
            }
            ctx.setAddedPermissionFilter(true);
        }
    }

    protected SolutionInfo getSolution() {
        return MetaDataLoader.getSolution((Context)this.getContext());
    }

    protected ResultSet excuteSQLOld(PreparedStatement stmt, Map<Integer, Object> parameters) throws SQLException {
        if (parameters != null) {
            for (Integer keyValue : parameters.keySet()) {
                if (keyValue == null) continue;
                int index = keyValue;
                Object val = parameters.get(keyValue);
                stmt.setObject(index, val);
            }
        }
        return stmt.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet excuteSQL(PreparedStatement stmt, Map<Integer, Object> parameters) throws SQLException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(((Object)((Object)this)).getClass().getName(), "excuteSQL", null);
        }
        try {
            if (parameters != null) {
                for (Integer keyValue : parameters.keySet()) {
                    if (keyValue == null) continue;
                    int index = keyValue;
                    Object[] val = (Object[])parameters.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        if (val[1] == null) {
                            stmt.setNull(index, ((SQLType)val[0]).getSQLType());
                            continue;
                        }
                        stmt.setString(index, val[1].toString());
                        continue;
                    }
                    stmt.setObject(index, val[1]);
                }
            }
            ResultSet resultSet = stmt.executeQuery();
            return resultSet;
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    protected BizEnumInfo getBizEnum(MetaDataPK pk) {
        return MetaDataLoader.getEnum((Context)this.getContext(), (IMetaDataPK)pk);
    }

    private BizEnumInfo getEnum(PropertyUnitDele fld) throws BOSException {
        PropertyRefDele ref;
        BizEnumInfo bizEnum = null;
        if (fld.getPropertyRefs().size() == 1 && (ref = fld.getPropertyRefs().get(0)).getSubEntity() != null && ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo && ((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.ENUM)) {
            PropertyInfo prop = ref.getRefProperty();
            if (prop instanceof OwnPropertyInfo) {
                String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
                String className = MetaDataUtils.getClassName((String)metadataRef);
                String packageName = MetaDataUtils.getPackageName((String)metadataRef);
                try {
                    bizEnum = this.getBizEnum(MetaDataPK.create((String)packageName, (String)className));
                }
                catch (Exception be) {
                    logger.error((Object)"getBizEnum(pk) occur error:", (Throwable)be);
                    throw new BOSException((Throwable)be);
                }
            } else {
                throw new BOSException("The type of property is not Ownproperty!");
            }
        }
        if (bizEnum != null) {
            return bizEnum;
        }
        throw new BOSException("Get BizEnumInfo message failed!");
    }

    protected void populateRowSetCell(IMetaDataPK pk, DynamicRowSet rowset, ResultSet rs, int col, QueryExecuteOption option, Map<String, BizEnumValueInfo> cache, Map<String, Boolean> enumPkCache) throws SQLException, BOSException {
        Map map = rowset.getRowSetMetaData().getExtendedProperties(col);
        PropertyUnitDele fld = (PropertyUnitDele)map.get("FieldInfo");
        ConstDataType tp = fld.getReturnType();
        String fldName = fld.getName();
        if (tp.equals((Object)ConstDataType.STRING)) {
            String colVal = rs.getString(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (option.isAutoTranslateEnum) {
                Boolean isAliableEnum = enumPkCache.get(fldName);
                if (isAliableEnum == null) {
                    isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                    enumPkCache.put(fldName, isAliableEnum);
                }
                if (isAliableEnum.booleanValue()) {
                    String key = fld.getName() + colVal.toString();
                    BizEnumValueInfo value = cache.get(key);
                    if (value == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), colVal)) != null) {
                        cache.put(key, value);
                    }
                    rowset.updateObject(col, (Object)value);
                } else {
                    rowset.updateString(col, colVal.intern());
                }
            } else {
                rowset.updateString(col, colVal.intern());
            }
        } else if (tp.equals((Object)ConstDataType.BOOLEAN)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else {
                int i;
                try {
                    i = TypeConversionUtils.objToInt((Object)colVal);
                }
                catch (IllegalConversionException e) {
                    throw new BOSException("Field ReturnType Conversion error. Field:" + fldName, (Throwable)e);
                }
                if (option.isAutoTranslateBoolean) {
                    rowset.updateObject(col, (Object)(i != 0 ? Boolean.TRUE : Boolean.FALSE));
                } else {
                    rowset.updateInt(col, i);
                }
            }
        } else if (tp.equals((Object)ConstDataType.INT)) {
            Object colVal = rs.getObject(col);
            if (colVal instanceof BigDecimal) {
                colVal = ((BigDecimal)colVal).intValue();
            }
            if (colVal instanceof Integer) {
                int i = (Integer)colVal;
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (value == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), i)) != null) {
                            cache.put(key, value);
                        }
                        rowset.updateObject(col, (Object)value);
                    } else if (option.isAutoIgnoreZero && i == 0) {
                        rowset.updateNull(col);
                    } else {
                        rowset.updateInt(col, i);
                    }
                } else if (option.isAutoIgnoreZero && i == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateInt(col, i);
                }
            } else if (colVal instanceof Byte) {
                byte b = (Byte)colVal;
                if (option.isAutoIgnoreZero && b == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateByte(col, b);
                }
            } else if (colVal instanceof Long) {
                long l = (Long)colVal;
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (value == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), l)) != null) {
                            cache.put(key, value);
                        }
                        rowset.updateObject(col, (Object)value);
                    } else if (option.isAutoIgnoreZero && l == 0L) {
                        rowset.updateNull(col);
                    } else {
                        rowset.updateLong(col, l);
                    }
                } else if (option.isAutoIgnoreZero && l == 0L) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateLong(col, l);
                }
            } else if (colVal instanceof String) {
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (value == null) {
                            try {
                                int intValue = Integer.parseInt(colVal.toString());
                                value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), intValue);
                            }
                            catch (NumberFormatException nue) {
                                // empty catch block
                            }
                            if (value != null) {
                                cache.put(key, value);
                            }
                        }
                        rowset.updateObject(col, value == null ? colVal : value);
                    } else {
                        rowset.updateObject(col, colVal);
                    }
                } else {
                    rowset.updateObject(col, colVal);
                }
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)ConstDataType.NUMBER)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Float) {
                float f = ((Float)colVal).floatValue();
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (value == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), f)) != null) {
                            cache.put(key, value);
                        }
                        rowset.updateObject(col, (Object)value);
                    } else if (option.isAutoIgnoreZero && f == 0.0f) {
                        rowset.updateNull(col);
                    } else {
                        rowset.updateFloat(col, f);
                    }
                } else if (option.isAutoIgnoreZero && f == 0.0f) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateFloat(col, f);
                }
            } else if (colVal instanceof Double) {
                double d = (Double)colVal;
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (cache.get(colVal) == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), d)) != null) {
                            cache.put(key, value);
                        }
                        rowset.updateObject(col, (Object)value);
                    } else if (option.isAutoIgnoreZero && d == 0.0) {
                        rowset.updateNull(col);
                    } else {
                        rowset.updateDouble(col, d);
                    }
                } else if (option.isAutoIgnoreZero && d == 0.0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateDouble(col, d);
                }
            } else if (colVal instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)colVal;
                if (option.isAutoTranslateEnum) {
                    Boolean isAliableEnum = enumPkCache.get(fldName);
                    if (isAliableEnum == null) {
                        isAliableEnum = QueryDeleUtil.isAliableEnum((PropertyUnitDele)fld);
                        enumPkCache.put(fldName, isAliableEnum);
                    }
                    if (isAliableEnum.booleanValue()) {
                        String key = fld.getName() + colVal.toString();
                        BizEnumValueInfo value = cache.get(key);
                        if (value == null && (value = QueryHelper.getAliasFromEnumValue(this.getEnum(fld), bd.doubleValue())) != null) {
                            cache.put(key, value);
                        }
                        rowset.updateObject(col, (Object)value);
                    } else if (option.isAutoIgnoreZero && bd.compareTo(new BigDecimal(0.0)) == 0) {
                        rowset.updateNull(col);
                    } else {
                        rowset.updateBigDecimal(col, bd);
                    }
                } else if (option.isAutoIgnoreZero && bd.compareTo(new BigDecimal(0.0)) == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateBigDecimal(col, bd);
                }
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)ConstDataType.DATE)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Date) {
                Date da = (Date)colVal;
                rowset.updateDate(col, da);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)ConstDataType.TIME)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)ConstDataType.TIMESTAMP)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else {
            rowset.updateObject(col, rs.getObject(col));
        }
    }

    protected Connection getConnection() throws SQLException {
        return EJBFactory.getQueryConnection(this.getContext());
    }

    protected int getCriticalIDSize() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.getCriticalIDList();
    }

    protected boolean isGetRealRowCount() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.isRealRowCount();
    }

    protected String processSQLLockHints(String sql, Map<String, String> hints) throws BOSException {
        if (hints == null || hints.size() == 0) {
            return sql;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            Map<String, String> processedLockHints = this.getProcessLockedHints(hints);
            this.processSqlSelectBaseLockHints(sqlSelectBase, processedLockHints);
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase(sqlSelectBase);
            return buffer.toString();
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, String> getProcessLockedHints(Map<String, String> hints) {
        HashMap<String, String> processedLockHints = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = hints.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            processedLockHints.put(QueryHelper.addMark(key).toUpperCase(), value);
        }
        return processedLockHints;
    }

    private void processSqlSelectBaseLockHints(SqlSelectBase sqlSelectBase, Map<String, String> hints) {
        if (sqlSelectBase instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
            SqlTableSourceBase sqlTableSourceBase = sqlSelect.tableSource;
            this.processSqlTableSourceBaseLockHints(sqlTableSourceBase, hints);
        } else if (sqlSelectBase instanceof SqlUnionSelect) {
            SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
            this.processSqlSelectBaseLockHints(sqlUnionSelect.left, hints);
            this.processSqlSelectBaseLockHints(sqlUnionSelect.right, hints);
        }
    }

    private void processSqlTableSourceBaseLockHints(SqlTableSourceBase sqlTableSourceBase, Map<String, String> hints) {
        if (sqlTableSourceBase instanceof SqlTableSource) {
            SqlTableSource sqlTableSource = (SqlTableSource)sqlTableSourceBase;
            sqlTableSource.lockingHint = hints.get(sqlTableSource.alias);
        } else if (sqlTableSourceBase instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource sqlJoinedTableSource = (SqlJoinedTableSource)sqlTableSourceBase;
            this.processSqlTableSourceBaseLockHints(sqlJoinedTableSource.left, hints);
            this.processSqlTableSourceBaseLockHints(sqlJoinedTableSource.right, hints);
        } else if (sqlTableSourceBase instanceof SqlSubQueryTableSource) {
            // empty if block
        }
    }

    protected RTQuerySqlAccess initSqlAccessInstance(QueryInfo query) {
        RTQuerySqlAccess qsa = new RTQuerySqlAccess(this.getContext(), query);
        return qsa;
    }

    public String getParametersString(Map<Integer, Object> parameters) {
        if (parameters == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<Integer, Object> entry : parameters.entrySet()) {
            Integer index = entry.getKey();
            Object value = entry.getValue();
            sbuf.append(index.toString());
            sbuf.append(":");
            sbuf.append(value == null ? "null" : value.toString());
            sbuf.append("!");
        }
        return sbuf.toString();
    }

    protected boolean isDefineLogicalKey(IMetaDataPK pk) throws BOSException {
        QueryInfo query = QueryContext.getInstance(new QueryExecuteOption()).getQuery(this.getContext(), null, pk, MetaDataTypeList.BASEQUERY);
        return query.getQueryPK() != null;
    }

    protected DynamicRowSet createRowSet(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i < colCount + 1; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }

    protected void populateRowSetCell(DynamicRowSet drs, ResultSet rs, int i) throws SQLException {
        int type = rs.getMetaData().getColumnType(i);
        Object colValue = rs.getObject(i);
        if (colValue == null) {
            drs.updateNull(i);
        } else {
            switch (type) {
                case -7: {
                    drs.updateByte(i, rs.getByte(i));
                    break;
                }
                case 91: {
                    drs.updateDate(i, rs.getDate(i));
                    break;
                }
                case 92: {
                    drs.updateTime(i, rs.getTime(i));
                    break;
                }
                case 93: {
                    drs.updateTimestamp(i, rs.getTimestamp(i));
                    break;
                }
                case 4: {
                    drs.updateInt(i, rs.getInt(i));
                    break;
                }
                case 6: {
                    drs.updateFloat(i, rs.getFloat(i));
                    break;
                }
                case 3: {
                    drs.updateBigDecimal(i, rs.getBigDecimal(i));
                    break;
                }
                case 8: {
                    drs.updateDouble(i, rs.getDouble(i));
                    break;
                }
                case 5: {
                    drs.updateShort(i, rs.getShort(i));
                    break;
                }
                case -5: {
                    drs.updateLong(i, rs.getLong(i));
                    break;
                }
                default: {
                    drs.updateObject(i, colValue);
                }
            }
        }
    }

    public static PreparedStatement prepareStatement(Connection con, String sql) throws SQLException {
        PreparedStatement ps = con.prepareStatement(sql);
        ps.setQueryTimeout(KSQLSettingFactory.getInstance().getQueryExecute_TimeOut());
        return ps;
    }
}

