/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.AbstractSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DbSeqTableAcuquire
extends AbstractSeqTableAcuquire {
    private static final Logger logger = Logger.getLogger(DbSeqTableAcuquire.class);

    private static String getRealAis(Context ctx) {
        Repository repo = RepositoryFactory.getCurrentRepository();
        if (repo != null) {
            return repo.getIdentity();
        }
        return ctx.getAIS();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map acquire(Context context, Uuid querySessionID, QueryDele query, EntityViewInfo view, Map views, Map params, QueryExecuteOption option, String sql) throws BOSException {
        HashMap<String, String> hashMap;
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int txIsolation = -1;
        SeqTableData seqTableData = new SeqTableData();
        try {
            cn = QueryConnectionProvider.getConnection(context);
            String readAis = DbSeqTableAcuquire.getRealAis(context);
            Context fakeCtx = new Context((IObjectPK)new ObjectUuidPK(), context.getSolution(), readAis, context.getLocale());
            seqTableData.setContext(fakeCtx);
            seqTableData.setQuerySessionID(querySessionID);
            seqTableData.setView(view);
            seqTableData.setViews(views);
            seqTableData.setTableName("QUERY_SEQTABLE");
            seqTableData.setLogicPKInfo(DbSeqTableAcuquire.getLogicPKInfo(query, sql));
            String createTableSQL = DbSeqTableAcuquire.buildCreateTableSQL(context, seqTableData, query);
            String comment = "Query: " + query.getFullName();
            QueryCacheManager.getInstance().putObject(querySessionID, seqTableData);
            String tableName = DbSeqTableAcuquire.acquireTable(context, readAis, cn, createTableSQL, comment);
            seqTableData.setTableName(tableName);
            String insertSQL = DbSeqTableAcuquire.buildInsertSQL(sqlMap, seqTableData, option, sql, KSqlUtil.getDbType((Connection)cn));
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            ps = BaseDataAccess.prepareStatement(cn, insertSQL);
            if (params != null) {
                for (Object keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = (Integer)keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.CHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
            }
            try {
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                String logInfo = DbSeqTableAcuquire.getSqlParameterString(insertSQL, params);
                logger.error((Object)logInfo);
                throw new BOSException(logInfo, (Throwable)sqle);
            }
            hashMap = sqlMap;
        }
        catch (Throwable e) {
            try {
                seqTableData.setThrowable(e);
                logger.error((Object)"createTable() occur error: ", e);
                throw new BOSException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e2);
                }
                catch (Throwable t) {
                    logger.error((Object)"acquire()'s setTransactionIsolation throw a Throwble not SQLException:", t);
                }
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)"acquire()'s setTransactionIsolation throw a Throwble not SQLException:", t);
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)cn);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void acquire(Context context, Uuid querySessionID, QueryExecuteOption option, String sql, List pkList) throws BOSException {
        Connection cn = null;
        PreparedStatement ps = null;
        SeqTableData seqTableData = new SeqTableData();
        int txIsolation = -1;
        try {
            cn = QueryConnectionProvider.getConnection(context);
            String readAis = DbSeqTableAcuquire.getRealAis(context);
            Context fakeCtx = new Context((IObjectPK)new ObjectUuidPK(), context.getSolution(), readAis, context.getLocale());
            seqTableData.setContext(fakeCtx);
            seqTableData.setQuerySessionID(querySessionID);
            seqTableData.setPkList(pkList);
            seqTableData.setTableName("QUERY_SEQTABLE");
            String createTableSQL = DbSeqTableAcuquire.buildCreateTableSQL(context, seqTableData, sql, pkList);
            String tableName = DbSeqTableAcuquire.acquireTable(context, readAis, cn, createTableSQL, "SQL: " + sql);
            seqTableData.setTableName(tableName);
            QueryCacheManager.getInstance().putObject(querySessionID, seqTableData);
            String insertSQL = DbSeqTableAcuquire.buildInsertSQL(seqTableData, option, sql, pkList);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buildInsertSQL:\n" + insertSQL));
            }
            cn = QueryConnectionProvider.getConnection(context);
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            ps = BaseDataAccess.prepareStatement(cn, insertSQL);
            try {
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                String logInfo = DbSeqTableAcuquire.getSqlParameterString(insertSQL, null);
                logger.error((Object)logInfo);
                throw new BOSException(logInfo, (Throwable)sqle);
            }
        }
        catch (Throwable e) {
            try {
                seqTableData.setThrowable(e);
                logger.error((Object)"createTable() occur error: ", e);
                throw new BOSException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e2);
                }
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private static String getSqlParameterString(String sql, Map params) {
        StringBuffer sb = new StringBuffer();
        sb.append("sql=" + sql + "\n");
        sb.append("---------------------start params---------\n");
        if (params != null) {
            for (Object keyValue : params.keySet()) {
                if (keyValue == null) continue;
                int index = (Integer)keyValue;
                sb.append("[index=" + index + "]");
                Object[] val = (Object[])params.get(keyValue);
                sb.append("[type=" + val[0] + "][value=" + val[1] + "]\n");
            }
        }
        sb.append("---------------------end params---------\n");
        return sb.toString();
    }

    public static String acquireTable(Context ctx, String ais, Connection cn, String createSQL, String comment) throws Exception {
        TempTablePool pool = TempTablePool.getInstance(ctx, ais);
        return pool.createTempTable(createSQL, "QUERY_SEQTABLE", "QUERY_SEQ_CONS");
    }

    private static String getRealCreateSQL(String realTableName, String createSQL) {
        String newConstraintName = DbSeqTableAcuquire.getConstraintName(realTableName);
        String sql = StringUtils.replace((String)createSQL, (String)"QUERY_SEQTABLE", (String)realTableName);
        sql = StringUtils.replace((String)sql, (String)"QUERY_SEQ_CONS", (String)newConstraintName);
        return sql;
    }

    private static String getConstraintName(String realTableName) {
        String newConstraintName = realTableName.substring(realTableName.length() - 16);
        newConstraintName = "ZC" + newConstraintName;
        return newConstraintName;
    }
}

