/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.AbstractSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheManager;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemcacheSeqTableAcuquire
extends AbstractSeqTableAcuquire {
    private static final Logger logger = Logger.getLogger(MemcacheSeqTableAcuquire.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map acquire(Context context, Uuid querySessionID, QueryDele query, EntityViewInfo view, Map views, Map params, QueryExecuteOption option, String sql, int length, String keyFieldName) throws BOSException {
        HashMap<String, String> hashMap;
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        Connection cn = null;
        PreparedStatement ps = null;
        Statement stmt = null;
        ResultSet rs = null;
        SeqTableData seqTableData = new SeqTableData();
        int txIsolation = -1;
        Context fakeCtx = new Context((IObjectPK)new ObjectUuidPK(), context.getSolution(), RWSplitingManager.getReadAis(context), context.getLocale());
        seqTableData.setContext(fakeCtx);
        seqTableData.setQuerySessionID(querySessionID);
        seqTableData.setView(view);
        seqTableData.setViews(views);
        try {
            cn = QueryConnectionProvider.getConnection(context);
            int dbtype = KSqlUtil.getDbType((Connection)cn);
            seqTableData.setLogicPKInfo(MemcacheSeqTableAcuquire.getLogicPKInfo(query, sql));
            QueryCacheManager.getInstance().putObject(querySessionID, seqTableData);
            String selectSQL = MemcacheSeqTableAcuquire.buildSelectSQL(sqlMap, seqTableData, option, sql, dbtype);
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            ps = BaseDataAccess.prepareStatement(cn, selectSQL);
            ps.setFetchSize(100);
            if (params != null) {
                for (Object keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = (Integer)keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
            }
            rs = ps.executeQuery();
            int columnCount = rs.getMetaData().getColumnCount();
            int k = 0;
            int rc = 0;
            int page = 0;
            ArrayList<Object[]> retValue = new ArrayList<Object[]>(50);
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            while (rs.next()) {
                ++k;
                ++rc;
                if (keyFieldName != null && keyFieldName.length() > 0) {
                    idSet.add(rs.getString(keyFieldName));
                }
                Object[] objs = new Object[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    objs[i - 1] = rs.getObject(i);
                }
                retValue.add(objs);
                if (k != 2 * length) continue;
                MemcacheManager.getInstance().getMemClient().add(querySessionID.toString() + ++page, retValue, 0x6DDD00L);
                retValue.clear();
                k = 0;
            }
            if (k > 0) {
                MemcacheManager.getInstance().getMemClient().add(querySessionID.toString() + ++page, retValue, 14400000L);
            }
            seqTableData.setRowCount(rc);
            seqTableData.setBillCount(idSet.size());
            MemcacheManager.getInstance().getMemClient().add(querySessionID + "idSet", idSet);
            hashMap = sqlMap;
        }
        catch (Throwable e) {
            try {
                seqTableData.setThrowable(e);
                throw new BOSException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e2);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        catch (Throwable t) {
            // empty catch block
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup(stmt);
        SQLUtils.cleanup((Connection)cn);
        return hashMap;
    }
}

