/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LRUMap;
import com.kingdee.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.Map;

public final class OpenQuerySqlCache {
    static final int DEFAULT_CACHE_SIZE = 0x1000000;
    private static final OpenQuerySqlCache instance = new OpenQuerySqlCache();
    private LRUMap cache = new LRUMap();

    private OpenQuerySqlCache() {
        this.cache.setMaxSize(this.getCacheMaxSize());
    }

    public static OpenQuerySqlCache getInstance() {
        if (instance == null) {
            throw new IllegalStateException("call createInstance(Context ctx) first.");
        }
        return instance;
    }

    private int getCacheMaxSize() {
        int maxSize = 0;
        IDeployInfoManager deploy = DeployInfoManagerFactory.getDeployInfoManager();
        ConfigurationItem debugOption = deploy.getConfigItem("DebugOptions");
        if (debugOption != null) {
            maxSize = TypeConversionUtils.objToInt((Object)debugOption.getProperty("selectCacheMaxSize"));
        }
        if (maxSize == 0) {
            maxSize = 0x1000000;
        }
        return maxSize;
    }

    public synchronized OpenQuerySqlDec getSql(String key) {
        return (OpenQuerySqlDec)this.cache.get((Object)key);
    }

    public synchronized OpenQuerySqlDec putSql(String key, OpenQuerySqlDec sql) {
        return (OpenQuerySqlDec)this.cache.put((Object)key, (Object)sql);
    }

    public synchronized int getCacheCount() {
        return this.cache.size();
    }

    public synchronized int getCacheSize() {
        return this.cache.getTotalSize();
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    private static class SQLDescSize
    implements LRUMap.IObjectSizeComputer {
        private SQLDescSize() {
        }

        public int sizeOf(Object obj) {
            if (obj == null) {
                return 8;
            }
            if (obj instanceof OpenQuerySqlDec) {
                return this.sizeOfOpenQuerySqlDec((OpenQuerySqlDec)obj);
            }
            if (obj instanceof String) {
                return SQLDescSize.sizeOfString((String)obj);
            }
            return 0;
        }

        private int sizeOfOpenQuerySqlDec(OpenQuerySqlDec selectDesc) {
            if (selectDesc == null) {
                return 8;
            }
            return 24 + SQLDescSize.sizeOfString(selectDesc.sql);
        }

        private static final int sizeOfString(String str) {
            if (str == null) {
                return 8;
            }
            return str.length() * 2 + 40;
        }

        private static final int sizeOfObjectArrayShell(int len) {
            return len * 4 + 16;
        }

        private static final int sizeOfStringArray(String[] aStr) {
            if (aStr == null) {
                return 8;
            }
            int size = 0;
            for (int i = 0; i < aStr.length; ++i) {
                size += SQLDescSize.sizeOfString(aStr[i]);
            }
            return size += SQLDescSize.sizeOfObjectArrayShell(aStr.length);
        }

        private static final int sizeOfArrayListShell(ArrayList list) {
            if (list == null) {
                return 8;
            }
            return SQLDescSize.sizeOfObjectArrayShell(list.size()) + 20;
        }
    }

    private static class StringSize
    implements LRUMap.IObjectSizeComputer {
        private StringSize() {
        }

        public int sizeOf(Object obj) {
            if (obj == null) {
                return 8;
            }
            return StringSize.sizeOfString((String)obj);
        }

        private static final int sizeOfString(String str) {
            return str.length() * 2 + 40;
        }
    }

    static class OpenQuerySqlDec {
        final Map param;
        final String sql;

        public OpenQuerySqlDec(Map param, String sql) {
            this.param = param;
            this.sql = sql;
        }

        public Map getParam() {
            return this.param;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

