/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.cache.CacheEngine;
import com.kingdee.bos.cache.CacheEvent;
import com.kingdee.bos.cache.CacheEventListener;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.DefaultObjectMonitor;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.RegionAttributes;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.dao.query.server.SeqTableManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionListener;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.util.Uuid;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

final class QueryCacheManager
implements SessionListener {
    private static final String QUERY_CACHE_NAME = "QueryCache";
    static final int IDLE_TIME_OUT = 28800000;
    private CacheRegion region = null;
    private CacheEventListener listener = null;
    private static final QueryCacheManager INSTANCE = new QueryCacheManager();
    private static final Logger logger = Logger.getLogger(QueryCacheManager.class);
    private int totalGetNum = 0;
    private int availableNum = 0;

    public int getAvailableNum() {
        return this.availableNum;
    }

    private QueryCacheManager() {
        this.initCacheRegion();
        this.initListener();
        SessionManager.addSessionListener((SessionListener)this);
    }

    private void initCacheRegion() {
        CacheRegion rootRegion = CacheEngine.getLocalRootRegion();
        RegionAttributes regionAttrs = new RegionAttributes();
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        ObjectAttributes objAttrs = new ObjectAttributes();
        objAttrs.setLong(6, 28800000L);
        objAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        this.region = rootRegion.createSubRegion((Object)QUERY_CACHE_NAME, regionAttrs, objAttrs);
        this.availableNum = 0;
        this.totalGetNum = 0;
    }

    private void initListener() {
        this.listener = new CacheEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(CacheEvent e) {
                if (e.getID() == 8) {
                    CacheObject cacheObject = null;
                    try {
                        cacheObject = e.getObject();
                        if (cacheObject == null || !cacheObject.isAvailable()) {
                            return;
                        }
                        SeqTableData seqTableData = (SeqTableData)cacheObject.get();
                        SeqTableManager.getInstance().release(seqTableData.getContext(), seqTableData.getQuerySessionID());
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"dropTable occor error:", (Throwable)e1);
                    }
                    finally {
                        QueryCacheManager.releaseCacheObject(cacheObject);
                    }
                }
            }
        };
    }

    static QueryCacheManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putObject(Object name, Object value) {
        this.region.putObject(name, value, this.getDefaultObjectAttributes());
        CacheObject cacheObject = null;
        try {
            cacheObject = this.region.getObject(name);
            cacheObject.addEventListener(this.listener);
        }
        catch (Throwable throwable) {
            QueryCacheManager.releaseCacheObject(cacheObject);
            throw throwable;
        }
        QueryCacheManager.releaseCacheObject(cacheObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(Object name) {
        CacheObject cacheObject;
        block3: {
            Object object;
            ++this.totalGetNum;
            cacheObject = null;
            try {
                cacheObject = this.region.getObject(name);
                if (cacheObject == null || !cacheObject.isAvailable() || cacheObject.isDestroyed() || !cacheObject.isObject()) break block3;
                ++this.availableNum;
                object = cacheObject.get();
            }
            catch (Throwable throwable) {
                QueryCacheManager.releaseCacheObject(cacheObject);
                throw throwable;
            }
            QueryCacheManager.releaseCacheObject(cacheObject);
            return object;
        }
        Object var3_4 = null;
        QueryCacheManager.releaseCacheObject(cacheObject);
        return var3_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyObject(Object name) {
        CacheRegion cacheRegion = this.region;
        synchronized (cacheRegion) {
            CacheObject cacheObject = null;
            try {
                cacheObject = this.region.getObject(name);
                if (cacheObject != null) {
                    cacheObject.destroy();
                }
            }
            catch (Throwable throwable) {
                QueryCacheManager.releaseCacheObject(cacheObject);
                throw throwable;
            }
            QueryCacheManager.releaseCacheObject(cacheObject);
        }
    }

    private static void releaseCacheObject(CacheObject cacheObject) {
        if (cacheObject != null) {
            cacheObject.release();
        }
    }

    private ObjectAttributes getDefaultObjectAttributes() {
        ObjectAttributes regionAttrs = new ObjectAttributes();
        regionAttrs.setLong(6, 28800000L);
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        regionAttrs.setBoolean(22, false);
        return regionAttrs;
    }

    public int cacheSize() {
        return this.region.childCount();
    }

    public int getTotalGetNum() {
        return this.totalGetNum;
    }

    public void create(String sessionID, SessionInfo session) {
    }

    public void destory(String sessionID, SessionInfo session) {
        Set querySessionIDs = (Set)session.get((Object)"querySessionIDs", new HashSet());
        for (Uuid querySessionID : querySessionIDs) {
            try {
                this.destroyObject(querySessionID);
                SeqTableManager.unRegisterInUserSession(querySessionID);
            }
            catch (Exception e) {
                logger.error((Object)"error while release querySession", (Throwable)e);
            }
        }
    }
}

