/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.dao.query.server.VirtualModeUtils;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.Query4EntityUtil;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryContext {
    private static final Logger logger = Logger.getLogger(QueryContext.class);
    private static CustomCacheService uuidPermViewCache = new CustomCacheService("cache.uuidPermViewCache");
    private EntityViewInfo view;
    private Map<String, EntityViewInfo> views;
    private QueryExecuteOption option;
    private int top;
    private boolean addOrder2Selector = false;
    private Map<String, String> countFields;
    private Map<String, String> countFieldPks;
    private boolean bParaType;
    private Map<Integer, Object> parameters;
    private RTQuerySqlAccess qsa = null;
    private EntityViewInfo permissionEntityView = null;
    boolean addedPermissionFilter = false;
    private CurrentQuery curr = new CurrentQuery();

    public static QueryContext getInstance(QueryExecuteOption option) {
        QueryContext ctx = new QueryContext(null, null, option, 0, null, null, false, null);
        return ctx;
    }

    public static QueryContext getInstance(EntityViewInfo view, QueryExecuteOption option) {
        QueryContext ctx = new QueryContext(view, null, option, 0, null, null, false, null);
        return ctx;
    }

    public static QueryContext getInstance(Map<String, EntityViewInfo> views, QueryExecuteOption option) {
        QueryContext ctx = new QueryContext(null, views, option, 0, null, null, false, null);
        return ctx;
    }

    public static QueryContext getInstance(EntityViewInfo view, Map<String, EntityViewInfo> views, QueryExecuteOption option, int top, Map<Integer, Object> parameters) {
        QueryContext ctx = new QueryContext(view, views, option, top, null, null, false, parameters);
        return ctx;
    }

    public static QueryContext getInstance(EntityViewInfo view, Map<String, EntityViewInfo> views, QueryExecuteOption option, int top, Map<String, String> countFields, Map<String, String> countFieldPks, boolean paraType, Map<Integer, Object> parameters) {
        return new QueryContext(view, views, option, top, countFields, countFieldPks, paraType, parameters);
    }

    public static QueryContext getInstance(EntityViewInfo view, Map<String, EntityViewInfo> views, QueryExecuteOption option, Map<String, String> countFields, Map<Integer, Object> parameters) {
        return new QueryContext(view, views, option, 0, countFields, null, false, parameters);
    }

    private QueryContext(EntityViewInfo view, Map<String, EntityViewInfo> views, QueryExecuteOption option, int top, Map<String, String> countFields, Map<String, String> countFieldPks, boolean paraType, Map<Integer, Object> parameters) {
        this.view = view;
        this.views = views;
        this.option = option;
        this.top = top;
        this.countFields = countFields;
        this.countFieldPks = countFieldPks;
        this.bParaType = paraType;
        this.parameters = parameters;
    }

    public void init(Context ctx, String querySessionID, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        QueryInfo query = this.getQuery(ctx, querySessionID, pk, type);
        if (query == null) {
            throw new BOSException("The QueryInfo is null!");
        }
        if (!this.curr.isSameWith(query, this.view, this.views) || this.qsa == null) {
            this.qsa = new RTQuerySqlAccess(ctx, query);
            if (this.view != null && this.view.size() > 0) {
                VirtualModeUtils.switchWFSpeacilFilter(this.view, query);
            }
            this.qsa.init(this.view, this.views);
        }
    }

    QueryInfo getQuery(Context ctx, String querySessionID, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        QueryInfo query = null;
        BOSObjectType mainEntityType = null;
        if (type.equals((Object)MetaDataTypeList.ENTITY)) {
            EntityObjectInfo en = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)pk);
            mainEntityType = en.getType();
            query = this.getQueryFromEntity(ctx, en);
            type = MetaDataTypeList.ENTITY;
        } else if (type.equals((Object)MetaDataTypeList.BASEQUERY) && (query = MetaDataLoader.getQuery((Context)ctx, (IMetaDataPK)pk)) != null) {
            SubObjectInfo subObj = query.getMainObject();
            if (subObj instanceof SubEntityInfo) {
                SubEntityInfo subEntity = (SubEntityInfo)subObj;
                mainEntityType = subEntity.getEntityRef().getType();
            }
            type = MetaDataTypeList.BASEQUERY;
        }
        if (query == null) {
            throw new BOSException("Can't find the bos object: " + pk.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query's IGNORE_PERMISSION:\t" + this.option.isIgnorePermissionCheck));
        }
        if (!this.option.isIgnorePermissionCheck) {
            Object permissionView;
            if (querySessionID != null && (permissionView = uuidPermViewCache.get(querySessionID + ctx.getCaller().toString())) instanceof EntityViewInfo) {
                this.permissionEntityView = (EntityViewInfo)permissionView;
            }
            if (this.permissionEntityView == null) {
                ServiceContext svcCtx = QueryContext.createServiceContext(type, mainEntityType, pk, new Object[]{ctx});
                svcCtx.setServiceParameter("STATEMGMT", "EXECUTE", (Object)Boolean.FALSE);
                QueryContext.invokeService((IServiceContext)svcCtx);
                EntityViewInfo view = null;
                Object permissionSrvRtn = svcCtx.getServiceResult("PERMISSION_SERVICE");
                if (permissionSrvRtn instanceof EntityViewInfo) {
                    view = (EntityViewInfo)permissionSrvRtn;
                } else if (permissionSrvRtn instanceof FilterInfo) {
                    view = new EntityViewInfo();
                    view.setFilter((FilterInfo)permissionSrvRtn);
                }
                if (view != null && mainEntityType != null) {
                    try {
                        ImplUtils.processEntryFilter(mainEntityType, view, ctx);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"convert entryWhere failed ", (Throwable)e);
                    }
                    catch (SQLException e) {
                        logger.error((Object)"convert entryWhere failed ", (Throwable)e);
                    }
                }
                this.setPermissionEntityView(view);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"checked permission!=====");
                }
            }
            if (querySessionID != null) {
                if (this.permissionEntityView != null) {
                    uuidPermViewCache.put(querySessionID + ctx.getCaller().toString(), (Object)this.permissionEntityView);
                } else {
                    uuidPermViewCache.put(querySessionID + ctx.getCaller().toString(), (Object)Boolean.FALSE);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"ignore permission!=====");
        }
        return query;
    }

    private static ServiceContext createServiceContext(BOSObjectType bosType, BOSObjectType mainEntityType, IMetaDataPK queryPK, Object[] args) {
        return new ServiceContext(bosType, mainEntityType, queryPK, null, args);
    }

    private static void invokeService(IServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceManagerFactory.getServiceManager().execute(svcCtx);
    }

    private QueryInfo getQueryFromEntity(Context ctx, EntityObjectInfo entity) throws BOSException {
        int i;
        if (entity == null) {
            throw new BOSException("The Entity is null!");
        }
        JoinQueryInfo jqy = new JoinQueryInfo();
        SubEntityInfo main = new SubEntityInfo((QueryInfo)jqy, entity);
        jqy.getSubObjects().add((SubObjectInfo)main);
        SelectorItemCollection selectors = new SelectorItemCollection();
        SorterItemCollection sorters = new SorterItemCollection();
        FilterInfo filter = new FilterInfo();
        jqy.setQueryPK(Query4EntityUtil.getQueryPKFromLogiaclKey((QueryInfo)jqy, (LogicalKeyInfo)entity.getLogicalKey()));
        if (entity.getDefaultView() != null) {
            if (entity.getDefaultView().getSelector().size() > 0) {
                selectors.addObjectCollection((IObjectCollection)entity.getDefaultView().getSelector());
            }
            if (entity.getDefaultView().getSorter().size() > 0) {
                sorters.addObjectCollection((IObjectCollection)entity.getDefaultView().getSorter());
            }
            if (entity.getDefaultView().getFilter() != null) {
                filter.setMaskString(entity.getDefaultView().getFilter().getMaskString());
                filter.getFilterItems().addObjectCollection((IObjectCollection)entity.getDefaultView().getFilter().getFilterItems());
            }
        }
        int n = selectors.size();
        for (i = 0; i < n; ++i) {
            String propName = selectors.get(i).getPropertyName();
            Query4EntityUtil.processPropertyName((QueryInfo)jqy, (String)propName, (boolean)true, (Context)ctx);
        }
        n = sorters.size();
        for (i = 0; i < n; ++i) {
            QueryUtil.processQuerySorter((QueryInfo)jqy, (SorterItemInfo)sorters.get(i));
        }
        QueryUtil.processQueryFilter((QueryInfo)jqy, (FilterInfo)filter);
        return jqy;
    }

    public EntityViewInfo getView() {
        return this.view;
    }

    public void setView(EntityViewInfo view) {
        this.view = view;
    }

    public Map<String, EntityViewInfo> getViews() {
        return this.views;
    }

    public void setViews(Map<String, EntityViewInfo> views) {
        this.views = views;
    }

    public QueryExecuteOption getOption() {
        return this.option;
    }

    public void setOption(QueryExecuteOption option) {
        this.option = option;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public Map<String, String> getCountFields() {
        return this.countFields;
    }

    public void setCountFields(Map<String, String> countFields) {
        this.countFields = countFields;
    }

    public Map<String, String> getCountFieldPks() {
        return this.countFieldPks;
    }

    public void setCountFieldPks(Map<String, String> countFieldPks) {
        this.countFieldPks = countFieldPks;
    }

    public boolean isBParaType() {
        return this.bParaType;
    }

    public void setBParaType(boolean paraType) {
        this.bParaType = paraType;
    }

    public Map<Integer, Object> getParameters() {
        return this.parameters;
    }

    public Map<Integer, Object> getParameters4Qsa() throws BOSException {
        return this.qsa.getParameters(this.parameters);
    }

    public void setParameters(Map<Integer, Object> parameters) {
        this.parameters = parameters;
    }

    public RTQuerySqlAccess getQuerySqlAccess() {
        return this.qsa;
    }

    public EntityViewInfo getPermissionEntityView() {
        return this.permissionEntityView;
    }

    public void setPermissionEntityView(EntityViewInfo permissionEntityView) {
        this.permissionEntityView = permissionEntityView;
    }

    public static void removePermViewCache(String querySessionID) {
        uuidPermViewCache.removeLocal(querySessionID);
    }

    public boolean isAddedPermissionFilter() {
        return this.addedPermissionFilter;
    }

    public void setAddedPermissionFilter(boolean addedPermissionFilter) {
        this.addedPermissionFilter = addedPermissionFilter;
    }

    public boolean isAddOrder2Selector() {
        return this.addOrder2Selector;
    }

    public void setAddOrder2Selector(boolean addOrder2Selector) {
        this.addOrder2Selector = addOrder2Selector;
    }

    private static class CurrentQuery {
        QueryInfo query;
        EntityViewInfo view;
        Map<String, EntityViewInfo> views;

        private CurrentQuery() {
        }

        boolean isSameWith(QueryInfo query, EntityViewInfo view, Map<String, EntityViewInfo> views) {
            boolean isSame = this.query == query;
            isSame = isSame && (this.view == null && view == null || this.view != null && this.view.equals((Object)view));
            boolean bl = isSame = isSame && ((this.views == null || this.views.isEmpty()) && (views == null || views.isEmpty()) || this.views != null && ((Object)this.views).equals(views));
            if (!isSame) {
                this.query = query;
                this.view = view;
                this.views = views;
            }
            return isSame;
        }
    }
}

