/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.dao.query.IQueryCacheManagerTraceListener;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.util.ArrayList;
import java.util.List;

public class QueryManagerTools {
    private static QueryManagerTools instance = new QueryManagerTools();
    private final IBuddyObject buddy;
    List listeners = new ArrayList();

    public static QueryManagerTools getInstance() {
        return instance;
    }

    private QueryManagerTools() {
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getAvailableNum() {
        return QueryCacheManager.getInstance().getAvailableNum();
    }

    public int getCacheSize() {
        return QueryCacheManager.getInstance().cacheSize();
    }

    public int getTotalGetNum() {
        return QueryCacheManager.getInstance().getTotalGetNum();
    }

    public double getAvailableUsage() {
        return Math.round(1.0 * (double)this.getAvailableNum() / (double)this.getTotalGetNum());
    }

    public void addListener(IQueryCacheManagerTraceListener lin) {
        if (!this.listeners.contains(lin)) {
            this.listeners.add(lin);
        }
    }

    public void removeListener(IQueryCacheManagerTraceListener lin) {
        if (this.listeners.contains(lin)) {
            this.listeners.remove(lin);
        }
    }

    void invokeSQLGeneratorStart() {
        int len = this.listeners.size();
        for (int i = 0; i < len; ++i) {
            ((IQueryCacheManagerTraceListener)this.listeners.get(i)).invokeSQLGeneratorStart();
        }
    }

    void invokeSQLGeneratorEnd() {
        int len = this.listeners.size();
        for (int i = 0; i < len; ++i) {
            ((IQueryCacheManagerTraceListener)this.listeners.get(i)).invokeSQLGeneratorEnd();
        }
    }

    void invokeQueryExecuteStart() {
        int len = this.listeners.size();
        for (int i = 0; i < len; ++i) {
            ((IQueryCacheManagerTraceListener)this.listeners.get(i)).invokeQueryExecuteStart();
        }
    }

    void invokeQueryExecuteEnd() {
        int len = this.listeners.size();
        for (int i = 0; i < len; ++i) {
            ((IQueryCacheManagerTraceListener)this.listeners.get(i)).invokeQueryExecuteEnd();
        }
    }
}

