/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLDataAccess
extends AbstractBOSObject
implements ISQLDataAccess {
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"SQLQ");
    private static final Logger logger = Logger.getLogger(SQLDataAccess.class);

    public SQLDataAccess() {
        this.registerInterface(ISQLDataAccess.class, this);
    }

    public SQLDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(ISQLDataAccess.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public IRowSet getRowSet(String sql) throws BOSException {
        DynamicRowSet dynamicRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection();
            stmt = cn.prepareStatement(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowSet()'s sql:\n" + sql));
            }
            int rowCount = 0;
            int idListSize = this.getCriticalIDSize();
            rs = this.excuteSQL(stmt);
            DynamicRowSet drs = this.createRowSet(rs);
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= drs.getMetaData().getColumnCount(); ++i) {
                    this.populateRowSetCell(drs, rs, i);
                }
                drs.insertRow();
                if (idListSize == 0 || ++rowCount <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException("fetched too much rows:" + rowCount + " SQL: " + sql);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("getRowSet(sql) sql " + sql));
                logger.error((Object)"getRowSet(sql) occur error ", (Throwable)sqle);
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    protected void populateRowSetCell(DynamicRowSet drs, ResultSet rs, int i) throws SQLException {
        int type = rs.getMetaData().getColumnType(i);
        Object colValue = rs.getObject(i);
        if (colValue == null) {
            drs.updateNull(i);
        } else {
            switch (type) {
                case -7: {
                    drs.updateByte(i, rs.getByte(i));
                    break;
                }
                case 91: {
                    drs.updateDate(i, rs.getDate(i));
                    break;
                }
                case 92: {
                    drs.updateTime(i, rs.getTime(i));
                    break;
                }
                case 93: {
                    drs.updateTimestamp(i, rs.getTimestamp(i));
                    break;
                }
                case 4: {
                    drs.updateInt(i, rs.getInt(i));
                    break;
                }
                case 6: {
                    drs.updateFloat(i, rs.getFloat(i));
                    break;
                }
                case 3: {
                    drs.updateBigDecimal(i, rs.getBigDecimal(i));
                    break;
                }
                case 8: {
                    drs.updateDouble(i, rs.getDouble(i));
                    break;
                }
                case 5: {
                    drs.updateShort(i, rs.getShort(i));
                    break;
                }
                case -5: {
                    drs.updateLong(i, rs.getLong(i));
                    break;
                }
                default: {
                    drs.updateObject(i, colValue);
                }
            }
        }
    }

    private DynamicRowSet createRowSet(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i < colCount + 1; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }

    private ResultSet excuteSQL(PreparedStatement stmt) throws SQLException {
        return stmt.executeQuery();
    }

    protected SolutionInfo getSolution() {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext()).getSolution();
    }

    protected Connection getConnection() throws SQLException {
        return EJBFactory.getQueryConnection(this.getContext());
    }

    protected int getCriticalIDSize() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.getCriticalIDList();
    }
}

