/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import java.util.HashSet;
import java.util.Iterator;

public class SQLTranslateUtil {
    private SQLTranslateUtil() {
    }

    public static String translateTopAndDistinctSQL(String sql, boolean checkOrderByField) throws BOSException {
        try {
            SqlSelect sqlSelect = null;
            SelectParser parser2 = null;
            StringBuffer buff = new StringBuffer();
            QuerySQLFormater formater = new QuerySQLFormater(buff);
            parser2 = new SelectParser(sql);
            SqlSelectBase selectBase = parser2.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (sqlSelect.limit == null || sqlSelect.distinct == 0 || sqlSelect.orderBy == null || sqlSelect.orderBy.size() <= 0) {
                    return sql;
                }
                formater.formatSelectBase((SqlSelectBase)SQLTranslateUtil.translateTopAndDistinctSQL(sqlSelect, checkOrderByField));
                return buff.toString();
            }
            throw new BOSException("Get SqlSelect failed!");
        }
        catch (ParserException parseException) {
            throw new BOSException((Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException((Throwable)formaterExcption);
        }
    }

    public static SqlSelect translateTopAndDistinctSQL(SqlSelect sqlSelect, boolean checkOrderByField) throws BOSException {
        if (sqlSelect == null) {
            throw new BOSException("SqlSelect Argument is null!");
        }
        if (sqlSelect.limit == null || sqlSelect.distinct == 0 || sqlSelect.orderBy == null || sqlSelect.orderBy.size() <= 0) {
            return sqlSelect;
        }
        if (checkOrderByField && SQLTranslateUtil._includeCheckOrderByField(sqlSelect)) {
            return sqlSelect;
        }
        SqlSelect newSqlSelect = new SqlSelect();
        newSqlSelect.selectList.add(new SqlSelectItem((SqlExpr)new SqlAllColumnExpr(), null));
        newSqlSelect.distinct = sqlSelect.distinct;
        sqlSelect.distinct = 0;
        SqlSubQueryTableSource subTabSrc = new SqlSubQueryTableSource();
        subTabSrc.alias = "DistinctTopSqlTempTable";
        subTabSrc.subQuery = sqlSelect;
        newSqlSelect.tableSource = subTabSrc;
        return newSqlSelect;
    }

    public static SqlSelect translateTopAndDistinctSQL(SqlSelect sqlSelect) throws BOSException {
        return SQLTranslateUtil.translateTopAndDistinctSQL(sqlSelect, true);
    }

    private static boolean _includeCheckOrderByField(SqlSelect sqlSelect) {
        HashSet<String> selectExprSet = new HashSet<String>();
        Iterator iter = sqlSelect.selectList.iterator();
        while (iter.hasNext()) {
            selectExprSet.add(((SqlSelectItem)iter.next()).expr.toString());
        }
        iter = sqlSelect.orderBy.iterator();
        while (iter.hasNext()) {
            if (selectExprSet.contains(((SqlOrderByItem)iter.next()).expr.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean orderbyAllInSelectList(SqlSelect sqlSelect) {
        HashSet<String> selectExprSet = new HashSet<String>();
        HashSet<String> selectAliasSet = new HashSet<String>();
        for (SqlSelectItem selectItem : sqlSelect.selectList) {
            selectExprSet.add(selectItem.expr.toString());
            selectAliasSet.add(selectItem.alias);
        }
        Iterator iter = sqlSelect.orderBy.iterator();
        while (iter.hasNext()) {
            String selecter = ((SqlOrderByItem)iter.next()).expr.toString();
            if (selectAliasSet.contains(selecter) || selectExprSet.contains(selecter)) continue;
            return false;
        }
        return true;
    }
}

