/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import bos.org.apache.commons.bos.MySqlDBUtils;
import bos.org.apache.commons.dbutils.QueryRunner;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.DbSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.MySqlSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.dao.query.server.SeqTableDbPageAcuquire;
import com.kingdee.bos.dao.query.server.SeqTableDiskCacheAcuquire;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionListener;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

final class SeqTableManager
implements SessionListener {
    private static final Logger logger = Logger.getLogger(SeqTableManager.class);
    private static SeqTableManager INSTANCE = null;
    private Set querySessions = Collections.synchronizedSet(new HashSet());
    static final String SEQ_FIELD = "KSQL_SEQ";
    static final String TABLENAME_FOR_CREATESQL_POOL = "QUERY_SEQTABLE";
    static final String CONSNAME_FOR_CREATESQL_POOL = "QUERY_SEQ_CONS";
    private boolean isMysql = false;
    private boolean isDatabase = false;
    private boolean isDiskCache = true;
    private MysqlTestThread mysqlTestThread = null;

    private SeqTableManager() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem item = config.getConfigItem("SeqTableManager");
        this.mysqlTestThread = new MysqlTestThread();
        if (item != null) {
            this.initFromConfig(item);
        }
    }

    static SeqTableManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SeqTableManager();
        }
        return INSTANCE;
    }

    void acquire(Context ctx, Uuid querySessionID, QueryExecuteOption option, String sql, List pkList) throws BOSException {
        DbSeqTableAcuquire.acquire(ctx, querySessionID, option, sql, pkList);
    }

    Map acquire(Context ctx, Uuid querySessionID, QueryDele query, EntityViewInfo view, Map views, Map params, QueryExecuteOption option, String sql, int length, String keyFieldName) throws BOSException {
        if (option.isUseDbPage) {
            return SeqTableDbPageAcuquire.acquire(ctx, querySessionID, query, view, views, params, option, sql, length, keyFieldName);
        }
        if (this.isSeqTabInMysql()) {
            return MySqlSeqTableAcuquire.acquire(ctx, querySessionID, query, view, views, params, option, sql);
        }
        if (this.isDatabase) {
            return DbSeqTableAcuquire.acquire(ctx, querySessionID, query, view, views, params, option, sql);
        }
        return SeqTableDiskCacheAcuquire.acquire(ctx, querySessionID, query, view, views, params, option, sql, length, keyFieldName);
    }

    public void release(Context ctx, Uuid querySessionID) throws BOSException {
        SeqTableData cacheData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        if (cacheData != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("release: " + cacheData.getTableName()));
            }
            if (this.isMysql) {
                TempTablePool.getInstanceForOutMySql().releaseTable(cacheData.getTableName());
            } else if (this.isDatabase) {
                TempTablePool.getInstance(ctx).releaseTable(cacheData.getTableName());
            } else {
                SeqTableDiskCacheAcuquire.release(ctx, cacheData);
            }
        }
        this.querySessions.remove(querySessionID);
    }

    void registerSession(Uuid querySessionID) {
        this.querySessions.add(querySessionID);
    }

    public static void registerInUserSession(Uuid querySessionID) {
        String sessionID = null;
        IServerSession serverSession = ServerSessionContainer.getCurrentSession();
        if (serverSession != null) {
            sessionID = (String)serverSession.get((Object)"bos_sessionid");
        }
        if (sessionID == null) {
            return;
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo session = manager.getSession(sessionID);
        if (session == null) {
            return;
        }
        Set querySessionIDs = (Set)session.get((Object)"querySessionIDs", new HashSet());
        session.put((Object)"querySessionIDs", (Object)querySessionIDs);
        querySessionIDs.add(querySessionID);
    }

    public static void unRegisterInUserSession(Uuid querySessionID) {
        String sessionID = null;
        IServerSession serverSession = ServerSessionContainer.getCurrentSession();
        if (serverSession != null) {
            sessionID = (String)serverSession.get((Object)"bos_sessionid");
        }
        if (sessionID == null) {
            return;
        }
        SeqTableManager.unRegisterInUserSession(querySessionID, sessionID);
    }

    public static void unRegisterInUserSession(Uuid querySessionID, String sessionID) {
        if (sessionID == null) {
            return;
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo session = manager.getSession(sessionID);
        if (session == null) {
            return;
        }
        Set querySessionIDs = (Set)session.get((Object)"querySessionIDs", new HashSet());
        querySessionIDs.remove(querySessionID);
        session.put((Object)"querySessionIDs", (Object)querySessionIDs);
    }

    boolean existSession(Uuid querySessionID) {
        return this.querySessions.contains(querySessionID);
    }

    public void create(String sessionID, SessionInfo session) {
    }

    public void destory(String sessionID, SessionInfo session) {
        Set querySessionIDs = (Set)session.get((Object)"querySessionIDs", new HashSet());
        Context ctx = session.getContext();
        for (Uuid querySessionID : querySessionIDs) {
            try {
                this.release(ctx, querySessionID);
            }
            catch (BOSException e) {
                logger.error((Object)"error while release querySession", (Throwable)e);
            }
        }
    }

    private void initFromConfig(ConfigurationItem item) {
        String value = item.getProperty("seqtableLoc");
        if (value != null) {
            if ((value = value.toLowerCase()).endsWith("mysql")) {
                this.isMysql = true;
                this.isDiskCache = false;
                this.mysqlTestThread.setMySqldown(false);
                this.mysqlTestThread.setBeginTest(false);
                this.mysqlTestThread.start();
            } else if (value.equalsIgnoreCase("database")) {
                this.isDatabase = true;
                this.isDiskCache = false;
            } else {
                this.isDiskCache = true;
            }
        }
    }

    public boolean isSeqTabInMysql() {
        return this.isMysql;
    }

    public boolean isDatabase() {
        return this.isDatabase;
    }

    public boolean isSeqTabInDiskCache() {
        return this.isDiskCache;
    }

    public void setMysql(boolean isMysql) {
        this.isMysql = isMysql;
        if (!isMysql) {
            this.mysqlTestThread.setBeginTest(true);
            this.mysqlTestThread.setMySqldown(true);
        } else {
            this.mysqlTestThread.setMySqldown(false);
            this.mysqlTestThread.setBeginTest(false);
        }
    }

    private static class MysqlTestThread
    extends Thread {
        private boolean isMySqldown = true;
        private boolean beginTest = false;
        private long interval = 300000L;

        public MysqlTestThread() {
            this.setDaemon(true);
            this.setName("mysqlTest");
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.interval);
                        if (!this.isMySqldown || !this.beginTest) continue;
                        try {
                            QueryRunner queryRunner = new QueryRunner(MySqlDBUtils.getdataSource());
                            boolean bl = this.isMySqldown = !queryRunner.queryIsExist("select 1;");
                            if (this.isMySqldown) continue block4;
                            this.stopTest();
                            continue block4;
                        }
                        catch (SQLException e) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stopTest() {
            this.beginTest = false;
            SeqTableManager.getInstance().setMysql(true);
        }

        public void setMySqldown(boolean isMySqldown) {
            this.isMySqldown = isMySqldown;
        }

        public void setBeginTest(boolean beginTest) {
            this.beginTest = beginTest;
        }
    }
}

