/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryFieldCollectionDele;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKDele;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.expr.SqlCaseExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class VirtualModeUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.query.server.VirtualModeUtils");

    VirtualModeUtils() {
    }

    public static Map<Integer, Object> processLogicPKParameter(QueryDele query, List<Object[]> keyList, QueryExecuteOption option) throws BOSException {
        if (query == null) {
            return new HashMap<Integer, Object>();
        }
        return VirtualModeUtils.processLogicPKParameter(query.getQueryPK(), keyList, option, false);
    }

    public static Map<Integer, Object> processLogicPKParameter(QueryDele query, List<Object[]> keyList, QueryExecuteOption option, boolean isParamLimit) throws BOSException {
        if (query == null) {
            return new HashMap<Integer, Object>();
        }
        return VirtualModeUtils.processLogicPKParameter(query.getQueryPK(), keyList, option, isParamLimit);
    }

    private static Map<Integer, Object> processLogicPKParameter(QueryPKDele info, List<Object[]> keyList, QueryExecuteOption option, boolean isParamLimit) throws BOSException {
        int i;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(2);
        if (info == null) {
            return map;
        }
        int count = 1;
        Object[] objs = null;
        int length = keyList.size() > option.pageCount ? keyList.size() : option.pageCount;
        HashMap<SQLType, Object> notExistMap = new HashMap<SQLType, Object>();
        notExistMap.put(SQLType.CHAR, "NE");
        notExistMap.put(SQLType.DATETIME, new Timestamp(0L));
        notExistMap.put(SQLType.INT, Integer.MIN_VALUE);
        notExistMap.put(SQLType.NCHAR, "NE");
        notExistMap.put(SQLType.NUMERIC, Integer.MIN_VALUE);
        notExistMap.put(SQLType.NVARCHAR, "NE");
        notExistMap.put(SQLType.VARCHAR, "NE");
        int m = info.getKeyPropertys().size();
        for (i = 0; i < m; ++i) {
            SQLType keyType = info.getKeyPropertys().get(i).getMappingFieldType();
            int keySize = keyList.size();
            for (int j = 0; j < length; ++j) {
                Object[] paramValueObj = new Object[2];
                paramValueObj[0] = keyType;
                if (j < keySize) {
                    objs = keyList.get(j);
                    paramValueObj[1] = objs[i];
                } else {
                    paramValueObj[1] = notExistMap.get(keyType);
                }
                map.put(count, paramValueObj);
                ++count;
            }
        }
        if (isParamLimit) {
            return map;
        }
        int keySize = keyList.size();
        for (i = 0; i < length; ++i) {
            int n;
            if (i < keySize) {
                objs = keyList.get(i);
            } else {
                objs = new Object[info.getKeyPropertys().size()];
                n = info.getKeyPropertys().size();
                for (int k = 0; k < n; ++k) {
                    objs[k] = notExistMap.get(info.getKeyPropertys().get(k).getMappingFieldType());
                }
            }
            n = info.getKeyPropertys().size();
            for (int j = 0; j < n; ++j) {
                Object[] paramValueObj = new Object[]{info.getKeyPropertys().get(j).getMappingFieldType(), objs[j]};
                map.put(count, paramValueObj);
                paramValueObj = new Object[]{SQLType.INT, objs[j] == null ? Integer.valueOf(1) : Integer.valueOf(0)};
                map.put(++count, paramValueObj);
                ++count;
            }
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getInitializeSql(QueryDele query, String sql, int size) throws BOSException {
        QueryPKDele pkInfo;
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(VirtualModeUtils.class.getName(), "getInitializeSql", null);
        }
        if ((pkInfo = query.getQueryPK()) == null) {
            throw new BOSException("Can't found QueryPK define,please define QueryPK!");
        }
        SqlSelect sqlSelect = null;
        SelectParser parser2 = null;
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            parser2 = new SelectParser(sql);
            SqlSelectBase selectBase = parser2.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (size == 0) {
                    SqlSelectItem selectItem;
                    int j;
                    int n;
                    int i;
                    ArrayList<SqlSelectItem> objs = new ArrayList<SqlSelectItem>();
                    QueryFieldCollectionDele fields = pkInfo.getKeyPropertys();
                    int fieldSize = fields.size();
                    block6: for (i = 0; i < fieldSize; ++i) {
                        String keyName = QueryHelper.addMark(fields.get(i).getName());
                        n = sqlSelect.selectList.size();
                        for (j = 0; j < n; ++j) {
                            selectItem = (SqlSelectItem)sqlSelect.selectList.get(j);
                            if (!selectItem.alias.equalsIgnoreCase(keyName)) continue;
                            objs.add(selectItem);
                            continue block6;
                        }
                    }
                    block8: for (i = 0; i < sqlSelect.orderBy.size(); ++i) {
                        SqlOrderByItem order = (SqlOrderByItem)sqlSelect.orderBy.get(i);
                        if (!QueryHelper.isIdentifierExpr(order.expr) && !(order.expr instanceof SqlCaseExpr)) continue;
                        String value = order.expr.toString();
                        if (order.expr instanceof SqlIdentifierExpr) {
                            value = ((SqlIdentifierExpr)order.expr).value;
                        }
                        if (value == null) {
                            value = "";
                        }
                        n = sqlSelect.selectList.size();
                        for (j = 0; j < n; ++j) {
                            selectItem = (SqlSelectItem)sqlSelect.selectList.get(j);
                            if (objs.contains(selectItem)) continue;
                            if (selectItem.alias.equalsIgnoreCase(value)) {
                                objs.add(selectItem);
                                continue block8;
                            }
                            if (!value.equalsIgnoreCase(selectItem.expr.toString())) continue;
                            objs.add(selectItem);
                            continue block8;
                        }
                    }
                    if (objs.size() == 0) throw new BOSException("Can't get the query logical key in selectors!");
                    sqlSelect.selectList.clear();
                    sqlSelect.selectList.addAll(objs);
                } else {
                    SqlExpr expr;
                    sqlSelect.condition = null;
                    sqlSelect.distinct = query.getType() == 0 ? (query.isIsDistinct() ? 1 : 0) : 0;
                    SqlExprParser exprParser = new SqlExprParser(VirtualModeUtils.buildParameter(pkInfo, size));
                    sqlSelect.condition = expr = exprParser.expr();
                }
                formater.formatSelectBase((SqlSelectBase)sqlSelect);
            }
            String string = buff.toString();
            return string;
        }
        catch (ParserException parseException) {
            logger.error((Object)"getInitializeSql() occur error: ", (Throwable)parseException);
            throw new BOSException((Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            logger.error((Object)"getInitializeSql() occur error: ", (Throwable)formaterExcption);
            throw new BOSException((Throwable)formaterExcption);
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private static String buildParameter(QueryPKDele pkInfo, int size) throws BOSException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buff.append("(");
            QueryFieldCollectionDele fields = pkInfo.getKeyPropertys();
            int n = fields.size();
            for (int j = 0; j < n; ++j) {
                PropertyUnitDele field = fields.get(j);
                if (field == null) {
                    throw new BOSException("The QueryField of QueryPK[" + pkInfo.getName() + "] is null!");
                }
                if (field.getPropertyRefs().size() > 1) {
                    throw new BOSException("Entity LogicalKey can't support multiKey!");
                }
                buff.append(field.getPropertyRefs().get(0).showValue());
                if (j < n - 1) {
                    buff.append(" = ? AND ");
                    continue;
                }
                buff.append(" = ? ");
            }
            if (i < size - 1) {
                buff.append(") OR");
                continue;
            }
            buff.append(")");
        }
        return buff.toString();
    }

    public static void getSQLWithLogicPK(QueryDele query, List<Object[]> logicPKs, SqlSelectBase selectBase, QueryExecuteOption option) throws BOSException {
        VirtualModeUtils.getSQLWithLogicPK(query, logicPKs, selectBase, option, false);
    }

    public static void getSQLWithLogicPK(QueryDele query, List<Object[]> logicPKs, SqlSelectBase selectBase, QueryExecuteOption option, boolean isParamLimit) throws BOSException {
        if (query == null) {
            return;
        }
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(VirtualModeUtils.class.getName(), "getSQLWithLogicPK", null);
        }
        try {
            if (selectBase instanceof SqlSelect) {
                SqlExpr expr;
                SqlSelect sqlSelect = (SqlSelect)selectBase;
                sqlSelect.condition = null;
                sqlSelect.distinct = query.getType() == 0 ? (query.isIsDistinct() ? 1 : 0) : 0;
                SqlExprParser exprParser = new SqlExprParser(VirtualModeUtils.buildLogicPKCondition(query.getQueryPK(), logicPKs, option, isParamLimit));
                sqlSelect.condition = expr = exprParser.expr();
            }
        }
        catch (ParserException parseException) {
            logger.error((Object)"getSQLWithLogicPK() occur error: ", (Throwable)parseException);
            throw new BOSException((Throwable)parseException);
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private static String buildLogicPKCondition(QueryPKDele pkInfo, List<Object[]> logicPKs, QueryExecuteOption option, boolean isParamLimit) throws BOSException {
        int length;
        StringBuffer buff = new StringBuffer();
        int n = length = logicPKs.size() > option.pageCount ? logicPKs.size() : option.pageCount;
        if (logicPKs.size() > 0) {
            int i;
            QueryFieldCollectionDele keyVec = pkInfo.getKeyPropertys();
            int m = keyVec.size();
            for (int i2 = 0; i2 < m; ++i2) {
                int j;
                PropertyUnitDele key = keyVec.get(i2);
                String keyName = key.getPropertyRefs().get(0).showValue();
                buff.append(" ( ");
                buff.append(keyName);
                buff.append(" in ( ");
                boolean existNull = false;
                int n2 = logicPKs.size();
                for (j = 0; j < n2; ++j) {
                    Object[] pkValues = logicPKs.get(j);
                    if (pkValues[i2] != null) continue;
                    existNull = true;
                    break;
                }
                for (j = 0; j < length; ++j) {
                    buff.append("?");
                    if (j >= length - 1) continue;
                    buff.append(", ");
                }
                buff.append(" ) ");
                if (existNull) {
                    buff.append(" or ");
                    buff.append(keyName);
                    buff.append(" is null ");
                }
                buff.append(" ) and ");
            }
            if (isParamLimit) {
                return buff.lastIndexOf("and ") > 0 ? buff.substring(0, buff.lastIndexOf("and ")) : buff.toString();
            }
            buff.append(" ( ");
            QueryFieldCollectionDele fields = pkInfo.getKeyPropertys();
            String[] keyNameVec = new String[fields.size()];
            int m2 = keyNameVec.length;
            for (i = 0; i < m2; ++i) {
                keyNameVec[i] = fields.get(i).getPropertyRefs().get(0).showValue();
            }
            for (i = 0; i < length; ++i) {
                buff.append("(");
                int n3 = keyNameVec.length;
                for (int j = 0; j < n3; ++j) {
                    buff.append("(");
                    buff.append(keyNameVec[j]);
                    buff.append("=?");
                    buff.append(" or (");
                    buff.append(keyNameVec[j]);
                    buff.append(" is null and ?=1))");
                    if (j >= keyNameVec.length - 1) continue;
                    buff.append(" and ");
                }
                buff.append(")");
                if (i >= length - 1) continue;
                buff.append(" or ");
            }
        }
        buff.append(" ) ");
        return buff.toString();
    }

    public static void processParameter(QueryDele query, List keyList, Map map) throws BOSException {
        VirtualModeUtils.processParameter(query.getQueryPK(), keyList, map);
    }

    private static void processParameter(QueryPKDele info, List keyList, Map map) throws BOSException {
        int count = 1;
        Object[] objs = null;
        int m = keyList.size();
        for (int i = 0; i < m; ++i) {
            if (!(keyList.get(i) instanceof Object[])) {
                throw new BOSException("Process parameters failed,The parameter's type is not Vector!");
            }
            objs = (Object[])keyList.get(i);
            int n = info.getKeyPropertys().size();
            for (int j = 0; j < n; ++j) {
                Object[] paramValueObj = new Object[2];
                paramValueObj[0] = info.getKeyPropertys().get(j).getMappingFieldType();
                if (objs != null) {
                    paramValueObj[1] = objs[j];
                    map.put(count, paramValueObj);
                    ++count;
                    continue;
                }
                throw new BOSException("The parameters is null!");
            }
        }
    }

    public static void switchWFSpeacilFilter(EntityViewInfo view, QueryInfo getQuery) {
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems().isEmpty()) {
            return;
        }
        boolean hasIdFiled = false;
        ArrayList fields = getQuery.getSelector().getFields();
        for (QueryFieldInfo field : fields) {
            if (!"id".equals(field.getName())) continue;
            hasIdFiled = true;
            break;
        }
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            String compareValue;
            FilterItemInfo item = filterItems.get(i);
            String propertyName = item.getPropertyName();
            if (propertyName == null || !propertyName.equals("WF_CurHandler")) continue;
            if (!hasIdFiled) {
                filterItems.remove(item);
                continue;
            }
            item.setPropertyName("fpersonempid");
            if (CompareType.NOTINNER.equals((Object)item.getCompareType()) || CompareType.NOTINCLUDE.equals((Object)item.getCompareType())) {
                item.setCompareType(CompareType.INCLUDE);
                compareValue = "select fbizobjid from t_wfr_assign where " + item.toString() + " and fbizobjid is not null";
                item.setCompareType(CompareType.NOTINNER);
            } else {
                compareValue = "select fbizobjid from t_wfr_assign where " + item.toString() + " and fbizobjid is not null";
                item.setCompareType(CompareType.INNER);
            }
            item.setPropertyName("id");
            item.setCompareValue((Object)compareValue);
        }
    }
}

