/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server.analysis;

import java.util.HashSet;

public abstract class Aggregator {
    public abstract String getName();

    public abstract Object aggregate(Object var1);

    public abstract Object getValue();

    public static Aggregator createAggregatorByFunction(String func) {
        if ("sum".equalsIgnoreCase(func)) {
            return new SUM();
        }
        if ("count".equalsIgnoreCase(func)) {
            return new COUNT();
        }
        if ("countHeader".equalsIgnoreCase(func)) {
            return new DISTINCTCOUNT();
        }
        if ("distinctCount".equalsIgnoreCase(func)) {
            return new DISTINCTCOUNT();
        }
        throw new RuntimeException("Unsupported funciton:" + func);
    }

    public static class DISTINCTCOUNT
    extends Aggregator {
        HashSet set = new HashSet();
        int value = 0;

        @Override
        public String getName() {
            return "distinct count";
        }

        @Override
        public Object aggregate(Object o) {
            if (!this.set.contains(o)) {
                this.set.add(o);
                ++this.value;
            }
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class COUNT
    extends Aggregator {
        int value = 0;

        @Override
        public String getName() {
            return "count";
        }

        @Override
        public Object aggregate(Object o) {
            ++this.value;
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class SUM
    extends Aggregator {
        double value = 0.0;

        @Override
        public String getName() {
            return "sum";
        }

        @Override
        public Object aggregate(Object o) {
            if (o != null) {
                this.value += ((Number)o).doubleValue();
            }
            return this.value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

