/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server.analysis;

import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class HeaderCounter {
    private HashMap<ObjectPair, HashSet> values = new HashMap();
    private ArrayList<ObjectPair> groupByList = new ArrayList();
    private String[] groupByFields;
    private String headerIdField;

    public HeaderCounter(String[] groupByFields, String headerIdField) {
        this.groupByFields = groupByFields;
        this.headerIdField = headerIdField;
    }

    public void prepareData(ResultSet rs) throws SQLException {
        while (rs.next()) {
            Object[] groupBy = new String[this.groupByFields.length];
            for (int i = 0; i < groupBy.length; ++i) {
                groupBy[i] = rs.getObject(this.groupByFields[i]);
            }
            Object header = rs.getObject(this.headerIdField);
            this.aggregate(groupBy, header);
        }
    }

    private void aggregate(Object[] groupBy, Object v) {
        ObjectPair pair = new ObjectPair(groupBy);
        HashSet<Object> set = null;
        if (!this.values.containsKey(pair)) {
            this.groupByList.add(pair);
            set = new HashSet<Object>();
            this.values.put(pair, set);
            set.add(v);
        } else {
            set = this.values.get(pair);
            if (!set.contains(v)) {
                set.add(v);
            }
        }
    }

    public IRowSet getResult() {
        DynamicRowSet rowSet = null;
        try {
            rowSet = new DynamicRowSet(this.groupByFields.length + 1);
            for (int i = 0; i < this.groupByFields.length; ++i) {
                rowSet.setColInfo(i + 1, this.groupByFields[i], this.groupByFields[i], 12, null);
            }
            rowSet.setColInfo(this.groupByFields.length + 1, "Count", "Count", 4, null);
            Iterator<ObjectPair> iter = this.groupByList.iterator();
            while (iter.hasNext()) {
                rowSet.moveToInsertRow();
                ObjectPair pair = iter.next();
                for (int i = 0; i < this.groupByFields.length; ++i) {
                    rowSet.updateObject(i + 1, pair.values[i]);
                }
                HashSet set = this.values.get(pair);
                rowSet.updateInt(this.groupByFields.length + 1, set.size());
                rowSet.insertRow();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    private class ObjectPair {
        private Object[] values;

        ObjectPair(Object[] values) {
            this.values = values;
        }

        public int hashCode() {
            int hash = this.values[0] == null ? 1 : this.values[0].hashCode();
            for (int i = 1; i < this.values.length; ++i) {
                hash ^= this.values[i] == null ? 1 : this.values[i].hashCode();
            }
            return hash;
        }

        public boolean equals(Object x) {
            ObjectPair s = null;
            if (x == null) {
                return false;
            }
            if (!(x instanceof ObjectPair)) {
                return false;
            }
            s = (ObjectPair)x;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] == null ? s.values[i] != null : !this.values[i].equals(s.values[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

