/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server.analysis;

import com.kingdee.bos.dao.query.server.analysis.AggInfo;
import com.kingdee.bos.dao.query.server.analysis.TimeSegmentAggregator;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class TimeAnalysis {
    private int[] timeSegments;
    private AggInfo[] aggInfos;
    private String timeField;
    private TimeSegmentAggregator[][] aggs;

    public TimeAnalysis(int[] timeSegments, AggInfo[] aggInfos, String timeField) {
        this.timeSegments = timeSegments;
        this.aggInfos = aggInfos;
        this.timeField = timeField;
        this.init();
    }

    private void init() {
        this.aggs = new TimeSegmentAggregator[this.aggInfos.length][this.timeSegments.length];
        for (int i = 0; i < this.aggInfos.length; ++i) {
            for (int j = 0; j < this.timeSegments.length; ++j) {
                this.aggs[i][j] = TimeSegmentAggregator.createAggregator(this.timeSegments[j], this.aggInfos[i].function);
            }
        }
    }

    public void prepareData(ResultSet rs) throws SQLException {
        while (rs.next()) {
            Date date = (Date)rs.getObject(this.timeField);
            for (int i = 0; i < this.aggInfos.length; ++i) {
                int j;
                Object value = null;
                if (this.aggInfos[i].field != null) {
                    value = rs.getObject(this.aggInfos[i].field);
                }
                boolean y = false;
                for (j = 0; j < this.timeSegments.length; ++j) {
                    if (this.timeSegments[j] == 32 || !this.aggs[i][j].aggregate(value, date)) continue;
                    y = true;
                }
                if (y) continue;
                for (j = 0; j < this.timeSegments.length; ++j) {
                    if (this.timeSegments[j] != 32) continue;
                    this.aggs[i][j].aggregate(value, date);
                }
            }
        }
    }

    public IRowSet getResult() {
        DynamicRowSet rowSet = null;
        try {
            int i;
            rowSet = new DynamicRowSet(this.aggs.length + 1);
            rowSet.setColInfo(1, "Time", "Time", 4, null);
            for (i = 0; i < this.aggs.length; ++i) {
                if (this.aggInfos[i].field == null) {
                    rowSet.setColInfo(2 + i, this.aggInfos[i].function, this.aggInfos[i].function, 2, null);
                    continue;
                }
                rowSet.setColInfo(2 + i, this.aggInfos[i].function + "_" + this.aggInfos[i].field, this.aggInfos[i].field, 2, null);
            }
            for (i = 0; i < this.timeSegments.length; ++i) {
                rowSet.moveToInsertRow();
                rowSet.updateInt(1, this.timeSegments[i]);
                for (int j = 0; j < this.aggInfos.length; ++j) {
                    rowSet.updateObject(2 + j, this.aggs[j][i].getValue());
                }
                rowSet.insertRow();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowSet;
    }
}

