/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server.seqtablecache;

import com.kingdee.bos.bigobjectcache.BigObjectCacheMap;
import com.kingdee.bos.bigobjectcache.BigObjectCacheMapFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class SeqTableCache {
    private String sessionId;
    private Map<String, Serializable> localMap = Collections.synchronizedMap(new LRUMap(10));
    private BigObjectCacheMap bigCache;
    private String cacheType = null;

    public SeqTableCache(String sessionId) {
        this.sessionId = sessionId;
        this.cacheType = "SeqTableCache-" + sessionId;
        this.bigCache = BigObjectCacheMapFactory.getBigCacheMap((Object)this.cacheType, (int)4);
    }

    public void put(String key, Serializable value, int timeout) {
        this.bigCache.put((Object)key, value, timeout);
    }

    public Serializable remove(String key) {
        this.localMap.remove(key);
        return this.bigCache.remove((Object)key);
    }

    public Serializable get(String key) {
        Serializable o = this.localMap.get(key);
        if (o == null) {
            o = this.bigCache.get((Object)key);
            this.localMap.put(key, o);
        }
        return o;
    }

    public void clear() {
        this.localMap.clear();
        this.bigCache.clear();
        BigObjectCacheMapFactory.release((Object)this.cacheType);
    }
}

